/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;

public class SrmEvaPlanBatchEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String EVAMETEOD = "evamethod";

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (row > 0) {
            DynamicObject curRow = (DynamicObject)entryEntity.get(row);
            String weightstrategy = curRow.getString("weightstrategy");
            if ("A".equals(weightstrategy)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"scorerweight"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"scorerweight"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "callbackid": {
                this.getView().invokeOperation("refresh");
                BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                break;
            }
            case "changescorer": {
                if (returnData == null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u59d4\u53d8\u66f4\u6210\u529f\u3002", (String)"SrmEvaPlanBatchEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                HashMap<String, String> param = new HashMap<String, String>(16);
                param.put("scorers", returnData.toString());
                param.put("billno", this.getModel().getDataEntity().getString("billno"));
                param.put("name", this.getModel().getDataEntity().getString("name"));
                String json = JacksonJsonUtil.toJSON(param);
                EventServiceHelper.triggerEventSubscribe((String)"srm_evaplanbatch_msg_changescorer", (String)json);
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String billstatus = dataEntity.getString("billstatus");
        String bizstatus = dataEntity.getString("bizstatus");
        if (StringUtils.isNotEmpty((CharSequence)billstatus) && StringUtils.isNotEmpty((CharSequence)bizstatus)) {
            Boolean isContainAutoIndex = false;
            if (isContainAutoIndex.booleanValue() && "C".equals(billstatus) && "C".equals(bizstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"reautoscore"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"reautoscore"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reautoscore"});
        }
        this.setVisibleAndEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid grid;
        int[] selectRows;
        String billno;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ((StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)"submit", (CharSequence)key)) && StringUtils.isNotBlank((CharSequence)(billno = this.getModel().getDataEntity().getString("billno")))) {
            this.getModel().setValue("billno", (Object)billno.trim());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"deletedlock", (CharSequence)key)) {
            this.cleanDlock();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"changescorer", (CharSequence)key) && ((selectRows = (grid = (EntryGrid)this.getView().getControl("entryentity")).getSelectRows()) == null || selectRows.length == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bc4\u4f30\u5bf9\u8c61\u6570\u636e\u884c\u3002", (String)"SrmEvaPlanBatchEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void cleanDlock() {
        Map map = DLock.getAllLockInfo();
        ArrayList<String> list = new ArrayList<String>(8);
        for (Map.Entry entrySet : map.entrySet()) {
            String key = (String)entrySet.getKey();
            if (!key.contains("directapprove")) continue;
            list.add(key);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            DLock.forceUnlock((String[])list.toArray(new String[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        long billId = (Long)this.getModel().getDataEntity().getPkValue();
        this.setVisibleAndEnable();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "audit": 
                case "unaudit": 
                case "push": {
                    this.getView().invokeOperation("refresh");
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                    break;
                }
                case "pushandsave": {
                    OperateOption option = OperateOption.create();
                    OperationServiceHelper.executeOperate((String)"sendmsg", (String)"srm_evaplan_batch", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)option);
                    this.getView().invokeOperation("refresh");
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                    break;
                }
                case "terminate": {
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_evaplanbatch_end", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
                    this.getView().invokeOperation("refresh");
                    BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                    break;
                }
                case "queryreport": {
                    ReportShowParameter reportShowParameter = new ReportShowParameter();
                    reportShowParameter.setHasRight(true);
                    reportShowParameter.setFormId("srm_evaplanbatchreport");
                    reportShowParameter.setStatus(OperationStatus.ADDNEW);
                    reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    reportShowParameter.setCustomParam("evplan.id", (Object)billId);
                    reportShowParameter.setCustomParam("evplanIdStr", (Object)String.valueOf(billId));
                    this.getView().showForm((FormShowParameter)reportShowParameter);
                    break;
                }
                case "changescorer": {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("billid", billId);
                    paramMap.put("evaplantype", "srm_evaplan_batch");
                    EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
                    int[] selectRows = grid.getSelectRows();
                    DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                    StringBuilder evaObject = new StringBuilder();
                    for (int i = 0; i < selectRows.length; ++i) {
                        if (evaObject.length() > 0) {
                            evaObject.append("&");
                        }
                        DynamicObject rowData = (DynamicObject)entryentity.get(selectRows[i]);
                        String supplier = rowData.getString("supplier.id");
                        String bizbillno = rowData.getString("bizbillno");
                        String category = rowData.getString("category.id");
                        String material = rowData.getString("material.id");
                        String scheme = rowData.getString("scheme.id");
                        if (StringUtils.isNotBlank((CharSequence)supplier) && !"0".equals(supplier)) {
                            evaObject.append(supplier);
                        }
                        if (StringUtils.isNotBlank((CharSequence)bizbillno)) {
                            evaObject.append(bizbillno);
                        }
                        if (StringUtils.isNotBlank((CharSequence)category) && !"0".equals(category)) {
                            evaObject.append(category);
                        }
                        if (StringUtils.isNotBlank((CharSequence)material) && !"0".equals(material)) {
                            evaObject.append(material);
                        }
                        if (!StringUtils.isNotBlank((CharSequence)scheme) || "0".equals(scheme)) continue;
                        evaObject.append(scheme);
                    }
                    paramMap.put("evaplantype", "srm_evaplan_batch");
                    paramMap.put("evaObject", evaObject.toString());
                    OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"srm_changescorer", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "changescorer"));
                    break;
                }
            }
        } else {
            switch (operateKey) {
                case "pushandsave": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "newsup": 
                case "deletesup": {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    int row = entryEntity.size() - 1;
                    if (row < 0) break;
                    DynamicObject curRow = (DynamicObject)entryEntity.get(row);
                    String weightstrategy = curRow.getString("weightstrategy");
                    if ("A".equals(weightstrategy)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"scorerweight"});
                        break;
                    }
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"scorerweight"});
                    break;
                }
            }
        }
    }

    protected String getStatusTabValue() {
        DynamicObject obj = this.getModel().getDataEntity();
        String bizStatus = obj.getString("bizstatus");
        return bizStatus == null ? "" : bizStatus.toLowerCase();
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        super.propertyChanged(arg0);
        String propertyName = arg0.getProperty().getName();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "evatype": 
            case "org": 
            case "category": {
                break;
            }
            case "scheme": {
                DynamicObject newValue = (DynamicObject)arg0.getChangeSet()[0].getNewValue();
                DynamicObjectCollection supplierEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                DynamicObjectCollection subentryentity = ((DynamicObject)supplierEntry.get(rowIndex)).getDynamicObjectCollection("subentryentity");
                if (newValue == null) {
                    this.getModel().setValue("grade", null, rowIndex);
                    subentryentity.clear();
                    this.getView().updateView("subentryentity");
                    return;
                }
                long schemeId = newValue.getLong("id");
                DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
                if (schemeObj == null) {
                    return;
                }
                this.setVisibleAndEnable();
                DynamicObject gradeDynamicObject = schemeObj.getDynamicObject("grade");
                if (Objects.nonNull(gradeDynamicObject)) {
                    this.getModel().setValue("grade", (Object)gradeDynamicObject, rowIndex);
                } else {
                    this.getModel().setValue("grade", null, rowIndex);
                }
                DynamicObjectCollection entry_scorer = schemeObj.getDynamicObjectCollection("entry_scorer");
                subentryentity.clear();
                for (DynamicObject entryScorerRow : entry_scorer) {
                    DynamicObject indexclass = entryScorerRow.getDynamicObject("indexclass");
                    DynamicObject scorer = entryScorerRow.getDynamicObject("scorer");
                    BigDecimal scorerweight = entryScorerRow.getBigDecimal("scorerweight");
                    DynamicObject newRow = subentryentity.addNew();
                    newRow.set("indexclass", (Object)indexclass);
                    newRow.set("scorer", (Object)scorer);
                    newRow.set("scorerweight", (Object)scorerweight);
                }
                this.getView().updateView("subentryentity");
                break;
            }
            case "bizbillno": {
                if (rowIndex < 0) {
                    return;
                }
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                DynamicObject entryRow = (DynamicObject)entryentity.get(rowIndex);
                if (entryRow == null) break;
                String bizbilltypeId = entryRow.getString("bizbilltype.id");
                String bizbillno = entryRow.getString("bizbillno");
                if (StringUtils.isBlank((CharSequence)bizbilltypeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4e1a\u52a1\u5355\u636e\u201d\u3002", (String)"SrmEvaPlanBatchEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                } else if (StringUtils.isNotBlank((CharSequence)bizbillno)) {
                    DynamicObject bizBill = QueryServiceHelper.queryOne((String)bizbilltypeId, (String)"id,supplier", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)bizbillno)});
                    if (bizBill != null) {
                        Long supplier = bizBill.getLong("supplier");
                        entryRow.set("supplier_id", (Object)supplier);
                    } else {
                        entryRow.set("supplier", null);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5355\u53f7\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SrmEvaPlanBatchEdit_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    entryRow.set("supplier", null);
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "bizbilltype": {
                DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity");
                DynamicObject entryRow1 = (DynamicObject)entryentity1.get(rowIndex);
                entryRow1.set("bizbillno", null);
                entryRow1.set("supplier", null);
                this.getView().updateView("entryentity");
                break;
            }
            case "supplier": {
                break;
            }
            case "evamethod": {
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject row : entryentity) {
                    row.set("category", null);
                    row.set("material", null);
                    row.set("bizbillno", null);
                    row.set("bizbilltype", null);
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "indexclass": 
            case "scorer": {
                this.getView().updateView("subentryentity");
                break;
            }
            case "weightstrategy": {
                Object newWeightstrategy = arg0.getChangeSet()[0].getNewValue();
                if (newWeightstrategy == null) break;
                String weightstrategy = newWeightstrategy.toString();
                if ("A".equals(weightstrategy)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"scorerweight"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"scorerweight"});
                }
                this.getView().updateView("subentryentity");
                break;
            }
        }
    }

    private void setVisibleAndEnable() {
        DynamicObject row;
        DynamicObject scheme;
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        boolean synsupgrade = false;
        Iterator iterator = entryentity.iterator();
        while (iterator.hasNext() && ((scheme = (row = (DynamicObject)iterator.next()).getDynamicObject("scheme")) == null || !(synsupgrade = scheme.getBoolean("synsupgrade")))) {
        }
        this.getView().setVisible(Boolean.valueOf(synsupgrade), new String[]{"datetimefrom", "datetimeto"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scheme = (BasedataEdit)this.getView().getControl("scheme");
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit grade = (BasedataEdit)this.getView().getControl("grade");
        grade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit indexClass = (BasedataEdit)this.getView().getControl("indexclass");
        indexClass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scorer = (BasedataEdit)this.getView().getControl("scorer");
        scorer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit category = (BasedataEdit)this.getView().getControl("category");
        category.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent f7SelectEvent) {
        String fieldKey = f7SelectEvent.getProperty().getName();
        int row = f7SelectEvent.getRow();
        int supplierEntryRow = this.getModel().getEntryCurrentRowIndex("entryentity");
        ListShowParameter showParameter = (ListShowParameter)f7SelectEvent.getFormShowParameter();
        DynamicObject curModelData = this.getModel().getDataEntity(true);
        DynamicObjectCollection supplierEntry = curModelData.getDynamicObjectCollection("entryentity");
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"scheme")) {
            long categoryId;
            long orgId;
            long biztypeId = SrmCommonUtil.getPkValue((DynamicObject)curModelData.getDynamicObject("evatype"));
            Map resultMap = SrmBillEditUtil.getSchemeFilter((long)biztypeId, (long)(orgId = SrmCommonUtil.getPkValue((DynamicObject)curModelData.getDynamicObject("org"))), (long)(categoryId = SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)supplierEntry.get(row)).getDynamicObject("category"))));
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                f7SelectEvent.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"supplier")) {
            GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"grade")) {
            if (((DynamicObject)supplierEntry.get(row)).getDynamicObject("scheme") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bc4\u4f30\u65b9\u6848\uff0c\u518d\u9009\u62e9\u5206\u7ea7\u65b9\u6848\u3002", (String)"SrmEvaPlanBatchEdit_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                f7SelectEvent.setCancel(true);
            } else {
                String evatypeNumber = curModelData.getString("evatype.number");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("evatype.number", "=", (Object)evatypeNumber));
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"indexclass")) {
            long schemeId = SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)supplierEntry.get(supplierEntryRow)).getDynamicObject("scheme"));
            Map resultMap = SrmBillEditUtil.getIndexClassFilterFromScheme((long)schemeId);
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                f7SelectEvent.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"scorer")) {
            DynamicObject supplierEntryCurRow = (DynamicObject)supplierEntry.get(supplierEntryRow);
            DynamicObjectCollection subentryentity = supplierEntryCurRow.getDynamicObjectCollection("subentryentity");
            DynamicObject indexClass = ((DynamicObject)subentryentity.get(row)).getDynamicObject("indexclass");
            if (indexClass != null) {
                DynamicObject scorer = ((DynamicObject)subentryentity.get(row)).getDynamicObject("scorer");
                if (scorer != null) {
                    ((ListShowParameter)f7SelectEvent.getFormShowParameter()).setMultiSelect(false);
                }
            } else {
                f7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6307\u6807\u5206\u7c7b\u3002", (String)"SrmEvaPlanBatchEdit_5", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"material")) {
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"category")) {
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
        }
    }
}

