/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.srm.formplugin.edit.portrait.SrmPortraitDataService;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticContainer;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticInfo;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;
import kd.sdk.scm.srm.extpoint.portait.ISrmPortraitStatistic;

public class SrmPortraitSupplierEdit
extends AbstractBillPlugIn
implements TabSelectListener,
BeforeF7SelectListener,
ItemClickListener {
    private static final int MAX_SELECT_ORG = 5;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currency");
        MulBasedataEdit queryOrg = (MulBasedataEdit)this.getView().getControl("queryorg");
        Label ordernum = (Label)this.getView().getControl("ordernum");
        Label contractnum = (Label)this.getView().getControl("contractnum");
        Label win = (Label)this.getView().getControl("win");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        queryOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ordernum.addClickListener((ClickListener)this);
        contractnum.addClickListener((ClickListener)this);
        win.addClickListener((ClickListener)this);
        if (Objects.nonNull(tab)) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label) {
            String property;
            switch (property = ((Label)source).getKey()) {
                case "ordernum": {
                    ISrmPortraitStatistic.viewPortraitIndicatorDetail((String)"pur_order", (IFormView)this.getView(), null, null);
                    break;
                }
                case "bid": {
                    ISrmPortraitStatistic.viewPortraitIndicatorDetail((String)"src_analysetool", (IFormView)this.getView(), null, null);
                    break;
                }
                case "win": {
                    ISrmPortraitStatistic.viewPortraitIndicatorDetail((String)"src_contract", (IFormView)this.getView(), null, null);
                    break;
                }
                case "contractnum": {
                    ISrmPortraitStatistic.viewPortraitIndicatorDetail((String)"conm_purcontract", (IFormView)this.getView(), null, null);
                    break;
                }
            }
        }
    }

    private SrmPortraitContext putParamToCache() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("queryorg");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject org : orgs) {
            long orgId = org.getLong("fbasedataid_id");
            if (orgId < 0L) continue;
            orgIds.add(orgId);
        }
        Date queryFrom = this.getModel().getDataEntity(true).getDate("queryfrom");
        Date queryTo = this.getModel().getDataEntity(true).getDate("queryto");
        long currency = this.getModel().getDataEntity(true).getLong("currency_id");
        long billId = (Long)this.getView().getFormShowParameter().getCustomParam("billid");
        SrmPortraitContext srmPortraitContext = new SrmPortraitContext();
        if (orgIds.size() > 0) {
            srmPortraitContext.setOrgIds(orgIds);
        }
        AbstractSrmPortraitDataSetStatistic.dealQueryTime((SrmPortraitContext)srmPortraitContext, (Date)queryFrom, (Date)queryTo);
        srmPortraitContext.getSupplierIds().add(billId);
        srmPortraitContext.setCurrId(currency);
        ISrmPortraitStatistic.putContextToCache((IPageCache)this.getView().getPageCache(), (SrmPortraitContext)srmPortraitContext);
        return srmPortraitContext;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "query": {
                Object queryfrom = this.getModel().getValue("queryfrom");
                Object queryto = this.getModel().getValue("queryto");
                if (queryfrom == null || queryto == null) {
                    args.setCancel(true);
                    return;
                }
                this.putParamToCache();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "query": {
                SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getPageCache());
                this.createSupplierBaseInfo(context);
                this.clearSelectedTagKeys();
                this.getView().addClientCallBack("srm_portrait_access");
                break;
            }
        }
    }

    private void clearSelectedTagKeys() {
        String allTabInfo = this.getView().getPageCache().get("allTabInfo");
        if (StringUtils.isNotBlank((CharSequence)allTabInfo)) {
            List allTabInfos = (List)SerializationUtils.fromJsonString((String)allTabInfo, List.class);
            this.getView().getPageCache().batchRemove(allTabInfos);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IPageCache pageCache = this.getPageCache();
        block8: for (ChangeData data : changeSet) {
            switch (name) {
                case "currency": {
                    String amountValue;
                    String num = "contractnum";
                    String tabSelect = "tabcontract";
                    String amount = "contractamount";
                    SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)pageCache);
                    DynamicObject newValue = (DynamicObject)data.getNewValue();
                    if (newValue == null) continue block8;
                    if (StringUtils.equals((CharSequence)name, (CharSequence)"ordercurr")) {
                        num = "ordernum";
                        amount = "orderamount";
                        tabSelect = "taborder";
                    }
                    if (StringUtils.isNotBlank((CharSequence)(amountValue = this.getView().getPageCache().get(name + newValue.getPkValue())))) {
                        String[] split = amountValue.split(":");
                        Label numLabel = (Label)this.getControl(num);
                        if (split.length == 2) {
                            numLabel.setText(split[0]);
                            this.getModel().setValue(amount, (Object)split[1]);
                        } else {
                            numLabel.setText("0");
                            this.getModel().setValue(amount, (Object)0);
                        }
                        ISrmPortraitStatistic.putContextToCache((IPageCache)pageCache, (SrmPortraitContext)context);
                        this.openSubFormPage(tabSelect);
                    }
                }
                case "queryorg": {
                    Object values = data.getNewValue();
                    Object oldValues = data.getOldValue();
                    if (!(values instanceof MulBasedataDynamicObjectCollection) || !(oldValues instanceof MulBasedataDynamicObjectCollection)) continue block8;
                    if (((MulBasedataDynamicObjectCollection)values).size() > 5 && ((MulBasedataDynamicObjectCollection)oldValues).size() <= 5) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u67e5\u8be25\u4e2a\u7ec4\u7ec7\u6570\u636e\u3002", (String)"SrmPortraitSupplierEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        this.getView().getModel().setValue("queryorg", data.getOldValue());
                        continue block8;
                    }
                    if (((MulBasedataDynamicObjectCollection)values).size() > 5) continue block8;
                    this.getView().getModel().setValue("queryorg", values);
                    continue block8;
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object billId = this.getView().getFormShowParameter().getCustomParams().get("billid");
        if (billId != null) {
            String contextStr = (String)this.getView().getFormShowParameter().getCustomParams().get("context");
            SrmPortraitContext context = null;
            context = StringUtils.isNotBlank((CharSequence)contextStr) ? (SrmPortraitContext)SerializationUtils.fromJsonString((String)contextStr, SrmPortraitContext.class) : new SrmPortraitContext();
            context.getSupplierIds().add((Long)billId);
            if (context.getDateTo() == null || context.getDateFrom() == null) {
                AbstractSrmPortraitDataSetStatistic.setBeforeMonth((SrmPortraitContext)context, (Date)TimeServiceHelper.now(), (int)12);
            }
            this.getModel().setValue("queryorg", (Object)context.getOrgIds().toArray());
            this.getModel().setValue("queryfrom", (Object)context.getDateFrom());
            this.getModel().setValue("queryto", (Object)context.getDateTo());
            String message = AbstractSrmPortraitDataSetStatistic.dealQueryTime((SrmPortraitContext)context, (Date)context.getDateFrom(), (Date)context.getDateTo());
            if (StringUtils.isNotBlank((CharSequence)message)) {
                this.getView().showErrorNotification(message);
                return;
            }
            this.createSupplierBaseInfo(context);
            this.getView().addClientCallBack("srm_portrait_access");
        }
    }

    private void createSupplierBaseInfo(SrmPortraitContext context) {
        this.clearSupplierBaseInfo();
        List supplierIds = context.getSupplierIds();
        if (supplierIds != null) {
            QFilter qFilter = new QFilter("id", "in", (Object)supplierIds);
            DynamicObject supplierInfo = BusinessDataServiceHelper.loadSingle((String)"srm_supplier", (String)"name,summary,regdate,societycreditcode,address,telephone,artificialperson,post,url,email,regcapital,curr,staffnum,supplier,createtime,auditdate,enable,auditstatus,entry_aptitude.aptitudetype1,entry_aptitude.aptitudetype,entry_aptitude.dateto", (QFilter[])new QFilter[]{qFilter});
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject supplier = supplierInfo.getDynamicObject("supplier");
            dataEntity.set("regdate", (Object)supplierInfo.getDate("regdate"));
            dataEntity.set("societycreditcode", (Object)supplierInfo.getString("societycreditcode"));
            dataEntity.set("address", (Object)supplierInfo.getString("address"));
            dataEntity.set("telephone", (Object)supplierInfo.getString("telephone"));
            dataEntity.set("artificialperson", (Object)supplierInfo.getString("artificialperson"));
            dataEntity.set("post", (Object)supplierInfo.getString("post"));
            dataEntity.set("url", (Object)supplierInfo.getString("url"));
            dataEntity.set("email", (Object)supplierInfo.getString("email"));
            dataEntity.set("regcapital", (Object)supplierInfo.getBigDecimal("regcapital"));
            dataEntity.set("staffnum", (Object)supplierInfo.getInt("staffnum"));
            SrmSupplierStatusEnum auditstatus = SrmSupplierStatusEnum.fromVal((String)supplierInfo.getString("auditstatus"));
            Label label = (Label)this.getControl("auditstatustag");
            label.setText(auditstatus.getName());
            DynamicObjectCollection entryAptitudes = supplierInfo.getDynamicObjectCollection("entry_aptitude");
            Date dateTo = null;
            for (DynamicObject entryAptitude : entryAptitudes) {
                String aptitudetypeNumber = entryAptitude.getString("aptitudetype1.number");
                String aptitudetype = entryAptitude.getString("aptitudetype");
                if (!"ZZLX000001".equals(aptitudetypeNumber) && !"2".equals(aptitudetype) || dateTo != null && (dateTo == null || !dateTo.before(entryAptitude.getDate("dateto")))) continue;
                dateTo = entryAptitude.getDate("dateto");
            }
            dataEntity.set("dateto", dateTo);
            if (supplier != null) {
                DynamicObject bdSupplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier");
                dataEntity.set("suppliernametag_id", supplier.getPkValue());
                if (bdSupplier != null) {
                    dataEntity.set("picture", (Object)bdSupplier.getString("picturefield"));
                    this.getModel().setValue("currency", (Object)bdSupplier.getLong("paymentcurrency_id"));
                    if (context.getCurrId() == 0L) {
                        context.setCurrId(bdSupplier.getLong("paymentcurrency_id"));
                    }
                }
            }
            Label suppliername = (Label)this.getView().getControl("suppliername");
            suppliername.setText(supplierInfo.getString("name"));
            this.getModel().setValue("curr", (Object)supplierInfo.getLong("curr_id"));
            context.getBdSupplierIds().add(supplierInfo.getLong("supplier_id"));
            context.getCustomParam().put("accessAuditDate", SerializationUtils.toJsonString((Object)supplierInfo.getDate("auditdate")));
            context.getCustomParam().put("accessCreateTime", SerializationUtils.toJsonString((Object)supplierInfo.getDate("createtime")));
            context.getCustomParam().put("accessEnable", supplierInfo.getString("enable"));
            context.getCustomParam().put("accessStatus", supplierInfo.getString("auditstatus"));
            ISrmPortraitStatistic.putContextToCache((IPageCache)this.getPageCache(), (SrmPortraitContext)context);
            this.getView().updateView("flexbasedetail");
        }
    }

    private void clearSupplierBaseInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.set("regdate", null);
        dataEntity.set("societycreditcode", (Object)"");
        dataEntity.set("address", (Object)"");
        dataEntity.set("telephone", (Object)"");
        dataEntity.set("artificialperson", (Object)"");
        dataEntity.set("post", (Object)"");
        dataEntity.set("url", (Object)"");
        dataEntity.set("email", (Object)"");
        dataEntity.set("regcapital", (Object)"");
        dataEntity.set("staffnum", (Object)"");
        dataEntity.set("dateto", null);
        dataEntity.set("picture", (Object)"");
        dataEntity.set("curr_id", (Object)0L);
        this.clearIndicatorInfo();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.openSubFormPage(tabKey);
    }

    private void openSubFormPage(String tabKey) {
        String loaded;
        if (!StringUtils.isEmpty((CharSequence)tabKey) && StringUtils.isEmpty((CharSequence)(loaded = this.getView().getPageCache().get(tabKey)))) {
            this.showForm(tabKey);
            this.getView().getPageCache().put(tabKey, "1");
        }
    }

    private void showForm(String subPageFormId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(subPageFormId);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(subPageFormId);
        param.setStatus(OperationStatus.EDIT);
        this.getView().showForm(param);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (e.getName().equals("srm_portrait_access")) {
            this.withDrawPortraitIndicator("query");
            Tab tabap = (Tab)this.getControl("tabap");
            String subForm = StringUtils.isNotBlank((CharSequence)tabap.getCurrentTab()) ? tabap.getCurrentTab() : "srm_portrait_access";
            this.openSubFormPage(subForm);
        }
    }

    private void withDrawPortraitIndicator(String opProperty) {
        SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getPageCache());
        SrmPortraitDataService srmPortraitDataService = new SrmPortraitDataService();
        SrmPortraitStatisticContainer container = null;
        switch (opProperty) {
            case "query": {
                container = srmPortraitDataService.getSrmPortraitContainer(context);
                break;
            }
        }
        if (container == null) {
            return;
        }
        this.createBizStatisticInfo(container, context);
        this.setVisible("1", true, container);
        this.createRealTimeStatisticInfo(container);
        ISrmPortraitStatistic.putContextToCache((IPageCache)this.getView().getPageCache(), (SrmPortraitContext)context);
    }

    private void setVisible(String enable, boolean isVisible, SrmPortraitStatisticContainer container) {
        Set tags = container.getTags(enable);
        this.getView().getPageCache().put("allTabInfo", SerializationUtils.toJsonString((Object)tags));
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexcooperap", "flexbidap", "flexcontractap", "flexorderap", "flexsouap", "flexnewdegradeap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"srm_portrait_access", "srm_portrait_source", "srm_portrait_contract", "srm_portrait_purchases", "srm_portrait_kpi", "srm_portrait_compare"});
        if (tags != null && tags.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(isVisible), tags.toArray(new String[0]));
            if (tags.contains("srm_portrait_source")) {
                this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"flexbidap"});
            }
            if (tags.contains("srm_portrait_contract")) {
                this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"flexcontractap"});
            }
            if (tags.contains("srm_portrait_purchases")) {
                this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"flexorderap", "flexcooperap"});
            }
            if (tags.contains("srm_portrait_kpi")) {
                this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"flexnewdegradeap"});
            }
        }
    }

    private void createBizStatisticInfo(SrmPortraitStatisticContainer container, SrmPortraitContext context) {
        Map statisticInfoMap = container.getStatisticInfoMap();
        if (statisticInfoMap == null) {
            return;
        }
        Long curr = context.getCurrId();
        String supplierNameTag = this.getView().getModel().getDataEntity().getString("suppliernametag_id");
        SrmPortraitStatisticInfo info = (SrmPortraitStatisticInfo)statisticInfoMap.get(supplierNameTag + "-" + curr);
        Iterator iterator = statisticInfoMap.entrySet().iterator();
        ArrayList<Long> currIds = new ArrayList<Long>(10);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if (curr.longValue() == ((SrmPortraitStatisticInfo)next.getValue()).getCurrId() && info == null) {
                info = (SrmPortraitStatisticInfo)next.getValue();
            }
            currIds.add(((SrmPortraitStatisticInfo)next.getValue()).getCurrId());
        }
        this.getPageCache().put("curr", SerializationUtils.toJsonString(currIds));
        this.setBizInfo(info, context);
    }

    private void setBizInfo(SrmPortraitStatisticInfo info, SrmPortraitContext context) {
        Label ordernum = (Label)this.getView().getControl("ordernum");
        Label contractnum = (Label)this.getView().getControl("contractnum");
        Label win = (Label)this.getView().getControl("win");
        if (info != null) {
            this.getModel().setValue("currency", (Object)info.getCurrId());
            ordernum.setText(String.valueOf(info.getOrderNum()));
            win.setText(String.valueOf(info.getWinNum()));
            this.getView().getModel().setValue("orderamount", (Object)info.getAmount());
            this.getView().getModel().setValue("contractamount", (Object)info.getContractAmount());
            this.wrapContextCustomParam(context, info);
            contractnum.setText(String.valueOf(info.getContractNum()));
        } else {
            this.wrapContextCustomParam(context, null);
            this.clearIndicatorInfo();
        }
    }

    private void clearIndicatorInfo() {
        Label yearlab = (Label)this.getView().getControl("yearlab");
        Label monthtap = (Label)this.getView().getControl("monthtap");
        Label ordernum = (Label)this.getView().getControl("ordernum");
        Label contractnum = (Label)this.getView().getControl("contractnum");
        Label win = (Label)this.getView().getControl("win");
        yearlab.setText("0");
        monthtap.setText("0");
        ordernum.setText("0");
        win.setText("0");
        contractnum.setText("0");
        this.getModel().setValue("orderamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("contractamount", (Object)BigDecimal.ZERO);
        this.getView().getModel().setValue("gradedate", null);
        Label gradeLabel = (Label)this.getView().getControl("gradelabel");
        Label gradeValue = (Label)this.getView().getControl("gradevalue");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"gradevalue"});
        gradeLabel.setText("");
        gradeValue.setText("");
    }

    private void wrapContextCustomParam(SrmPortraitContext context, SrmPortraitStatisticInfo info) {
        if (context == null || context.getCustomParam() == null) {
            return;
        }
        context.getCustomParam().put("confirm", info != null ? Integer.valueOf(info.getOrderNum()) : "0");
        context.getCustomParam().put("unconfirm", info != null ? Integer.valueOf(info.getUnConFirmOrderNum()) : "0");
        context.getCustomParam().put("paidpreallamount", info != null ? info.getPaidPreAllAmount() : "0");
        context.getCustomParam().put("paidallamount", info != null ? info.getPaidAllAmount() : "0");
        context.getCustomParam().put("totalallamount", info != null ? info.getContractAmount() : "0");
        context.getCustomParam().put("winnum", info != null ? Integer.valueOf(info.getWinNum()) : "0");
    }

    private void createRealTimeStatisticInfo(SrmPortraitStatisticContainer container) {
        Map realTimeStatisticInfoMap = container.getRealTimeStatisticInfoMap();
        if (realTimeStatisticInfoMap == null) {
            return;
        }
        Map statisticMap = (Map)realTimeStatisticInfoMap.get(this.getModel().getDataEntity().getString("suppliernametag_id"));
        if (statisticMap != null) {
            String categoryName = (String)statisticMap.get("categoryname");
            String evaGradeName = (String)statisticMap.get("evagradename");
            Date modifyTime = (Date)statisticMap.get("modifytime");
            Date copTime = (Date)statisticMap.get("copTime");
            Label yearlab = (Label)this.getView().getControl("yearlab");
            Label monthtap = (Label)this.getView().getControl("monthtap");
            if (copTime != null) {
                Calendar instance = Calendar.getInstance();
                instance.setTime(copTime);
                Date now = TimeServiceHelper.now();
                Calendar instance1 = Calendar.getInstance();
                instance1.setTime(now);
                int year = instance1.get(1) - instance.get(1);
                int month = instance1.get(2) - instance.get(2);
                if (month < 0) {
                    month += 12;
                    --year;
                }
                yearlab.setText(year + "");
                monthtap.setText(month + 1 + "");
            }
            this.getView().getModel().setValue("gradedate", (Object)modifyTime);
            Label gradeLabel = (Label)this.getView().getControl("gradelabel");
            Label gradeValue = (Label)this.getView().getControl("gradevalue");
            gradeLabel.setText(categoryName);
            gradeValue.setText(evaGradeName);
            if (evaGradeName != null) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"gradevalue"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "currency": {
                String idstr = this.getView().getPageCache().get("curr");
                List customQFilters = e.getCustomQFilters();
                List<Long> ids = null;
                if (StringUtils.isNotBlank((CharSequence)idstr)) {
                    ids = (List)SerializationUtils.fromJsonString((String)idstr, List.class);
                } else {
                    ids = new ArrayList();
                    ids.add(-1L);
                }
                customQFilters.add(new QFilter("id", "in", ids));
                break;
            }
            case "queryorg": {
                ((ListShowParameter)e.getFormShowParameter()).setMultiSelect(true);
                HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"02", (String)"XV1IC150UR4", (String)"srm_supplier", (String)"3+IT7E0G9GO=");
                if (allPermOrgs != null && !allPermOrgs.hasAllOrgPerm()) {
                    QFilter orgFilter = new QFilter("id", "in", (Object)allPermOrgs.getHasPermOrgs());
                    ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(orgFilter);
                    break;
                }
                if (allPermOrgs == null || !allPermOrgs.hasAllOrgPerm()) break;
                return;
            }
        }
    }
}

