/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmRecruitStatusEnum;
import kd.scm.common.util.BillFormUtil;

public class SrmRecruitEdit
extends AbstractBillPlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        IDataModel Model = this.getModel();
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
                String text = richTextEditor.getText();
                Model.setValue("content", (Object)text);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (key.equals("bar_push") || key.equals("bar_push1688") || key.equals("bar_terminate")) {
            DynamicObject obj = this.getModel().getDataEntity();
            if (obj == null) {
                evt.setCancel(true);
                return;
            }
            String billstatus = obj.getString("billstatus");
            String bizstatus = obj.getString("bizstatus");
            int pushnotice = obj.getInt("pushnotice");
            int push1688 = obj.getInt("push1688");
            switch (key) {
                case "bar_push": {
                    if (!billstatus.equals(BillStatusEnum.AUDIT.getVal()) || !bizstatus.equals(SrmRecruitStatusEnum.RECRUITING.getValue()) || pushnotice != 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u9879\u76ee\u72b6\u6001\u4e3a\u62db\u52df\u4e2d\uff0c\u672a\u53d1\u5e03\u8fc7\u516c\u544a\u7684\u62db\u52df\u5355\u624d\u80fd\u53d1\u5e03\u516c\u544a\u3002", (String)"SrmRecruitEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                }
                case "bar_push1688": {
                    if (!billstatus.equals(BillStatusEnum.AUDIT.getVal()) || !bizstatus.equals(SrmRecruitStatusEnum.RECRUITING.getValue()) || push1688 != 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u9879\u76ee\u72b6\u6001\u4e3a\u62db\u52df\u4e2d\uff0c\u672a\u53d1\u5e03\u8fc71688\u7684\u62db\u52df\u5355\u624d\u80fd\u53d1\u5e03\u52301688\u3002", (String)"SrmRecruitEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                }
                case "bar_terminate": {
                    if (billstatus.equals(BillStatusEnum.AUDIT.getVal()) && bizstatus.equals(SrmRecruitStatusEnum.RECRUITING.getValue())) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u62db\u52df\u4e2d\u7684\u62db\u52df\u5355\u624d\u80fd\u7ed3\u675f\u3002", (String)"SrmRecruitEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_terminate": {
                this.terninate();
                break;
            }
            case "preview": {
                Long id = (Long)this.getModel().getValue("id");
                this.showDetailPage(id);
                break;
            }
        }
    }

    private void showDetailPage(Long id) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("adm_recruit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u516c\u544a\u9884\u89c8", (String)"SrmRecruitEdit_3", (String)"scm-sou-formplugin", (Object[])new Object[0]));
        showParameter.setPkId((Object)id);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("org", (Object)RequestContext.get().getOrgId());
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        richTextEditor.setText(" ");
        this.getModel().setValue("content", (Object)"");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
        IDataModel dataModel = this.getModel();
        if (dataModel.getValue("content") != null) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            richTextEditor.setText(dataModel.getValue("content").toString());
        }
    }

    private void terninate() {
        this.openDealPage("srm_recruitend", "callbackid");
    }

    private void openDealPage(String pageKey, String actionId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("billid", this.getModel().getDataEntity().getPkValue());
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)ShowType.Modal));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        BillModel model = (BillModel)this.getModel();
        switch (actionId) {
            case "callbackid": {
                model.load(model.getPKValue());
                view.updateView();
                break;
            }
        }
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
        model.setDataChanged(false);
    }

    protected String getStatusTabValue() {
        DynamicObject recruitObject = this.getModel().getDataEntity();
        String bizStatus = recruitObject.getString("bizstatus");
        return bizStatus == null ? "" : bizStatus.toLowerCase();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        IDataModel model = this.getModel();
        String text = (String)model.getValue("content");
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        if (null != text) {
            richTextEditor.setText(text);
        }
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "audit": 
            case "unaudit": 
            case "push": 
            case "terminate": {
                BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(this.getStatusTabValue() + "tab"));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        super.propertyChanged(arg0);
    }
}

