/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.BaseDataViewDetailUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;
import kd.scm.srm.common.SrmCommUtil;
import kd.scm.srm.common.enums.SrmSceneResultEnum;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;

public class SrmSceneExamEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private Set<DynamicObject> beforeDeleteJudgerSet = new HashSet<DynamicObject>(16);

    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit aptitudeno = (BasedataEdit)this.getControl("aptitudeno");
        aptitudeno.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"srm_aptitudeexam", (String)"srm_aptitudeexam"));
        });
        BasedataEdit improvebillno = (BasedataEdit)this.getControl("improvebillno");
        improvebillno.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"srm_improve", (String)"srm_improve"));
        });
        BasedataEdit category = (BasedataEdit)this.getControl("category");
        category.addBeforeF7SelectListener(x -> this.beforeF7Select(x));
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(x -> this.beforeF7Select(x));
        BasedataEdit judger = (BasedataEdit)this.getControl("judger");
        judger.addBeforeF7SelectListener(x -> this.beforeF7Select(x));
        SrmCommUtil.addValidatePreValueBeforeF7Listener((AbstractFormPlugin)this, (String)"supplier", (String)"org");
        SrmCommUtil.addAptitudeNoBeforeF7Listener((AbstractFormPlugin)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("category".equals(fieldKey)) {
            String level;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            Boolean isCategory = SrmCategoryConfigUtil.isCategory((DynamicObject)org);
            if (isCategory.booleanValue() && (level = SrmCategoryConfigUtil.getCategoryLeve((DynamicObject)org)) != null && !level.isEmpty()) {
                QFilter qFilter = new QFilter("level", "=", (Object)Integer.valueOf(level));
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        } else if ("material".equals(fieldKey)) {
            DynamicObjectCollection groups;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            String level = SrmCategoryConfigUtil.getCategoryLeve((DynamicObject)org);
            if (StringUtils.isNotEmpty((CharSequence)level) && StringUtils.isNumeric((CharSequence)level) && !CollectionUtils.isEmpty((Collection)(groups = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("level", "=", (Object)Integer.valueOf(level))})))) {
                List ids = groups.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                QFilter filter = new QFilter("group.id", "in", ids);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        } else if ("judger".equals(fieldKey)) {
            int row = beforeF7SelectEvent.getRow();
            DynamicObject judger = ((DynamicObject)this.getModel().getEntryEntity("auditentryentity").get(row)).getDynamicObject("judger");
            if (judger != null) {
                this.getPageCache().put("curjudger", judger.getPkValue().toString());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.sceneSesult();
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isscene", "issample", "ismaterial", "isapprove"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isscene", "issample", "ismaterial", "isapprove"});
        }
        this.setVisible();
    }

    private void setVisible() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (pkValue != null && pkValue.toString().equals("0")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mobileinspect", "mobileinspect"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mobileinspect", "mobileinspect"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "auditdeleteentry": {
                this.initJudgerInfo();
            }
        }
    }

    private void initJudgerInfo() {
        this.beforeDeleteJudgerSet.clear();
        DynamicObject model = this.getModel().getDataEntity(true);
        DynamicObjectCollection auditEntryEntity = model.getDynamicObjectCollection("auditentryentity");
        for (DynamicObject auditEntryEntityRow : auditEntryEntity) {
            DynamicObject judger = auditEntryEntityRow.getDynamicObject("judger");
            this.beforeDeleteJudgerSet.add(judger);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        this.setVisible();
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "inspectnewentry": {
                this.addDefault("inspectentryentity", "isleader");
                break;
            }
            case "auditdeleteentry": {
                this.buildInspectEntry();
                break;
            }
            case "mobileinspect": {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                OperationResult saveoperationResult = SaveServiceHelper.saveOperate((String)"srm_sceneexam", (DynamicObject[])new DynamicObject[]{dataEntity}, null);
                if (saveoperationResult.isSuccess()) break;
                this.log.info("\u70b9\u51fb\u79fb\u52a8\u8bc4\u5ba1\u5e76\u4e0b\u63a8\u79fb\u52a8\u8bc4\u5ba1\u5355\u540e\u73b0\u573a\u8bc4\u5ba1\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25" + saveoperationResult.getAllErrorOrValidateInfo() + saveoperationResult.getMessage());
                break;
            }
        }
    }

    private void addDefault(String entryName, String defaultField) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(entryName);
        boolean hasDefault = false;
        for (DynamicObject entryRow : entry) {
            String isdefault = entryRow.getString(defaultField);
            if (!isdefault.equals("true")) continue;
            hasDefault = true;
            break;
        }
        if (!hasDefault) {
            this.getModel().setValue(defaultField, (Object)"1", entry.size() - 1);
        }
    }

    private void setEntryEntityEnable() {
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propertyName;
        super.propertyChanged(arg0);
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        switch (propertyName = arg0.getProperty().getName()) {
            case "org": 
            case "supplier": {
                SrmBillEditUtil.setAptitudeNo((IDataModel)this.getModel(), (String)"isscene", (String)"hasscene");
                this.sceneSesult();
                this.suplierChang();
                this.setCategory();
                break;
            }
            case "aptitudeno": {
                SrmBillEditUtil.setCategory((AbstractFormDataModel)((AbstractFormDataModel)this.getModel()));
                this.setCategory();
                break;
            }
            case "categorytype": {
                String categorytype = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex)).getString("categorytype");
                if (categorytype.equals("A")) {
                    this.getModel().setValue("category", null, rowIndex);
                    break;
                }
                if (!categorytype.equals("B")) break;
                this.getModel().setValue("category", null, rowIndex);
                this.getModel().setValue("material", null, rowIndex);
                break;
            }
            case "category": {
                String categorytype = this.getModel().getEntryRowEntity("entryentity", rowIndex).getString("categorytype");
                if (!categorytype.equals("B")) break;
                break;
            }
            case "material": {
                DynamicObject materialObj = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex)).getDynamicObject("material");
                if (materialObj != null) {
                    Long materialId = materialObj.getLong("id");
                    DynamicObject materialDyo = QueryServiceHelper.queryOne((String)"bd_materialgroupdetail", (String)"group.id", (QFilter[])new QFilter[]{new QFilter("standard.number", "=", (Object)"JBFLBZ"), new QFilter("material.id", "=", (Object)materialId)});
                    Long groupId = materialDyo.getLong("group.id");
                    DynamicObject mateGroup = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroup", (String)"fullname,masterid,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupId)});
                    this.getModel().setValue("categorytype", (Object)"A", rowIndex);
                    this.getModel().setValue("category", (Object)mateGroup, rowIndex);
                    break;
                }
                this.getModel().setValue("category", null, rowIndex);
                break;
            }
            case "isleader": {
                this.setDefault("inspectentryentity", "isleader", rowIndex);
                break;
            }
            case "judger": {
                this.buildInspectEntry();
                break;
            }
        }
    }

    private void buildInspectEntry() {
        this.reBuildInspectEntry();
        this.getView().updateView("inspectentryentity");
    }

    private void reBuildInspectEntry() {
        DynamicObject newRow;
        DynamicObject model = this.getModel().getDataEntity(true);
        DynamicObjectCollection auditEntryEntity = model.getDynamicObjectCollection("auditentryentity");
        DynamicObjectCollection inspectEntryEntity = model.getDynamicObjectCollection("inspectentryentity");
        HashMap<DynamicObject, Boolean> userMap = new HashMap<DynamicObject, Boolean>(16);
        String leaderId = "";
        for (DynamicObject inspectEntryRow : inspectEntryEntity) {
            DynamicObject inspectstaff = inspectEntryRow.getDynamicObject("inspectstaff");
            boolean bl = inspectEntryRow.getBoolean("isleader");
            if (bl && inspectstaff != null) {
                leaderId = inspectstaff.getPkValue().toString();
            }
            if (inspectstaff == null) continue;
            userMap.put(inspectstaff, bl);
        }
        for (DynamicObject auditEntryEntityRow : auditEntryEntity) {
            DynamicObject judger = auditEntryEntityRow.getDynamicObject("judger");
            if (!userMap.containsKey(judger)) continue;
            userMap.remove(judger);
        }
        for (DynamicObject judger : this.beforeDeleteJudgerSet) {
            if (!userMap.containsKey(judger)) continue;
            userMap.remove(judger);
        }
        inspectEntryEntity.clear();
        String curjudger = this.getPageCache().get("curjudger");
        boolean hasLeader = false;
        if (!userMap.isEmpty()) {
            for (Map.Entry entry : userMap.entrySet()) {
                DynamicObject key = (DynamicObject)entry.getKey();
                String pk = key.getPkValue().toString();
                if (pk.equals(curjudger)) continue;
                Boolean value = (Boolean)entry.getValue();
                newRow = inspectEntryEntity.addNew();
                newRow.set("inspectstaff", (Object)key);
                newRow.set("isleader", (Object)value);
                if (!value.booleanValue()) continue;
                hasLeader = true;
            }
        }
        HashSet<DynamicObject> inspectEntryEntityStaffSet = new HashSet<DynamicObject>(16);
        for (DynamicObject auditEntryRow : auditEntryEntity) {
            DynamicObject judger = auditEntryRow.getDynamicObject("judger");
            if (judger == null || inspectEntryEntityStaffSet.contains(judger)) continue;
            inspectEntryEntityStaffSet.add(judger);
            String judgerId = judger.getPkValue().toString();
            newRow = inspectEntryEntity.addNew();
            newRow.set("inspectstaff", (Object)judger);
            if (!leaderId.equals(judgerId)) continue;
            newRow.set("isleader", (Object)true);
            hasLeader = true;
        }
        if (!hasLeader && !inspectEntryEntity.isEmpty()) {
            ((DynamicObject)inspectEntryEntity.get(0)).set("isleader", (Object)true);
        }
    }

    private void setDefault(String entryName, String defaultField, int rowIndex) {
        String value = this.getModel().getValue(defaultField, rowIndex).toString();
        if (value.equals("true")) {
            int size = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName).size();
            for (int i = 0; i < size; ++i) {
                if (i == rowIndex) continue;
                this.getModel().setValue(defaultField, (Object)false, i);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String ItemKey = evt.getItemKey();
        if (ItemKey.equals("barsubmit")) {
            this.delRepeatRow("entryentity", "category", "material");
            this.delRepeatRow("inspectentryentity", "inspectstaff", null);
        } else if (ItemKey.equals("mobileinspect")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            OperationResult saveoperationResult = SaveServiceHelper.saveOperate((String)"srm_sceneexam", (DynamicObject[])new DynamicObject[]{dataEntity}, null);
            if (!saveoperationResult.isSuccess()) {
                this.log.info("\u70b9\u51fb\u79fb\u52a8\u8bc4\u5ba1\u540e\u4e0b\u63a8\u79fb\u52a8\u8bc4\u5ba1\u5355\u524d\u73b0\u573a\u8bc4\u5ba1\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25" + saveoperationResult.getAllErrorOrValidateInfo() + saveoperationResult.getMessage());
            }
        }
    }

    private void setCategory() {
        if (Objects.nonNull(this.getModel().getValue("aptitudeno"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pl_category"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"entryentity"});
            this.categoryVisibleBySyscategory();
        }
    }

    private void categoryVisibleBySyscategory() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        Boolean categoryConfig = SrmCategoryConfigUtil.isCategory((DynamicObject)org);
        if (!categoryConfig.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pl_category"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pl_category"});
        }
    }

    private void suplierChang() {
        List isdefault_link;
        DynamicObject suplierDy = this.getModel().getDataEntity().getDynamicObject("supplier");
        if (Objects.isNull(suplierDy)) {
            this.getModel().setValue("supplierlinkman", null);
            this.getModel().setValue("supplierlinkmobile", null);
            this.getModel().setValue("supplierlinkemail", null);
            return;
        }
        Object certifiapplyId = suplierDy.get("certifiapply.id");
        String regtype = suplierDy.getString("regtype");
        DynamicObjectCollection entry_link = suplierDy.getDynamicObjectCollection("entry_link");
        if (Objects.nonNull(certifiapplyId) || "0".equals(regtype)) {
            this.getModel().setValue("caapplyid", certifiapplyId);
            this.getModel().setValue("applytype", (Object)"0");
        } else {
            this.getModel().setValue("caapplyid", null);
            this.getModel().setValue("applytype", (Object)"1");
        }
        if (!CollectionUtils.isEmpty((Collection)entry_link) && !CollectionUtils.isEmpty(isdefault_link = entry_link.stream().filter(x -> x.getBoolean("isdefault_link")).collect(Collectors.toList()))) {
            this.getModel().setValue("supplierlinkman", ((DynamicObject)isdefault_link.get(0)).get("name1"));
            this.getModel().setValue("supplierlinkemail", ((DynamicObject)isdefault_link.get(0)).get("email1"));
            this.getModel().setValue("supplierlinkmobile", ((DynamicObject)isdefault_link.get(0)).get("mobile1"));
        }
    }

    public void sceneSesult() {
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        if (null != supplier) {
            DynamicObject normalSupplier;
            Object supplierId = supplier.get("supplier.id");
            Object statusPk = null;
            if (supplierId != null && (normalSupplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier", (String)"supplier_status.id")) != null) {
                statusPk = normalSupplier.get("supplier_status.id");
            }
            ComboEdit ce = (ComboEdit)this.getControl("sceneresult");
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
            for (SrmSceneResultEnum srmSceneResultEnum : SrmSceneResultEnum.values()) {
                ComboItem ci = new ComboItem(new LocaleString(srmSceneResultEnum.getName()), srmSceneResultEnum.getVal());
                if (BillAssistConstant.SUPPLIER_STATUS_LATENT.equals(statusPk) && srmSceneResultEnum.getVal().equals("3")) continue;
                comboItemList.add(ci);
            }
            ce.setComboItems(comboItemList);
        }
    }

    private void delRepeatRow(String entryName, String field1, String field2) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryName);
        HashMap<String, Integer> hasMap = new HashMap<String, Integer>(32);
        ArrayList<Integer> delIndexList = new ArrayList<Integer>(32);
        int index = 0;
        for (DynamicObject rowDyo : entryentity) {
            DynamicObject baseData2;
            String key = "";
            DynamicObject baseData1 = rowDyo.getDynamicObject(field1);
            if (baseData1 != null) {
                key = key + baseData1.getString("id");
            }
            if (field2 != null && !field2.equals("") && (baseData2 = rowDyo.getDynamicObject(field2)) != null) {
                key = key + baseData2.getString("id");
            }
            if (hasMap.containsKey(key)) {
                delIndexList.add(index);
            } else {
                hasMap.put(key, 1);
            }
            ++index;
        }
        int[] delIndexArray = new int[delIndexList.size()];
        for (int j = 0; j < delIndexList.size(); ++j) {
            delIndexArray[j] = (Integer)delIndexList.get(j);
        }
        IDataModel entryOp = this.getModel();
        entryOp.deleteEntryRows(entryName, delIndexArray);
    }
}

