/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;

public class SrmSupGradeTabEdit
extends AbstractBasePlugIn
implements TabSelectListener,
HyperLinkClickListener {
    private static final String TABAP = "tabap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        if (Objects.nonNull(tab)) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        EntryGrid supgradeentrygrid = (EntryGrid)this.getControl("supgradeentry");
        supgradeentrygrid.addHyperClickListener(this::hyperLinkClick);
        EntryGrid historysupgradeentry = (EntryGrid)this.getControl("historysupgradeentry");
        historysupgradeentry.addHyperClickListener(this::hyperLinkClick);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("supgradeinfo".equals(tabKey)) {
            long bdsupplier = this.getModel().getDataEntity().getLong("supplier.id");
            List orgs = OrgUtil.getAllViewPermissionOrgs((String)"bd_suppliergrade");
            DynamicObjectCollection supgrades = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"PbdSupplierGradeService", (String)"querySupplierGrade", (Object[])new Object[]{bdsupplier, orgs});
            this.initEntry(supgrades, "supgradeentry");
            DynamicObjectCollection gradeHistoryData = this.queryGradeHistoryData(orgs, bdsupplier);
            DynamicObjectCollection scoreRptHistoryData = this.queryScoreRptHistoryData(orgs, bdsupplier);
            if (Objects.nonNull(gradeHistoryData) && Objects.nonNull(scoreRptHistoryData)) {
                gradeHistoryData.addAll((Collection)scoreRptHistoryData);
                this.initEntry(gradeHistoryData, "historysupgradeentry");
            }
        }
    }

    private void initEntry(DynamicObjectCollection supgradeData, String entryName) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryName);
        if (!CollectionUtils.isEmpty((Collection)supgradeData)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            DataEntityPropertyCollection properties = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(entryName).getDynamicObjectType().getProperties();
            List props = properties.stream().map(x -> x.getName()).collect(Collectors.toList());
            for (int i = 0; i < supgradeData.size(); ++i) {
                DynamicObject supgrade = (DynamicObject)supgradeData.get(i);
                String name = supgrade.getDataEntityType().getName();
                List supgradeNames = supgrade.getDataEntityType().getProperties().stream().map(x -> x.getName()).collect(Collectors.toList());
                for (String prop : props) {
                    Object value;
                    String[] grade_s;
                    if ("seq".equals(prop)) {
                        vs.set("seq", (Object)(i + 1), i);
                    }
                    if ("historysupgradeentry".equals(entryName)) {
                        if (supgradeNames.contains("id")) {
                            vs.set("hgrade_sourcetype", (Object)"A", i);
                        } else {
                            vs.set("hgrade_sourcetype", (Object)"B", i);
                        }
                    }
                    if ((grade_s = prop.split("grade_")).length <= 1 || !supgradeNames.contains(grade_s[1]) || !Objects.nonNull(value = supgrade.get(grade_s[1]))) continue;
                    vs.set(prop, value, i);
                }
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(entryName, vs);
            this.getModel().endInit();
            this.getView().updateView(entryName);
        } else {
            BizLog.log((String)" initEntry gradeData is null");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if ("grade_source".equals(fieldName)) {
            this.clickHyper(rowIndex, "supgradeentry", "grade_sourcetype", "grade_source");
        }
        if ("hgrade_source".equals(fieldName)) {
            this.clickHyper(rowIndex, "historysupgradeentry", "hgrade_sourcetype", "hgrade_source");
        }
    }

    public void clickHyper(int rowIndex, String entryName, String sourcetype, String source) {
        DynamicObject dynamicObject;
        DynamicObjectCollection supgradeentry = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName);
        if (!CollectionUtils.isEmpty((Collection)supgradeentry) && Objects.nonNull(dynamicObject = (DynamicObject)supgradeentry.get(rowIndex))) {
            DynamicObject dynamicObjectdb;
            String grade_sourcetype = dynamicObject.getString(sourcetype);
            String grade_source = dynamicObject.getString(source);
            if ("A".equals(grade_sourcetype) && !StringUtils.isEmpty((Object)grade_source)) {
                DynamicObject dynamicObjectdb2 = QueryServiceHelper.queryOne((String)"bd_suppliergrade_enter", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)grade_source)});
                if (Objects.nonNull(dynamicObjectdb2)) {
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"bd_suppliergrade_enter", (Object)dynamicObjectdb2.get("id"), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
                }
            } else if ("B".equals(grade_sourcetype) && !StringUtils.isEmpty((Object)grade_source) && Objects.nonNull(dynamicObjectdb = QueryServiceHelper.queryOne((String)"srm_scorerpt", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)grade_source)}))) {
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_scorerpt", (Object)dynamicObjectdb.get("id"), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
            }
        }
    }

    public DynamicObjectCollection queryGradeHistoryData(List<Long> orgs, Long bdsupplierid) {
        QFilter qFilter = new QFilter("org.id", "in", orgs);
        qFilter.and(new QFilter("bdsupplier.id", "=", (Object)bdsupplierid));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        Date today = TimeServiceHelper.now();
        Date twoYearsBefore = KDDateUtils.addYears((Date)today, (int)-2);
        qFilter.and(new QFilter("createtime", ">=", (Object)twoYearsBefore));
        qFilter.and(new QFilter("createtime", "<=", (Object)today));
        DynamicObjectCollection bd_suppliergrade_enter = QueryServiceHelper.query((String)"bd_suppliergrade_enter", (String)"id,billno as source,createtime,org,entryentity.category as category,entryentity.evagrade as evagrade,entryentity.datetimefrom as datetimefrom,entryentity.datetimeto as datetimeto", (QFilter[])new QFilter[]{qFilter});
        return bd_suppliergrade_enter;
    }

    public DynamicObjectCollection queryScoreRptHistoryData(List<Long> orgs, Long bdsupplierid) {
        Date today = TimeServiceHelper.now();
        Date twoYearsBefore = KDDateUtils.addYears((Date)today, (int)-2);
        QFilter scorptQFilter = new QFilter("org.id", "in", orgs);
        scorptQFilter.and(new QFilter("supplier.id", "=", (Object)bdsupplierid));
        scorptQFilter.and(new QFilter("bizstatus", "=", (Object)"G"));
        scorptQFilter.and(new QFilter("scheme.synsupgrade", "=", (Object)Boolean.TRUE));
        scorptQFilter.and(new QFilter("createtime", ">=", (Object)twoYearsBefore));
        scorptQFilter.and(new QFilter("createtime", "<=", (Object)today));
        DynamicObjectCollection srm_scorerpt = QueryServiceHelper.query((String)"srm_scorerpt", (String)"org,createtime,billno as source,datetimefrom,datetimeto,auditgrade as evagrade,category", (QFilter[])new QFilter[]{scorptQFilter});
        return srm_scorerpt;
    }
}

