/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit.autoeva;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.sdk.sdkutil.GroupStandardUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillEditUtil;
import kd.scm.srm.common.autoeva.SrmAutoEvaTplUtil;

public class SrmAutoEvaTplPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private boolean isChanging = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit grade = (BasedataEdit)this.getView().getControl("grade");
        grade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit indexClass = (BasedataEdit)this.getView().getControl("indexclass");
        indexClass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit evaindexclass = (BasedataEdit)this.getView().getControl("evaindexclass");
        evaindexclass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit evasupplier = (BasedataEdit)this.getView().getControl("evasupplier");
        evasupplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit evacategory = (BasedataEdit)this.getView().getControl("evacategory");
        evacategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit evamaterial = (BasedataEdit)this.getView().getControl("evamaterial");
        evamaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit evagrade = (BasedataEdit)this.getView().getControl("evagrade");
        evagrade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        int rowIndex = beforeF7SelectEvent.getRow();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"grade")) {
            if (this.getModel().getDataEntity().getDynamicObject("scheme") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bc4\u4f30\u65b9\u6848\uff0c\u518d\u9009\u62e9\u5206\u7ea7\u65b9\u6848\u3002", (String)"SrmAutoEvaTplPlugin_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"evagrade")) {
            if (((DynamicObject)this.getModel().getEntryEntity("evasupentry").get(rowIndex)).getDynamicObject("evascheme") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bc4\u4f30\u65b9\u6848\uff0c\u518d\u9009\u62e9\u5206\u7ea7\u65b9\u6848\u3002", (String)"SrmAutoEvaTplPlugin_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"indexclass")) {
            Map resultMap = SrmBillEditUtil.getIndexClassFilterFromScheme((IDataModel)this.getModel());
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                beforeF7SelectEvent.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"supplier")) {
            DynamicObjectCollection supplierEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity1");
            ArrayList<Long> supplierList = new ArrayList<Long>(10);
            for (DynamicObject entryRow : supplierEntry) {
                if (entryRow == null) continue;
                long supplier = entryRow.getLong("supplier.id");
                supplierList.add(supplier);
            }
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", supplierList));
            GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"evasupplier")) {
            GroupStandardUtil.getSupplierGroupStandard((ListShowParameter)showParameter);
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"evamaterial")) {
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"evacategory")) {
            GroupStandardUtil.getMaterialGroupStandard((ListShowParameter)showParameter, (String)"srm");
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"evaindexclass")) {
            int supplierEntryRow = this.getModel().getEntryCurrentRowIndex("evasupentry");
            DynamicObject curModelData = this.getModel().getDataEntity(true);
            DynamicObjectCollection supplierEntry = curModelData.getDynamicObjectCollection("evasupentry");
            long schemeId = SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)supplierEntry.get(supplierEntryRow)).getDynamicObject("evascheme"));
            Map resultMap = SrmBillEditUtil.getIndexClassFilterFromScheme((long)schemeId);
            if (((Boolean)resultMap.get("succed")).booleanValue()) {
                showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
            } else {
                this.getView().showTipNotification(resultMap.get("message").toString());
                beforeF7SelectEvent.setCancel(true);
            }
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        FormOperate oprate = (FormOperate)evt.getSource();
        String operationKey = oprate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)operationKey)) {
            FilterCondition filterCondition = this.getFilterCondition();
            this.saveFilterToText(filterCondition);
            this.saveConditionToText(filterCondition);
            String repeatnumber = this.getModel().getDataEntity().getString("repeatnumber");
            if (StringUtils.isBlank((CharSequence)repeatnumber) || Long.parseLong(repeatnumber) == 0L) {
                this.getModel().setValue("repeatnumber", (Object)1L);
            }
        }
        super.beforeDoOperation(evt);
    }

    private FilterCondition getFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private void saveFilterToText(FilterCondition condition) {
        DynamicObject billobject = this.getModel().getDataEntity().getDynamicObject("billobject");
        if (billobject == null) {
            return;
        }
        String number = billobject.getString("number");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)number);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
        filterBuilder.buildFilter();
        QFilter qFilter = filterBuilder.getQFilter();
        String filtertext = null;
        if (qFilter != null) {
            filtertext = qFilter.toSerializedString();
        }
        this.getModel().setValue("filtertext_tag", (Object)filtertext);
    }

    private void saveConditionToText(FilterCondition filterCondition) {
        String conditionstr = null;
        if (filterCondition != null) {
            conditionstr = SerializationUtils.toJsonString((Object)filterCondition);
        }
        this.getModel().setValue("conditiontext_tag", (Object)conditionstr);
    }

    public void afterBindData(EventObject e) {
        this.setBillOprationItemsandFilter();
        this.setFilterGridvalue();
        this.setScorerValueType();
        this.setMustInput();
        this.setDesc();
        super.afterBindData(e);
    }

    private void setBillOprationItemsandFilter() {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObject billentity = data.getDynamicObject("billobject");
        if (null == billentity) {
            return;
        }
        String entityName = billentity.getString("number");
        this.setOpertionCombListValue(entityName, "op");
        this.setBasedataCombListValue(entityName, "bos_org", "evaorgvalue");
        this.setBasedataCombListValue(entityName, "bd_supplier", "suppliervalue");
        this.setBasedataCombListValue(entityName, "bos_user", "scorervalue");
        this.setEntryBasedataCombListValue(entityName, "bd_material", "materialvalue");
        this.setEntryBasedataCombListValue(entityName, "bd_materialgroup", "categoryvalue");
        this.setDateTimePropCombListValue(entityName, "timevalue");
        this.setFilterGrid(entityName);
    }

    private void setFilterGrid(String entityNumber) {
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterFieldBuildOption option = new FilterFieldBuildOption();
            List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            this.clearFilterGrid();
            filterGrid.setEntityNumber(entityNumber);
            filterGrid.setFilterColumns(cols);
            this.getView().updateView("filtergridap");
        }
    }

    private void initPage() {
        this.clearFilterGrid();
        this.getModel().setValue("op", null);
        this.getModel().setValue("evaorgvalue", null);
        this.getModel().setValue("suppliervalue", null);
        this.getModel().setValue("categoryvalue", null);
        this.getModel().setValue("materialvalue", null);
        this.getModel().setValue("timevalue", null);
        List combList = null;
        ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl("op");
        fieldsCombo.setComboItems(combList);
        fieldsCombo = (ComboEdit)this.getView().getControl("evaorgvalue");
        fieldsCombo.setComboItems(combList);
        fieldsCombo = (ComboEdit)this.getView().getControl("suppliervalue");
        fieldsCombo.setComboItems(combList);
        fieldsCombo = (ComboEdit)this.getView().getControl("scorervalue");
        fieldsCombo.setComboItems(combList);
        fieldsCombo = (ComboEdit)this.getView().getControl("categoryvalue");
        fieldsCombo.setComboItems(combList);
        fieldsCombo = (ComboEdit)this.getView().getControl("materialvalue");
        fieldsCombo.setComboItems(combList);
        fieldsCombo = (ComboEdit)this.getView().getControl("timevalue");
        fieldsCombo.setComboItems(combList);
        this.getView().updateView("op");
        this.getView().updateView("evaorgvalue");
        this.getView().updateView("suppliervalue");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entryRow : entryentity) {
            entryRow.set("indexclass", null);
            entryRow.set("scorervaluetype", null);
            entryRow.set("scorervalue", null);
            entryRow.set("scorer", null);
            entryRow.set("scorerweight", null);
        }
        entryentity.clear();
        this.setScorerEntryFromScheme();
        this.getView().updateView("entryentity");
    }

    private void clearFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        condition.getFilterRow().clear();
        filterGrid.SetValue(condition);
        filterGrid.getFieldColumns().clear();
        filterGrid.getFilterFieldKeys().clear();
    }

    private void setFilterGridvalue() {
        Object filterObj = this.getModel().getValue("conditiontext_tag");
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((Object)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj.toString(), FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = changedData[0].getNewValue();
        switch (propertyName) {
            case "pushtype": {
                if (newValue == null || !"srm_evaplan".equals(newValue.toString())) break;
                this.getModel().setValue("evamethod", (Object)"A");
                break;
            }
            case "billobject": {
                this.initPage();
                if (null == newValue) {
                    return;
                }
                this.setBillOprationItemsandFilter();
                break;
            }
            case "exectype": 
            case "scheme": 
            case "autogetvalue": 
            case "timerange": {
                String pushtype;
                if ("scheme".equals(propertyName)) {
                    this.isChanging = true;
                    this.setScorerEntryFromScheme();
                    this.isChanging = false;
                } else if ("exectype".equals(propertyName)) {
                    this.getModel().setValue("repeatunit", null);
                    this.getModel().setValue("execmonth", null);
                    this.getModel().setValue("execday", null);
                    this.getModel().setValue("billobject", null);
                    this.getModel().setValue("op", null);
                    this.getModel().setValue("evaorgvalue", null);
                    this.getModel().setValue("suppliervalue", null);
                    this.getModel().setValue("categoryvalue", null);
                    this.getModel().setValue("materialvalue", null);
                    this.getModel().setValue("timevalue", null);
                    this.initPage();
                    if (newValue != null && "2".equals(newValue.toString())) {
                        this.getModel().setValue("evamethod", (Object)"A");
                    }
                } else if ("autogetvalue".equals(propertyName) && StringUtils.isNotBlank((CharSequence)(pushtype = this.getModel().getDataEntity().getString("pushtype"))) && "srm_evaplan_batch".equals(pushtype) && newValue != null && !((Boolean)newValue).booleanValue()) {
                    this.getModel().setValue("scheme", null);
                }
                this.setScorerValueType();
                this.setMustInput();
                break;
            }
            case "scorervaluetype": {
                if ("1".equals(newValue.toString())) {
                    this.getModel().setValue("scorervalue", null, rowIndex);
                    break;
                }
                if ("2".equals(newValue.toString())) {
                    this.getModel().setValue("scorer", null, rowIndex);
                    break;
                }
                this.getModel().setValue("scorervalue", null, rowIndex);
                this.getModel().setValue("scorer", null, rowIndex);
                break;
            }
            case "repeatnumber": 
            case "repeatunit": 
            case "execmonth": 
            case "execday": 
            case "exectime": 
            case "effectivedate": 
            case "expiringdate": {
                this.setDesc();
                break;
            }
            case "istypescorer": {
                if (this.isChanging) {
                    return;
                }
                this.getModel().deleteEntryData("entryentity");
                this.getModel().insertEntryRow("entryentity", 0);
                break;
            }
            case "evascheme": {
                DynamicObject newScheme = (DynamicObject)newValue;
                DynamicObjectCollection supplierEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("evasupentry");
                DynamicObjectCollection subentryentity = ((DynamicObject)supplierEntry.get(rowIndex)).getDynamicObjectCollection("evascorerentry");
                if (newScheme == null) {
                    this.getModel().setValue("grade", null, rowIndex);
                    subentryentity.clear();
                    this.getView().updateView("evascorerentry");
                    return;
                }
                long schemeId = newScheme.getLong("id");
                DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
                if (schemeObj == null) {
                    return;
                }
                DynamicObject gradeDynamicObject = schemeObj.getDynamicObject("grade");
                if (Objects.nonNull(gradeDynamicObject)) {
                    this.getModel().setValue("evagrade", (Object)gradeDynamicObject, rowIndex);
                } else {
                    this.getModel().setValue("evagrade", null, rowIndex);
                }
                DynamicObjectCollection entry_scorer = schemeObj.getDynamicObjectCollection("entry_scorer");
                subentryentity.clear();
                for (DynamicObject entryScorerRow : entry_scorer) {
                    DynamicObject indexclass = entryScorerRow.getDynamicObject("indexclass");
                    DynamicObject scorer = entryScorerRow.getDynamicObject("scorer");
                    BigDecimal scorerweight = entryScorerRow.getBigDecimal("scorerweight");
                    DynamicObject newRow = subentryentity.addNew();
                    newRow.set("evaindexclass", (Object)indexclass);
                    newRow.set("evascorer", (Object)scorer);
                    newRow.set("evascorerweight", (Object)scorerweight);
                }
                this.getView().updateView("evascorerentry");
                break;
            }
        }
    }

    private void setScorerEntryFromScheme() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        long schemeId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("scheme"));
        if (schemeId == 0L) {
            this.getModel().setValue("grade", null);
            return;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
        if (schemeObj == null) {
            return;
        }
        this.getModel().setValue("istypescorer", (Object)schemeObj.getBoolean("istypescorer"));
        DynamicObject gradeDynamicObject = schemeObj.getDynamicObject("grade");
        if (Objects.nonNull(gradeDynamicObject)) {
            this.getModel().setValue("grade", (Object)gradeDynamicObject);
        } else {
            this.getModel().setValue("grade", null);
        }
        DynamicObjectCollection scorerEntries = schemeObj.getDynamicObjectCollection("entry_scorer");
        if (scorerEntries == null || scorerEntries.size() == 0) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < scorerEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)scorerEntries.get(i);
            long indexclass = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("indexclass"));
            long scorer = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("scorer"));
            BigDecimal scorerweight = entry.getBigDecimal("scorerweight");
            vs.set("seq", (Object)(i + 1), i);
            vs.set("scorervaluetype", (Object)"1", i);
            vs.set("indexclass", (Object)indexclass, i);
            vs.set("scorer", (Object)scorer, i);
            vs.set("scorerweight", (Object)scorerweight, i);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void setOpertionCombListValue(String entityName, String controlName) {
        ComboEdit fieldsCombo;
        IFormView view = this.getView();
        List<ComboItem> combList = this.getOpreateComboItemList(entityName);
        if (null != combList && combList.size() != 0 && null != (fieldsCombo = (ComboEdit)view.getControl(controlName))) {
            fieldsCombo.setComboItems(combList);
        }
    }

    private List<ComboItem> getOpreateComboItemList(String entityNumber) {
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(16);
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if (dataEntityOperate.size() == 0) {
            return comboList;
        }
        Set<String> removeOpType = this.getRemoveOpType();
        LocaleString localeString = null;
        for (Map operate : dataEntityOperate) {
            String key = (String)operate.get("key");
            Object name = operate.get("name");
            String type = (String)operate.get("type");
            if (removeOpType.contains(type) || name == null) continue;
            localeString = new LocaleString(ResManager.loadKDString((String)"\u672a\u547d\u540d\u64cd\u4f5c", (String)"SrmAutoEvaTplPlugin_13", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            localeString = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)) : new LocaleString(name.toString());
            comboList.add(new ComboItem(localeString, key));
        }
        return comboList;
    }

    private Set<String> getRemoveOpType() {
        HashSet<String> removeOpType = new HashSet<String>(16);
        removeOpType.add("importexport_userset");
        removeOpType.add("reset");
        removeOpType.add("importtemplatelist");
        removeOpType.add("exportdetails");
        removeOpType.add("exportlistdownload");
        removeOpType.add("exportlist_expt");
        removeOpType.add("exportlist");
        removeOpType.add("importdetails");
        removeOpType.add("importdata");
        removeOpType.add("importtemplate");
        removeOpType.add("newimporttemplate");
        removeOpType.add("returndata");
        removeOpType.add("delete");
        removeOpType.add("last");
        removeOpType.add("next");
        removeOpType.add("previous");
        removeOpType.add("first");
        removeOpType.add("viewapprovalrecord");
        removeOpType.add("imagereview");
        removeOpType.add("viewapprovalrecord");
        removeOpType.add("viewflowchart");
        removeOpType.add("imagereview");
        removeOpType.add("trackall");
        removeOpType.add("trackup");
        removeOpType.add("trackdown");
        removeOpType.add("draw");
        removeOpType.add("view");
        removeOpType.add("copy");
        removeOpType.add("modify");
        removeOpType.add("new");
        removeOpType.add("exportentry");
        removeOpType.add("switchentryview");
        removeOpType.add("configuregrid");
        removeOpType.add("batchcopyentry");
        removeOpType.add("moveentrydown");
        removeOpType.add("moveentryup");
        removeOpType.add("lastentry");
        removeOpType.add("nextentry");
        removeOpType.add("previousentry");
        removeOpType.add("firstentry");
        removeOpType.add("importentry");
        removeOpType.add("insertentry");
        removeOpType.add("copyentryrow");
        removeOpType.add("deleteentry");
        removeOpType.add("newentry");
        removeOpType.add("option");
        removeOpType.add("print");
        removeOpType.add("tda");
        removeOpType.add("tdahistory");
        removeOpType.add("batchfillentry");
        removeOpType.add("rowstatusconvert");
        removeOpType.add("viewbillrelation");
        removeOpType.add("batchfillentry");
        removeOpType.add("printsetting");
        removeOpType.add("printpreview");
        removeOpType.add("openform");
        removeOpType.add("showinvoice");
        removeOpType.add("refresh");
        removeOpType.add("close");
        removeOpType.add("showinvoice");
        removeOpType.add("mobtoolbarselect");
        removeOpType.add("mobtoolbarcancel");
        return removeOpType;
    }

    private void setBasedataCombListValue(Object entityName, String basedataName, String comboName) {
        if (entityName == null) {
            return;
        }
        ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(comboName);
        ArrayList<ComboItem> combList = new ArrayList<ComboItem>(10);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName.toString());
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof BasedataProp)) continue;
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            String name = property.getName();
            String localeValue = property.getDisplayName().getLocaleValue();
            if (!baseEntityId.equals(basedataName)) continue;
            combList.add(new ComboItem(new LocaleString(localeValue), name));
        }
        fieldsCombo.setComboItems(combList);
    }

    private void setEntryBasedataCombListValue(Object entityName, String basedataName, String comboName) {
        if (entityName == null) {
            return;
        }
        ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(comboName);
        ArrayList<ComboItem> combList = new ArrayList<ComboItem>(10);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName.toString());
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp)) continue;
            String name = property.getName();
            DynamicObject entry = ORMUtil.newDynamicObject((String)(entityName.toString() + "." + name));
            DataEntityPropertyCollection entryProperties = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty entryProperty : entryProperties) {
                if (!(entryProperty instanceof BasedataProp)) continue;
                String baseEntityId = ((BasedataProp)entryProperty).getBaseEntityId();
                String entryPropertyName = entryProperty.getName();
                String localeValue = entryProperty.getDisplayName().getLocaleValue();
                if (!StringUtils.isNotBlank((CharSequence)baseEntityId) || !baseEntityId.equals(basedataName)) continue;
                combList.add(new ComboItem(new LocaleString(localeValue), name + "." + entryPropertyName));
            }
        }
        fieldsCombo.setComboItems(combList);
    }

    private void setDateTimePropCombListValue(Object entityName, String comboName) {
        if (entityName == null) {
            return;
        }
        ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl(comboName);
        ArrayList<ComboItem> combList = new ArrayList<ComboItem>(10);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName.toString());
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof DateTimeProp)) continue;
            String name = property.getName();
            String localeValue = property.getDisplayName().getLocaleValue();
            combList.add(new ComboItem(new LocaleString(localeValue), name));
        }
        fieldsCombo.setComboItems(combList);
    }

    private void setScorerValueType() {
        ComboEdit fieldsCombo = (ComboEdit)this.getView().getControl("scorervaluetype");
        ArrayList<ComboItem> combList = new ArrayList<ComboItem>(10);
        String exectype = this.getModel().getDataEntity().getString("exectype");
        combList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6307\u5b9a\u5177\u4f53\u4eba\u5458", (String)"SrmAutoEvaTplPlugin_1", (String)"scm-srm-formplugin", (Object[])new Object[0])), "1"));
        if ("2".equals(exectype)) {
            combList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ece\u5355\u636e\u5bf9\u8c61\u4e2d\u53d6\u4eba\u5458", (String)"SrmAutoEvaTplPlugin_2", (String)"scm-srm-formplugin", (Object[])new Object[0])), "2"));
        }
        fieldsCombo.setComboItems(combList);
    }

    private void setMustInput() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String exectype = dataEntity.getString("exectype");
        if (StringUtils.isBlank((CharSequence)exectype)) {
            return;
        }
        FieldEdit op = (FieldEdit)this.getControl("op");
        FieldEdit evaorgvalue = (FieldEdit)this.getControl("evaorgvalue");
        FieldEdit suppliervalue = (FieldEdit)this.getControl("suppliervalue");
        FieldEdit timevalue = (FieldEdit)this.getControl("timevalue");
        FieldEdit repeatnumber = (FieldEdit)this.getControl("repeatnumber");
        FieldEdit repeatunit = (FieldEdit)this.getControl("repeatunit");
        FieldEdit execmonth = (FieldEdit)this.getControl("execmonth");
        FieldEdit execday = (FieldEdit)this.getControl("execday");
        FieldEdit exectime = (FieldEdit)this.getControl("exectime");
        FieldEdit startdate = (FieldEdit)this.getControl("startdate");
        FieldEdit enddate = (FieldEdit)this.getControl("enddate");
        FieldEdit grade = (FieldEdit)this.getControl("grade");
        DynamicObject schemeid = dataEntity.getDynamicObject("scheme");
        if (schemeid != null) {
            boolean synsupgrade = schemeid.getBoolean("synsupgrade");
            grade.setMustInput(synsupgrade);
        } else {
            grade.setMustInput(false);
        }
        if (exectype.equals("1")) {
            repeatnumber.setMustInput(true);
            repeatunit.setMustInput(true);
            execday.setMustInput(true);
            exectime.setMustInput(true);
            String repeatunitvalue = dataEntity.getString("repeatunit");
            if (StringUtils.isNotBlank((CharSequence)repeatunitvalue) && repeatunitvalue.equals("1")) {
                execmonth.setMustInput(true);
            } else {
                execmonth.setMustInput(false);
            }
            op.setMustInput(false);
            evaorgvalue.setMustInput(false);
            boolean autogetvalue = dataEntity.getBoolean("autogetvalue");
            if (autogetvalue) {
                suppliervalue.setMustInput(true);
                timevalue.setMustInput(true);
            } else {
                suppliervalue.setMustInput(false);
                timevalue.setMustInput(false);
            }
            String timerange = dataEntity.getString("timerange");
            if (StringUtils.isNotBlank((CharSequence)timerange) && timerange.equals("1")) {
                startdate.setMustInput(true);
                enddate.setMustInput(true);
            } else {
                startdate.setMustInput(false);
                enddate.setMustInput(false);
            }
        } else {
            repeatnumber.setMustInput(false);
            repeatunit.setMustInput(false);
            execday.setMustInput(false);
            exectime.setMustInput(false);
            execmonth.setMustInput(false);
            startdate.setMustInput(false);
            enddate.setMustInput(false);
            op.setMustInput(true);
            evaorgvalue.setMustInput(true);
            suppliervalue.setMustInput(true);
        }
    }

    private String getDesc() {
        StringBuilder desc = new StringBuilder();
        desc.append(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u9996\u6b21\u6267\u884c\u65f6\u95f4\u4e3a\uff1a", (String)"SrmAutoEvaTplPlugin_4", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date startTime = SrmAutoEvaTplUtil.getStartTime((DynamicObject)dataEntity);
        String repeatunit = this.getModel().getDataEntity().getString("repeatunit");
        if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("4")) {
            return ResManager.loadKDString((String)"\u6bcf\u5b63\u5ea6\u6700\u540e\u4e00\u5929\u89e6\u53d1\u4e00\u6b21\u3002", (String)"SrmAutoEvaTplPlugin_9", (String)"scm-srm-formplugin", (Object[])new Object[0]);
        }
        if (startTime == null) {
            return "";
        }
        int execday = dataEntity.getInt("execday");
        int exectime = dataEntity.getInt("exectime");
        int exechour = exectime / 3600;
        int execminute = exectime / 60 % 60;
        int execsecond = exectime % 60;
        startTime.setHours(exechour);
        startTime.setMinutes(execminute);
        startTime.setSeconds(execsecond);
        String startTimeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(startTime);
        desc.append(startTimeStr);
        desc.append(ResManager.loadKDString((String)"\uff0c", (String)"SrmAutoEvaTplPlugin_14", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        int repeatnumber = dataEntity.getInt("repeatnumber");
        String unit = "";
        if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("1")) {
            unit = ResManager.loadKDString((String)"\u5e74", (String)"SrmAutoEvaTplPlugin_6", (String)"scm-srm-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("2")) {
            unit = ResManager.loadKDString((String)"\u6708", (String)"SrmAutoEvaTplPlugin_7", (String)"scm-srm-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("3")) {
            unit = ResManager.loadKDString((String)"\u65e5", (String)"SrmAutoEvaTplPlugin_8", (String)"scm-srm-formplugin", (Object[])new Object[0]);
        }
        String cycle = "";
        if (repeatnumber == 0 || !StringUtils.isNotBlank((CharSequence)unit)) {
            return cycle;
        }
        cycle = repeatnumber + unit;
        desc.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6bcf%1\u91cd\u590d\u89e6\u53d1\u4e00\u6b21\u3002", (String)"SrmAutoEvaTplPlugin_10", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmAutoEvaTplPlugin_10", (String)"bos-srm-formplugin", (Object[])new Object[]{cycle}));
        Date effectivedate = null;
        Date expiringdate = null;
        desc.append(System.getProperty("line.separator"));
        effectivedate = this.getModel().getDataEntity().getDate("effectivedate");
        desc.append(ResManager.loadKDString((String)"\u4f9d\u636e\u914d\u7f6e,\u9884\u8ba1\u6700\u8fd1\u5341\u6b21\u6267\u884c\u65f6\u95f4\uff1a", (String)"SrmAutoEvaTplPlugin_11", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        expiringdate = this.getModel().getDataEntity().getDate("expiringdate");
        desc.append(System.getProperty("line.separator"));
        while (TimeServiceHelper.now().after(startTime)) {
            if ("1".equals(repeatunit)) {
                startTime = KDDateUtils.addYears((Date)startTime, (int)repeatnumber);
                continue;
            }
            if ("2".equals(repeatunit)) {
                startTime = KDDateUtils.addMonths((Date)startTime, (int)repeatnumber);
                continue;
            }
            if (!"3".equals(repeatunit)) continue;
            startTime = KDDateUtils.addDays((Date)startTime, (int)repeatnumber);
        }
        if ((long)execday == 32L && !"3".equals(repeatunit)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            int actualMaximum = calendar.getActualMaximum(5);
            startTime.setDate(actualMaximum);
        }
        desc.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(startTime));
        if (expiringdate != null && expiringdate.before(startTime)) {
            desc.append(ResManager.loadKDString((String)"\uff08\u5728\u6709\u6548\u671f\u5916\uff0c\u9884\u8ba1\u4e0d\u4e88\u6267\u884c\uff09", (String)"SrmAutoEvaTplPlugin_12", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
        desc.append(System.getProperty("line.separator"));
        for (int i = 0; i < 9; ++i) {
            if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("3")) {
                startTime = KDDateUtils.addDays((Date)startTime, (int)repeatnumber);
            } else if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("2")) {
                startTime = KDDateUtils.addMonths((Date)startTime, (int)repeatnumber);
            } else if (StringUtils.isNotBlank((CharSequence)repeatunit) && repeatunit.equals("1")) {
                startTime = KDDateUtils.addYears((Date)startTime, (int)repeatnumber);
            }
            if ((long)execday == 32L && !"3".equals(repeatunit)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(startTime);
                int actualMaximum = calendar.getActualMaximum(5);
                startTime.setDate(actualMaximum);
            }
            desc.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(startTime));
            if (expiringdate != null && expiringdate.before(startTime)) {
                desc.append(ResManager.loadKDString((String)"\uff08\u5728\u6709\u6548\u671f\u5916\uff0c\u9884\u8ba1\u4e0d\u4e88\u6267\u884c\uff09", (String)"SrmAutoEvaTplPlugin_12", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            }
            desc.append(System.getProperty("line.separator"));
        }
        return desc.toString();
    }

    private void setDesc() {
        this.getModel().setValue("txtdesc", (Object)this.getDesc());
    }
}

