/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit.portrait;

import java.util.Date;
import java.util.EventObject;
import java.util.Formatter;
import java.util.HashSet;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.srm.formplugin.edit.portrait.IEntryGridControl;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;
import kd.sdk.scm.srm.extpoint.portait.ISrmPortraitStatistic;

public final class SrmPortraitContractEdit
extends AbstractBillPlugIn
implements IEntryGridControl {
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        block18: {
            SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getView().getParentView().getPageCache());
            try (AlgoContext algoContext = Algo.newContext();){
                if (context == null) break block18;
                QFilter qFilter = this.getFilter(context);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"conm_purcontract", (String)"createtime,validdate,supplier,org", (QFilter[])new QFilter[]{qFilter}, null);
                DataSet map = dataSet.map(new MapFunction(){

                    public Object[] map(Row row) {
                        Date createtime = row.getDate("createtime");
                        Date validdate = row.getDate("validdate");
                        long avgTime = 0L;
                        if (createtime != null && validdate != null) {
                            avgTime = validdate.getTime() - createtime.getTime();
                        }
                        return new Object[]{avgTime, row.get("supplier"), row.get("org")};
                    }

                    public RowMeta getResultRowMeta() {
                        RowMeta sourceRowMeta = new RowMeta(new String[]{"avgtime", "supplier", "org"}, new DataType[]{DataType.LongType, DateType.LongType, DateType.LongType});
                        return sourceRowMeta;
                    }
                });
                GroupbyDataSet avgtime = map.groupBy(new String[]{"supplier"}).avg("avgtime");
                DataSet finish = avgtime.finish();
                Label avgTimeLabel = (Label)this.getView().getControl("intimevalue");
                Formatter formatter = null;
                for (Row row : finish) {
                    long value = row.getLong("avgtime");
                    try {
                        formatter = new Formatter();
                        avgTimeLabel.setText(formatter.format("%.2f", (double)value / 8.64E7).toString());
                    }
                    catch (Exception e1) {
                        avgTimeLabel.setText("0.00");
                    }
                    finally {
                        if (formatter == null) continue;
                        formatter.close();
                    }
                }
                this.getView().getModel().setValue("prepay", context.getCustomParam().get("paidpreallamount"));
                this.getView().getModel().setValue("amount", context.getCustomParam().get("totalallamount"));
                this.getView().getModel().setValue("pay", context.getCustomParam().get("paidallamount"));
                this.getView().getModel().setValue("curr", (Object)context.getCurrId());
                EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
                int pageRow = grid.getPageRow();
                int startRowIndex = 0;
                this.onFetchPageData(startRowIndex, pageRow, true);
            }
        }
    }

    private QFilter getFilter(SrmPortraitContext context) {
        HashSet<String> validstatus = new HashSet<String>();
        validstatus.add("B");
        validstatus.add("C");
        QFilter qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter((String)"supplier", (String)"org", (String)"createtime", (SrmPortraitContext)context);
        qFilter.and("validstatus", "in", validstatus);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("validdate", "is not null", null);
        qFilter.and("settlecurrency", "=", (Object)context.getCurrId());
        return qFilter;
    }

    private void createContractDetail(SrmPortraitContext context, QFilter qFilter) {
    }

    @Override
    public void createEntryEntity(int startRowIndex, int pageRows, boolean isFirstPage) {
        SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getView().getParentView().getPageCache());
        QFilter qfilter = this.getFilter(context);
        qfilter.and("settlecurrency", "=", (Object)context.getCurrId());
        DataSet dataSet = ORM.create().queryDataSet(this.getClass().getName(), "conm_purcontract", "org,billname,contparties,contparties.name,biztime,biztimebegin,biztimeend,settlecurrency,totalallamount totalamount,closestatus,supplier,auditdate", new QFilter[]{qfilter}, "biztime desc", startRowIndex, pageRows);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (Row row : dataSet) {
            ts.set("org", (Object)row.getLong("org"), i);
            ts.set("billname", (Object)row.getString("billname"), i);
            ts.set("contpartiesname", (Object)row.getString("contparties.name"), i);
            ts.set("biztime", (Object)row.getDate("biztime"), i);
            ts.set("biztimebegin", (Object)row.getDate("biztimebegin"), i);
            ts.set("biztimeend", (Object)row.getDate("biztimeend"), i);
            ts.set("settlecurrency", (Object)row.getLong("settlecurrency"), i);
            ts.set("totalamount", (Object)row.getBigDecimal("totalamount"), i);
            ts.set("closestatus", (Object)row.getString("closestatus"), i);
            ++i;
        }
        this.getView().getModel().beginInit();
        ((AbstractFormDataModel)this.getView().getModel()).batchCreateNewEntryRow("entryentity", ts);
        this.getView().getModel().endInit();
        if (isFirstPage) {
            int rowCount = ORM.create().count(this.getClass().getName(), "conm_purcontract", "id", new QFilter[]{qfilter}, (Distinctable)WithDistinctable.get());
            dataEntity.getDataEntityState().setEntryRowCount("entryentity", rowCount);
        }
        dataEntity.getDataEntityState().setEntryPageSize("entryentity", pageRows);
        dataEntity.getDataEntityState().setEntryStartRowIndex("entryentity", startRowIndex);
    }

    public void onGetControl(OnGetControlArgs e) {
        this.onCustomGetControl(e, "entryentity", this.getView());
    }
}

