/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit.portrait;

import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticContainer;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;

public final class SrmPortraitDataService {
    private static Log log = LogFactory.getLog(SrmPortraitDataService.class);

    public SrmPortraitStatisticContainer getSrmPortraitContainer(SrmPortraitContext context) {
        SrmPortraitStatisticContainer configs = this.getSrmPortraitStatisticPlugin();
        try (AlgoContext algoContext = Algo.newContext();){
            SrmPortraitStatisticContainer container = new SrmPortraitStatisticContainer();
            container.setConfigs((DynamicObject[])configs);
            for (SrmPortraitStatisticContainer config : configs) {
                if ("0".equals(config.getString("enable")) || !StringUtils.isNotBlank((CharSequence)config.getString("indicatorplugin"))) continue;
                String plugin = StringUtils.trim((String)config.getString("indicatorplugin"));
                try {
                    Class<?> aClass = Class.forName(plugin);
                    if (!AbstractSrmPortraitDataSetStatistic.class.isAssignableFrom(aClass)) continue;
                    AbstractSrmPortraitDataSetStatistic instance = (AbstractSrmPortraitDataSetStatistic)TypesContainer.createInstance(aClass);
                    instance.startStatistic(context, container);
                }
                catch (ClassNotFoundException e) {
                    log.error("SrmPortraitDataService syncPortraitStatisticData error ", (Throwable)e);
                }
            }
            SrmPortraitStatisticContainer srmPortraitStatisticContainer = container;
            return srmPortraitStatisticContainer;
        }
    }

    private DynamicObject[] getSrmPortraitStatisticPlugin() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject[] portraitConfig = BusinessDataServiceHelper.load((String)"srm_portrait_config", (String)"number,status,enable,indicatorplugin,subform,synctime", (QFilter[])new QFilter[]{qFilter});
        return portraitConfig;
    }
}

