/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit.portrait;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;
import kd.sdk.scm.srm.extpoint.portait.ISrmPortraitStatistic;

public final class SrmPortraitOrderEdit
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if ("unit".equals(name)) {
            ChangeData[] changeSet;
            for (ChangeData data : changeSet = e.getChangeSet()) {
                Object newValue = data.getNewValue();
                if (!Objects.nonNull(newValue)) continue;
                this.changeBarInfo(newValue);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object radioValue = this.getModel().getValue("unit");
        Integer unitValue = 1;
        if (Objects.nonNull(radioValue)) {
            unitValue = Integer.valueOf(String.valueOf(radioValue));
        }
        this.changeBarInfo(unitValue);
    }

    private void changeBarInfo(Object unitValue) {
        Integer value = 1;
        try {
            if (Objects.nonNull(unitValue)) {
                value = Integer.valueOf(String.valueOf(unitValue));
            }
        }
        catch (NumberFormatException e) {
            value = 1;
        }
        IDataEntityProperty radiogroup = this.getModel().getProperty("unit");
        String itemByName = "";
        if (radiogroup instanceof ComboProp) {
            itemByName = ((ComboProp)radiogroup).getItemByName(String.valueOf(value));
        }
        this.createIndicatorInfo(value, itemByName);
    }

    private void createIndicatorInfo(Integer unitValue, String label) {
        Object s;
        SrmPortraitContext context = ISrmPortraitStatistic.getContextFromCache((IPageCache)this.getView().getParentView().getPageCache());
        if (context == null) {
            return;
        }
        QFilter qFilter = this.getQfilter(context);
        this.createOrderInicatorInfo(context);
        BigDecimal total = BigDecimal.ZERO;
        int months = SrmPortraitOrderEdit.monthsBetween(context.getDateFrom(), context.getDateTo());
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>(12);
        String[] cat = new String[months];
        Number[] counts = new Number[months];
        for (int i = 0; i < months; ++i) {
            cat[i] = s = DateUtils.formatDate((Date)DateUtil.addMonth((Date)context.getDateFrom(), (int)(i + 1)), (Object[])new Object[]{"yyyy-MM"});
            counts[i] = 0;
            indexMap.put(s, i);
        }
        if (qFilter != null) {
            Control histogramchartap;
            AlgoContext algoContext = Algo.newContext();
            s = null;
            try {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order", (String)"id,billdate,sumtaxamount", (QFilter[])new QFilter[]{qFilter}, (String)"billdate");
                DataSet billdate = dataSet.map(new MapFunction(){

                    public Object[] map(Row row) {
                        String month = "";
                        String yearAndMonth = "";
                        if (row.getDate("billdate") != null) {
                            month = DateUtils.formatDate((Date)row.getDate("billdate"), (Object[])new Object[]{"MM"});
                            yearAndMonth = DateUtils.formatDate((Date)row.getDate("billdate"), (Object[])new Object[]{"yyyy-MM"});
                        }
                        return new Object[]{yearAndMonth, month, row.get("id"), row.getBigDecimal("sumtaxamount")};
                    }

                    public RowMeta getResultRowMeta() {
                        RowMeta sourceRowMeta = new RowMeta(new String[]{"yearandmonth", "month", "id", "sumtaxamount"}, new DataType[]{DataType.StringType, DataType.StringType, DateType.LongType, DateType.BigDecimalType});
                        return sourceRowMeta;
                    }
                });
                GroupbyDataSet groupbyDataSet = billdate.groupBy(new String[]{"yearandmonth"});
                groupbyDataSet.sum("sumtaxamount", "num");
                DataSet finish1 = groupbyDataSet.finish();
                int i = 0;
                for (Row row : finish1) {
                    if (i >= months) {
                        break;
                    }
                    Integer yearandmonth = (Integer)indexMap.get(row.getString("yearandmonth"));
                    if (yearandmonth != null && yearandmonth >= 0) {
                        counts[yearandmonth.intValue()] = row.getBigDecimal("num").divide(new BigDecimal(unitValue), 4, 4);
                        total = total.add(row.getBigDecimal("num"));
                    }
                    ++i;
                }
            }
            catch (Throwable dataSet) {
                s = dataSet;
                throw dataSet;
            }
            finally {
                if (algoContext != null) {
                    if (s != null) {
                        try {
                            algoContext.close();
                        }
                        catch (Throwable dataSet) {
                            ((Throwable)s).addSuppressed(dataSet);
                        }
                    } else {
                        algoContext.close();
                    }
                }
            }
            if ((histogramchartap = this.getView().getControl("histogramchartap")) instanceof HistogramChart) {
                HistogramChart chart = (HistogramChart)histogramchartap;
                BarSeries series = chart.createSeries(ResManager.loadKDString((String)"\u8ba2\u5355\u6c47\u603b", (String)"SrmPortraitOrderEdit_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                chart.createYAxis(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u91d1\u989d(%1$s)", (String)"SrmPortraitOrderEdit_1", (String)"scm-srm-formplugin", (Object[])new Object[0]), label));
                Axis axis = chart.createXAxis(ResManager.loadKDString((String)"\u5e74\u6708", (String)"SrmPortraitOrderEdit_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), AxisType.category);
                axis.setCategorys(cat);
                series.setData(counts);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("containLabel", true);
                param.put("left", "50px");
                chart.addProperty("grid", param);
                series.setBarWidth("20px");
                chart.bindData(null);
            }
        }
    }

    public static int monthsBetween(Date firstDate, Date secDate) {
        LocalDate localDate1 = firstDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = secDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate2.isAfter(localDate1) ? (int)localDate1.until(localDate2, ChronoUnit.MONTHS) : (int)localDate2.until(localDate1, ChronoUnit.MONTHS);
    }

    private void createOrderInicatorInfo(SrmPortraitContext context) {
        Label confirm = (Label)this.getView().getControl("confirm");
        Label unconfirm = (Label)this.getView().getControl("unconfirm");
        confirm.setText(String.valueOf(context.getCustomParam().get("confirm")));
        unconfirm.setText(String.valueOf(context.getCustomParam().get("unconfirm")));
    }

    private QFilter getQfilter(SrmPortraitContext context) {
        if (context != null) {
            QFilter qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter((String)"supplier", (String)"org", (String)"billdate", (SrmPortraitContext)context);
            if (qFilter != null) {
                qFilter.and("curr", "=", (Object)context.getCurrId());
                qFilter.and("billstatus", "=", (Object)"C");
            }
            return qFilter;
        }
        return null;
    }
}

