/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.edit.portrait.statistic;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitContext;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticContainer;
import kd.sdk.scm.srm.extpoint.dto.indicator.SrmPortraitStatisticInfo;
import kd.sdk.scm.srm.extpoint.portait.AbstractSrmPortraitDataSetStatistic;

public final class SrmPortraitContractStatistic
extends AbstractSrmPortraitDataSetStatistic {
    public final void startStatistic(SrmPortraitContext context, SrmPortraitStatisticContainer container) {
        HashSet<String> validstatus = new HashSet<String>();
        validstatus.add("B");
        validstatus.add("C");
        QFilter qFilter = AbstractSrmPortraitDataSetStatistic.wrapCommonFilter((String)"supplier", (String)"org", (String)"auditdate", (SrmPortraitContext)context);
        qFilter.and("validstatus", "in", validstatus);
        qFilter.and("billstatus", "=", (Object)"C");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"id,totalallamount,settlecurrency curr,supplier,org,auditdate,biztime,paidallamount,paidpreallamount", (QFilter[])new QFilter[]{qFilter}, null);){
            GroupbyDataSet groupbyDataSet = this.groupBy(dataSet);
            GroupbyDataSet sum = groupbyDataSet.countDistinct(new String[]{"id"}, "contracttotal");
            sum.sum("totalallamount").sum("paidallamount").sum("paidpreallamount");
            this.reduceStatistic(sum.finish(), container);
        }
    }

    private void reduceStatistic(DataSet dataSource, SrmPortraitStatisticContainer container) {
        Map statisticInfoMap;
        if (dataSource != null && container != null && (statisticInfoMap = container.getStatisticInfoMap()) != null) {
            for (Row row : dataSource) {
                SrmPortraitStatisticInfo info = (SrmPortraitStatisticInfo)statisticInfoMap.get(this.makeRowKey(row));
                if (info == null) {
                    info = this.createStatisticInfo(row, statisticInfoMap);
                }
                info.setContractNum(row.getInteger("contracttotal").intValue());
                BigDecimal sumtaxamount = row.getBigDecimal("totalallamount");
                info.setContractAmount(sumtaxamount);
                info.setPaidPreAllAmount(row.getBigDecimal("paidpreallamount"));
                info.setPaidAllAmount(row.getBigDecimal("paidallamount"));
            }
        }
    }
}

