/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.formula;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scm.srm.common.formula.model.CRFormulaModel;
import kd.scm.srm.common.formula.utils.FormulaHelper;

public class SrmFormulaEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String POINT = ".";
    private static final String FEXPRESSION = "fexpression";
    private static final String TREENODES = "treenodes";
    private static final String FORMULA = "formula";
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String CLR = "clr";
    private static final String BACKSPACE = "backspace";
    private static final String RIGHT_BRACKETS = ")";
    private static final String LEFT_BRACKETS = "(";
    private static final String HEADNODEID = "0";
    private static final String BILLHEAD = "billhead";
    private static final String TV_FIELDS = "tv_fields";
    private static final String FTRANEXPR = "ftranexpr";
    private static final String TYPE = "type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL});
        this.addClickListeners(new String[]{"btnfunction", CLR, BACKSPACE});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnsum", "btnavg", "btnmin", "btnmax", "btnleft", "btnright", "btnif", "btncount"});
        TreeView tv = (TreeView)this.getView().getControl(TV_FIELDS);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
        FormulaHelper.initData((IDataModel)this.getModel(), (String)conditonJson);
        Integer type = (Integer)this.getView().getFormShowParameter().getCustomParam(TYPE);
        switch (type) {
            case 1: {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnsum"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnavg"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnmin"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnmax"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncount"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnand"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnor"});
                break;
            }
            case 2: {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnequal"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnotequal"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnlessthen"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnmorethen"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnlessequal"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnmoreequal"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnif"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnand"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnor"});
                break;
            }
            case 3: 
            case 4: {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnsum"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnavg"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnmin"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnmax"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnif"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncount"});
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(TREENODES);
        if (StringUtils.isNotEmpty((String)json)) {
            FormulaHelper.fillTreeNodes((IFormView)this.getView(), (String)json);
        } else {
            FormulaHelper.addTreeRootNode((IFormView)this.getView());
        }
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "=";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = LEFT_BRACKETS;
                break;
            }
            case "btnright": {
                compareValue = RIGHT_BRACKETS;
                break;
            }
            case "btnsum": {
                compareValue = "sum( )";
                break;
            }
            case "btnavg": {
                compareValue = "avg( )";
                break;
            }
            case "btnmin": {
                compareValue = "min( )";
                break;
            }
            case "btnmax": {
                compareValue = "max( )";
                break;
            }
            case "btnif": {
                compareValue = "if( , , )";
                break;
            }
            case "btncount": {
                compareValue = "count( )";
                break;
            }
        }
        if (!StringUtils.isBlank((String)compareValue)) {
            FormulaHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)FEXPRESSION, (String)compareValue);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId = (String)e.getNodeId();
        if (HEADNODEID.equals(currNodeId)) {
            currNodeId = "";
        }
        FormulaHelper.insertExpression((IFormView)this.getView(), (String)TV_FIELDS, (String)FEXPRESSION, (String)currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (BTNOK.equalsIgnoreCase(ctlSource.getKey())) {
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
            CRFormulaModel formulaObj = FormulaHelper.deserialize((String)conditonJson);
            FormulaHelper.getFormulaObj((IDataModel)this.getModel(), (CRFormulaModel)formulaObj);
            try {
                if (StringUtils.isEmpty((String)formulaObj.getExpression())) {
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
                    this.getView().close();
                    return;
                }
                String json = (String)this.getView().getFormShowParameter().getCustomParam(TREENODES);
                String tranExpr = FormulaHelper.tranExpression((String)formulaObj.getExpression(), (String)json);
                formulaObj.getLocaleExprTran().setItem(Lang.defaultLang().toString(), (Object)tranExpr);
            }
            catch (Exception var6) {
                String errorMsg = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"SrmFormulaEditPlugin_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmFormulaEditPlugin_0", (String)"scm-srm-formplugin", (Object[])new Object[]{var6.getMessage()});
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
            this.getView().close();
        } else if (BTNCANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (CLR.equalsIgnoreCase(ctlSource.getKey())) {
            this.getModel().setValue(FEXPRESSION, (Object)"");
            FormulaHelper.setCursorIndex((IFormView)this.getView(), (String)FEXPRESSION, (int)0);
        } else if (BACKSPACE.equalsIgnoreCase(ctlSource.getKey())) {
            FormulaHelper.backSpaceExpression((IFormView)this.getView(), (String)BACKSPACE, (String)FEXPRESSION);
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(FEXPRESSION)) {
            String expression = (String)this.getModel().getValue(FEXPRESSION);
            if (StringUtils.isEmpty((String)expression)) {
                this.getModel().setValue(FTRANEXPR, (Object)"");
                return;
            }
            String json = (String)this.getView().getFormShowParameter().getCustomParam(TREENODES);
            String tranExpr = "";
            try {
                tranExpr = FormulaHelper.tranExpression((String)expression, (String)json);
            }
            catch (FormulaException var5) {
                this.log.error(var5.getMessage());
                tranExpr = var5.getCause() != null ? var5.getCause().getMessage() : var5.getMessage();
            }
            catch (Exception var6) {
                this.log.error(var6.getMessage());
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"SrmFormulaEditPlugin_1", (String)"scm-srm-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(FTRANEXPR, (Object)tranExpr);
        }
    }
}

