/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.list.events.ListHyperLinkClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillListUtil;

public class SrmAptitudeExamList
extends AbstractListPlugin
implements ListHyperLinkClickListener {
    private static final Map<String, String> billMap = new HashMap<String, String>();
    private static final Map<String, String> aptitudenoBillMap = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.addListHyperLinkClickListener((ListHyperLinkClickListener)this);
    }

    public void hyperLinkClick(ListHyperLinkClickEvent e) {
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow) {
            List columns = args.getListColumns();
            List<String> deleteColumns = this.getColumnList();
            ArrayList<IListColumn> listColumns = new ArrayList<IListColumn>(columns.size());
            for (IListColumn column : columns) {
                String fieldKey = column.getListFieldKey();
                if (!deleteColumns.contains(fieldKey)) {
                    listColumns.add(column);
                }
                if (!"entertype.name".equals(fieldKey)) continue;
                column.setHyperlink(true);
            }
            columns.clear();
            columns.addAll(listColumns);
        }
    }

    private List<String> getColumnList() {
        ArrayList<String> columnList = new ArrayList<String>(4);
        columnList.add("aptitudeno.hasscene");
        columnList.add("aptitudeno.hassample");
        columnList.add("aptitudeno.hasmaterial");
        columnList.add("aptitudeno.hasapprove");
        columnList.add("hasscene");
        columnList.add("hassample");
        columnList.add("hasmaterial");
        columnList.add("hasapprove");
        return columnList;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object billId = list.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if (billMap.containsKey(fieldName)) {
            args.setCancel(true);
            this.openBill(String.valueOf(billId), billMap.get(args.getFieldName()));
        } else if (aptitudenoBillMap.containsKey(fieldName)) {
            args.setCancel(true);
            QFilter aptitudenoFilter = new QFilter("id", "=", billId);
            String name = ((IListView)this.getView()).getBillFormId();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)name, (String)"id,aptitudeno", (QFilter[])new QFilter[]{aptitudenoFilter});
            long aptitudeno = dynamicObject.getLong("aptitudeno");
            this.openBill(String.valueOf(aptitudeno), aptitudenoBillMap.get(args.getFieldName()));
        } else if (SrmCommonUtil.enableNewAccessFlow() && fieldName.equals("entertype_name")) {
            args.setCancel(true);
            FormShowParameter fsp = new FormShowParameter();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeRefresh");
            fsp.setCloseCallBack(closeCallBack);
            fsp.setCustomParam("billId", billId);
            fsp.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
            fsp.setShowClose(false);
            fsp.setFormId("srm_nodeprogress");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    private void openBill(String billId, String pageKey) {
        DynamicObjectCollection dyn = SrmBillListUtil.getAllRelatedBill((String)pageKey, (String)billId, (String)"id");
        if (dyn != null) {
            if (dyn.size() == 1) {
                Long id = ((DynamicObject)dyn.get(0)).getLong("id");
                OpenFormUtil.openBillPage((IFormView)this.getView(), (String)pageKey, (Object)id, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
            } else {
                ArrayList<Long> idList = new ArrayList<Long>(16);
                for (DynamicObject billData : dyn) {
                    idList.add(Long.parseLong(billData.getString("id")));
                }
                QFilter qf = new QFilter("id", "in", idList);
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)pageKey, (ShowType)ShowType.MainNewTabPage, null, (QFilter)qf, null);
            }
        }
    }

    static {
        billMap.put("hasscene", "srm_sceneexam");
        billMap.put("hassample", "srm_sampleexam");
        billMap.put("hasmaterial", "srm_materialexam");
        billMap.put("hasapprove", "srm_supapprove");
        aptitudenoBillMap.put("aptitudeno_hasscene", "srm_sceneexam");
        aptitudenoBillMap.put("aptitudeno_hassample", "srm_sampleexam");
        aptitudenoBillMap.put("aptitudeno_hasmaterial", "srm_materialexam");
        aptitudenoBillMap.put("aptitudeno_hasapprove", "srm_supapprove");
    }
}

