/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmCommUtil;

public class SrmComponentList
extends AbstractListPlugin {
    private String getInfo() {
        return ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u6811\u9009\u62e9\u5408\u9002\u7684\u7ec4\u4ef6\u7c7b\u578b(\u53f6\u8282\u70b9)\uff0c\u518d\u201c\u65b0\u589e\u201d\u6216\u201c\u4fee\u6539\u201d\u7ec4\u4ef6\u3002", (String)"SrmComponentList_0", (String)"scm-srm-formplugin", (Object[])new Object[0]);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "tblnew": {
                evt.setCancel(true);
                if (this.isNewConponent()) {
                    SrmCommUtil.isNewPermission();
                }
                this.newComponent();
                break;
            }
            case "tblmodify": {
                evt.setCancel(true);
                long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                if (billId == 0L) {
                    return;
                }
                this.editComponent(billId);
                break;
            }
            case "tbldel": {
                if (!this.isNewConponent()) break;
                evt.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c \u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"SrmComponentList_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isdelete"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("disable".equals(afterDoOperationEventArgs.getOperateKey()) || "delete".equals(afterDoOperationEventArgs.getOperateKey()) || "enable".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"number", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            if (Objects.isNull(currentSelectedRowInfo)) {
                return;
            }
            long billId = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            this.editComponent(billId);
        }
    }

    private void newComponent() {
        IListView listView = (IListView)this.getView();
        ITreeListView treeListView = listView.getTreeListView();
        String parentId = treeListView.getTreeModel().getRoot().getId();
        Object groupId = treeListView.getTreeModel().getCurrentNodeId();
        if (groupId == null || groupId.equals(parentId)) {
            this.getView().showTipNotification(this.getInfo());
            return;
        }
        this.openComponentPage(Long.parseLong(groupId.toString()), null, BillOperationStatus.ADDNEW);
    }

    private void editComponent(Object billId) {
        DynamicObject obj = this.queryComponent(billId);
        if (Objects.isNull(obj)) {
            return;
        }
        long groupId = (Long)obj.getDynamicObject("group").getPkValue();
        this.openComponentPage(groupId, billId, BillOperationStatus.EDIT);
    }

    private DynamicObject queryComponent(Object billId) {
        String entity;
        if (this.isNewConponent()) {
            entity = "srm_portal_component";
            SrmCommUtil.isModifyPermission();
        } else {
            entity = "srm_component";
        }
        DynamicObject obj = QueryRecordUtil.queryRecordSet((String)entity, (String)"group", (String)"id", (Object)billId, null, null, null, null, null, null, null, (String)"loadOne", null);
        if (obj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55\uff0c\u4e0d\u80fd\u5904\u7406\u3002", (String)"SrmComponentList_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return obj;
    }

    private DynamicObject getopComponentGroup(long groupId) {
        String groupEntity = this.isNewConponent() ? "srm_portal_compgroup" : "srm_compgroup";
        DynamicObject obj = QueryRecordUtil.queryRecordSet((String)groupEntity, (String)"compobject", (String)"id", (Object)groupId, (String)"isleaf", (Object)"1", null, null, null, null, null, (String)"loadOne", null);
        if (obj == null) {
            this.getView().showTipNotification(this.getInfo());
            return null;
        }
        return obj;
    }

    private void openComponentPage(long groupId, Object billId, BillOperationStatus openStatus) {
        DynamicObject obj = this.getopComponentGroup(groupId);
        if (obj == null) {
            return;
        }
        String entityName = null;
        DynamicObject object = obj.getDynamicObject("compobject");
        if (object == null) {
            entityName = "srm_component";
            if (this.isNewConponent()) {
                entityName = "srm_portal_component";
            }
        } else {
            entityName = object.getString("number");
        }
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("group_id", groupId);
        OpenFormUtil.openBasePage((IFormView)this.getView(), (String)entityName, (Object)billId, (BillOperationStatus)openStatus, (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("isdelete".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.delete();
        }
    }

    private void delete() {
        Object[] ids;
        OperationResult delete;
        long deleteId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
        if (deleteId == 0L) {
            return;
        }
        DynamicObject componentObj = this.queryComponent(deleteId);
        if (componentObj == null) {
            return;
        }
        long groupId = (Long)componentObj.getDynamicObject("group").getPkValue();
        DynamicObject groupObject = this.getopComponentGroup(groupId);
        if (groupObject == null) {
            return;
        }
        String entityName = null;
        DynamicObject object = groupObject.getDynamicObject("compobject");
        if (object == null) {
            entityName = "srm_component";
            if (this.isNewConponent()) {
                entityName = "srm_portal_component";
            }
        } else {
            entityName = object.getString("number");
        }
        if (Objects.nonNull(delete = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])(ids = new Object[]{deleteId}), (OperateOption)OperateOption.create())) && !delete.isSuccess()) {
            List validateErrors;
            ValidateResultCollection validateResult;
            List allErrorInfo = delete.getAllErrorInfo();
            StringBuilder stringBuilder = new StringBuilder(12);
            for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                stringBuilder.append(operateErrorInfo.getMessage()).append('\t');
            }
            if (stringBuilder.length() == 0 && Objects.nonNull(validateResult = delete.getValidateResult()) && Objects.nonNull(validateErrors = validateResult.getValidateErrors())) {
                for (ValidateResult validateError : validateErrors) {
                    List allErrorInfo1 = validateError.getAllErrorInfo();
                    if (!Objects.nonNull(allErrorInfo1)) continue;
                    for (OperateErrorInfo operateErrorInfo : allErrorInfo1) {
                        String message = operateErrorInfo.getMessage();
                        stringBuilder.append(message);
                    }
                }
            }
            this.getView().showTipNotification(stringBuilder.toString());
        }
        this.getView().invokeOperation("refresh");
    }

    private boolean isNewConponent() {
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        return "srm_portal_component".equals(billFormId) || "srm_portal_comptopinfo".equals(billFormId) || "srm_portal_compbottominfo".equals(billFormId);
    }
}

