/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.HashSet;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;

public class SrmEvaPlanBatchList
extends AbstractListPlugin {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        HashSet<Object> pkSet = new HashSet<Object>(16);
        for (ListSelectedRow row : selectedRows) {
            Object primaryKeyValue = row.getPrimaryKeyValue();
            pkSet.add(primaryKeyValue);
        }
        switch (key) {
            case "tblurgemsg": 
            case "tblterminate": 
            case "tblunpush": 
            case "tblpush": {
                if (pkSet.size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SrmEvaPlanBatchList_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("pushandsave".equals(operateKey) && Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            OperateOption option = OperateOption.create();
            OperationServiceHelper.executeOperate((String)"sendmsg", (String)"srm_evaplan_batch", (Object[])primaryKeyValues, (OperateOption)option);
        } else if ("queryreport".equals(operateKey) && Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            HashSet<Object> pkSet = new HashSet<Object>(16);
            for (ListSelectedRow row : selectedRows) {
                Object object = row.getPrimaryKeyValue();
                pkSet.add(object);
            }
            StringBuilder pkStr = new StringBuilder();
            for (Object e : pkSet) {
                if (pkStr.length() > 0) {
                    pkStr.append(",");
                }
                pkStr.append(e.toString());
            }
            Object object = selectedRows.get(0).getPrimaryKeyValue();
            ReportShowParameter reportShowParameter = new ReportShowParameter();
            reportShowParameter.setHasRight(true);
            reportShowParameter.setFormId("srm_evaplanbatchreport");
            reportShowParameter.setStatus(OperationStatus.ADDNEW);
            reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            reportShowParameter.setCustomParam("evplan.id", object);
            reportShowParameter.setCustomParam("evplanIdStr", (Object)pkStr.toString());
            this.getView().showForm((FormShowParameter)reportShowParameter);
        } else if ("terminate".equals(operateKey) && Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_evaplanbatch_end", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            this.getView().invokeOperation("refresh");
        }
    }
}

