/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.HashMap;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmEvaPlanStatusEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;

public class SrmEvaPlanList
extends AbstractListPlugin {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        DynamicObject obj = null;
        long billId = 0L;
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        switch (key) {
            case "tblpush": {
                billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                obj = QueryRecordUtil.queryRecordSet((String)"srm_evaplan", (String)"id", (String)"id", (Object)billId, (String)"billstatus", (Object)BillStatusEnum.AUDIT.getVal(), (String)"bizstatus", (Object)SrmEvaPlanStatusEnum.TOBEPUSH.getValue(), null, null, null, (String)"queryOne", null);
                if (obj != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u8ba1\u5212\u72b6\u6001\u4e3a\u5f85\u4e0b\u8fbe\u7684\u8ba1\u5212\u624d\u80fd\u4e0b\u8fbe\u3002", (String)"SrmEvaPlanList_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                this.getView().invokeOperation("refresh");
                return;
            }
            case "tblterminate": {
                billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                QFilter qFilter = new QFilter("id", "=", (Object)billId).and("bizstatus", "<", (Object)SrmEvaPlanStatusEnum.APPROVED.getValue());
                obj = QueryServiceHelper.queryOne((String)"srm_evaplan", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (obj != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6838\u51c6\u6216\u5df2\u7ec8\u6b62\u7684\u8bc4\u4f30\u8ba1\u5212\u4e0d\u5141\u8bb8\u7ec8\u6b62\u3002", (String)"SrmEvaPlanList_1", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "queryresult": {
                IFormView view = this.getView();
                billId = SrmCommonUtil.getBillSelectedId((IFormView)view, (BillList)((BillList)view.getControl("billlistap")));
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                paramMap.put("billid", billId);
                OpenFormUtil.openDynamicPage((IFormView)view, (String)"srm_evaresult", (ShowType)ShowType.MainNewTabPage, paramMap, null);
                break;
            }
            case "queryreport": {
                billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                Boolean auditStatus = this.isAuditStatus(billId);
                if (!auditStatus.booleanValue()) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5df2\u6838\u51c6\u201d\u7684\u6570\u636e\u884c\u624d\u5141\u8bb8\u62a5\u8868\u67e5\u770b\u3002", (String)"SrmEvaPlanList_01", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ReportShowParameter reportShowParameter = new ReportShowParameter();
                reportShowParameter.setFormId("srm_evaplanreport");
                reportShowParameter.setStatus(OperationStatus.ADDNEW);
                reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                reportShowParameter.setCustomParam("evplan.id", (Object)billId);
                this.getView().showForm((FormShowParameter)reportShowParameter);
                break;
            }
            case "queryautoresult": {
                billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                if (billId == 0L) {
                    evt.setCancel(true);
                    return;
                }
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)"srm_cal_result", (ShowType)ShowType.MainNewTabPage, null, (QFilter)new QFilter("evaplanid", "in", (Object)billId), null);
                break;
            }
            case "unpush": {
                if (selectedRows.size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SrmEvaPlanList_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            this.getView().invokeOperation("refresh");
        }
        if (closedCallBackEvent.getActionId().equals("changescorer") && closedCallBackEvent.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bc4\u59d4\u53d8\u66f4\u6210\u529f\u3002", (String)"SrmEvaPlanList_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "pushandsave": {
                    Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                    OperateOption option = OperateOption.create();
                    OperationServiceHelper.executeOperate((String)"sendmsg", (String)"srm_evaplan", (Object[])primaryKeyValues, (OperateOption)option);
                    break;
                }
                case "terminate": {
                    long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_evaplanend", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
                    break;
                }
                case "changescorer": {
                    ListSelectedRowCollection selectedRows = this.getSelectedRows();
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    if (selectedRows.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SrmEvaPlanList_2", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                    paramMap.put("billid", billId);
                    paramMap.put("evaplantype", "srm_evaplan");
                    OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"srm_changescorer", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "changescorer"));
                    break;
                }
            }
        } else {
            switch (operateKey) {
                case "pushandsave": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }

    private Boolean isAuditStatus(Object billId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"srm_evaplan", (String)"bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", billId)});
        if (Objects.isNull(dynamicObject)) {
            return Boolean.FALSE;
        }
        String bizstatus = dynamicObject.getString("bizstatus");
        if (SrmEvaPlanStatusEnum.APPROVED.getValue().equals(bizstatus)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

