/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.srm.service.list.SrmScoreRptListService;
import kd.scm.srm.service.valid.SrmScoreRptListServiceValid;

public class SrmScorerptList
extends AbstractListPlugin {
    private SrmScoreRptListServiceValid serviceValid;
    private SrmScoreRptListService srmScoreRptListService;

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        ArrayList<String> bizStatusList = new ArrayList<String>();
        bizStatusList.add(SrmScoreStatusEnum.SCORED.getValue());
        bizStatusList.add(SrmScoreStatusEnum.TRIALED.getValue());
        bizStatusList.add(SrmScoreStatusEnum.UNTRIALED.getValue());
        bizStatusList.add(SrmScoreStatusEnum.APPROVED.getValue());
        bizStatusList.add(SrmScoreStatusEnum.UNAPPROVED.getValue());
        bizStatusList.add(SrmScoreStatusEnum.ENDED.getValue());
        qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).and(new QFilter("bizstatus", "in", bizStatusList)));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "tblreview": {
                this.review(evt);
                break;
            }
            case "tblapprove": {
                this.approve(evt);
                break;
            }
            case "tbldirectapprove": {
                this.directapprove(evt);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("review".equals(actionId) || "approve".equals(actionId) || "directapprove".equals(actionId)) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            Object returnData = closedCallBackEvent.getReturnData();
            for (Object primaryKeyValue : primaryKeyValues) {
                MutexHelper.release((String)"srm_scorerpt", (String)actionId, (String)String.valueOf(primaryKeyValue));
            }
            SrmScoreRptListService serviceRpt = this.getServiceRpt();
            if ("review".equals(actionId) && Objects.nonNull(returnData)) {
                OperateOption option = OperateOption.create();
                OperationServiceHelper.executeOperate((String)"sendmsg", (String)"srm_scorerpt", (Object[])primaryKeyValues, (OperateOption)option);
                serviceRpt.dealReviewReurnData((HashMap)returnData, primaryKeyValues, false);
            }
            if ("approve".equals(actionId) && Objects.nonNull(returnData)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                OperationServiceHelper.executeOperate((String)"sendapprovemsg", (String)"srm_scorerpt", (Object[])primaryKeyValues, (OperateOption)option.copy());
                serviceRpt.dealApproveReurnData((HashMap)returnData, primaryKeyValues, false);
                Object result = ((HashMap)returnData).get("result");
                if (Objects.nonNull(result) && "agree".equals(result.toString())) {
                    OperationServiceHelper.executeOperate((String)"synsupgrade", (String)"srm_scorerpt", (Object[])primaryKeyValues, (OperateOption)option.copy());
                    this.writeBackGroupEvaPlanCalStatus();
                }
            }
            if ("directapprove".equals(actionId) && Objects.nonNull(returnData)) {
                String result = ((HashMap)returnData).get("result").toString();
                OperateOption option = OperateOption.create();
                option.setVariableValue("cfmOption", ((HashMap)returnData).get("cfmOption").toString());
                option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                if ("agree".equals(result)) {
                    OperationServiceHelper.executeOperate((String)"directapprove_exec", (String)"srm_scorerpt", (Object[])primaryKeyValues, (OperateOption)option.copy());
                } else {
                    OperationServiceHelper.executeOperate((String)"directreject_exec", (String)"srm_scorerpt", (Object[])primaryKeyValues, (OperateOption)option.copy());
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void writeBackGroupEvaPlanCalStatus() {
        Long groupevaplanno;
        long curId = Long.parseLong(this.getSelectedRows().getPrimaryKeyValues()[0].toString());
        DynamicObject curBill = QueryServiceHelper.queryOne((String)"srm_scorerpt", (String)"id,taskbillid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curId)});
        long taskbillid = curBill.getLong("taskbillid");
        DynamicObject srm_evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan", (String)"id,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskbillid)});
        if (srm_evaplan == null) {
            srm_evaplan = QueryServiceHelper.queryOne((String)"srm_evaplan_batch", (String)"id,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskbillid)});
        }
        if (srm_evaplan != null && (groupevaplanno = Long.valueOf(srm_evaplan.getLong("groupevaplanno"))) != null && groupevaplanno != 0L) {
            this.writeBackGroupEvaPlanCalStatus(groupevaplanno);
        }
    }

    private void writeBackGroupEvaPlanCalStatus(long groupevaplanno) {
        DynamicObjectCollection srm_evaplan = QueryServiceHelper.query((String)"srm_evaplan", (String)"id,bizstatus,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("groupevaplanno", "=", (Object)groupevaplanno)});
        if (srm_evaplan == null || srm_evaplan.isEmpty()) {
            srm_evaplan = QueryServiceHelper.query((String)"srm_evaplan_batch", (String)"id,bizstatus,groupevaplanno", (QFilter[])new QFilter[]{new QFilter("groupevaplanno", "=", (Object)groupevaplanno)});
        }
        HashSet<Long> evaplanIds = new HashSet<Long>(16);
        boolean wb = true;
        for (Object evaplan : srm_evaplan) {
            String bizstatus = evaplan.getString("bizstatus");
            if ("A".equals(bizstatus) || "B".equals(bizstatus)) {
                wb = false;
            }
            long evaplanId = evaplan.getLong("id");
            evaplanIds.add(evaplanId);
        }
        DynamicObjectCollection srm_scorerpt = QueryServiceHelper.query((String)"srm_scorerpt", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("taskbillid", "in", evaplanIds)});
        for (DynamicObject scorerpt : srm_scorerpt) {
            String bizstatus = scorerpt.getString("bizstatus");
            if ("G".equals(bizstatus) || "Z".equals(bizstatus)) continue;
            wb = false;
            break;
        }
        if (wb) {
            DynamicObject groupevaplan = BusinessDataServiceHelper.loadSingle((String)"srm_groupevaplan", (String)"id,billno,billstatus,cansumcalculate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupevaplanno)});
            groupevaplan.set("cansumcalculate", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{groupevaplan});
        }
    }

    private void review(BeforeItemClickEvent evt) {
        evt.setCancel(true);
        Object[] billIds = this.getSelectedRows().getPrimaryKeyValues();
        if (billIds.length == 0) {
            return;
        }
        SrmScoreRptListServiceValid serviceValid = this.getServiceValid();
        StringBuilder message = serviceValid.valid(billIds, "tblreview");
        if (message.length() > 0) {
            this.getView().showMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5185\u5bb9\u4e0d\u7b26\u5408\u521d\u5ba1\u8981\u6c42\uff0c\u8bf7\u91cd\u9009\u3002", (String)"SrmScorerptList_3", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmScorerptList_3", (String)"scm-srm-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
            return;
        }
        evt.setCancel(false);
    }

    private void approve(BeforeItemClickEvent evt) {
        evt.setCancel(true);
        Object[] billIds = this.getSelectedRows().getPrimaryKeyValues();
        SrmScoreRptListServiceValid serviceValid = this.getServiceValid();
        StringBuilder message = serviceValid.valid(billIds, "tblapprove");
        if (message.length() > 0) {
            this.getView().showMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5185\u5bb9\u4e0d\u7b26\u5408\u6838\u51c6\u8981\u6c42\uff0c\u8bf7\u91cd\u9009\u3002", (String)"SrmScorerptList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmScorerptList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
            return;
        }
        evt.setCancel(false);
    }

    private void directapprove(BeforeItemClickEvent evt) {
        evt.setCancel(true);
        Object[] billIds = this.getSelectedRows().getPrimaryKeyValues();
        SrmScoreRptListServiceValid serviceValid = this.getServiceValid();
        StringBuilder message = serviceValid.valid(billIds, "directapprove");
        if (message.length() > 0) {
            this.getView().showMessage(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5185\u5bb9\u4e0d\u7b26\u5408\u6838\u51c6\u8981\u6c42\uff0c\u8bf7\u91cd\u9009\u3002", (String)"SrmScorerptList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmScorerptList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
            return;
        }
        evt.setCancel(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "review": {
                    this.openDynamicPage("srm_reviewdy", "review");
                    break;
                }
                case "approve": {
                    this.openDynamicPage("srm_approvedy", "approve");
                    break;
                }
                case "directapprove": {
                    this.openDynamicPage("srm_directapprove", "directapprove");
                }
            }
        }
    }

    protected void openDynamicPage(String openPageName, String opId) {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"srm_scorerpt", (String)"evatype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)Long.parseLong(this.getSelectedRows().getPrimaryKeyValues()[0].toString()))});
        if (Objects.nonNull(dyo)) {
            mp.put("evatype", dyo.get("evatype"));
        }
        mp.put("score_Id", primaryKeyValues);
        for (Object primaryKeyValue : primaryKeyValues) {
            MutexHelper.require((String)"srm_scorerpt", (Object)primaryKeyValue, (String)opId, (boolean)true, (StringBuilder)new StringBuilder(16));
        }
        OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)openPageName, (ShowType)ShowType.NonModal, mp, (CloseCallBack)new CloseCallBack((IFormPlugin)this, opId));
    }

    protected SrmScoreRptListServiceValid getServiceValid() {
        if (Objects.isNull(this.serviceValid)) {
            this.serviceValid = new SrmScoreRptListServiceValid();
            return this.serviceValid;
        }
        return this.serviceValid;
    }

    protected SrmScoreRptListService getServiceRpt() {
        if (Objects.isNull(this.srmScoreRptListService)) {
            this.srmScoreRptListService = new SrmScoreRptListService();
            return this.srmScoreRptListService;
        }
        return this.srmScoreRptListService;
    }
}

