/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.service.AssignService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.util.JSONUtils;

public class SrmSupplierAssignPlugin
implements IBaseDataCtrlPlugin {
    private static Log logger = LogFactory.getLog(SrmSupplierAssignPlugin.class);

    public QFilter getExtendOrgQFilter() {
        return null;
    }

    public Boolean chectDuplicate(String s, Long aLong, List<Long> list) {
        return null;
    }

    public Map<Long, String> afterPermChangeCheck(List<Long> ids) {
        DynamicObjectCollection srm_suppliers;
        if (!ids.isEmpty() && (srm_suppliers = QueryServiceHelper.query((String)"srm_supplier", (String)"createorg,supplier,supplier.createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) != null && !srm_suppliers.isEmpty()) {
            long org = 0L;
            HashMap<Long, HashSet<Long>> bdSupplierMap = new HashMap<Long, HashSet<Long>>(16);
            for (DynamicObject srm_supplier : srm_suppliers) {
                long supplier = srm_supplier.getLong("supplier");
                if (supplier == 0L) continue;
                long createorg = srm_supplier.getLong("createorg");
                long supplierCreateorg = srm_supplier.getLong("supplier.createorg");
                HashSet<Long> bdSupplierSet = (HashSet<Long>)bdSupplierMap.get(supplierCreateorg);
                if (bdSupplierSet == null) {
                    bdSupplierSet = new HashSet<Long>(16);
                }
                bdSupplierSet.add(supplier);
                bdSupplierMap.put(supplierCreateorg, bdSupplierSet);
                if (createorg == 0L) continue;
                org = createorg;
            }
            for (Map.Entry entry : bdSupplierMap.entrySet()) {
                Long key = (Long)entry.getKey();
                Set value = (Set)entry.getValue();
                BaseDataServiceHelper.changeManageRight((String)"bd_supplier", (Long)key, (String)"basedata", (Set)value, (Long)org);
            }
        }
        return super.afterPermChangeCheck(ids);
    }

    public List<Object[]> unAssignCheckWitchDetail(List<Long[]> unAssignDatas) {
        try {
            HashSet<Long> dataIdSet = new HashSet<Long>();
            HashSet<Long> orgIdSet = new HashSet<Long>();
            for (Long[] unAssignData : unAssignDatas) {
                dataIdSet.add(unAssignData[0]);
                orgIdSet.add(unAssignData[1]);
            }
            Set<Long> bdSupplierIdSet = this.getBdSupplierId(dataIdSet, true);
            List res = BaseDataServiceHelper.cancelAssign((String)"bd_supplier", bdSupplierIdSet, orgIdSet);
            logger.info("\u4e3b\u6570\u636e\u540c\u6b65\u53d6\u6d88\u5206\u914d\u6210\u529f:" + JSONUtils.toString((Object)res));
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6570\u636e\u540c\u6b65\u53d6\u6d88\u5206\u914d\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage());
        }
        return new ArrayList<Object[]>();
    }

    private Set<Long> getBdSupplierId(HashSet<Long> dataIdSet, boolean needJudgeStrategy) {
        QFilter queryFilter;
        QFilter idFilter = new QFilter("id", "in", dataIdSet);
        DynamicObjectCollection srm_suppliers = QueryServiceHelper.query((String)"srm_supplier", (String)"id,supplier.number,number,createorg.id,ctrlstrategy", (QFilter[])idFilter.toArray());
        HashSet<Long> bdSupIds = new HashSet<Long>(srm_suppliers.size());
        if (srm_suppliers.size() != 0 && (queryFilter = this.getQueryFilter(srm_suppliers, needJudgeStrategy)) != null) {
            DynamicObjectCollection bd_suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])queryFilter.toArray());
            for (DynamicObject bdSupplier : bd_suppliers) {
                bdSupIds.add(bdSupplier.getLong("id"));
            }
        }
        return bdSupIds;
    }

    public Map<Long, Map<Long, String>> assignCheckWithDetail(List<Long> dataIDs, List<Long> orgIDs) {
        try {
            QFilter idFilter = new QFilter("id", "in", dataIDs);
            DynamicObjectCollection srm_supplier = QueryServiceHelper.query((String)"srm_supplier", (String)"id,number,supplier.number,createorg.id,ctrlstrategy", (QFilter[])idFilter.toArray());
            if (srm_supplier.size() != 0) {
                long assignOrgId = ((DynamicObject)srm_supplier.get(0)).getLong("createorg.id");
                QFilter queryFilter = this.getQueryFilter(srm_supplier, true);
                if (queryFilter != null) {
                    DynamicObjectCollection bd_suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,createorg.id", (QFilter[])queryFilter.toArray());
                    HashSet<Long> bdSupIds = new HashSet<Long>(bd_suppliers.size());
                    for (DynamicObject bdSupplier : bd_suppliers) {
                        bdSupIds.add(bdSupplier.getLong("id"));
                    }
                    logger.info("\u540c\u6b65\u4e3b\u6570\u636e\u4f9b\u5e94\u5546id\u4e3a\uff1a" + JSONUtils.toString(bdSupIds));
                    HashSet<Long> orgIds = new HashSet<Long>(bdSupIds.size());
                    orgIds.addAll(orgIDs);
                    AssignService service = new AssignService("bd_supplier");
                    BaseDataResponse response = service.assign(Long.valueOf(assignOrgId), "srm", bdSupIds, orgIds, true);
                    if (!response.isSuccess()) {
                        logger.info("\u540c\u6b65\u5206\u914d\u4e3b\u6570\u636e\u4f9b\u5e94\u5546\u5931\u8d25: " + response.getErrorMsg());
                    } else {
                        logger.info("\u540c\u6b65\u5206\u914d\u4e3b\u6570\u636e\u4f9b\u5e94\u5546\u6210\u529f");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4e3b\u6570\u636e\u540c\u6b65\u5206\u914d\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage());
        }
        return new HashMap<Long, Map<Long, String>>();
    }

    public void afterChangeCtrlStrategy(String entityId, List<Long> dataIds, String ctrlStrategy) {
        HashSet<Long> dataIdSet = new HashSet<Long>(dataIds);
        Set<Long> bdSupplierIdSet = this.getBdSupplierId(dataIdSet, false);
        QFilter idFilter = new QFilter("id", "=", (Object)dataIds.get(0));
        DynamicObject srmSup = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"createorg", (QFilter[])idFilter.toArray());
        long createorg = srmSup.getLong("createorg");
        BaseDataResponse response = BaseDataServiceHelper.changeCtrlStrategy((String)"bd_supplier", bdSupplierIdSet, (String)ctrlStrategy, (String)"srm", (Long)createorg);
        logger.info("\u540c\u6b65\u4e3b\u6570\u636e\u63a7\u5236\u7b56\u7565\u7ed3\u679c\uff1a " + response.isSuccess());
        if (!response.isSuccess()) {
            logger.info("\u540c\u6b65\u4e3b\u6570\u636e\u63a7\u5236\u7b56\u7565\u5931\u8d25\uff1a" + response.getErrorMsg());
        }
    }

    private QFilter getQueryFilter(DynamicObjectCollection srm_supplier, boolean needJudgeStrategy) {
        QFilter queryFilter = null;
        for (DynamicObject supplier : srm_supplier) {
            String number = supplier.getString("supplier.number");
            Long createorgId = supplier.getLong("createorg.id");
            QFilter ctrlstrategyFilter = null;
            if (needJudgeStrategy) {
                String ctrlstrategy = supplier.getString("ctrlstrategy");
                ctrlstrategyFilter = new QFilter("ctrlstrategy", "=", (Object)ctrlstrategy);
            }
            QFilter numberFilter = new QFilter("number", "=", (Object)number);
            QFilter orgFilter = new QFilter("createorg.id", "=", (Object)createorgId);
            QFilter filter = numberFilter.and(orgFilter).and(ctrlstrategyFilter);
            if (queryFilter == null) {
                queryFilter = filter;
                continue;
            }
            queryFilter = queryFilter.or(filter);
        }
        return queryFilter;
    }
}

