/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.constant.SupplierLifeCycleConstant;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.task.SupChgFilterDefService;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierLifeCycleManagerUtil;
import kd.sdk.scm.common.extpoint.ISupChgFilterService;
import kd.sdk.scm.srm.extpoint.portait.ISrmPortraitStatistic;
import org.apache.commons.beanutils.ConversionException;

public class SrmSupplierList
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(SrmSupplierList.class);
    private static final String CONFIRMCALLBACKID = "confirmBack";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult checkResult = FeatureCheckUtil.checkSRMFeatureByVersion((String)"XV1IC150UR4", (String)"srm_supplier", (Long)RequestContext.get().getCurrUserId(), (String)"7.0");
        if (checkResult != null && !checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        HashSet<Long> status_supplier = new HashSet<Long>(16);
        DynamicObjectCollection bd_supplierstatus = QueryServiceHelper.query((String)"bd_supplierstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("id", "!=", (Object)SupplierLifeCycleConstant.SUPSTATUS_REGISTER))});
        for (DynamicObject status : bd_supplierstatus) {
            status_supplier.add(status.getLong("id"));
        }
        qFilterList.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("supplier_status.id", "in", status_supplier));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        int size = selectedRows.size();
        String pushBillEntityName = "";
        switch (itemKey) {
            case "tbl_change_normal": {
                pushBillEntityName = "srm_aptitudeexam";
                break;
            }
            case "tbl_change_temp": {
                pushBillEntityName = "srm_supapprovetemp";
                break;
            }
            case "tbl_change_quit": {
                pushBillEntityName = "srm_supquit";
                break;
            }
            case "tbl_change_black": {
                pushBillEntityName = "srm_blackenterprise";
                break;
            }
        }
        if ("tbl_change_normal".equals(itemKey) || "tbl_change_temp".equals(itemKey) || "tbl_change_quit".equals(itemKey) || "tbl_change_black".equals(itemKey)) {
            if (size != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"SrmSupplierList_19", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                evt.setCancel(false);
                return;
            }
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            if (StringUtils.isNotBlank((CharSequence)pushBillEntityName)) {
                Map result = SupplierLifeCycleManagerUtil.checkSupplierStatus((Object)primaryKeyValue, (String)pushBillEntityName);
                if (((Boolean)result.get("success")).booleanValue()) {
                    Map pushResult = SupplierLifeCycleManagerUtil.pushBizBill((Object)primaryKeyValue, (String)pushBillEntityName);
                    if (((Boolean)pushResult.get("success")).booleanValue()) {
                        DynamicObjectCollection pushBillEntity = QueryServiceHelper.query((String)pushBillEntityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("supplier", "=", primaryKeyValue)}, (String)"createtime desc");
                        if (pushBillEntity != null && pushBillEntity.size() > 0) {
                            long pkId = ((DynamicObject)pushBillEntity.get(0)).getLong("id");
                            OpenFormUtil.openBillPage((IFormView)this.getView(), (String)pushBillEntityName, (Object)pkId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                        }
                    } else {
                        this.getView().showTipNotification(pushResult.get("msg").toString());
                    }
                } else if (result.get("msg") != null) {
                    this.getView().showTipNotification(result.get("msg").toString());
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("tblchange")) {
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            if (billId == 0L) {
                args.setCancel(true);
                return;
            }
            DynamicObject obj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"auditstatus,name,id,createorg.id", (String)"id", (Object)billId, null, null, null, null, null, null, null, (String)"queryOne", null);
            if (obj == null) {
                args.setCancel(true);
                return;
            }
            Object changebyorg = ParamUtil.getParamObj((String)"XV1IC150UR4", (String)"changebyorg");
            String verifyOrg = this.getPageCache().get("verifyOrg");
            Object createorg = obj.get("createorg.id");
            if (Objects.nonNull(changebyorg) && "B".equals(changebyorg) && StringUtils.isNotEmpty((CharSequence)verifyOrg) && Objects.nonNull(createorg) && !verifyOrg.contains(createorg.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u8be5\u4f9b\u5e94\u5546\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u53d1\u8d77\u53d8\u66f4\u3002", (String)"SrmSupplierList_15", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (obj.getString("auditstatus").equals(SrmSupplierStatusEnum.UNAUDIT.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u9a73\u56de\u72b6\u6001\u7684\u4f9b\u5e94\u5546\u4e0d\u80fd\u8fdb\u884c\u8d44\u6599\u53d8\u66f4\u3002", (String)"SrmSupplierList_16", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getPageCache().put("billid", String.valueOf(billId));
            Map result = null;
            Long supId = obj.getLong("id");
            SupChgFilterDefService defPlugin = new SupChgFilterDefService();
            PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISupChgFilterService.class, (String)"SCM_SRM_SRMSUPCHGFILTERSERVICE_EXT", null);
            List plugins = pluginProxy.getPlugins();
            if (plugins != null && !plugins.isEmpty()) {
                for (ISupChgFilterService srmSupChgFilterService : plugins) {
                    result = srmSupChgFilterService.supplierChgFilter(supId);
                }
            }
            if (result != null && !((Boolean)result.get("success")).booleanValue()) {
                this.getView().showTipNotification(result.get("message").toString());
                args.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "tblchange": {
                if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                long billId = Long.parseLong(this.getPageCache().get("billid"));
                OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"srm_supplierchg", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "syncbdsupplier": {
                ListShowParameter lsp = this.bulidParameter();
                this.getView().showForm((FormShowParameter)lsp);
                break;
            }
            case "syncsupplier": {
                HashMap supplierOfSociety = new HashMap();
                HashMap<Long, String> srmSupplierOfSociety = new HashMap<Long, String>();
                ArrayList supplierNoList = new ArrayList();
                HashMap supplierNoMap = new HashMap();
                try {
                    QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                    QFilter societycreditcodeFilter = new QFilter("societycreditcode", "!=", (Object)"");
                    QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_supplier", (String)"id,societycreditcode,supplier,createorg", (QFilter[])new QFilter[0], (String)"id");
                    Object object = null;
                    try {
                        dataSet.forEach(row -> srmSupplierOfSociety.put(row.getLong("supplier"), row.getString("societycreditcode") + "-|-" + row.getString("createorg")));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (dataSet != null) {
                            if (object != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                dataSet.close();
                            }
                        }
                    }
                    log.info(((Object)srmSupplierOfSociety).toString());
                    dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"bd_supplier", (String)"id,societycreditcode,number,createorg", (QFilter[])new QFilter[]{enableFilter.and(statusFilter), societycreditcodeFilter}, (String)"id");
                    object = null;
                    try {
                        dataSet.forEach(row -> {
                            supplierOfSociety.put(row.getLong("id"), row.getString("societycreditcode") + "-|-" + row.getString("createorg"));
                            supplierNoMap.put(row.getLong("id"), row.getString("number"));
                        });
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (dataSet != null) {
                            if (object != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                dataSet.close();
                            }
                        }
                    }
                    log.info(((Object)supplierOfSociety).toString());
                    ArrayList<Long> supplierPkIds = new ArrayList<Long>();
                    for (Map.Entry entry : supplierOfSociety.entrySet()) {
                        Long key = (Long)entry.getKey();
                        String value = (String)entry.getValue();
                        if (srmSupplierOfSociety.containsKey(key) || value == null || value.isEmpty() || srmSupplierOfSociety.containsValue(value)) continue;
                        supplierPkIds.add(key);
                        supplierNoList.add(supplierNoMap.get(key));
                        srmSupplierOfSociety.put(key, value);
                    }
                    log.info(((Object)supplierPkIds).toString());
                    if (!supplierPkIds.isEmpty()) {
                        String srcEntityKey = "bd_supplier";
                        String string = "srm_supplier";
                        PushArgs pushArgs = new PushArgs();
                        pushArgs.setSourceEntityNumber(srcEntityKey);
                        pushArgs.setTargetEntityNumber(string);
                        pushArgs.setBuildConvReport(false);
                        ArrayList selectedRowList = new ArrayList();
                        supplierPkIds.forEach(row -> {
                            ListSelectedRow listSelectedRow = new ListSelectedRow();
                            listSelectedRow.setPrimaryKeyValue(row);
                            selectedRowList.add(listSelectedRow);
                        });
                        pushArgs.setSelectedRows(selectedRowList);
                        ConvertOperationResult result = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
                        if (result.isSuccess()) {
                            Set targetBillIds = result.getTargetBillIds();
                            this.saveResult(targetBillIds);
                            this.getView().showSuccessNotification(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5df2\u5b8c\u6210 %1 \u6761\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u540c\u6b65\u3002", (String)"SrmSupplierList_2", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_2", (String)"scm-srm-formplugin", (Object[])new Object[]{targetBillIds.size()}));
                            log.info("\u6b63\u5f0f\u4f9b\u5e94\u5546\u8f6c\u6ce8\u518c\u4f9b\u5e94\u6210\u529f\uff0c\u606d\u559c\u60a8\u3002" + targetBillIds.size());
                        } else {
                            StringBuilder message = new StringBuilder();
                            result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
                            log.info("\u6b63\u5f0f\u4f9b\u5e94\u5546\u8f6c\u6ce8\u518c\u4f9b\u5e94\u5546\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u662f\uff1a" + message);
                        }
                        this.getView().updateView();
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u540c\u6b65\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u3002", (String)"SrmSupplierList_3", (String)"scm-srm-formplugin", (Object[])new Object[0]));
                }
                catch (ConversionException e) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u57fa\u7840\u4f9b\u5e94\u5546\u7684\u6ce8\u518c\u8d44\u672c\u4fe1\u606f\u586b\u5199\u662f\u5426\u7b26\u5408\u89c4\u8303\u3002", (String)"SrmSupplierList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]), ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801\uff1a%1", (String)"SrmSupplierList_5", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_5", (String)"scm-srm-formplugin", (Object[])new Object[]{supplierNoList}), MessageTypes.Default);
                    log.error("\u540c\u6b65\u4f9b\u5e94\u5546\u51fa\u9519\uff1a" + e.getMessage());
                }
                catch (NumberFormatException e) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u57fa\u7840\u4f9b\u5e94\u5546\u7684\u6ce8\u518c\u8d44\u672c\u4fe1\u606f\u586b\u5199\u662f\u5426\u7b26\u5408\u89c4\u8303\u3002", (String)"SrmSupplierList_4", (String)"scm-srm-formplugin", (Object[])new Object[0]), ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801\uff1a%1", (String)"SrmSupplierList_5", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_5", (String)"scm-srm-formplugin", (Object[])new Object[]{supplierNoList}), MessageTypes.Default);
                    log.error("\u540c\u6b65\u4f9b\u5e94\u5546\u51fa\u9519\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
                }
                catch (Exception e) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u6b65\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u8f6c\u6362\u89c4\u5219\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SrmSupplierList_8", (String)"scm-srm-formplugin", (Object[])new Object[0]), ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u51fa\u9519\uff1a%1", (String)"SrmSupplierList_9", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_9", (String)"scm-srm-formplugin", (Object[])new Object[]{supplierNoList}), MessageTypes.Default);
                    log.error("" + ExceptionUtil.getStackTrace((Throwable)e));
                }
                break;
            }
            case "viewportrait": {
                long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                if (billId == 0L) break;
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"srm_supplier");
                ISrmPortraitStatistic.viewSrmPortraitInfo((DynamicObject)obj, (IFormView)this.getView());
                break;
            }
        }
    }

    private void saveResult(Set<Object> targetBillIds) {
        DynamicObject[] targetData = BusinessDataServiceHelper.load((String)"srm_supplier", (String)"id,type,name,auditdate,auditor,org,createorg,useorg", (QFilter[])new QFilter[]{new QFilter("id", "in", targetBillIds)});
        Date now = TimeServiceHelper.now();
        String userId = RequestContext.get().getUserId();
        for (DynamicObject supplier : targetData) {
            String supName = supplier.getString("name");
            String type = this.getBdSupplierType(supName);
            if (type != null) {
                if (type.equals("3")) {
                    supplier.set("type", (Object)"5");
                } else if (type.equals("2")) {
                    supplier.set("type", (Object)"8");
                } else if (type.equals("4")) {
                    supplier.set("type", (Object)"7");
                } else if (type.equals("5")) {
                    supplier.set("type", (Object)"6");
                } else if (type.equals("1")) {
                    supplier.set("type", (Object)"1");
                }
            } else {
                supplier.set("type", (Object)type);
            }
            supplier.set("auditdate", (Object)now);
            supplier.set("auditor_id", (Object)Long.valueOf(userId));
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", String.valueOf(true));
            SaveServiceHelper.save((DynamicObject[])targetData);
        }
    }

    private String getBdSupplierType(String supName) {
        DynamicObject bdSupplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"type", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)supName)});
        return bdSupplier == null ? "" : bdSupplier.getString("type");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("syncback".equals(actionId) && !CollectionUtils.isEmpty((Collection)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            Object[] primaryKeyValues = returnData.getPrimaryKeyValues();
            if (primaryKeyValues.length == 0) {
                log.info("sync call back selectValues is null");
                return;
            }
            HashMap bdsupplierOfSociety = new HashMap(12);
            HashMap srmSupplierOfSociety = new HashMap(12);
            HashMap bdsupplierOfNumber = new HashMap(12);
            HashMap bdsupplierOfName = new HashMap(12);
            ArrayList<Long> selectBdIds = new ArrayList<Long>(32);
            DataSet bdSuppliers = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"bd_supplier", (String)"id,name,societycreditcode,number,createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)}, null);
            bdSuppliers.forEach(row -> {
                bdsupplierOfSociety.put(row.getLong("id"), row.getString("societycreditcode") + "-|-" + row.getLong("createorg"));
                bdsupplierOfNumber.put(row.getLong("id"), row.getString("number"));
                bdsupplierOfName.put(row.getLong("id"), row.getString("name"));
            });
            DataSet srmSuppliers = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_supplier", (String)"id,societycreditcode,supplier,createorg", (QFilter[])new QFilter[0], (String)"id");
            srmSuppliers.forEach(row -> srmSupplierOfSociety.put(row.getLong("supplier"), row.getString("societycreditcode") + "-|-" + row.getString("createorg")));
            Set bdsupplierOfSocietyentries = bdsupplierOfSociety.entrySet();
            StringBuilder confirmMessage = new StringBuilder(32);
            for (Map.Entry bdsupplierOfSocietyentry : bdsupplierOfSocietyentries) {
                Long id = (Long)bdsupplierOfSocietyentry.getKey();
                String societyen = (String)bdsupplierOfSocietyentry.getValue();
                if (srmSupplierOfSociety.containsKey(id) || srmSupplierOfSociety.containsValue(societyen)) {
                    String number = (String)bdsupplierOfNumber.get(id);
                    String name = (String)bdsupplierOfName.get(id);
                    confirmMessage.append(name).append("(").append(number).append(")").append(System.lineSeparator());
                    continue;
                }
                selectBdIds.add(id);
            }
            if (selectBdIds.size() == 0) {
                this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6240\u9009\u7684\u4f9b\u5e94\u5546\u90fd\u5df2\u5b58\u5728\u4e8e\u4f9b\u5e94\u5546\u5e93\u4e2d\uff0c\u65e0\u9700\u540c\u6b65\u3002", (String)"SrmSupplierList_11", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_11", (String)"scm-srm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                return;
            }
            ConfirmCallBackListener confirm = new ConfirmCallBackListener(CONFIRMCALLBACKID, (IFormPlugin)this);
            if (confirmMessage.length() > 0) {
                this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u6240\u9009\u7684\u4e3b\u6570\u636e\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\u4e8e\u4f9b\u5e94\u5546\u5e93\u4e2d\u3002\u662f\u5426\u7ee7\u7eed\u540c\u6b65\u5176\u4ed6\u4f9b\u5e94\u5546\uff1f", (String)"SrmSupplierList_10", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_10", (String)"scm-srm-formplugin", (Object[])new Object[0]), confirmMessage.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirm, null, ((Object)selectBdIds).toString());
            } else {
                this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u786e\u8ba4\u5f00\u59cb\u540c\u6b65\u4e3b\u6570\u636e\u4f9b\u5e94\u5546\uff1f", (String)"SrmSupplierList_12", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_12", (String)"scm-srm-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirm, null, ((Object)selectBdIds).toString());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRMCALLBACKID.equals(callBackId)) {
            String resultValue = messageBoxClosedEvent.getResultValue();
            if (!"Yes".equals(resultValue)) {
                return;
            }
            String selectIds = messageBoxClosedEvent.getCustomVaule();
            ArrayList<Long> supplierPkIds = new ArrayList<Long>(12);
            log.info("confirmCallBack selectIds is " + selectIds);
            if (StringUtils.isNotEmpty((CharSequence)selectIds)) {
                String replaceIds = selectIds.replace("[", "").replace("]", "");
                String[] splitIds = replaceIds.split(",");
                if (splitIds.length > 0) {
                    for (String splitId : splitIds) {
                        String trimsplitId = splitId.trim();
                        supplierPkIds.add(Long.parseLong(trimsplitId));
                    }
                }
                if (supplierPkIds.size() > 0) {
                    this.pushbdSupplier(supplierPkIds);
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void pushbdSupplier(List<Long> supplierPkIds) {
        log.info("start pushbdSupplier supplierPkIds is:" + supplierPkIds.toString());
        String srcEntityKey = "bd_supplier";
        String targetEntityKey = "srm_supplier";
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityKey);
        pushArgs.setTargetEntityNumber(targetEntityKey);
        pushArgs.setBuildConvReport(true);
        ArrayList selectedRowList = new ArrayList();
        supplierPkIds.forEach(row -> {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue(row);
            selectedRowList.add(listSelectedRow);
        });
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (result.isSuccess()) {
            Set targetBillIds = result.getTargetBillIds();
            this.saveResult(targetBillIds);
            this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5171%1\u6761\u6570\u636e\uff0c\u540c\u6b65\u6210\u529f%2\u6761\u3002", (String)"SrmSupplierList_18", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_13", (String)"scm-srm-formplugin", (Object[])new Object[]{supplierPkIds.size(), targetBillIds.size()}), MessageBoxOptions.OK);
        } else {
            StringBuilder message = new StringBuilder();
            result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
            this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6b63\u5f0f\u4f9b\u5e94\u5546\u8f6c\u6ce8\u518c\u4f9b\u5e94\u5546\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u662f\uff1a%1", (String)"SrmSupplierList_14", (String)"scm-srm-formplugin", (Object[])new Object[0]), (String)"SrmSupplierList_14", (String)"scm-srm-formplugin", (Object[])new Object[]{message}), MessageBoxOptions.OK);
            log.info("\u6b63\u5f0f\u4f9b\u5e94\u5546\u8f6c\u6ce8\u518c\u4f9b\u5e94\u5546\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u662f\uff1a" + message);
        }
    }

    private ListShowParameter bulidParameter() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bd_supplier", (boolean)true, (int)0, (boolean)true);
        ListFilterParameter filterParameter = new ListFilterParameter();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C")).and(new QFilter("societycreditcode", "!=", (Object)"")).and(new QFilter("societycreditcode", "not like", (Object)" % "));
        filterParameter.setFilter(qFilter);
        lsp.setListFilterParameter(filterParameter);
        lsp.setCustomParam("groupStandard", (Object)716529547008326656L);
        lsp.setCloseCallBack(new CloseCallBack(this.getPluginName(), "syncback"));
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)null, (String)"bd_supplier", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            lsp.setUseOrgId(RequestContext.get().getOrgId());
        }
        return lsp;
    }
}

