/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.formplugin.warn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;

public class SrmWarnConditionService {
    public static QFilter queryCondition(Map<String, Object> customConditionMap) {
        Integer warnday = (Integer)customConditionMap.get("warnday");
        Date today = TimeServiceHelper.today();
        Date priviousDate = DateUtil.addDays((Date)today, (int)-1);
        priviousDate = DateUtil.getDayStart((Date)priviousDate);
        Date warningDate = DateUtil.addDays((Date)today, (int)warnday);
        QFilter qFilter = new QFilter("entry_aptitude.dateto", ">=", (Object)priviousDate);
        if (Objects.isNull(warningDate)) {
            Date defalutDate = DateUtil.addDays((Date)today, (int)30);
            qFilter.and("entry_aptitude.dateto", "<=", (Object)defalutDate);
        } else {
            qFilter.and("entry_aptitude.dateto", "<=", (Object)warningDate);
        }
        return qFilter;
    }

    public static void bulidCostomMessage(StringBuilder costomMessage, Map<String, Object> customConditionDataMap, DynamicObject dynamicObject) {
        QFilter qFilter = SrmWarnConditionService.queryCondition(customConditionDataMap);
        QFilter qFilterid = new QFilter("id", "=", dynamicObject.get("id"));
        qFilter.and(qFilterid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"srm_supplier", (String)"entry_aptitude,entry_aptitude.aptitudename,entry_aptitude.dateto", (QFilter[])new QFilter[]{qFilter});
        if (!CollectionUtils.isEmpty((Collection)query)) {
            for (DynamicObject aptitude : query) {
                costomMessage.append("\n");
                String aptitudename = aptitude.getString("entry_aptitude.aptitudename");
                Date dateto = aptitude.getDate("entry_aptitude.dateto");
                costomMessage.append("\"").append(aptitudename).append("\"").append(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f", (String)"SrmWarnConditionService_1", (String)"scm-srm-formplugin", (Object[])new Object[0])).append("\"").append(dateto).append("\"");
            }
        }
    }

    public static List<Long> getSupplierUserIds(DynamicObject[] dynamicObjects) {
        ArrayList<Long> receiverIds = new ArrayList<Long>(12);
        ArrayList<Object> supIds = new ArrayList<Object>(12);
        if (Objects.nonNull(dynamicObjects) && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                supIds.add(dynamicObject.getPkValue());
            }
        } else {
            BizLog.log((String)"SrmWarnCostomReceivePlugin getReceiverIds dynamicObjects is null");
        }
        if (supIds.size() > 0) {
            DynamicObjectCollection srmQuerySup = QueryServiceHelper.query((String)"srm_supplier", (String)"supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", supIds)});
            if (!CollectionUtils.isEmpty((Collection)srmQuerySup)) {
                List srmSupplier = srmQuerySup.stream().map(x -> x.getLong("supplier")).collect(Collectors.toList());
                DynamicObject[] loadSupplier = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", srmSupplier)});
                if (Objects.nonNull(loadSupplier) && loadSupplier.length > 0) {
                    Set bizpartner = Arrays.stream(loadSupplier).map(x -> x.getLong("bizpartner.id")).collect(Collectors.toSet());
                    List supUserIdsByBizPartner = BizPartnerUtil.getSupEnableUserIdsByBizPartner(bizpartner);
                    if (!CollectionUtils.isEmpty((Collection)supUserIdsByBizPartner)) {
                        BizLog.log((String)("SrmWarnCostomReceivePlugin getReceiverIds supUserIdsByBizPartner is " + supUserIdsByBizPartner.toString()));
                        return supUserIdsByBizPartner;
                    }
                } else {
                    BizLog.log((String)"SrmWarnCostomReceivePlugin getReceiverIds loadSupplier is null");
                }
            } else {
                BizLog.log((String)"SrmWarnCostomReceivePlugin getReceiverIds srmQuerySup is null");
            }
        }
        return receiverIds;
    }
}

