/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sw.business.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.sw.business.model.TodoEntryData;

public class TodoData
implements Serializable {
    private static final long serialVersionUID = -337845928271250593L;
    private String cardKey;
    private Map<String, Map<String, Set<Long>>> status_entityIdMap;
    private Map<String, List<TodoEntryData>> entryDataMap;

    public TodoData() {
    }

    public TodoData(String cardKey) {
        this.cardKey = cardKey;
    }

    public Map<String, Map<String, Set<Long>>> getStatus_entityIdMap() {
        return this.status_entityIdMap;
    }

    public void setStatus_entityIdMap(Map<String, Map<String, Set<Long>>> status_entityIdMap) {
        this.status_entityIdMap = status_entityIdMap;
    }

    public int getTotalNumber() {
        if (CollectionUtils.isEmpty(this.status_entityIdMap)) {
            return 0;
        }
        int total = 0;
        for (Map.Entry<String, Map<String, Set<Long>>> entry : this.status_entityIdMap.entrySet()) {
            total += this.getStatusTotalNumber(entry.getKey());
        }
        return total;
    }

    public int getStatusTotalNumber(String status) {
        int total = 0;
        for (Map.Entry<String, Set<Long>> inner : this.status_entityIdMap.get(status).entrySet()) {
            total += inner.getValue().size();
        }
        return total;
    }

    public Map<String, List<TodoEntryData>> getEntryDataMap() {
        return this.entryDataMap;
    }

    public void addEntryData(String status, List<TodoEntryData> entryDatas) {
        if (CollectionUtils.isEmpty(this.entryDataMap)) {
            this.entryDataMap = new LinkedHashMap<String, List<TodoEntryData>>();
        }
        if (null == entryDatas) {
            return;
        }
        List data = this.entryDataMap.computeIfAbsent(status, s -> new ArrayList(entryDatas.size()));
        data.addAll(entryDatas);
    }

    public String toString() {
        return "TodoData [cardKey=" + this.cardKey + ", status_entityIdMap=" + this.status_entityIdMap + ", entryDataMap=" + this.entryDataMap + "]";
    }
}

