/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sw.business.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.sw.business.model.SwCard;
import kd.scm.sw.business.model.SwCardEntry;
import kd.scm.sw.business.model.TodoData;
import kd.scm.sw.business.model.TodoEntryData;
import kd.scm.sw.business.service.ToDoDataQueryService;
import kd.scm.sw.business.service.TodoDataAccessRunner;

public class ToDoDataQueryServiceImpl
implements ToDoDataQueryService {
    private Log logger = LogFactory.getLog(ToDoDataQueryServiceImpl.class);
    private static final ThreadPool workerThreadPool;

    @Override
    public TodoData queryTodoData(SwCard config) {
        TodoData todoDataResult = new TodoData(config.getCardKey());
        try {
            List<SwCardEntry> entryCards = config.getEntries();
            LinkedHashMap<SwCardEntry, Future> resultMap = new LinkedHashMap<SwCardEntry, Future>(8);
            for (SwCardEntry card : entryCards) {
                TraceSpan create = Tracer.create((String)"ToDoDataQueryServiceImpl.queryTodoData", (String)String.valueOf(card.getEntityNumber()));
                Throwable throwable = null;
                try {
                    TodoDataAccessRunner runner = new TodoDataAccessRunner(card.getServiceName(), card.getEntityNumber());
                    Future submit = workerThreadPool.submit((Callable)runner, RequestContext.get());
                    resultMap.put(card, submit);
                }
                catch (Throwable runner) {
                    throwable = runner;
                    throw runner;
                }
                finally {
                    if (create == null) continue;
                    if (throwable != null) {
                        try {
                            create.close();
                        }
                        catch (Throwable runner) {
                            throwable.addSuppressed(runner);
                        }
                        continue;
                    }
                    create.close();
                }
            }
            LinkedHashMap<String, Map<String, Set<Long>>> status_entityIdMap = new LinkedHashMap<String, Map<String, Set<Long>>>(16);
            for (Map.Entry entry : resultMap.entrySet()) {
                SwCardEntry card = (SwCardEntry)entry.getKey();
                Map pks = (Map)((Future)entry.getValue()).get();
                Map value = status_entityIdMap.computeIfAbsent(card.getTabStatusName(), s -> new LinkedHashMap());
                value.putAll(pks);
            }
            todoDataResult.setStatus_entityIdMap(status_entityIdMap);
        }
        catch (Exception e) {
            this.logger.info("ToDoDataQueryServiceImpl.queryTodoData Error-->{}", (Object)ExceptionUtil.getStackTrace((Throwable)e));
        }
        return todoDataResult;
    }

    @Override
    public List<TodoEntryData> queryTodoEntryDatasByPks(String entityKey, Set<Long> pks, String selectFeilds) {
        QFilter filter = new QFilter("id", "in", pks);
        ArrayList<TodoEntryData> result = new ArrayList<TodoEntryData>(pks.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ToDoDataQueryServiceImpl.queryTodoEntryDatasByPks", (String)entityKey, (String)(StringUtils.isBlank((CharSequence)selectFeilds) ? "id,org.name,creator,auditor,auditdate,billno" : selectFeilds), (QFilter[])new QFilter[]{filter}, null).select("id,org.name,creator,auditor,auditdate,billno").orderBy(new String[]{"auditdate desc"});){
            for (Row row : ds) {
                Long pkId = row.getLong("id");
                TodoEntryData todoEntryData = new TodoEntryData();
                todoEntryData.setEntityId(entityKey);
                todoEntryData.setPkId(pkId);
                todoEntryData.setTitle(this.getTitle(row, entityKey));
                todoEntryData.setCreatorId(StringUtils.equals((CharSequence)"pur_iminventory", (CharSequence)entityKey) ? 0L : row.getLong("creator"));
                todoEntryData.setNumber(row.getString("billno"));
                todoEntryData.setDatetime(row.getDate("auditdate"));
                result.add(todoEntryData);
            }
        }
        return result;
    }

    private String getTitle(Row row, String entityKey) {
        String entityName = MetadataServiceHelper.getDataEntityType((String)entityKey).getDisplayName().getLocaleValue();
        if (entityKey.startsWith("tnd")) {
            return ResManager.loadKDString((String)"\u60a8\u6709\u4e00\u5f20\u5f85\u5904\u7406\u7684{0}\uff0c\u5bfb\u6e90\u9879\u76ee\u5355\u53f7\uff1a{1}\uff0c\u4e1a\u52a1\u90e8\u95e8\uff1a{2}\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"ToDoDataQueryServiceImpl_2", (String)"scm-sw-business", (Object[])new Object[]{entityName, row.getString("billno"), row.getString("org.name")});
        }
        if (StringUtils.equals((CharSequence)"pur_iminventory", (CharSequence)entityKey)) {
            return ResManager.loadKDString((String)"\u60a8\u6709\u4e00\u6761\u5f85\u5904\u7406\u7684\u7269\u6599\u8865\u8d27\u63d0\u9192\uff0c\u7269\u6599\u7f16\u7801\uff1a{0}\uff0c\u4e1a\u52a1\u90e8\u95e8\uff1a{1}\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"ToDoDataQueryServiceImpl_1", (String)"scm-sw-business", (Object[])new Object[]{row.getString("billno"), row.getString("org.name")});
        }
        return ResManager.loadKDString((String)"\u60a8\u6709\u4e00\u5f20\u5f85\u5904\u7406\u7684{0}\uff0c\u5355\u53f7\uff1a{1}\uff0c\u4e1a\u52a1\u90e8\u95e8\uff1a{2}\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"ToDoDataQueryServiceImpl_0", (String)"scm-sw-business", (Object[])new Object[]{entityName, row.getString("billno"), row.getString("org.name")});
    }

    static {
        int count;
        try {
            count = Integer.parseInt(System.getProperty("SCM_SWTODO_QEURY_TASK_THREADS"));
            if (count <= 0) {
                count = 16;
            }
        }
        catch (NumberFormatException var2) {
            count = 16;
        }
        workerThreadPool = ThreadPools.newCachedThreadPool((String)"SCM_SWTODO_QEURY_TASK_THREADS", (int)0, (int)count);
    }
}

