/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sw.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.workflow.api.MessageRequestInfo;
import kd.bos.workflow.message.service.impl.MessageCenterServiceImpl;

public class SwMessageCardPlugin
extends GridCardPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final int DEFAULT_COUNT = 7;
    private static final String HTML_NEWLINE_LABEL = "<br/>";
    private static final String CONTENT = "content";
    private static final String CLOSE_MESSAGE = "close_message";

    public void registerListener(EventObject e) {
        EntryGrid entity2;
        super.registerListener(e);
        EntryGrid entity1 = (EntryGrid)this.getControl("entryentity1");
        if (entity1 != null) {
            entity1.addRowClickListener((RowClickEventListener)this);
            entity1.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((entity2 = (EntryGrid)this.getControl("entryentity2")) != null) {
            entity2.addRowClickListener((RowClickEventListener)this);
            entity2.addHyperClickListener((HyperLinkClickListener)this);
        }
        this.addClickListeners(new String[]{"labelap"});
        this.addClickListeners(new String[]{"refreshap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"labelap")) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            Tab tab = (Tab)this.getControl("tabap");
            String tabKey = tab.getCurrentTab();
            String suffix = tabKey.substring(tabKey.length() - 1);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)suffix)) {
                customParams.put("msgType", 475779909600436224L);
            } else {
                customParams.put("msgType", 475779578418192384L);
            }
            customParams.put("eventSource", "card");
            this.openMessageList(null, customParams, new CloseCallBack((IFormPlugin)this, CLOSE_MESSAGE), this.getTitle(suffix));
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"refreshap")) {
            this.refreshCard(this.getAllConfigMap());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        super.refreshCard(allConfigMap);
        this.showMessage();
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        String cardKey = cardEntry.getEntryKey();
        if (StringUtils.startsWith((CharSequence)cardKey, (CharSequence)"entryentity")) {
            this.openMessgeListByClickEntry(evt.getRow(), cardKey.substring(cardKey.length() - 1));
        }
    }

    private void openMessgeListByClickEntry(int clickRowIndex, String suffix) {
        DynamicObject msgObj = this.getModel().getEntryRowEntity("entryentity" + suffix, clickRowIndex);
        Long messageId = 0L;
        if (msgObj != null) {
            messageId = msgObj.getLong("messageid" + suffix);
        }
        ArrayList<Long> ids = new ArrayList<Long>(4);
        ids.add(messageId);
        QFilter filter = new QFilter("id", "in", ids);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_MESSAGE);
        this.openMessageList(filter, null, closeCallBack, this.getTitle(suffix));
    }

    private String getTitle(String suffix) {
        return StringUtils.equals((CharSequence)suffix, (CharSequence)"1") ? ResManager.loadKDString((String)"\u6d88\u606f\u5217\u8868", (String)"SwMessageCardPlugin_0", (String)"scm-sw-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9884\u8b66\u5217\u8868", (String)"SwMessageCardPlugin_1", (String)"scm-sw-formplugin", (Object[])new Object[0]);
    }

    private void openMessageList(QFilter filter, Map<String, Object> customParams, CloseCallBack callBack, String title) {
        block5: {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId("wf_msg_message");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.getListFilterParameter().setFilter(filter);
            lsp.setCaption(title);
            if (customParams != null) {
                lsp.setCustomParams(customParams);
            }
            if (callBack != null) {
                lsp.setCloseCallBack(callBack);
            }
            try {
                IFormView parentView = this.getView().getParentView();
                if (null != parentView) {
                    parentView.showForm((FormShowParameter)lsp);
                    this.getView().sendFormAction(parentView);
                }
            }
            catch (Exception e) {
                IFormView view = this.getView();
                if (null == view) break block5;
                view.showForm((FormShowParameter)lsp);
                this.getView().sendFormAction(view);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.isNotBlank((CharSequence)e.getActionId()) && StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)CLOSE_MESSAGE)) {
            this.refreshCard(this.getAllConfigMap());
        }
    }

    private void createEntry(List<Map<String, Object>> messageList, int index) {
        this.clearOldNotify("entryentity" + index);
        if (!CollectionUtils.isEmpty(messageList)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("messageid" + index, new Object[0]);
            vs.addField("msgtitle" + index, new Object[0]);
            vs.addField("msgdate" + index, new Object[0]);
            for (Map<String, Object> messageMap : messageList) {
                String message = String.valueOf(messageMap.get(CONTENT));
                message = this.replaceHtmlLabel(message);
                Object messageDate = messageMap.get("createdate");
                vs.addRow(new Object[]{messageMap.get("id"), message, messageDate});
            }
            model.batchCreateNewEntryRow("entryentity" + index, vs);
            model.endInit();
        }
        this.getView().updateView("entryentity" + index);
    }

    private void showMessage() {
        this.createEntry(this.getMessageByType("message"), 1);
        this.createEntry(this.getMessageByType("warning"), 2);
    }

    private List<Map<String, Object>> getMessageByType(String msgType) {
        MessageCenterServiceImpl service = new MessageCenterServiceImpl();
        MessageRequestInfo info = new MessageRequestInfo();
        info.setLimit(0);
        int count = this.getModel().getDataEntity().getInt("count");
        info.setLimit(count > 0 ? count : 7);
        info.setEntityNumber("wf_msg_message");
        info.setMsgType(msgType);
        info.setUnread(Boolean.valueOf(true));
        info.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        return service.getMessageData(info);
    }

    private void clearOldNotify(String entryentityName) {
        this.getModel().deleteEntryData(entryentityName);
    }

    private String replaceHtmlLabel(String content) {
        int labelIndex = content.indexOf(HTML_NEWLINE_LABEL);
        if (labelIndex == -1) {
            return content;
        }
        if (labelIndex == 0) {
            return this.replaceHtmlLabel(content.substring(HTML_NEWLINE_LABEL.length()));
        }
        return StringUtils.substringBefore((String)content, (String)HTML_NEWLINE_LABEL) + "...";
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        int selectRowIndex = args.getRowIndex();
        String feildName = args.getFieldName();
        if (StringUtils.startsWith((CharSequence)feildName, (CharSequence)"msgtitle")) {
            this.openMessgeListByClickEntry(selectRowIndex, feildName.substring(feildName.length() - 1));
        }
    }
}

