/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sw.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.RadioEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.sw.business.model.SwCard;
import kd.scm.sw.business.model.SwCardEntry;
import kd.scm.sw.business.model.TodoData;
import kd.scm.sw.business.model.TodoEntryData;
import kd.scm.sw.business.service.impl.ToDoDataQueryServiceImpl;
import kd.scm.sw.formplugin.card.SwTodoCardMetaGenerator;

public class SwMyTodoListPlugin
extends GridCardPlugin
implements TabSelectListener {
    private static Log log = LogFactory.getLog(SwMyTodoListPlugin.class);
    private static final String CLOSE_PAGE = "close_page";
    private static final String CARDSKEYCACHE = "cardsKeyCache";
    private static final String LABELCACHEKEYS = "labelCacheKeys";
    private static final String FLEXCACHEKEYS = "flexCacheKeys";
    private static final String FIELDCACHEKEYS = "fieldCacheKeys";
    private static final String RADIOGROUPFIELDID = "cNfs9QSTMj";
    private static final int LABELSIZE = 3;
    private static final int TABSIZE = 6;
    private static final String TOTAL_NUMBER = "total_number";
    private static final String RADIOGROUPFIELD = "radiogroupfield";
    private static final String REFRESH = "refresh";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{REFRESH, "btn_more"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refresh(true);
    }

    private void hideAllTabPage() {
        for (int i = 0; i < 6; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap" + (i + 1)});
        }
    }

    private void initBackgroundImg() {
        Container flexpanelap5 = (Container)this.getControl("flexpanelap5");
        flexpanelap5.setBackgroundImg("/icons/pc/other/jdyxkqjb_ic_dbzl_20_20.png");
        Container flexpanelap2 = (Container)this.getControl("flexpanelap2");
        flexpanelap2.setBackgroundImg("/images/pc/cardbackground/jdyxkqjb_image_backbround_211_156.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(boolean isInit) {
        long start = TimeServiceHelper.getTimeStamp();
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"SwMyTodoListPlugin_0", (String)"scm-sw-formplugin", (Object[])new Object[0])));
            this.hideAllTabPage();
            Map<String, SwCard> cardConfigMap = this.loadSwCardConfigFromDB(isInit);
            this.createAllCardByConfig(cardConfigMap);
            Map<String, TodoData> todoDataMap = this.initTodoDatas(cardConfigMap);
            this.initBackgroundImg();
            Label totalNumberLabel = (Label)this.getControl(TOTAL_NUMBER);
            int totalNumber = this.getTotalNumber(todoDataMap);
            totalNumberLabel.setText(String.valueOf(totalNumber));
            for (Map.Entry<String, TodoData> entry : todoDataMap.entrySet()) {
                Label label = (Label)this.getControl(entry.getKey() + "_" + "number");
                label.setText(String.valueOf(entry.getValue().getTotalNumber()));
            }
            Object val = this.getModel().getValue(RADIOGROUPFIELD);
            String cardkey = null != val ? (String)val : this.getPageCache().get("default_cardkey");
            this.getModel().setValue(RADIOGROUPFIELD, (Object)cardkey);
            this.changeBlock2Selected(cardConfigMap.get(cardkey), todoDataMap.get(cardkey));
            this.getView().updateView();
        }
        catch (Exception e) {
            log.info(ExceptionUtil.getStackTrace((Throwable)e));
        }
        finally {
            long end = TimeServiceHelper.getTimeStamp();
            log.info("\u5237\u65b0\u5f85\u529e\u8017\u65f6(ms)\uff1a" + (end - start));
            this.getView().hideLoading();
        }
    }

    private int getTotalNumber(Map<String, TodoData> todoDataMap) {
        int res = 0;
        for (Map.Entry<String, TodoData> entry : todoDataMap.entrySet()) {
            res += entry.getValue().getTotalNumber();
        }
        return res;
    }

    private void createAllCardByConfig(Map<String, SwCard> cardConfig) {
        Container container = (Container)this.getControl("felx_card_container");
        if (!CollectionUtils.isEmpty(cardConfig)) {
            boolean isFirstCard = true;
            ArrayList<String> cardKeyList = new ArrayList<String>(16);
            ArrayList<String> fieldKeyList = new ArrayList<String>(16);
            ArrayList<String> flexCacheKeys = new ArrayList<String>(32);
            ArrayList<String> labelCacheKeys = new ArrayList<String>(32);
            if (null != this.getPageCache().get(CARDSKEYCACHE)) {
                container.deleteControls(this.getPageCache().get(CARDSKEYCACHE).split(","));
            }
            ArrayList<Map> attrControls = new ArrayList<Map>(cardConfig.size());
            for (Map.Entry<String, SwCard> entry : cardConfig.entrySet()) {
                cardKeyList.add("flex_" + entry.getKey());
                fieldKeyList.add(entry.getKey() + "_" + "select");
                SwTodoCardMetaGenerator generator = new SwTodoCardMetaGenerator(entry.getValue(), isFirstCard);
                attrControls.add(generator.createFlexCardByConfig().createControl());
                flexCacheKeys.addAll(generator.getFlexCacheKeys());
                labelCacheKeys.addAll(generator.getLabelCacheKeys());
                isFirstCard = false;
            }
            container.addControls(attrControls);
            this.getPageCache().put(CARDSKEYCACHE, String.join((CharSequence)",", cardKeyList));
            this.getPageCache().put(FLEXCACHEKEYS, String.join((CharSequence)",", flexCacheKeys));
            this.getPageCache().put(LABELCACHEKEYS, String.join((CharSequence)",", labelCacheKeys));
            this.getPageCache().put(FIELDCACHEKEYS, String.join((CharSequence)",", fieldKeyList));
            this.getView().updateView("felx_card_container");
        }
    }

    private Map<String, TodoData> initTodoDatas(Map<String, SwCard> cardConfig) {
        HashMap<String, TodoData> todoDataMap = new HashMap<String, TodoData>(cardConfig.size());
        ToDoDataQueryServiceImpl service = new ToDoDataQueryServiceImpl();
        HashMap<String, String> cache = new HashMap<String, String>(cardConfig.size());
        for (Map.Entry<String, SwCard> entry : cardConfig.entrySet()) {
            TodoData data = service.queryTodoData(entry.getValue());
            todoDataMap.put(entry.getKey(), data);
            cache.put(entry.getKey(), SerializationUtils.toJsonString((Object)data));
        }
        this.getPageCache().put(cache);
        return todoDataMap;
    }

    public void onGetControl(OnGetControlArgs e) {
        String fieldKeys;
        String labelKeys;
        String flexKeys = this.getView().getPageCache().get(FLEXCACHEKEYS);
        if (StringUtils.isNotBlank((CharSequence)flexKeys)) {
            for (String clickEventKey : flexKeys.split(",")) {
                if (!e.getKey().equals(clickEventKey)) continue;
                Container needClickContainer = new Container();
                needClickContainer.setView(this.getView());
                needClickContainer.setKey(e.getKey());
                needClickContainer.addClickListener((ClickListener)this);
                e.setControl((Control)needClickContainer);
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(labelKeys = this.getView().getPageCache().get(LABELCACHEKEYS)))) {
            for (String labelKey : labelKeys.split(",")) {
                if (!e.getKey().equals(labelKey)) continue;
                Label label = new Label();
                label.setView(this.getView());
                label.setKey(e.getKey());
                label.addClickListener((ClickListener)this);
                e.setControl((Control)label);
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(fieldKeys = this.getView().getPageCache().get(FIELDCACHEKEYS)))) {
            for (String fieldKey : fieldKeys.split(",")) {
                if (!e.getKey().equals(fieldKey)) continue;
                RadioEdit edit = new RadioEdit();
                edit.setFieldKey(fieldKey);
                edit.setView(this.getView());
                edit.setKey(fieldKey);
                edit.setFireEvtUp(true);
                edit.setGroup(RADIOGROUPFIELDID);
                edit.setItems(fieldKey.split("_")[0]);
                e.setControl((Control)edit);
                return;
            }
        }
    }

    private Map<String, SwCard> loadSwCardConfigFromDB(boolean isInit) {
        LinkedHashMap<String, SwCard> cardConfig = new LinkedHashMap<String, SwCard>(16);
        QFilter filter = QFilter.of((String)"enable = '1'", (Object[])new Object[0]);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"pbd_todoconfig", (String)"number,name,icon,icon_selected,cardseq,group,entryentity.tabstatus.number,entryentity.tabstatus.name,entryentity.entity.id,entryentity.entity.number,entryentity.classname", (QFilter[])new QFilter[]{filter}, (String)"cardseq,entryentity.seq ASC");
        HashMap<String, String> cache = new HashMap<String, String>(cardConfig.size());
        for (int i = 0; i < dyos.size(); ++i) {
            DynamicObject dyo = (DynamicObject)dyos.get(i);
            String number = dyo.getString("number");
            SwCard swCard = cardConfig.computeIfAbsent(number, c -> new SwCard());
            if (StringUtils.isBlank((CharSequence)swCard.getCardKey())) {
                swCard.setCardAppId(dyo.getString("group"));
                swCard.setCardIcon(dyo.getString("icon"));
                swCard.setCardSelectedIncon(dyo.getString("icon_selected"));
                swCard.setCardSeq(dyo.getInt("cardseq"));
                swCard.setCardKey(number);
                swCard.setCardName(dyo.getString("name"));
            }
            if (i == 0 && isInit) {
                swCard.setDefaultSelected(true);
                this.getPageCache().put("default_cardkey", number);
            }
            SwCardEntry entry = new SwCardEntry();
            entry.setEntityId(dyo.getString("entryentity.entity.id"));
            entry.setEntityNumber(dyo.getString("entryentity.entity.number"));
            entry.setServiceName(dyo.getString("entryentity.classname"));
            entry.setTabStatus(dyo.getString("entryentity.tabstatus.number"));
            entry.setTabStatusName(dyo.getString("entryentity.tabstatus.name"));
            swCard.addEntry(entry);
            cache.put("config_" + number, SerializationUtils.toJsonString((Object)swCard));
        }
        this.getPageCache().put(cache);
        return cardConfig;
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        super.refreshCard(allConfigMap);
    }

    public void click(EventObject e) {
        super.click(e);
        String clickKey = ((Control)e.getSource()).getKey();
        if (StringUtils.isNotBlank((CharSequence)clickKey) && (clickKey.startsWith("flex_") || clickKey.contains("_label") || clickKey.contains("_number"))) {
            String[] split = clickKey.split("_");
            String cardKey = "quo";
            for (String s : split) {
                if (null == this.getPageCache().get("config_" + s)) continue;
                cardKey = s;
                break;
            }
            this.getModel().setValue(RADIOGROUPFIELD, (Object)cardKey);
            this.getView().updateView();
        }
        if (StringUtils.equals((CharSequence)REFRESH, (CharSequence)clickKey)) {
            this.refresh(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)RADIOGROUPFIELD)) {
            ChangeData[] changedData = e.getChangeSet();
            Object oldValue = changedData[0].getOldValue();
            Object newValue = changedData[0].getNewValue();
            if (null != newValue && oldValue != newValue) {
                String cardKey = (String)newValue;
                TodoData todoData = this.getTodoDataFromCache(cardKey);
                SwCard cardConfig = this.getSwCardConfigFromCache(cardKey);
                this.changeBlock2Selected(cardConfig, todoData);
                if (null != oldValue) {
                    this.changeBlock2Normal(this.getSwCardConfigFromCache((String)oldValue));
                }
            }
        }
    }

    private TodoData getTodoDataFromCache(String cardKey) {
        return (TodoData)SerializationUtils.fromJsonString((String)this.getPageCache().get(cardKey), TodoData.class);
    }

    private SwCard getSwCardConfigFromCache(String cardKey) {
        return (SwCard)SerializationUtils.fromJsonString((String)this.getPageCache().get("config_" + cardKey), SwCard.class);
    }

    private void changeBlock2Selected(SwCard cardConfig, TodoData data) {
        String cardKey = cardConfig.getCardKey();
        Container flex = (Container)this.getControl("flex_" + cardKey);
        Container iconFlex = (Container)this.getControl(cardKey + "_" + "icon");
        flex.setBackgroundImg(cardConfig.getCardSelectedBg());
        iconFlex.setBackgroundImg(cardConfig.getCardSelectedIncon());
        this.setLabelStyle(cardKey + "_" + "number", "#FFF");
        for (int i = 0; i < 3; ++i) {
            this.setLabelStyle(cardKey + "_" + "label" + (i + 1), "#FFF");
        }
        this.createTabs(data);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        tab.selectTab("tabpageap1");
        tab.activeTab("tabpageap1");
    }

    private void changeBlock2Normal(SwCard cardConfig) {
        String cardKey = cardConfig.getCardKey();
        Container flex = (Container)this.getControl("flex_" + cardKey);
        Container iconFlex = (Container)this.getControl(cardKey + "_" + "icon");
        flex.setBackgroundImg(cardConfig.getCardDefaultBg());
        iconFlex.setBackgroundImg(cardConfig.getCardIcon());
        this.setLabelStyle(cardKey + "_" + "number", "#666");
        this.setLabelStyle(cardKey + "_" + "label1", "#000");
        this.setLabelStyle(cardKey + "_" + "label2", "#999");
        this.setLabelStyle(cardKey + "_" + "label3", "#999");
    }

    private void createTabs(TodoData data) {
        this.hideAllTabPage();
        if (CollectionUtils.isEmpty((Map)data.getStatus_entityIdMap())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5361\u7247\u914d\u7f6e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6216\u5237\u65b0\u91cd\u8bd5\u3002", (String)"SwMyTodoListPlugin_1", (String)"scm-sw-formplugin", (Object[])new Object[0]));
        }
        int index = 1;
        HashMap<String, String> cache = new HashMap<String, String>(data.getStatus_entityIdMap().size());
        for (Map.Entry entry : data.getStatus_entityIdMap().entrySet()) {
            String status = (String)entry.getKey();
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabpageap" + index});
            cache.put("tabpageap" + index, status);
            TabPage tabPage = (TabPage)this.getControl("tabpageap" + index);
            tabPage.setText(new LocaleString(status + "\uff08" + data.getStatusTotalNumber(status) + "\uff09"));
            ++index;
        }
        this.getPageCache().put(cache);
    }

    private void showEntryInContainer(List<TodoEntryData> datas, String tapPage) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("sw_todoentry");
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey(tapPage);
        fsp.getCustomParams().put("todoentry_cache", SerializationUtils.toJsonString(datas));
        fsp.setAppId("sw");
        fsp.setHasRight(true);
        this.getView().showForm(fsp);
    }

    private void setLabelStyle(String labelKey, String color) {
        HashMap<String, String> titleParam = new HashMap<String, String>(4);
        titleParam.put("fc", color);
        this.getView().updateControlMetadata(labelKey, titleParam);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.isNotBlank((CharSequence)e.getActionId()) && StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)CLOSE_PAGE)) {
            this.refresh(false);
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        String tabKey = arg0.getTabKey();
        String cardKey = this.getModel().getDataEntity().getString(RADIOGROUPFIELD);
        TodoData todoData = this.getTodoDataFromCache(cardKey);
        String status = this.getPageCache().get(tabKey);
        if (!CollectionUtils.isEmpty((Map)todoData.getEntryDataMap()) && !CollectionUtils.isEmpty((Collection)((Collection)todoData.getEntryDataMap().get(status)))) {
            ((List)todoData.getEntryDataMap().get(status)).clear();
        }
        Map entityPksMap = (Map)todoData.getStatus_entityIdMap().get(status);
        ToDoDataQueryServiceImpl service = new ToDoDataQueryServiceImpl();
        String selectFeilds = "id,org.name,creator,auditor,auditdate,billno";
        for (Map.Entry entry : entityPksMap.entrySet()) {
            selectFeilds = "id,org.name,creator,auditor,auditdate,billno";
            String entityNumber = (String)entry.getKey();
            if (entityNumber.startsWith("tnd")) {
                selectFeilds = StringUtils.equals((CharSequence)entityNumber, (CharSequence)"tnd_winnotice") || StringUtils.equals((CharSequence)entityNumber, (CharSequence)"tnd_inviteletter") ? "id,org.name,publisher as creator,publisher as auditor,senddate as auditdate,project.billno as billno" : (StringUtils.equals((CharSequence)entityNumber, (CharSequence)"tnd_quotebill") || StringUtils.equals((CharSequence)entityNumber, (CharSequence)"tnd_tenderbill") ? "id,org.name,creator,auditor,createtime as auditdate,project.billno as billno" : (StringUtils.equals((CharSequence)entityNumber, (CharSequence)"tnd_aptitude") ? "id,org.name,creator,auditor,createtime as auditdate,project.billno as billno" : "id,org.name,creator,auditor,auditdate,project.billno as billno"));
            }
            if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)"pur_iminventory")) {
                selectFeilds = "id,recorg.name as org.name,0 as creator,0 as auditor,updatetime as auditdate,material.number as billno";
            }
            todoData.addEntryData(status, service.queryTodoEntryDatasByPks((String)entry.getKey(), (Set)entry.getValue(), selectFeilds));
        }
        this.showEntryInContainer((List)todoData.getEntryDataMap().get(status), tabKey);
        this.getPageCache().put(cardKey, SerializationUtils.toJsonString((Object)todoData));
    }
}

