/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sw.formplugin;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;

public class SwOrderAnalysisPlugin
extends GridCardPlugin {
    private static Log log = LogFactory.getLog(SwOrderAnalysisPlugin.class);
    public static final String CUSTOMCHARTAP = "customchartap";
    public static final int MAX_MONTHSDURATION = 12;
    public static final int MIN_MONTHSDURATION = 6;
    public static final int DEFAULT_PART = 5;
    public static final String AMOUNTDATAS = "amountDatas";
    public static final String QTYDATAS = "qtyDatas";
    public static final String QUERYFROM = "queryfrom";
    public static final String XAXISDATA = "xAxisData";
    public static final String QUERYTO = "queryto";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"query"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultDateRange();
        this.refreshData((Date)this.getModel().getValue(QUERYFROM), (Date)this.getModel().getValue(QUERYTO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshData(Date fromDate, Date toDate) {
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"SwOrderAnalysisPlugin_3", (String)"scm-sw-formplugin", (Object[])new Object[0])));
            Control customChart = this.getView().getControl(CUSTOMCHARTAP);
            if (customChart instanceof CustomChart) {
                CustomChart chart = (CustomChart)customChart;
                Map<String, Object> xyAxisDataMap = this.getXYAxisDataMap(fromDate, toDate);
                chart.setShowTitle(false);
                String qtyString = ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf", (String)"SwOrderAnalysisPlugin_0", (String)"scm-sw-formplugin", (Object[])new Object[0]);
                String amtString = ResManager.loadKDString((String)"\u8ba2\u5355\u91d1\u989d", (String)"SwOrderAnalysisPlugin_1", (String)"scm-sw-formplugin", (Object[])new Object[0]);
                LineSeries lineSerial = chart.createLineSeries(qtyString);
                lineSerial.setType(ChartType.line);
                lineSerial.setYAxisIndex(1);
                BarSeries barSerial = chart.createBarSeries(amtString);
                barSerial.setType(ChartType.bar);
                Axis axis = chart.createXAxis("", AxisType.category);
                String[] cat = (String[])xyAxisDataMap.get(XAXISDATA);
                Number[] amtDatas = (Number[])xyAxisDataMap.get(AMOUNTDATAS);
                Number[] qtyDatas = (Number[])xyAxisDataMap.get(QTYDATAS);
                axis.setCategorys(cat);
                this.creatYAxis(chart, amtDatas, amtString);
                this.creatYAxis(chart, qtyDatas, qtyString);
                barSerial.setData(amtDatas);
                barSerial.setBarWidth("40px");
                lineSerial.setData(qtyDatas);
                HashMap<String, Boolean> param = new HashMap<String, Boolean>(4);
                param.put("containLabel", Boolean.TRUE);
                chart.addProperty("grid", param);
                chart.setShowTooltip(true);
                chart.bindData(null);
            }
        }
        catch (Exception e) {
            log.info(ExceptionUtil.getStackTrace((Throwable)e));
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void creatYAxis(CustomChart chart, Number[] datas, String name) {
        Number amtMax = Stream.of(datas).max(Comparator.comparingInt(Number::intValue)).get();
        if (amtMax.doubleValue() <= 0.0) {
            amtMax = 100;
        }
        double interval = Math.ceil(amtMax.doubleValue() / 5.0);
        Axis amtYAxis = chart.createYAxis(name, AxisType.value);
        amtYAxis.setInterval((Number)interval);
        amtYAxis.setMax((Number)(interval * 5.0));
        amtYAxis.setMin((Number)0);
    }

    public void click(EventObject e) {
        super.click(e);
        String clickKey = ((Control)e.getSource()).getKey();
        if (StringUtils.isNotBlank((CharSequence)clickKey) && StringUtils.equals((CharSequence)"query", (CharSequence)clickKey)) {
            Date fromDate = (Date)this.getModel().getValue(QUERYFROM);
            Date toDate = (Date)this.getModel().getValue(QUERYTO);
            if (Objects.isNull(fromDate) || Objects.isNull(toDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u67e5\u8be2\u8303\u56f4\u4e3a\u7a7a\u6216\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SwOrderAnalysisPlugin_4", (String)"scm-sw-formplugin", (Object[])new Object[0]));
                return;
            }
            int gapMonths = SwOrderAnalysisPlugin.monthsBetween(fromDate, toDate);
            if (gapMonths < 6 || gapMonths > 12) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u67e5\u8be2\u8303\u56f4\u8de8\u5ea6\u6700\u5927\u652f\u630112\u4e2a\u6708\uff0c\u6700\u5c0f6\u4e2a\u6708\uff0c\u8bf7\u8c03\u6574\u67e5\u8be2\u8303\u56f4\u3002", (String)"SwOrderAnalysisPlugin_2", (String)"scm-sw-formplugin", (Object[])new Object[0]));
                return;
            }
            this.refreshData(fromDate, toDate);
        }
    }

    private Map<String, Object> getXYAxisDataMap(Date fromDate, Date toDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        int months = SwOrderAnalysisPlugin.monthsBetween(fromDate, toDate);
        String[] cat = new String[months];
        Number[] amountDatas = new Number[months];
        Number[] qtyDatas = new Number[months];
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(12);
        for (int i = 0; i < months; ++i) {
            String s;
            cat[i] = s = DateUtils.formatDate((Date)DateUtil.addMonth((Date)fromDate, (int)i), (Object[])new Object[]{"yyyy-MM"});
            amountDatas[i] = 0;
            qtyDatas[i] = 0;
            indexMap.put(s, i);
        }
        resultMap.put(XAXISDATA, cat);
        List filterList = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"scp", (String)"IScpStagingListService", (String)"getOrderFilter", (Object[])new Object[0]);
        filterList.add(new QFilter("auditdate", ">=", (Object)fromDate));
        filterList.add(new QFilter("auditdate", "<", (Object)DateUtil.addMonth((Date)toDate, (int)1)));
        if (!CollectionUtils.isEmpty((Collection)filterList)) {
            QFilter[] qFilters = filterList.toArray(new QFilter[0]);
            try (AlgoContext algoContext = Algo.newContext();
                 DataSet originDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"scp_order", (String)"id,auditdate,sumtaxamount", (QFilter[])qFilters, (String)"auditdate");){
                DataSet orderDataSet = originDataSet.map(new MapFunction(){

                    public Object[] map(Row row) {
                        String yearAndMonth = "";
                        if (row.getDate("auditdate") != null) {
                            yearAndMonth = DateUtils.formatDate((Date)row.getDate("auditdate"), (Object[])new Object[]{"yyyy-MM"});
                        }
                        return new Object[]{yearAndMonth, row.get("id"), row.getBigDecimal("sumtaxamount")};
                    }

                    public RowMeta getResultRowMeta() {
                        RowMeta sourceRowMeta = new RowMeta(new String[]{"yearandmonth", "id", "sumtaxamount"}, new DataType[]{DataType.StringType, DateType.LongType, DateType.BigDecimalType});
                        return sourceRowMeta;
                    }
                }).groupBy(new String[]{"yearandmonth"}).count("id").sum("sumtaxamount", "num").finish();
                int i = 0;
                for (Row row : orderDataSet) {
                    if (i >= months) {
                        break;
                    }
                    Integer yearandmonth = (Integer)indexMap.get(row.getString("yearandmonth"));
                    if (yearandmonth != null && yearandmonth >= 0) {
                        amountDatas[yearandmonth.intValue()] = row.getBigDecimal("num");
                        qtyDatas[yearandmonth.intValue()] = row.getInteger("id");
                    }
                    ++i;
                }
            }
        }
        resultMap.put(AMOUNTDATAS, amountDatas);
        resultMap.put(QTYDATAS, qtyDatas);
        return resultMap;
    }

    private void setDefaultDateRange() {
        this.getModel().setValue(QUERYTO, (Object)DateUtil.formatStartDate((Date)TimeServiceHelper.now()));
        this.getModel().setValue(QUERYFROM, (Object)DateUtil.getPreviousSomeMonth((Date)TimeServiceHelper.now(), (int)11));
    }

    public static int monthsBetween(Date firstDate, Date secDate) {
        LocalDate localDate1 = firstDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = DateUtil.addMonth((Date)secDate, (int)1).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate2.isAfter(localDate1) ? (int)localDate1.until(localDate2, ChronoUnit.MONTHS) : (int)localDate2.until(localDate1, ChronoUnit.MONTHS);
    }
}

