/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sw.formplugin.card;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.scm.sw.business.model.SwCard;

public class SwTodoCardMetaGenerator {
    private SwCard cardConfig;
    private boolean isFirstCard;
    private List<String> flexCacheKeys;
    private List<String> labelCacheKeys;
    private List<String> feildCacheKeys;

    public SwTodoCardMetaGenerator(SwCard cardConfig, boolean isFirstCard) {
        this.cardConfig = cardConfig;
        this.isFirstCard = isFirstCard;
        this.flexCacheKeys = new ArrayList<String>(16);
        this.labelCacheKeys = new ArrayList<String>(16);
        this.feildCacheKeys = new ArrayList<String>(16);
    }

    public FlexPanelAp createFlexCardByConfig() {
        if (this.cardConfig == null) {
            throw new KDBizException("cardconfig is null,can not init card model");
        }
        FlexPanelAp res = new FlexPanelAp();
        String idKey = "flex_" + this.cardConfig.getCardKey();
        this.flexCacheKeys.add(idKey);
        res.setId(idKey);
        res.setKey(idKey);
        res.setBackgroundImg(this.cardConfig.isDefaultSelected() ? this.cardConfig.getCardSelectedBg() : this.cardConfig.getCardDefaultBg());
        res.setGrow(0);
        res.setOverflow("visible");
        res.setShrink(0);
        res.setJustifyContent("center");
        res.setAlignItems("center");
        res.setName(new LocaleString(this.cardConfig.getCardName()));
        res.setHeight(new LocaleString("150px"));
        res.setWidth(new LocaleString("308px"));
        res.setWrap(false);
        if (!this.isFirstCard) {
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("-22px");
            style.setMargin(margin);
            res.setStyle(style);
        }
        res.getItems().add(this.createClickFlexAp(res));
        return res;
    }

    public List<String> getFlexCacheKeys() {
        return this.flexCacheKeys;
    }

    public List<String> getLabelCacheKeys() {
        return this.labelCacheKeys;
    }

    public List<String> getFeildCacheKeys() {
        return this.feildCacheKeys;
    }

    private FlexPanelAp createClickFlexAp(FlexPanelAp parentFlex) {
        FlexPanelAp res = new FlexPanelAp();
        String idKey = parentFlex.getId() + "_" + "click";
        this.flexCacheKeys.add(idKey);
        res.setWrap(false);
        res.setId(idKey);
        res.setKey(idKey);
        res.setParentId(parentFlex.getId());
        res.setClickable(true);
        res.setGrow(0);
        res.setHeight(new LocaleString("105px"));
        res.setWidth(new LocaleString("260px"));
        res.setJustifyContent("flex-start");
        res.setAlignItems("stretch");
        res.setDirection("column");
        FlexPanelAp topFlexAp = this.createClickTopFlexAp(res);
        FlexPanelAp bottomFlexAp = this.createClickBottomFlexAp(res);
        FieldAp selectAp = this.createSelectAp(res);
        res.getItems().add(topFlexAp);
        res.getItems().add(bottomFlexAp);
        res.getItems().add(selectAp);
        return res;
    }

    private FlexPanelAp createClickTopFlexAp(FlexPanelAp parentFlex) {
        String idKey = parentFlex.getId() + "_" + "top";
        FlexPanelAp res = new FlexPanelAp();
        res.setId(idKey);
        res.setKey(idKey);
        res.setOverflow("visible");
        res.setAlignItems("center");
        res.setJustifyContent("flex-start");
        res.setHeight(new LocaleString("52px"));
        res.setWrap(false);
        res.setParentId(parentFlex.getId());
        Style style = new Style();
        Padding padding = new Padding();
        padding.setTop("14px");
        padding.setLeft("24px");
        padding.setRight("24px");
        style.setPadding(padding);
        res.setStyle(style);
        FlexPanelAp iconFlex = this.createIconFlexAp(parentFlex);
        FlexPanelAp titleFlex = this.createTitleFlexAp(parentFlex);
        res.getItems().add(iconFlex);
        res.getItems().add(titleFlex);
        return res;
    }

    private FlexPanelAp createClickBottomFlexAp(FlexPanelAp parentFlex) {
        String idKey = parentFlex.getId() + "_" + "bottom";
        FlexPanelAp res = new FlexPanelAp();
        res.setId(idKey);
        res.setKey(idKey);
        res.setAlignItems("center");
        res.setIndex(1);
        res.setJustifyContent("space-between");
        res.setWrap(false);
        res.setParentId(parentFlex.getId());
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("24px");
        padding.setRight("24px");
        style.setPadding(padding);
        res.setStyle(style);
        res.getItems().add(this.createBottomLeftFlexAp(res));
        res.getItems().add(this.createBottomRightFlexAp(res));
        return res;
    }

    private FieldAp createSelectAp(FlexPanelAp parentFlex) {
        FieldAp selectAp = new FieldAp();
        selectAp.setFireUpdEvt(true);
        selectAp.setInvisible(true);
        String idKey = this.cardConfig.getCardKey() + "_" + "select";
        this.feildCacheKeys.add(idKey);
        selectAp.setKey(idKey);
        selectAp.setId(idKey);
        selectAp.setFieldId(idKey);
        selectAp.setIndex(2);
        selectAp.setParentId(parentFlex.getId());
        return selectAp;
    }

    private FlexPanelAp createIconFlexAp(FlexPanelAp parentFlex) {
        FlexPanelAp iconFlex = new FlexPanelAp();
        String idKey = this.cardConfig.getCardKey() + "_" + "icon";
        this.flexCacheKeys.add(idKey);
        iconFlex.setId(idKey);
        iconFlex.setKey(idKey);
        iconFlex.setBackgroundImg(this.cardConfig.isDefaultSelected() ? this.cardConfig.getCardSelectedIncon() : this.cardConfig.getCardIcon());
        iconFlex.setGrow(0);
        iconFlex.setShrink(0);
        iconFlex.setHeight(new LocaleString("34px"));
        iconFlex.setWidth(new LocaleString("34px"));
        iconFlex.setParentId(parentFlex.getId());
        return iconFlex;
    }

    private FlexPanelAp createTitleFlexAp(FlexPanelAp parentFlex) {
        FlexPanelAp iconFlex = new FlexPanelAp();
        String idKey = this.cardConfig.getCardKey() + "_" + "title" + "_" + "flex";
        iconFlex.setId(idKey);
        iconFlex.setKey(idKey);
        iconFlex.setIndex(1);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("12px");
        style.setPadding(padding);
        iconFlex.setStyle(style);
        iconFlex.setParentId(parentFlex.getId());
        iconFlex.getItems().add(this.createTitleLabel(iconFlex));
        return iconFlex;
    }

    private LabelAp createTitleLabel(FlexPanelAp parentFlex) {
        LabelAp titleAp = new LabelAp();
        String idKey = this.cardConfig.getCardKey() + "_" + "label1";
        this.labelCacheKeys.add(idKey);
        titleAp.setId(idKey);
        titleAp.setKey(idKey);
        titleAp.setClickable(true);
        titleAp.setLabelStyle("1");
        titleAp.setFontWeight("bold");
        if (this.cardConfig.isDefaultSelected()) {
            titleAp.setForeColor("#FFF");
        }
        titleAp.setName(new LocaleString(this.cardConfig.getCardName()));
        titleAp.setFontSize(18);
        titleAp.setParentId(parentFlex.getId());
        return titleAp;
    }

    private FlexPanelAp createBottomLeftFlexAp(FlexPanelAp parentFlex) {
        String idKey = "flex_" + this.cardConfig.getCardKey() + "_" + "bottom" + "_" + "left";
        FlexPanelAp res = new FlexPanelAp();
        res.setId(idKey);
        res.setKey(idKey);
        res.setHeight(new LocaleString("100%"));
        res.setAlignItems("flex-end");
        res.setIndex(3);
        res.setJustifyContent("flex-start");
        res.setWrap(false);
        res.setParentId(parentFlex.getId());
        res.getItems().add(this.createLeftLabel(res));
        return res;
    }

    private FlexPanelAp createBottomRightFlexAp(FlexPanelAp parentFlex) {
        String idKey = "flex_" + this.cardConfig.getCardKey() + "_" + "bottom" + "_" + "right";
        FlexPanelAp res = new FlexPanelAp();
        res.setId(idKey);
        res.setKey(idKey);
        res.setOverflow("visible");
        res.setHeight(new LocaleString("100%"));
        res.setAlignItems("flex-end");
        res.setIndex(4);
        res.setJustifyContent("flex-end");
        res.setWrap(false);
        res.setParentId(parentFlex.getId());
        res.getItems().add(this.createNumberLabel(res));
        res.getItems().add(this.createRightLabel(res));
        return res;
    }

    private LabelAp createLeftLabel(FlexPanelAp parentFlex) {
        LabelAp labelAp = new LabelAp();
        String idKey = this.cardConfig.getCardKey() + "_" + "label2";
        this.labelCacheKeys.add(idKey);
        labelAp.setId(idKey);
        labelAp.setKey(idKey);
        labelAp.setClickable(true);
        labelAp.setLabelStyle("1");
        if (this.cardConfig.isDefaultSelected()) {
            labelAp.setForeColor("#FFF");
        } else {
            labelAp.setForeColor("#999");
        }
        labelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5f85\u529e\u6570", (String)"SwTodoCardMetaGenerator_0", (String)"scm-sw-formplugin", (Object[])new Object[0])));
        labelAp.setParentId(parentFlex.getId());
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("16px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        return labelAp;
    }

    private LabelAp createNumberLabel(FlexPanelAp parentFlex) {
        LabelAp labelAp = new LabelAp();
        String idKey = this.cardConfig.getCardKey() + "_" + "number";
        this.labelCacheKeys.add(idKey);
        labelAp.setId(idKey);
        labelAp.setKey(idKey);
        labelAp.setClickable(true);
        labelAp.setLabelStyle("1");
        if (this.cardConfig.isDefaultSelected()) {
            labelAp.setForeColor("#FFF");
        } else {
            labelAp.setForeColor("#666");
        }
        labelAp.setParentId(parentFlex.getId());
        labelAp.setFontSize(32);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("10px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        return labelAp;
    }

    private LabelAp createRightLabel(FlexPanelAp parentFlex) {
        LabelAp labelAp = new LabelAp();
        String idKey = this.cardConfig.getCardKey() + "_" + "label3";
        this.labelCacheKeys.add(idKey);
        labelAp.setId(idKey);
        labelAp.setKey(idKey);
        labelAp.setClickable(true);
        labelAp.setIndex(1);
        labelAp.setLabelStyle("1");
        if (this.cardConfig.isDefaultSelected()) {
            labelAp.setForeColor("#FFF");
        } else {
            labelAp.setForeColor("#999");
        }
        labelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u9879", (String)"SwTodoCardMetaGenerator_1", (String)"scm-sw-formplugin", (Object[])new Object[0])));
        labelAp.setParentId(parentFlex.getId());
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("4px");
        margin.setBottom("16px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        return labelAp;
    }
}

