/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.business.basedata.serviceImpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.business.basedata.ITenInvitationService;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.common.util.BackBidWayUtil;
import kd.scm.ten.common.util.CommonUtil;

public class TenInvitationServiceImpl
implements ITenInvitationService {
    private static final String CONTACTS = "contacts";
    private static final String PHONE = "phone";
    private static final String ADDRESS = "address";
    private static final String FAX = "fax";
    private static final String EMAIL = "email";
    private static final String NOTE = "note";
    private static final String INSTRUCTION = "instruction";
    private static final String BIDPROJECT = "bidproject";
    private static final String SUPPLIERENTRY = "supplierentry";
    private static final String LABEL_INVITATIONSTATUS = "invitationstatus";

    @Override
    public void acceptInvitation(DynamicObject data, List<String> sectionList, DynamicObject currentSupplier, HashMap<Long, DynamicObject> projectSectionMap) {
        Long supplierId = (Long)currentSupplier.get("id");
        Lang lang = RequestContext.get().getLang();
        BizLog.log((String)("\u6295\u6807\u3010acceptInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u4f9b\u5e94\u5546id: " + supplierId + "  \u8bed\u8a00\u73af\u5883: " + lang));
        this.updateSupplierInvitation(supplierId, data, sectionList, projectSectionMap);
        this.updateBidProjectInvitation(supplierId, data, sectionList, projectSectionMap);
        String uid = RequestContext.get().getUserId();
        QFilter[] supplierEntryFilter = new QFilter[]{new QFilter("supplierentry.id", "=", (Object)Long.parseLong(data.get(SUPPLIERENTRY).toString()))};
        DynamicObject bidInvitationDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bid_invitation", (String)"id,supplierentry.invitationuser,supplierentry.invitationstatus,publishdate,name,supplierentry.confirmman,supplierentry.confirmdate", (QFilter[])supplierEntryFilter);
        if (bidInvitationDynamicObject == null) {
            return;
        }
        DynamicObjectCollection supplierEntryCollection = (DynamicObjectCollection)bidInvitationDynamicObject.get(SUPPLIERENTRY);
        for (int i = 0; i < supplierEntryCollection.size(); ++i) {
            DynamicObject item = (DynamicObject)supplierEntryCollection.get(i);
            if (!data.get(SUPPLIERENTRY).toString().equals(item.get("id").toString())) continue;
            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                item.set(LABEL_INVITATIONSTATUS, (Object)"INVIATIONACCEPTED");
            } else {
                item.set(LABEL_INVITATIONSTATUS, (Object)"ACCEPTED");
            }
            item.set("invitationuser", (Object)uid);
            item.set("confirmman", (Object)RequestContext.get().getUserId());
            item.set("confirmdate", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidInvitationDynamicObject});
        BizLog.log((String)"\u6295\u6807\u3010acceptInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u4fdd\u5b58\u9080\u8bf7\u51fd\u6210\u529f");
        Object bidProjectID = data.get(BIDPROJECT);
        DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)bidProjectID, (String)"bid_project", (String)"org, backbidway, doctype, bidsection, bidsection.sectionname, enablemultisection, purmodel, currency");
        QFilter[] filter = new QFilter[]{new QFilter(BIDPROJECT, "=", (Object)Long.parseLong(bidProjectID.toString())), new QFilter("supplier", "=", currentSupplier.getPkValue())};
        DynamicObject myTender1 = BusinessDataServiceHelper.loadSingle((String)TenFormTypeConstants.getFormConstant((String)"mytender", this.getClass()), (String)"id,entry.projectSection,entry.sectionname,entry.sectionstatus", (QFilter[])filter);
        MainEntityType mytenderType = EntityMetadataCache.getDataEntityType((String)"ten_mytender");
        if (myTender1 == null) {
            BizLog.log((String)("\u6295\u6807\u3010acceptInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u6295\u6807\u8be6\u60c5\uff1a" + myTender1));
            DynamicObject myTender = new DynamicObject((DynamicObjectType)mytenderType);
            myTender.set("name", (Object)bidInvitationDynamicObject.getString("name"));
            myTender.set("billstatus", (Object)"C");
            myTender.set("org", (Object)bid_project.getDynamicObject("org"));
            myTender.set(BIDPROJECT, (Object)bid_project);
            myTender.set("ispublicbid", (Object)Boolean.FALSE);
            myTender.set("tenderstatus", (Object)MyTenderStatus.ACCEPT_INVITED);
            myTender.set("publishdate", (Object)bidInvitationDynamicObject.getDate("publishdate"));
            myTender.set("invitation", (Object)bidInvitationDynamicObject);
            myTender.set("tenderer", (Object)RequestContext.get().getUserId());
            myTender.set("supplier", (Object)currentSupplier);
            myTender.set("createtime", (Object)new Date());
            myTender.set("currency", bid_project.get("currency"));
            myTender.set("entitytypeid", (Object)TenFormTypeConstants.getFormConstant((String)"mytender", this.getClass()));
            String backBidWay = bid_project.getString("backbidway");
            String docType = bid_project.getString("doctype");
            String backType = BackBidWayUtil.getBackBidType((String)backBidWay, (String)docType);
            myTender.set("backbidway", (Object)backBidWay);
            myTender.set("backbidtype", (Object)backType);
            myTender.set("rounds", (Object)1);
            myTender.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21", (String)"TenInvitationServiceImpl_0", (String)"scm-ten-business", (Object[])new Object[0]), CommonUtil.toChinese((String)"1")));
            EntityType myTenderEntryEntityType = (EntityType)mytenderType.getAllEntities().get("entry");
            DynamicObjectCollection myTenderEntryColl = new DynamicObjectCollection((DynamicObjectType)myTenderEntryEntityType, (Object)myTender);
            for (int i = 0; i < sectionList.size(); ++i) {
                DynamicObject myTenderEntry = new DynamicObject((DynamicObjectType)myTenderEntryEntityType);
                DynamicObject projectSection = projectSectionMap.get(Long.parseLong(sectionList.get(i)));
                myTenderEntry.set("projectSection", (Object)projectSection);
                myTenderEntry.set("seq", (Object)i);
                myTenderEntry.set("sectionname", projectSection.get("sectionname"));
                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.APPLIED);
                myTenderEntryColl.add((Object)myTenderEntry);
            }
            Boolean enablemultisection = bid_project.getBoolean("enablemultisection");
            String purmodel = bid_project.getString("purmodel");
            if (!enablemultisection.booleanValue() || "02".equals(purmodel)) {
                DynamicObject myTenderEntry = new DynamicObject((DynamicObjectType)myTenderEntryEntityType);
                DynamicObject projectSection = (DynamicObject)bid_project.getDynamicObjectCollection("bidsection").get(0);
                myTenderEntry.set("projectSection", (Object)projectSection);
                myTenderEntry.set("seq", (Object)0);
                myTenderEntry.set("sectionname", projectSection.get("sectionname"));
                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.APPLIED);
                myTenderEntryColl.add((Object)myTenderEntry);
            }
            myTender.set("entry", (Object)myTenderEntryColl);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{myTender});
        } else {
            DynamicObject projectSection;
            EntityType myTenderEntryEntityType = (EntityType)mytenderType.getAllEntities().get("entry");
            DynamicObject myTender = BusinessDataServiceHelper.loadSingle((Object)myTender1.getPkValue(), (String)"ten_mytender");
            BizLog.log((String)("\u6295\u6807\u3010acceptInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u6295\u6807\u8be6\u60c5\uff1a" + myTender.getPkValue()));
            myTender.set("tenderer", (Object)RequestContext.get().getUserId());
            DynamicObjectCollection entryColl = myTender.getDynamicObjectCollection("entry");
            HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
            int entrySize = entryColl.size();
            if (!CollectionUtils.isEmpty((Collection)entryColl)) {
                for (DynamicObject entry : entryColl) {
                    projectSection = entry.getDynamicObject("projectsection");
                    if (projectSection == null) continue;
                    entryMap.put(projectSection.getString("sectionname"), entry);
                }
            }
            DynamicObject myTenderEntry = null;
            for (int i = 0; i < sectionList.size(); ++i) {
                DynamicObject oldEntry;
                projectSection = projectSectionMap.get(Long.parseLong(sectionList.get(i)));
                String sectionName = projectSection.getString("sectionname");
                myTenderEntry = !CollectionUtils.isEmpty(entryMap) ? ((oldEntry = (DynamicObject)entryMap.get(sectionName)) != null ? oldEntry : entryColl.addNew()) : entryColl.addNew();
                myTenderEntry.set("projectSection", (Object)projectSection);
                myTenderEntry.set("seq", (Object)entrySize++);
                myTenderEntry.set("sectionname", projectSection.get("sectionname"));
                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.APPLIED);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{myTender});
            BizLog.log((String)"\u6295\u6807\u3010acceptInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u66f4\u65b0\u6295\u6807\u8be6\u60c5\u6210\u529f\u3002");
        }
    }

    protected void updateBidProjectByReject(Object bidProjectId, String supplierId, boolean isRebm) {
        String projectEntityName = isRebm ? "rebm_project" : "bid_project";
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)projectEntityName);
        DynamicObjectCollection sectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        for (DynamicObject sectionEntry : sectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection(SUPPLIERENTRY);
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (null == supplier || !supplier.getPkValue().toString().equals(supplierId)) continue;
                supplierEntry.set(LABEL_INVITATIONSTATUS, (Object)"REJECTED");
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
    }

    @Override
    public boolean rejectInvitation(DynamicObject invitation, String supplierId) {
        Object bidProjectId = invitation.get(BIDPROJECT);
        QFilter[] bidProjectFilter = new QFilter[]{new QFilter(BIDPROJECT, "=", bidProjectId)};
        DynamicObject bidProjectLoadSingle = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"entitytypeid");
        String loadSingleEntityName = "";
        boolean isRebm = !"bid_project".equals(bidProjectLoadSingle.getString("entitytypeid"));
        loadSingleEntityName = !isRebm ? "bid_supplierinvitation" : "rebm_supplierinvitation";
        DynamicObject[] bidSupplierInvitations = BusinessDataServiceHelper.load((String)loadSingleEntityName, (String)"bidsection,supplierentry,supplierentry.invitationstatus,supplierentry.suppliercontact,supplierentry.isrecommend,supplierentry.supplier,supplierentry.contactphone,supplierentry.email,supplierentry.address,supplierentry.fax,supplierentry.invitation", (QFilter[])bidProjectFilter);
        Lang lang = RequestContext.get().getLang();
        for (DynamicObject bidSupplierInvitation : bidSupplierInvitations) {
            DynamicObjectCollection bidSectionColl = bidSupplierInvitation.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection(SUPPLIERENTRY);
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    DynamicObject supplier = (DynamicObject)supplierEntry.get("supplier");
                    DynamicObject supplierEntryInvitation = (DynamicObject)supplierEntry.get("invitation");
                    if (supplierEntryInvitation == null || !supplierId.equals(supplier.getString("id")) || !invitation.getString("id").equals(supplierEntryInvitation.getString("id"))) continue;
                    if (!"UNCONFIRM".equals(supplierEntry.get(LABEL_INVITATIONSTATUS).toString())) {
                        return false;
                    }
                    supplierEntry.set(LABEL_INVITATIONSTATUS, (Object)"REJECTED");
                    supplierEntry.set("isrecommend", (Object)Boolean.FALSE);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidSupplierInvitation});
        }
        QFilter[] supplierFilter = new QFilter[]{new QFilter("supplierentry.id", "=", invitation.get("supplierentry.id"))};
        String invitationEntityName = "";
        invitationEntityName = !isRebm ? "bid_invitation" : "rebm_invitation";
        DynamicObject bidInvitation = BusinessDataServiceHelper.loadSingle((String)invitationEntityName, (String)"id,supplierentry.invitationstatus,confirmman,confirmdate", (QFilter[])supplierFilter);
        if (bidInvitation != null) {
            DynamicObjectCollection supplierEntryColl = (DynamicObjectCollection)bidInvitation.get(SUPPLIERENTRY);
            for (int i = 0; i < supplierEntryColl.size(); ++i) {
                DynamicObject item = (DynamicObject)supplierEntryColl.get(i);
                if (!invitation.get("supplierentry.id").equals(item.get("id"))) continue;
                if (!"UNCONFIRM".equals(item.get(LABEL_INVITATIONSTATUS).toString())) {
                    return false;
                }
                if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                    item.set(LABEL_INVITATIONSTATUS, (Object)"INVIATIONREJECTED");
                } else {
                    item.set(LABEL_INVITATIONSTATUS, (Object)"REJECTED");
                }
                item.set("confirmman", (Object)RequestContext.get().getUserId());
                item.set("confirmdate", (Object)new Date());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidInvitation});
        this.updateBidProjectByReject(bidProjectId, supplierId, isRebm);
        return true;
    }

    protected void updateSupplierInvitation(Long supplierId, DynamicObject data, List<String> sectionList, Map<Long, DynamicObject> projectSectionMap) {
        Object contacts = data.get(CONTACTS);
        Object invitationId = data.get("invitationid");
        Object phone = data.get(PHONE);
        Object address = data.get(ADDRESS);
        Object fax = data.get(FAX);
        Object email = data.get(EMAIL);
        Object note = data.get(NOTE);
        Object instruction = data.get(INSTRUCTION);
        String proejctId = data.get(BIDPROJECT).toString();
        BizLog.log((String)("\u6295\u6807\u3010updateSupplierInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u4f9b\u5e94\u5546id: " + supplierId));
        QFilter[] bidProjectFilter = new QFilter[]{new QFilter(BIDPROJECT, "=", (Object)Long.parseLong(proejctId)), new QFilter("billstatus", "!=", (Object)"XX")};
        DynamicObject[] bidSupplierInvitationObject = BusinessDataServiceHelper.load((String)"bid_supplierinvitation", (String)"entitytypeid,bidsection,supplierentry,supplierentry.invitationstatus,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.email,supplierentry.address,supplierentry.fax,supplierentry.supplier,supplierentry.invitation,supplierentry.invitationuser,supplierentry.instruction,supplierentry.note,supplierentry.inviteattachfile,supplierentry.isrecommend,bidsection.sectionname", (QFilter[])bidProjectFilter);
        ArrayList<String> sectionNameList = new ArrayList<String>();
        if (null != sectionList && sectionList.size() > 0) {
            for (String sectionId : sectionList) {
                DynamicObject projectSection = projectSectionMap.get(Long.valueOf(sectionId));
                if (null == projectSection) continue;
                sectionNameList.add(projectSection.getString("sectionname"));
            }
        }
        if (bidSupplierInvitationObject != null && bidSupplierInvitationObject.length > 0) {
            BizLog.log((String)("\u6295\u6807\u3010updateSupplierInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u5165\u56f4\u5355id: " + bidSupplierInvitationObject));
            DynamicObject registerInviteFile = BusinessDataServiceHelper.loadSingle((String)"ten_register_invite_file", (String)"id", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"invitation"), new QFilter("supplierId", "=", (Object)supplierId), new QFilter("bidprojectid", "=", (Object)Long.parseLong(proejctId)), new QFilter("invitationid", "=", (Object)Long.parseLong(invitationId.toString()))});
            List attachmentList = new ArrayList();
            if (registerInviteFile != null) {
                attachmentList = AttachmentServiceHelper.getAttachments((String)"ten_register_invite_file", (Object)registerInviteFile.getPkValue(), (String)"attachmentpanelap");
            }
            for (DynamicObject bidSupplierInvitation : bidSupplierInvitationObject) {
                DynamicObjectCollection bidSectionCollection = bidSupplierInvitation.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < bidSectionCollection.size(); ++i) {
                    DynamicObject bidSectionDynamicObject = (DynamicObject)bidSectionCollection.get(i);
                    DynamicObjectCollection supplierEntryCollection = bidSectionDynamicObject.getDynamicObjectCollection(SUPPLIERENTRY);
                    for (int k = 0; k < supplierEntryCollection.size(); ++k) {
                        DynamicObject supplierEntryDynamicObject = (DynamicObject)supplierEntryCollection.get(k);
                        DynamicObject supplierItem = (DynamicObject)supplierEntryDynamicObject.get("supplier");
                        DynamicObject invitation = (DynamicObject)supplierEntryDynamicObject.get("invitation");
                        if (invitation == null || !supplierId.toString().equals(supplierItem.getString("id")) || !invitationId.toString().equals(invitation.getString("id"))) continue;
                        if (sectionNameList.size() > 0 && !sectionNameList.contains(bidSectionDynamicObject.getString("sectionname"))) {
                            BizLog.log((String)("\u6295\u6807\u3010updateSupplierInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u62d2\u7edd\u6807\u6bb5\u540d\u79f0: " + bidSectionDynamicObject.getString("sectionname")));
                            supplierEntryDynamicObject.set(LABEL_INVITATIONSTATUS, (Object)"REJECTED");
                            supplierEntryDynamicObject.set("isrecommend", (Object)Boolean.FALSE);
                            continue;
                        }
                        BizLog.log((String)("\u6295\u6807\u3010updateSupplierInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u63a5\u53d7\u6807\u6bb5\u540d\u79f0: " + bidSectionDynamicObject.getString("sectionname")));
                        supplierEntryDynamicObject.set(LABEL_INVITATIONSTATUS, (Object)"ACCEPTED");
                        supplierEntryDynamicObject.set("isrecommend", (Object)Boolean.TRUE);
                        supplierEntryDynamicObject.set("suppliercontact", contacts);
                        supplierEntryDynamicObject.set("contactphone", phone);
                        supplierEntryDynamicObject.set(EMAIL, email);
                        supplierEntryDynamicObject.set(ADDRESS, address);
                        supplierEntryDynamicObject.set(FAX, fax);
                        supplierEntryDynamicObject.set("invitationuser", (Object)RequestContext.get().getUserId());
                        supplierEntryDynamicObject.set(NOTE, note);
                        supplierEntryDynamicObject.set(INSTRUCTION, instruction);
                        List attachments = AttachmentUtil.copyToEntryAttachment(attachmentList);
                        DynamicObjectCollection inviteAttachFiles = supplierEntryDynamicObject.getDynamicObjectCollection("inviteattachfile");
                        inviteAttachFiles.clear();
                        attachments.stream().forEach(item -> {
                            DynamicObject inviteAttach = inviteAttachFiles.addNew();
                            inviteAttach.set("fbasedataid", item);
                        });
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidSupplierInvitation});
                BizLog.log((String)"\u6295\u6807\u3010updateSupplierInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u4fdd\u5b58\u5165\u56f4\u5355\u6210\u529f\u3002");
            }
        }
    }

    protected void updateBidProjectInvitation(Long supplierId, DynamicObject data, List<String> sectionList, Map<Long, DynamicObject> projectSectionMap) {
        Object contacts = data.get(CONTACTS);
        Object phone = data.get(PHONE);
        Object address = data.get(ADDRESS);
        Object fax = data.get(FAX);
        Object email = data.get(EMAIL);
        ArrayList<String> sectionNameList = new ArrayList<String>();
        if (null != sectionList && sectionList.size() > 0) {
            for (String sectionId : sectionList) {
                DynamicObject projectSection = projectSectionMap.get(Long.valueOf(sectionId));
                if (null == projectSection) continue;
                sectionNameList.add(projectSection.getString("sectionname"));
            }
        }
        BizLog.log((String)("\u6295\u6807\u3010updateBidProjectInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u4f9b\u5e94\u5546id: " + supplierId));
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)data.get(BIDPROJECT), (String)"bid_project");
        DynamicObjectCollection sectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        for (DynamicObject sectionEntry : sectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection(SUPPLIERENTRY);
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (null == supplier || !supplierId.toString().equals(supplier.getPkValue().toString())) continue;
                if (sectionNameList.size() > 0 && !sectionNameList.contains(sectionEntry.getString("rollsectionname"))) {
                    BizLog.log((String)("\u6295\u6807\u3010updateBidProjectInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u62d2\u7edd\u6807\u6bb5: " + sectionEntry.getString("rollsectionname")));
                    supplierEntry.set(LABEL_INVITATIONSTATUS, (Object)"REJECTED");
                    continue;
                }
                BizLog.log((String)("\u6295\u6807\u3010updateBidProjectInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u62d2\u7edd\u6807\u6bb5: " + sectionEntry.getString("rollsectionname")));
                supplierEntry.set(LABEL_INVITATIONSTATUS, (Object)"ACCEPTED");
                supplierEntry.set("suppliercontact", contacts);
                supplierEntry.set("contactphone", phone);
                supplierEntry.set(EMAIL, email);
                supplierEntry.set(ADDRESS, address);
                supplierEntry.set(FAX, fax);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
        BizLog.log((String)"\u6295\u6807\u3010updateBidProjectInvitation\u3011\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u4fdd\u5b58\u7acb\u9879\u6210\u529f\u3002");
    }
}

