/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.opplugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidBustalkService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.formplugin.bill.util.BidBustalkUtil;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;

public class OnlieBustalkOp
extends AbstractOperationServicePlugIn {
    private BidBustalkUtil bidBustalkUtil = new BidBustalkUtil();
    private IBidBustalkService bidBustalkService = new BidBustalkServiceImpl();
    private IBidDecisionService bidDecisionService = new BidDecisionServiceImpl();
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    private static final String TEXT_TENDERPRICE = "texttenderprice";
    private static final String TEXT_TEXTNOTAXTENDERPRICE = "textnotaxtenderprice";
    private static final String TEXT_TAX = "texttax";
    private static final String TEXT_PRICEVAT = "textpricevat";
    private static final String TEXT_PROJECTMANAGE = "textprojectmanage";
    private static final String TEXT_WORKDAY = "textworkday";
    private static final String TEXT_RATE = "textrate";
    private static final String TEXT_TENDERSTATE = "texttenderstate";
    private static final String[] ATTACH_FEILD_ID = new String[]{"attatech", "attacommerce", "attaother"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("entry");
        keys.add("entry.sectionid");
        keys.add("entry.tenderprice");
        keys.add("entry.notaxtenderprice");
        keys.add("entry.pricevat");
        keys.add("entry.tax");
        keys.add("entry.rate");
        keys.add("entry.tenderstate");
        keys.add("supplier");
        keys.add("supplierdetail");
        if (this.getBidAppId().equals("rebm")) {
            keys.add("supplierdetail.resourceitem");
        }
        keys.add("supplierdetail.bd_taxrate");
        keys.add("supplierdetail.purentrycontent");
        keys.add("supplierdetail.materialid");
        keys.add("supplierdetail.inclutaxprice");
        keys.add("supplierdetail.inclutaxamount");
        keys.add("supplierdetail.taxrate");
        keys.add("supplierdetail.taxamount");
        keys.add("supplierdetail.excepttaxamount");
        keys.add("supplierdetail.costrate");
        keys.add("negotiateinvite");
        keys.add("offerstoptime");
        keys.add("bidproject");
        keys.add("supplier");
        keys.add("currency");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        DynamicObjectCollection col = e.getDataEntities()[0].getDynamicObjectCollection("entry");
        DynamicObject data = datas[0];
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
            data.set("billstatus", (Object)"A");
            this.saveOnlieBustalkData(data);
        }
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            data.set("billstatus", (Object)"B");
            data.set("submittime", (Object)new Date());
            data.set("submituser", (Object)RequestContext.get().getUserId());
            this.saveOnlieBustalkData(data);
        }
        if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
            this.updateBustalkData(data, key);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            this.updateBustalkData(dataEntity, key);
            this.updateDecisionDataSubmit(dataEntity);
            this.sendMessage(dataEntity, key, "submitonliebustalk", "ten_onlie_bustalk");
            this.saveDecipurdetailshow(dataEntity);
        }
        if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
            this.updateDecisionDataUnSubmit(dataEntity);
            this.deleteDecipurdetailshow(dataEntity);
            if ("ten".equals(this.getAppId())) {
                this.sendMessage(dataEntity, key, "tenunsubonliebustalk", "ten_onlie_bustalk");
            } else {
                this.sendMessage(dataEntity, key, "respunsubonliebustalk", "resp_onlie_bustalk");
            }
        }
    }

    protected void sendMessage(DynamicObject dataEntity, String operation, String tplScene, String entityNumber) {
        DynamicObject negotiateinvite = dataEntity.getDynamicObject("negotiateinvite");
        DynamicObject bustalkF7 = negotiateinvite.getDynamicObject("bustalkid");
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkF7.getPkValue(), (String)(this.getBidAppId() + "_bustalk"));
        DynamicObject bidProjectF7 = bustalk.getDynamicObject("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)(this.getBidAppId() + "_project"));
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("pkId", bustalk.getPkValue());
        msgParam.put("id", dataEntity.getPkValue());
        msgParam.put("title", null);
        msgParam.put("content", null);
        msgParam.put("msgentity", entityNumber);
        msgParam.put("tplScene", tplScene);
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        msgParam.put("operation", operation);
        if ("ten".equals(this.getAppId())) {
            msgParam.put("appId", "bid");
            msgParam.put("formId", "bid_bustalk");
        } else {
            msgParam.put("appId", "rebm");
            msgParam.put("formId", "rebm_bustalk");
        }
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        for (Object member : memberColl) {
            String[] values;
            if (member.getString("respbusiness") != null && (values = member.getString("respbusiness").split(",")) != null && values.length > 0) {
                for (int m = 0; m < values.length; ++m) {
                    if (!"15".equals(values[m])) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!member.getBoolean("isdirector")) continue;
            memberSet.add(member.getDynamicObject("user"));
        }
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        String notifyType = MessageChannelUtil.getNotifyType((String)tplScene, (String)entityNumber);
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
    }

    protected void setFileDetail(DynamicObject dataEntity, Object supplierentryId, Object sectionId, Object supplierId) {
        List otherFileList;
        List comFileList;
        Long suplierenId = Long.valueOf(supplierentryId.toString());
        Long suplierPkId = Long.valueOf(supplierId.toString());
        boolean exists = QueryServiceHelper.exists((String)"bid_bustalk_file", (QFilter[])new QFilter[]{new QFilter("sectionid", "=", (Object)suplierenId), new QFilter("supplierid", "=", (Object)suplierPkId)});
        if (exists) {
            DeleteServiceHelper.delete((String)"bid_bustalk_file", (QFilter[])new QFilter[]{new QFilter("sectionid", "=", (Object)suplierenId), new QFilter("supplierid", "=", (Object)suplierPkId)});
        }
        DynamicObject techFile = BusinessDataServiceHelper.newDynamicObject((String)"bid_bustalk_file");
        techFile.set("sectionid", supplierentryId);
        techFile.set("status", (Object)"A");
        techFile.set("supplierid", supplierId);
        techFile.set("type", (Object)"techFile");
        DynamicObject comFile = BusinessDataServiceHelper.newDynamicObject((String)"bid_bustalk_file");
        comFile.set("sectionid", supplierentryId);
        comFile.set("status", (Object)"A");
        comFile.set("supplierid", supplierId);
        comFile.set("type", (Object)"comFile");
        DynamicObject otherFile = BusinessDataServiceHelper.newDynamicObject((String)"bid_bustalk_file");
        otherFile.set("sectionid", supplierentryId);
        otherFile.set("status", (Object)"A");
        otherFile.set("supplierid", supplierId);
        otherFile.set("type", (Object)"otherFile");
        String formId = this.getAppId() + "_onlie_bustalk";
        List techFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)dataEntity.getPkValue(), (String)("attatech" + sectionId));
        if (!techFileList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{techFile});
        }
        if (!(comFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)dataEntity.getPkValue(), (String)("attacommerce" + sectionId))).isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{comFile});
        }
        if (!(otherFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)dataEntity.getPkValue(), (String)("attaother" + sectionId))).isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{otherFile});
        }
        String fileFormId = "bid_bustalk_file";
        try (TXHandle h = TX.requiresNew();){
            try {
                if (!techFileList.isEmpty()) {
                    BidFileHelper.copyFileFromAToB((String)formId, (Object)dataEntity.getPkValue(), (String)("attatech" + sectionId), (String)fileFormId, (Object)techFile.getPkValue(), (String)"attachmentpanelap");
                }
                if (!comFileList.isEmpty()) {
                    BidFileHelper.copyFileFromAToB((String)formId, (Object)dataEntity.getPkValue(), (String)("attacommerce" + sectionId), (String)fileFormId, (Object)comFile.getPkValue(), (String)"attachmentpanelap");
                }
                if (!comFileList.isEmpty()) {
                    BidFileHelper.copyFileFromAToB((String)formId, (Object)dataEntity.getPkValue(), (String)("attaother" + sectionId), (String)fileFormId, (Object)otherFile.getPkValue(), (String)"attachmentpanelap");
                }
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private void updateDecisionDataSubmit(DynamicObject data) {
        DynamicObject negotiateinvite = data.getDynamicObject("negotiateinvite");
        DynamicObject bustalkF7 = negotiateinvite.getDynamicObject("bustalkid");
        this.bidBustalkUtil.auditSupplierToDecision((Long)bustalkF7.getPkValue(), this.getBidAppId());
        this.bidBustalkUtil.auditPriceToDecision((Long)bustalkF7.getPkValue(), this.getBidAppId());
    }

    public void updateDecisionDataUnSubmit(DynamicObject data) {
        DynamicObject negotiateinvite = data.getDynamicObject("negotiateinvite");
        DynamicObject bustalkF7 = negotiateinvite.getDynamicObject("bustalkid");
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkF7.getPkValue(), (String)(this.getBidAppId() + "_bustalk"));
        DynamicObject bidProjectF7 = bustalk.getDynamicObject("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)(this.getBidAppId() + "_project"));
        Long bidProjectId = bidProject.getLong("id");
        DynamicObject bidDecision = this.bidBustalkUtil.getDecision(bustalk, this.getBidAppId());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_decision");
        BusinessDataServiceHelper.delete((IDataEntityType)type, (Object[])new Object[]{bidDecision.getPkValue()});
        this.bidDecisionService.createByLastStep(bidProject, BidStepEnum.BidBustalk);
        this.questionClarifyService.clarifyWriteBackBidDesicion(this.getBidAppId(), bidProject);
        DynamicObjectCollection list = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId, "judge_num asc");
        for (DynamicObject l : list) {
            DynamicObject temp = null;
            temp = "rebm".equals(this.getBidAppId()) ? BusinessDataServiceHelper.loadSingle((Object)l.getLong("id"), (String)"rebm_bustalk") : this.bidBustalkService.getBustalkById(Long.valueOf(l.getLong("id")));
            this.bidBustalkUtil.auditSupplierToDecisionReally(temp, this.getBidAppId());
            this.bidBustalkUtil.auditPriceToDecisionReally(temp, this.getBidAppId());
        }
    }

    private void updateBustalkData(DynamicObject data, String key) {
        DynamicObject negotiateinvite = data.getDynamicObject("negotiateinvite");
        DynamicObject supplierOn = data.getDynamicObject("supplier");
        DynamicObject bustalkF7 = negotiateinvite.getDynamicObject("bustalkid");
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkF7.getPkValue(), (String)(this.getBidAppId() + "_bustalk"));
        DynamicObjectCollection bidsection = bustalk.getDynamicObjectCollection("bidsection");
        DynamicObject bidProjectF7 = bustalk.getDynamicObject("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)(this.getBidAppId() + "_project"));
        DynamicObjectCollection entry = data.getDynamicObjectCollection("entry");
        for (DynamicObject next : entry) {
            String sectionid = next.getString("sectionid");
            BigDecimal tenderprice = next.getBigDecimal("tenderprice");
            BigDecimal notaxtenderprice = next.getBigDecimal("notaxtenderprice");
            BigDecimal pricevat = next.getBigDecimal("pricevat");
            BigDecimal tax = next.getBigDecimal("tax");
            BigDecimal rate = next.getBigDecimal("rate");
            String tenderstate = next.getString("tenderstate");
            DynamicObjectCollection onsupplierdetails = next.getDynamicObjectCollection("supplierdetail");
            for (DynamicObject section : bidsection) {
                String section_id = section.getPkValue().toString();
                if (!sectionid.equals(section_id)) continue;
                DynamicObjectCollection supplierentrys = section.getDynamicObjectCollection("supplierentry");
                Iterator supplieriterator = supplierentrys.iterator();
                String ip = IsIllegalBidUtil.getLoginIp();
                while (supplieriterator.hasNext()) {
                    DynamicObject supplierentry = (DynamicObject)supplieriterator.next();
                    DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                    if (!supplierOn.getPkValue().toString().equals(supplier.getPkValue().toString())) continue;
                    if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                        supplierentry.set("isoffer", (Object)Boolean.TRUE);
                        supplierentry.set("offerdate", (Object)new Date());
                        supplierentry.set("offerperson", (Object)RequestContext.get().getUserId());
                        supplierentry.set("new_price", (Object)tenderprice);
                        supplierentry.set("taxrate", (Object)pricevat);
                        supplierentry.set("pricevat", (Object)tax);
                        supplierentry.set("bus_exceptvat", (Object)notaxtenderprice);
                        supplierentry.set("newrate", (Object)rate);
                        supplierentry.set("offerexplain", (Object)tenderstate);
                        BigDecimal upPrice = supplierentry.getBigDecimal("up_price");
                        if (upPrice.compareTo(BigDecimal.ZERO) > 0 && tenderprice.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal decline = tenderprice.subtract(upPrice).divide(upPrice, 4, 4);
                            supplierentry.set("decline", (Object)decline);
                        }
                        supplierentry.set("ipaddress", (Object)ip);
                        supplierentry.set("isiprepeat", (Object)this.dealWithBustalkIpRepeat(bustalkF7.getPkValue(), supplier.getPkValue(), ip));
                        String formId = this.getAppId() + "_onlie_bustalk";
                        List techFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)data.getPkValue(), (String)("attatech" + section_id));
                        List comFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)data.getPkValue(), (String)("attacommerce" + section_id));
                        List otherFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)data.getPkValue(), (String)("attaother" + section_id));
                        List techFile = AttachmentUtil.copyToEntryAttachment((List)techFileList);
                        List conFile = AttachmentUtil.copyToEntryAttachment((List)comFileList);
                        List otherFile = AttachmentUtil.copyToEntryAttachment((List)otherFileList);
                        DynamicObjectCollection technology_new = supplierentry.getDynamicObjectCollection("technology_new");
                        DynamicObjectCollection business_new = supplierentry.getDynamicObjectCollection("business_new");
                        DynamicObjectCollection otherFile_new = supplierentry.getDynamicObjectCollection("otherfile_new");
                        technology_new.clear();
                        business_new.clear();
                        otherFile_new.clear();
                        techFile.forEach(attachment -> technology_new.addNew().set("fbasedataid", attachment));
                        conFile.forEach(attachment -> business_new.addNew().set("fbasedataid", attachment));
                        otherFile.forEach(attachment -> otherFile_new.addNew().set("fbasedataid", attachment));
                    }
                    if (!StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) continue;
                    supplierentry.set("isoffer", (Object)Boolean.FALSE);
                    supplierentry.set("offerdate", (Object)new Date());
                    supplierentry.set("offerperson", (Object)RequestContext.get().getUserId());
                    supplierentry.set("ipaddress", (Object)ip);
                    supplierentry.set("new_price", null);
                    supplierentry.set("taxrate", null);
                    supplierentry.set("pricevat", null);
                    supplierentry.set("bus_exceptvat", null);
                    supplierentry.set("newrate", null);
                    supplierentry.set("offerexplain", null);
                    supplierentry.set("purdetail", null);
                    DynamicObjectCollection technology_new = supplierentry.getDynamicObjectCollection("technology_new");
                    DynamicObjectCollection business_new = supplierentry.getDynamicObjectCollection("business_new");
                    DynamicObjectCollection otherFile_new = supplierentry.getDynamicObjectCollection("otherfile_new");
                    for (DynamicObject object : technology_new) {
                        object.set("fbasedataid", null);
                    }
                    for (DynamicObject dynamicObject : business_new) {
                        dynamicObject.set("fbasedataid", null);
                    }
                    for (DynamicObject dynamicObject : otherFile_new) {
                        dynamicObject.set("fbasedataid", null);
                    }
                    supplierentry.set("otherfile", null);
                    supplierentry.set("business", null);
                    supplierentry.set("technology", null);
                    supplierentry.set("decline", null);
                    supplierentry.set("isiprepeat", (Object)this.dealWithBustalkIpRepeat(bustalkF7.getPkValue(), supplier.getPkValue(), ip));
                }
                DynamicObjectCollection supplierdetails = section.getDynamicObjectCollection("supplierdetail");
                for (DynamicObject supplierdetail : supplierdetails) {
                    DynamicObject pursupplier = supplierdetail.getDynamicObject("pursupplier");
                    if (!supplierOn.getPkValue().toString().equals(pursupplier.getPkValue().toString())) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(supplierOn.getPkValue());
                    int bidType = bidProject.getInt("bidtype");
                    if (bidType == 0) {
                        sb.append(supplierdetail.getString("purentrycontent"));
                    } else if (bidType == 1) {
                        sb.append(supplierdetail.getString("materialid.id"));
                    } else if (bidType == 2 && this.getBidAppId().equals("rebm")) {
                        sb.append(supplierdetail.getString("resourceitem.id"));
                    }
                    for (DynamicObject onsupplierdetail : onsupplierdetails) {
                        StringBuilder sbb = new StringBuilder();
                        sbb.append(supplierOn.getPkValue());
                        if (bidType == 0) {
                            sbb.append(onsupplierdetail.getString("purentrycontent"));
                        } else if (bidType == 1) {
                            sbb.append(onsupplierdetail.getString("materialid.id"));
                        } else if (bidType == 2 && this.getBidAppId().equals("rebm")) {
                            sbb.append(onsupplierdetail.getString("resourceitem.id"));
                        }
                        if (!sb.toString().equals(sbb.toString())) continue;
                        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                            supplierdetail.set("inclutaxprice", onsupplierdetail.get("inclutaxprice"));
                            supplierdetail.set("inclutaxamount", onsupplierdetail.get("inclutaxamount"));
                            supplierdetail.set("staxrate", (Object)onsupplierdetail.getBigDecimal("taxrate").divide(new BigDecimal("100")));
                            supplierdetail.set("taxamount", onsupplierdetail.get("taxamount"));
                            supplierdetail.set("excepttaxamount", onsupplierdetail.get("excepttaxamount"));
                            supplierdetail.set("costrate", (Object)onsupplierdetail.getBigDecimal("costrate").divide(new BigDecimal("100")));
                            supplierdetail.set("bd_taxrate", onsupplierdetail.get("bd_taxrate"));
                        }
                        if (!StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) continue;
                        supplierdetail.set("inclutaxprice", null);
                        supplierdetail.set("inclutaxamount", null);
                        supplierdetail.set("staxrate", null);
                        supplierdetail.set("taxamount", null);
                        supplierdetail.set("excepttaxamount", null);
                        supplierdetail.set("costrate", null);
                        supplierdetail.set("bd_taxrate", null);
                    }
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bustalk});
        this.addBustalkOperationIp(bustalkF7, supplierOn, key);
    }

    private void addBustalkOperationIp(DynamicObject bustalkF7, DynamicObject supplier, String key) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(this.getBidAppId() + "_bustalk_operationip"));
        DynamicObject bustalk_operationip = new DynamicObject((DynamicObjectType)mainType);
        ORM orm = ORM.create();
        long id = orm.genLongId((IDataEntityType)mainType);
        bustalk_operationip.set("id", (Object)id);
        bustalk_operationip.set("creator", (Object)RequestContext.get().getUserId());
        bustalk_operationip.set("createtime", (Object)new Date());
        bustalk_operationip.set("ip", (Object)IsIllegalBidUtil.getLoginIp());
        bustalk_operationip.set("bustalkid", (Object)bustalkF7);
        bustalk_operationip.set("supplier", (Object)supplier);
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            bustalk_operationip.set("type", (Object)"OFFER");
        }
        if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
            bustalk_operationip.set("type", (Object)"UNOFFER");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bustalk_operationip});
        DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingle((Object)bustalkF7.getPkValue(), (String)(this.getBidAppId().equals("bid") ? "bid_bustalk" : "rebm_bustalk"));
        DynamicObject bidproject = dynamicObject1.getDynamicObject("bidproject");
        String entityName1 = this.getBidAppId().equals("bid") ? "bid_iprecord" : "rebm_iprecord";
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName1);
        dynamicObject.set("bidproject", (Object)bidproject);
        dynamicObject.set("stage", (Object)"bustalk");
        dynamicObject.set("supplier", (Object)supplier);
        dynamicObject.set("ip", (Object)IsIllegalBidUtil.getLoginIp());
        dynamicObject.set("operationtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private Boolean dealWithBustalkIpRepeat(Object bustalkId, Object supplierId, String ip) {
        Boolean isiprepeat = Boolean.FALSE;
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkId, (String)(this.getBidAppId() + "_bustalk"));
        DynamicObjectCollection bidsection = bustalk.getDynamicObjectCollection("bidsection");
        for (DynamicObject section : bidsection) {
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject next : supplierentry) {
                DynamicObject supplier = next.getDynamicObject("supplier");
                String ipaddress = next.getString("ipaddress");
                if (supplier == null || supplierId.toString().equals(supplier.getPkValue().toString()) || !ipaddress.equals(ip)) continue;
                next.set("isiprepeat", (Object)Boolean.TRUE);
                isiprepeat = Boolean.TRUE;
            }
        }
        SaveServiceHelper.update((DynamicObject)bustalk);
        return isiprepeat;
    }

    private void dealWithBustalkIpRepeatAll(DynamicObject data) {
        DynamicObject negotiateinvite = data.getDynamicObject("negotiateinvite");
        DynamicObject bustalkF7 = negotiateinvite.getDynamicObject("bustalkid");
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkF7.getPkValue(), (String)(this.getBidAppId() + "_bustalk"));
        DynamicObjectCollection bidsection = bustalk.getDynamicObjectCollection("bidsection");
        Iterator bidsectioniterator = bidsection.iterator();
        List<String> supplier_ip = this.getAllSupplierAndIp(bustalkF7.getPkValue());
        while (bidsectioniterator.hasNext()) {
            DynamicObject section = (DynamicObject)bidsectioniterator.next();
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject next : supplierentry) {
                DynamicObject supplier = next.getDynamicObject("supplier");
                String ipaddress = next.getString("ipaddress");
                if (supplier == null) continue;
                int count = 0;
                for (String s : supplier_ip) {
                    String[] s1 = s.split("_");
                    if (s1[0].equals(supplier.getPkValue().toString()) || !s1[1].equals(ipaddress)) continue;
                    ++count;
                }
                if (count > 0) {
                    next.set("isiprepeat", (Object)Boolean.TRUE);
                    continue;
                }
                next.set("isiprepeat", (Object)Boolean.FALSE);
            }
        }
        SaveServiceHelper.update((DynamicObject)bustalk);
    }

    private List<String> getAllSupplierAndIp(Object bustalkId) {
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkId, (String)(this.getBidAppId() + "_bustalk"));
        DynamicObjectCollection bidsection = bustalk.getDynamicObjectCollection("bidsection");
        Iterator bidsectioniterator = bidsection.iterator();
        ArrayList<String> supplier_ip = new ArrayList<String>();
        while (bidsectioniterator.hasNext()) {
            DynamicObject section = (DynamicObject)bidsectioniterator.next();
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject next : supplierentry) {
                DynamicObject supplier = next.getDynamicObject("supplier");
                String ipaddress = next.getString("ipaddress");
                if (supplier == null) continue;
                supplier_ip.add(supplier.getPkValue().toString() + "_" + (StringUtils.isNotBlank((CharSequence)ipaddress) ? ipaddress : "123456"));
            }
        }
        return supplier_ip;
    }

    private List<Map<String, String>> getIdAndName(Object pkId) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        DynamicObject onlie_bustalk = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(this.getAppId() + "_onlie_bustalk"));
        DynamicObjectCollection sectionentry = onlie_bustalk.getDynamicObjectCollection("entry");
        DynamicObject bidProjectF7 = onlie_bustalk.getDynamicObject("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)(this.getBidAppId() + "_project"), (String)"enablemultisection,doctype");
        String docTypeStr = bidProject.getString("doctype");
        for (DynamicObject section : sectionentry) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", section.getString("sectionid"));
            map.put("sectionname", section.getString("sectionname"));
            map.put("doctype", docTypeStr);
            map.put("seq", section.getString("seq"));
            list.add(map);
        }
        return list;
    }

    public String getAppId() {
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        return appName;
    }

    public String getBidAppId() {
        return this.getAppId().equals("ten") ? "bid" : "rebm";
    }

    private void saveOnlieBustalkData(DynamicObject data) {
        List<Map<String, String>> list = this.getIdAndName(data.getPkValue());
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject entry = (DynamicObject)data.getDynamicObjectCollection("entry").get(i);
            Map<String, String> map = list.get(i);
            String sectionId = map.get("id");
            String sectionid = entry.getString("sectionid");
            if (!StringUtils.equals((CharSequence)sectionid, (CharSequence)sectionId)) continue;
            entry.set("tenderprice", data.get(TEXT_TENDERPRICE + sectionId));
            entry.set("notaxtenderprice", data.get(TEXT_TEXTNOTAXTENDERPRICE + sectionId));
            entry.set("tax", data.get(TEXT_TAX + sectionId));
            entry.set("pricevat", (Object)data.getBigDecimal(TEXT_PRICEVAT + sectionId).divide(new BigDecimal("100")));
            entry.set("projectmanage", data.get(TEXT_PROJECTMANAGE + sectionId));
            entry.set("workday", data.get(TEXT_WORKDAY + sectionId));
            entry.set("tenderstate", data.get(TEXT_TENDERSTATE + sectionId));
            entry.set("rate", (Object)data.getBigDecimal(TEXT_RATE + sectionId).divide(new BigDecimal("100")));
            entry.set("sectionname", (Object)map.get("sectionname"));
            entry.set("sectionid", (Object)sectionId);
            entry.set("seq", (Object)(i + 1));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new Validator());
    }

    private int parseInt(Object o) {
        if (o == null) {
            return 0;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void saveDecipurdetailshow(DynamicObject dataEntity) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(this.getBidAppId() + "_decipurdetailshow"));
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
        ArrayList<DynamicObject> toSaveshow = new ArrayList<DynamicObject>(entry.size());
        String tenappid = this.getAppId().equals("ten") ? "ten" : "resp";
        int amtPrecision = 0;
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject object = (DynamicObject)entry.get(i);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainType);
            dynamicObject.set("currency", dataEntity.get("currency"));
            dynamicObject.set("inclutaxamount", object.get("tenderprice"));
            dynamicObject.set("taxrate", (Object)object.getBigDecimal("pricevat").multiply(new BigDecimal("100")));
            dynamicObject.set("taxamount", object.get("tax"));
            dynamicObject.set("excepttaxamount", object.get("notaxtenderprice"));
            dynamicObject.set("quotesource", (Object)"bustalk");
            dynamicObject.set("datetimefield", (Object)new Date());
            dynamicObject.set("supplier", dataEntity.get("supplier"));
            dynamicObject.set("sectionname", object.get("sectionname"));
            dynamicObject.set("bidproject", dataEntity.get("bidproject"));
            dynamicObject.set("sourceid", (Object)dataEntity.getPkValue().toString());
            dynamicObject.set("entitytype", (Object)tenappid);
            QFilter projectqfilter = new QFilter("bidproject", "=", dataEntity.getDynamicObject("bidproject").getPkValue());
            QFilter sectionfilter = new QFilter("sectionname", "=", (Object)object.getString("sectionname"));
            QFilter supplierfilter = new QFilter("supplier", "=", dataEntity.getDynamicObject("supplier").getPkValue());
            DynamicObject[] lastdetailshows = BusinessDataServiceHelper.load((String)(this.getBidAppId() + "_decipurdetailshow"), (String)"inclutaxamount,datetimefield", (QFilter[])new QFilter[]{projectqfilter, sectionfilter, supplierfilter}, (String)"datetimefield desc");
            if (lastdetailshows.length > 0) {
                DynamicObject lastdetailshow = lastdetailshows[0];
                BigDecimal inclutaxamount = lastdetailshow.getBigDecimal("inclutaxamount");
                if (inclutaxamount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal decline = dynamicObject.getBigDecimal("inclutaxamount").subtract(inclutaxamount).divide(inclutaxamount, amtPrecision, 4);
                    DecimalFormat df = new DecimalFormat("0.00");
                    String declineStr = df.format(decline.multiply(new BigDecimal("100")));
                    declineStr = declineStr.replaceAll("-", "");
                    if (decline.compareTo(BigDecimal.ZERO) > 0) {
                        dynamicObject.set("decline_dec", (Object)(declineStr + "% \u2191"));
                    } else if (decline.compareTo(BigDecimal.ZERO) < 0) {
                        dynamicObject.set("decline_dec", (Object)(declineStr + "% \u2193"));
                    } else {
                        dynamicObject.set("decline_dec", (Object)"0.00%");
                    }
                } else {
                    dynamicObject.set("decline_dec", (Object)"0.00%");
                }
            } else {
                dynamicObject.set("decline_dec", (Object)"0.00%");
            }
            toSaveshow.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])toSaveshow.toArray(new DynamicObject[0]));
    }

    public void deleteDecipurdetailshow(DynamicObject dataEntity) {
        QFilter qFilter = new QFilter("sourceid", "=", (Object)dataEntity.getPkValue().toString());
        DeleteServiceHelper.delete((String)(this.getBidAppId() + "_decipurdetailshow"), (QFilter[])qFilter.toArray());
    }

    private class Validator
    extends AbstractValidator {
        private Validator() {
        }

        public void validate() {
            Date offerstoptime;
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            ExtendedDataEntity dataEntity = dataEntities[0];
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                DynamicObject bidProjectf7 = (DynamicObject)dataEntities[0].getValue("bidproject");
                DynamicObjectCollection entry = (DynamicObjectCollection)dataEntities[0].getValue("entry");
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectf7.getPkValue(), (String)(OnlieBustalkOp.this.getBidAppId() + "_" + "project"));
                Boolean enablemultisection = entry.size() > 1;
                Boolean isRateBidding = bidProject.getBoolean("isratebidding");
                Date offerstoptime2 = (Date)dataEntities[0].getValue("offerstoptime");
                if (offerstoptime2.getTime() - new Date().getTime() < 0L) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff0c\u8bf7\u9000\u51fa\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"OnlieBustalkOp_0", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
                List ids = OnlieBustalkOp.this.getIdAndName(dataEntities[0].getBillPkId());
                for (int i = 0; i < ids.size(); ++i) {
                    Map map = (Map)ids.get(i);
                    Integer workDay = OnlieBustalkOp.this.parseInt(dataEntity.getValue(OnlieBustalkOp.TEXT_WORKDAY + (String)map.get("id")));
                    if (workDay >= 0) continue;
                    if (enablemultisection.booleanValue()) {
                        String str = String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5de5\u671f\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"OnlieBustalkOp_3", (String)"scm-ten-opplugin", (Object[])new Object[0]), map.get("sectionname"));
                        this.addErrorMessage(dataEntity, str);
                    } else {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5de5\u671f\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"OnlieBustalkOp_4", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    }
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key) && (offerstoptime = (Date)dataEntities[0].getValue("offerstoptime")).getTime() - new Date().getTime() < 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\uff0c\u8bf7\u9000\u51fa\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"OnlieBustalkOp_5", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

