/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;
import kd.scm.ten.formplugin.util.TenderRecordUtil;

public class TenBiddingOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private IBidOpenService bidOpenService = new BidOpenServiceImpl();
    private static final String TEXT_TENDERPRICE = "texttenderprice";
    private static final String TEXT_TEXTNOTAXTENDERPRICE = "textnotaxtenderprice";
    private static final String TEXT_TAX = "texttax";
    private static final String TEXT_PRICEVAT = "textpricevat";
    private static final String TEXT_PROJECTMANAGE = "textprojectmanage";
    private static final String TEXT_WORKDAY = "textworkday";
    private static final String TEXT_RATE = "textrate";
    private static final String TEXT_TENDERSTATE = "texttenderstate";
    private static final String[] ATTACH_FEILD_ID = new String[]{"attatech", "attacommerce", "attainvite", "attaother"};
    private static final String REVOKEBIDNUMBER = "revokebidnumber";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("entry");
        keys.add("supplier");
        keys.add("supplierdetail");
        keys.add("mytender");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new Validator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObjectCollection supplierDetail;
        DynamicObjectCollection entry;
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        DynamicObjectCollection col = e.getDataEntities()[0].getDynamicObjectCollection("entry");
        DynamicObject data = datas[0];
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            String orderBys;
            QFilter reSubmitTendersFilter;
            DynamicObject bidProject = data.getDynamicObject("bidproject");
            DynamicObject supplier = data.getDynamicObject("supplier");
            QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplier.getString("id") + "%"));
            QFilter isBidDingFilter = new QFilter("is_again_bidding", "!=", (Object)"2");
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
            QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI));
            DynamicObject[] latestDatas = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)"id,bidsection,bidsection.sectionname,bidsection.pursupplier,is_again_bidding,supplierdetail,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifyTypeFilter, billStatusFilter, reSubmitTendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE), isBidDingFilter}, (String)(orderBys = "submitdate desc"), (int)1);
            if (latestDatas != null && latestDatas.length > 0) {
                DynamicObject questionClarify = latestDatas[0];
                questionClarify.set("is_again_bidding", (Object)2);
                SaveServiceHelper.update((DynamicObject)questionClarify);
            }
            QFilter qFilter = new QFilter("bidproject.id", "=", bidProject.getPkValue());
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.COMPLETE.getVal())));
            qFilter.and(new QFilter("is_again_bidding", "!=", (Object)"2"));
            DynamicObject[] busTalkList = BusinessDataServiceHelper.load((String)"bid_bustalk", (String)"id,billstatus,is_again_bidding", (QFilter[])new QFilter[]{qFilter}, (String)"judge_num asc");
            if (busTalkList != null && busTalkList.length > 0) {
                for (DynamicObject busTalk : busTalkList) {
                    busTalk.set("is_again_bidding", (Object)2);
                }
                SaveServiceHelper.update((DynamicObject[])busTalkList);
            }
        }
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
            data.set("billstatus", (Object)"A");
            this.saveBiddingData(data);
            entry = data.getDynamicObjectCollection("entry");
            if (entry != null && entry.size() > 0) {
                for (int i = 0; i < entry.size(); ++i) {
                    supplierDetail = ((DynamicObject)entry.get(i)).getDynamicObjectCollection("supplierdetail");
                    for (int j = 0; j < supplierDetail.size(); ++j) {
                        ((DynamicObject)supplierDetail.get(j)).set("taxrate", (Object)((DynamicObject)supplierDetail.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                        ((DynamicObject)supplierDetail.get(j)).set("costrate", (Object)((DynamicObject)supplierDetail.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                    }
                }
            }
            this.saveBiddingData(data);
        }
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            data.set("billstatus", (Object)"B");
            data.set("modifytime", (Object)new Date());
            this.saveBiddingData(data);
            entry = data.getDynamicObjectCollection("entry");
            if (entry != null && entry.size() > 0) {
                for (int i = 0; i < entry.size(); ++i) {
                    supplierDetail = ((DynamicObject)entry.get(i)).getDynamicObjectCollection("supplierdetail");
                    for (int j = 0; j < supplierDetail.size(); ++j) {
                        ((DynamicObject)supplierDetail.get(j)).set("taxrate", (Object)((DynamicObject)supplierDetail.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                        ((DynamicObject)supplierDetail.get(j)).set("costrate", (Object)((DynamicObject)supplierDetail.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                    }
                }
            }
            this.saveBiddingData(data);
            this.updateMyTenderStatus(data);
        }
    }

    public void isGenaralBidOpen(DynamicObject data) {
        DynamicObject bidproject = (DynamicObject)data.get("bidproject");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidmode.bidopen,bidmode.biddecision");
        DynamicObject bidmode = (DynamicObject)project.get("bidmode");
        Boolean isBidOpen = bidmode.getBoolean("bidopen");
        DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,bidsection,bidsection.sectionname", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidproject.getPkValue())});
        if (isBidOpen.booleanValue() && bidopen == null) {
            this.bidOpenService.saveBidOpen((Long)bidproject.getPkValue(), true);
        }
    }

    public List<Map<String, String>> getIdAndName(Object myTenderId) {
        DynamicObject myTender = BusinessDataServiceHelper.loadSingle((Object)myTenderId, (String)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()), (String)"bidproject,entry,entry.projectsection,entry.sectionstatus");
        DynamicObject bidProjectF7 = (DynamicObject)myTender.get("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"enablemultisection");
        Boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        DynamicObjectCollection entryColll = myTender.getDynamicObjectCollection("entry");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashSet<Long> set = new HashSet<Long>(entryColll.size());
        for (int i = 0; i < entryColll.size(); ++i) {
            Object projectSectionId = ((DynamicObject)entryColll.get(i)).get("projectsection_id");
            set.add(Long.parseLong(projectSectionId.toString()));
        }
        QFilter filter = new QFilter("id", "in", set);
        DynamicObject[] projectsection = BusinessDataServiceHelper.load((String)TenFormTypeConstants.getFormConstant((String)"projectsection_f7", ((Object)((Object)this)).getClass()), (String)"sectionname", (QFilter[])new QFilter[]{filter});
        for (int i = 0; i < entryColll.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryColll.get(i);
            String projectSectionId = entry.getString("projectsection_id");
            Object sectionStatus = entry.get("sectionstatus");
            String pk = entry.getPkValue().toString();
            if (sectionStatus.equals("UNINVITED")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", pk);
            map.put("projectSectionId", projectSectionId);
            map.put("enablemultisection", enablemultisection.toString());
            for (int j = 0; j < projectsection.length; ++j) {
                String tempId = projectsection[j].getPkValue().toString();
                if (!tempId.equals(projectSectionId)) continue;
                map.put("name", projectsection[j].getString("sectionname"));
            }
            list.add(map);
        }
        return list;
    }

    public void saveBiddingData(DynamicObject data) {
        DynamicObject mytender = (DynamicObject)data.get("mytender");
        boolean enablemultisection = data.getDynamicObject("bidproject").getBoolean("enablemultisection");
        List<Map<String, String>> list = this.getIdAndName(mytender.getPkValue().toString());
        if (enablemultisection) {
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject entry = (DynamicObject)data.getDynamicObjectCollection("entry").get(i);
                Map<String, String> map = list.get(i);
                String sectionId = map.get("id");
                String bidProjectPkValue = entry.getDynamicObject("projectsection").getPkValue().toString();
                if (!StringUtils.equals((CharSequence)bidProjectPkValue, (CharSequence)map.get("projectSectionId"))) continue;
                entry.set("tenderprice", data.get(TEXT_TENDERPRICE + sectionId));
                entry.set("notaxtenderprice", data.get(TEXT_TEXTNOTAXTENDERPRICE + sectionId));
                entry.set("tax", data.get(TEXT_TAX + sectionId));
                entry.set("pricevat", (Object)data.getBigDecimal(TEXT_PRICEVAT + sectionId).divide(new BigDecimal("100")));
                entry.set("projectmanage", data.get(TEXT_PROJECTMANAGE + sectionId));
                entry.set("workday", data.get(TEXT_WORKDAY + sectionId));
                entry.set("tenderstate", data.get(TEXT_TENDERSTATE + sectionId));
                entry.set("rate", (Object)data.getBigDecimal(TEXT_RATE + sectionId).divide(new BigDecimal("100")));
                entry.set("sectionname", (Object)map.get("name"));
                entry.set("mytenderentry", (Object)sectionId);
                entry.set("seq", (Object)(i + 1));
            }
        } else {
            MainEntityType mainType = (MainEntityType)data.getDataEntityType();
            EntityType type = (EntityType)mainType.getAllEntities().get("entry");
            DynamicObjectCollection coll = new DynamicObjectCollection();
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject entry = (DynamicObject)data.getDynamicObjectCollection("entry").get(i);
                Map<String, String> map = list.get(i);
                String sectionId = map.get("id");
                entry.set("tenderprice", data.get(TEXT_TENDERPRICE + sectionId));
                entry.set("notaxtenderprice", data.get(TEXT_TEXTNOTAXTENDERPRICE + sectionId));
                entry.set("tax", data.get(TEXT_TAX + sectionId));
                entry.set("pricevat", (Object)data.getBigDecimal(TEXT_PRICEVAT + sectionId).divide(new BigDecimal("100")));
                entry.set("projectmanage", data.get(TEXT_PROJECTMANAGE + sectionId));
                entry.set("workday", data.get(TEXT_WORKDAY + sectionId));
                entry.set("tenderstate", data.get(TEXT_TENDERSTATE + sectionId));
                entry.set("rate", (Object)data.getBigDecimal(TEXT_RATE + sectionId).divide(new BigDecimal("100")));
                entry.set("sectionname", (Object)map.get("name"));
                entry.set("mytenderentry", (Object)sectionId);
                DynamicObject projectsection = BusinessDataServiceHelper.loadSingle((Object)map.get("projectSectionId"), (String)TenFormTypeConstants.getFormConstant((String)"projectsection_f7", ((Object)((Object)this)).getClass()));
                entry.set("projectsection", (Object)projectsection);
                entry.set("seq", (Object)(i + 1));
                coll.add((Object)entry);
            }
            data.set("entry", (Object)coll);
        }
    }

    public void submitBiddingData(DynamicObject data, List<Map<String, String>> list) {
        BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\uff1a\u5f00\u59cb", (String)"TenBiddingOperationServicePlugin_8", (String)"scm-ten-opplugin", (Object[])new Object[0]));
        DynamicObject bidproject = (DynamicObject)data.get("bidproject");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidmode.bidopen,bidmode.biddecision,entitytypeid");
        String entityTypePre = project.getString("entitytypeid").split("_")[0];
        DynamicObject supplier = null;
        if ("bid".equals(entityTypePre)) {
            supplier = SupplierUtil.getSupplier();
        } else if ("rebm".equals(entityTypePre)) {
            supplier = SupplierUtil.getRESMSupplier();
        }
        if (supplier != null) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\uff1a\u4f9b\u5e94\u5546id\uff08%s\uff09\u3002", (String)"TenBiddingOperationServicePlugin_9", (String)"scm-ten-opplugin", (Object[])new Object[0]), supplier.getPkValue()));
        } else {
            BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\uff1a\u4f9b\u5e94\u5546id\uff08\u4f9b\u5e94\u5546\u4e3a\u7a7a\uff09\u3002", (String)"TenBiddingOperationServicePlugin_10", (String)"scm-ten-opplugin", (Object[])new Object[0]));
        }
        DynamicObject[] bidopenArray = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.supplier_istender,supplierentry.supplier_tenderdate,supplierentry.supplier_manager,supplierentry.supplier_techfile,supplierentry.supplier_comfile,supplierentry.supplier_tenfile,supplierentry.supplier_otherfile,supplierentry.supplier_pricevat,supplierentry.supplier_tenderprice,supplierentry.supplier_exceptvat,supplierentry.supplier_rate,supplierentry.supplier_illustration,supplierentry.supplier_isfrombackbid,supplierentry.supplier_workday,supplierentry.supplier_ip,supplierentry.supplier_taxrate,supplierentry.supplier_revokebidnumbersupplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate,supplierdetail.listnumber,supplierdetail.listname,supplierdetail.resourceitem", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidproject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX", "J"})});
        if (bidopenArray == null || bidopenArray.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6295\u6807\u5931\u8d25\uff0c\u5f00\u6807\u5355\u4e0d\u5b58\u5728\u3002", (String)"TenBiddingOperationServicePlugin_6", (String)"scm-ten-opplugin", (Object[])new Object[0]));
        }
        if (bidopenArray != null && bidopenArray.length > 0) {
            for (int i = 0; i < bidopenArray.length; ++i) {
                this.saveBidOpenData(data, bidopenArray[i], supplier, list);
                this.copyFileToBidOpen(data, bidopenArray[i], list, supplier);
            }
            return;
        }
    }

    public void saveBidOpenData(DynamicObject biddingObject, DynamicObject bidOpen, DynamicObject supplier, List<Map<String, String>> list) {
        boolean flag;
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getPkValue(), (String)"bid_bidopen", (String)"id,entitytypeid");
        String entityTypePre = tempObj.getString("entitytypeid").split("_")[0];
        HashMap<String, DynamicObject> supplierMap = new HashMap<String, DynamicObject>();
        if ("bid".equals(entityTypePre)) {
            DynamicObject[] supplierByUser;
            bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bid_bidopen"));
            for (DynamicObject tempSupplier : supplierByUser = SupplierUtil.getSupplierByUser()) {
                supplierMap.put(tempSupplier.getPkValue().toString(), tempSupplier);
            }
        } else if ("rebm".equals(entityTypePre)) {
            bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getPkValue(), (String)"rebm_bidopen");
            supplierMap.put(supplier.getPkValue().toString(), supplier);
        }
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\uff1a\u5f00\u6807\u5355id\uff08%s\uff09\u3002", (String)"TenBiddingOperationServicePlugin_11", (String)"scm-ten-opplugin", (Object[])new Object[0]), tempObj.getPkValue()));
        DynamicObject mytender = (DynamicObject)biddingObject.get("mytender");
        List<Map<String, String>> myTenderSectionlist = this.getIdAndName(mytender.getPkValue().toString());
        Map<String, Map<String, Integer>> totalAttachMap = this.getAttachMap(biddingObject);
        DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
        Set<String> sectionNameSet = totalAttachMap.keySet();
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\uff1a\u9644\u4ef6\u6570\u91cf\u4fe1\u606f\uff08%s\uff09\u3002", (String)"TenBiddingOperationServicePlugin_12", (String)"scm-ten-opplugin", (Object[])new Object[0]), totalAttachMap));
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            DynamicObjectCollection suppliereEntryColl = bidsection.getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < suppliereEntryColl.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)suppliereEntryColl.get(j);
                DynamicObject supplier1 = (DynamicObject)supplierentry.get("supplier");
                flag = supplierMap.containsKey(supplier1.getPkValue().toString());
                String ip = IsIllegalBidUtil.getLoginIp();
                for (String sectionName : sectionNameSet) {
                    if (!flag || !sectionName.equals(bidsection.get("sectionname").toString())) continue;
                    DynamicObject changeSupplier = supplier1;
                    for (int k = 0; k < myTenderSectionlist.size(); ++k) {
                        Map<String, String> map = myTenderSectionlist.get(k);
                        if (!map.get("name").equals(bidsection.get("sectionname").toString())) continue;
                        String sectionId = map.get("id");
                        Map attMap = (Map)totalAttachMap.entrySet().stream().filter(item -> ((String)item.getKey()).equals(sectionName)).findAny().get().getValue();
                        supplierentry.set("supplier_istender", (Object)Boolean.TRUE);
                        supplierentry.set("supplier_tenderdate", (Object)new Date());
                        supplierentry.set("supplier_isfrombackbid", (Object)Boolean.TRUE);
                        supplierentry.set("supplier_revokebidnumber", (Object)biddingObject.getInt(REVOKEBIDNUMBER));
                        supplierentry.set("supplier_manager", biddingObject.get(TEXT_PROJECTMANAGE + sectionId));
                        if (biddingObject.get(TEXT_TENDERPRICE + sectionId) != null && biddingObject.get(TEXT_PRICEVAT + sectionId) != null) {
                            BigDecimal tenderFormat = new BigDecimal(biddingObject.get(TEXT_TENDERPRICE + sectionId).toString());
                            double tenderPrice = tenderFormat.setScale(2, 4).doubleValue();
                            supplierentry.set("supplier_tenderprice", (Object)tenderPrice);
                        }
                        supplierentry.set("supplier_taxrate", (Object)biddingObject.getBigDecimal(TEXT_PRICEVAT + sectionId));
                        supplierentry.set("supplier_rate", (Object)biddingObject.getBigDecimal(TEXT_RATE + sectionId).divide(new BigDecimal("100")));
                        supplierentry.set("supplier_illustration", biddingObject.get(TEXT_TENDERSTATE + sectionId));
                        supplierentry.set("supplier_workday", biddingObject.get(TEXT_WORKDAY + sectionId));
                        supplierentry.set("supplier_ip", (Object)ip);
                        supplierentry.set("supplier_tenfile", attMap.get("attainvite"));
                        supplierentry.set("supplier_otherfile", attMap.get("attaother"));
                        supplierentry.set("supplier_techfile", attMap.get("attatech"));
                        supplierentry.set("supplier_comfile", attMap.get("attacommerce"));
                        DynamicObject bidproject = biddingObject.getDynamicObject("bidproject");
                        boolean isIllegalBid = IsIllegalBidUtil.isIllegalBidInOpen((long)((Long)supplier.getPkValue()), (long)((Long)bidproject.getPkValue()), (String)sectionName, (String)ip, (String)(this.getAppId(bidproject) + "_tenderrecord"));
                        supplierentry.set("isillegalbid", (Object)isIllegalBid);
                        supplierentry.set("tender", (Object)RequestContext.get().getCurrUserId());
                        supplierentry.set("tenderrecord", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"TenBiddingOperationServicePlugin_5", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                        DynamicObjectCollection datasections = biddingObject.getDynamicObjectCollection("entry");
                        for (DynamicObject datasection : datasections) {
                            Object sectionNameObj = datasection.get("sectionname");
                            if (sectionNameObj == null || !sectionNameObj.toString().equals(map.get("name")) || !changeSupplier.getPkValue().toString().equals(((DynamicObject)suppliereEntryColl.get(j)).getDynamicObject("supplier").getPkValue().toString())) continue;
                            supplierentry.set("supplier_pricevat", datasection.get("tax"));
                            supplierentry.set("supplier_exceptvat", datasection.get("notaxtenderprice"));
                        }
                        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\uff1a\u6295\u6807\u4fe1\u606f\uff08%1$s\uff09\u3001\u7a0e\u7387\uff08%2$s\uff09\u3001\u8d39\u7387\uff08%3$s\uff09\u3002", (String)"TenBiddingOperationServicePlugin_13", (String)"scm-ten-opplugin", (Object[])new Object[0]), biddingObject.get(TEXT_TENDERPRICE + sectionId), biddingObject.getBigDecimal(TEXT_PRICEVAT + sectionId), biddingObject.getBigDecimal(TEXT_RATE + sectionId)));
                    }
                }
            }
        }
        HashMap<String, DynamicObject> bidOpendDetailMap = new HashMap<String, DynamicObject>();
        for (DynamicObject bidOpenSectionEntry : bidOpen.getDynamicObjectCollection("bidsection")) {
            for (DynamicObject bidOpenDetailEntry : bidOpenSectionEntry.getDynamicObjectCollection("supplierdetail")) {
                DynamicObject bidOpenDetailSupplier = bidOpenDetailEntry.getDynamicObject("pursupplier");
                if (bidOpenDetailSupplier == null || !(flag = supplierMap.containsKey(bidOpenDetailSupplier.getPkValue().toString()))) continue;
                DynamicObject bidOpenDetailMaterial = bidOpenDetailEntry.getDynamicObject("materialid");
                String key = this.createKey(bidOpenSectionEntry, bidOpenDetailEntry, bidOpenDetailMaterial, entityTypePre);
                bidOpendDetailMap.put(key, bidOpenDetailEntry);
            }
        }
        for (DynamicObject biddingSectionEntry : biddingObject.getDynamicObjectCollection("entry")) {
            for (DynamicObject bidOpenSectionEntry : bidOpen.getDynamicObjectCollection("bidsection")) {
                if (!biddingSectionEntry.getString("sectionname").equals(bidOpenSectionEntry.getString("sectionname"))) continue;
                DynamicObjectCollection bidOpenDetailColl = bidOpenSectionEntry.getDynamicObjectCollection("supplierdetail");
                for (DynamicObject biddingDetailEntry : biddingSectionEntry.getDynamicObjectCollection("supplierdetail")) {
                    DynamicObject biddingDetailMaterial;
                    String key = this.createKey(biddingSectionEntry, biddingDetailEntry, biddingDetailMaterial = biddingDetailEntry.getDynamicObject("materialid"), entityTypePre);
                    if (bidOpendDetailMap.containsKey(key)) {
                        DynamicObject bidOpendDetail = (DynamicObject)bidOpendDetailMap.get(key);
                        bidOpendDetail.set("inclutaxprice", biddingDetailEntry.get("inclutaxprice"));
                        bidOpendDetail.set("inclutaxamount", biddingDetailEntry.get("inclutaxamount"));
                        bidOpendDetail.set("taxrate", biddingDetailEntry.get("taxrate"));
                        bidOpendDetail.set("taxamount", biddingDetailEntry.get("taxamount"));
                        bidOpendDetail.set("excepttaxamount", biddingDetailEntry.get("excepttaxamount"));
                        bidOpendDetail.set("costrate", biddingDetailEntry.get("costrate"));
                        bidOpendDetail.set("bd_taxrate", biddingDetailEntry.get("bd_taxrate"));
                        continue;
                    }
                    DynamicObject newSupplierDetail = bidOpenDetailColl.addNew();
                    newSupplierDetail.set("seq", (Object)bidOpenDetailColl.size());
                    newSupplierDetail.set("pursupplier", (Object)supplier);
                    newSupplierDetail.set("purentrycontent", biddingDetailEntry.get("purentrycontent"));
                    newSupplierDetail.set("purentryproject", biddingDetailEntry.get("purentryproject"));
                    newSupplierDetail.set("materialid", biddingDetailEntry.get("materialid"));
                    newSupplierDetail.set("materialdes", biddingDetailEntry.get("materialdes"));
                    newSupplierDetail.set("qty", biddingDetailEntry.get("qty"));
                    newSupplierDetail.set("inclutaxprice", biddingDetailEntry.get("inclutaxprice"));
                    newSupplierDetail.set("inclutaxamount", biddingDetailEntry.get("inclutaxamount"));
                    newSupplierDetail.set("bd_taxrate", biddingDetailEntry.get("bd_taxrate"));
                    newSupplierDetail.set("taxrate", biddingDetailEntry.get("taxrate"));
                    newSupplierDetail.set("taxamount", biddingDetailEntry.get("taxamount"));
                    newSupplierDetail.set("excepttaxamount", biddingDetailEntry.get("excepttaxamount"));
                    newSupplierDetail.set("costrate", biddingDetailEntry.get("costrate"));
                    if (!"rebm".equals(entityTypePre)) continue;
                    newSupplierDetail.set("resourceitem", biddingDetailEntry.get("resourceitem"));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidOpen});
        TenderRecordUtil.createTenderRecordData((DynamicObject)biddingObject, (String)entityTypePre, (boolean)true, list, (Object)bidOpen.getPkValue());
        BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\uff1a\u7ed3\u675f", (String)"TenBiddingOperationServicePlugin_16", (String)"scm-ten-opplugin", (Object[])new Object[0]));
    }

    protected String createKey(DynamicObject sectionEntry, DynamicObject detailEntry, DynamicObject detailMaterial, String entityTypePre) {
        StringJoiner stringJoiner = new StringJoiner("|");
        stringJoiner.add(sectionEntry.getString("sectionname"));
        stringJoiner.add(StringUtils.isEmpty((CharSequence)detailEntry.getString("purentrycontent")) ? "" : detailEntry.getString("purentrycontent"));
        stringJoiner.add(detailMaterial == null ? "" : detailMaterial.getPkValue().toString());
        stringJoiner.add(detailEntry.getDynamicObject("purentryproject") == null ? "" : detailEntry.getDynamicObject("purentryproject").getString("id"));
        stringJoiner.add(detailEntry.getString("materialdes") == null ? "" : detailEntry.getString("materialdes"));
        if ("rebm".equals(entityTypePre)) {
            stringJoiner.add(detailEntry.getDynamicObject("resourceitem") == null ? "" : detailEntry.getDynamicObject("resourceitem").getString("id"));
        }
        return stringJoiner.toString();
    }

    public Map<String, Map<String, Integer>> getAttachMap(DynamicObject data) {
        DynamicObject mytender = (DynamicObject)data.get("mytender");
        List<Map<String, String>> list = this.getIdAndName(mytender.getPkValue().toString());
        HashMap<String, Map<String, Integer>> totalAttachMap = new HashMap<String, Map<String, Integer>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Integer> attMap = new HashMap<String, Integer>(ATTACH_FEILD_ID.length);
            Map<String, String> map = list.get(i);
            String id = map.get("id");
            for (int j = 0; j < ATTACH_FEILD_ID.length; ++j) {
                List attachments = AttachmentServiceHelper.getAttachments((String)String.valueOf(TenFormTypeConstants.getFormConstant((String)"bidding", ((Object)((Object)this)).getClass())), (Object)data.get("id"), (String)(ATTACH_FEILD_ID[j] + id));
                int countFile = attachments.size();
                attMap.put(ATTACH_FEILD_ID[j], countFile);
            }
            totalAttachMap.put(map.get("name"), attMap);
        }
        return totalAttachMap;
    }

    public void updateMyTenderStatus(DynamicObject data) {
        DynamicObject mytender = (DynamicObject)data.get("mytender");
        DynamicObject myTenderObject = BusinessDataServiceHelper.loadSingle((Object)mytender.getPkValue(), (String)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()), (String)"bidproject,tenderstatus,entry,entry.projectsection,entry.sectionstatus");
        myTenderObject.set("tenderstatus", (Object)MyTenderStatus.TENDERED);
        for (DynamicObject myTenderEntry : myTenderObject.getDynamicObjectCollection("entry")) {
            if (MyTenderStatus.UNINVITED.getValue().equals(myTenderEntry.getString("sectionstatus"))) continue;
            myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.TENDERED);
        }
        SaveServiceHelper.update((DynamicObject)myTenderObject);
    }

    public void copyFileToBidOpen(DynamicObject dataEntity, DynamicObject bidOpen, List<Map<String, String>> list, DynamicObject supplier) {
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        String appId = this.getAppId(bidProject);
        DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
        HashMap<Object, DynamicObject> supplierMap = new HashMap<Object, DynamicObject>();
        if ("bid".equals(appId)) {
            DynamicObject[] supplierByUser;
            for (DynamicObject tempSupplier : supplierByUser = SupplierUtil.getSupplierByUser()) {
                supplierMap.put(tempSupplier.getPkValue(), tempSupplier);
            }
        } else {
            supplierMap.put(supplier.getPkValue(), supplier);
        }
        bidsectioncoll.forEach(bidsection -> {
            DynamicObjectCollection suppliereEntryColl = bidsection.getDynamicObjectCollection("supplierentry");
            suppliereEntryColl.forEach(suppliereEntry -> {
                Object supplierId = suppliereEntry.getDynamicObject("supplier").getPkValue();
                if (supplierMap.containsKey(supplierId)) {
                    list.stream().filter(map -> ((String)map.get("name")).equals(bidsection.getString("sectionname"))).findAny().ifPresent(map -> this.setFileDetail(dataEntity, (DynamicObject)bidsection, (Map<Object, DynamicObject>)supplierMap, supplierId, (Map<String, String>)map, appId));
                }
            });
        });
    }

    protected void setFileDetail(DynamicObject dataEntity, DynamicObject bidsection, Map<Object, DynamicObject> supplierMap, Object supplierId, Map<String, String> map, String appId) {
        DynamicObject tempSupplier = supplierMap.get(supplierId);
        String sectionId = map.get("id");
        DeleteServiceHelper.delete((String)FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("sectionid", "=", bidsection.getPkValue()), new QFilter("supplierid", "=", tempSupplier.getPkValue())});
        DynamicObject techFile = BusinessDataServiceHelper.newDynamicObject((String)FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass()));
        techFile.set("sectionid", bidsection.getPkValue());
        techFile.set("status", (Object)"A");
        techFile.set("supplierid", tempSupplier.getPkValue());
        techFile.set("type", (Object)"techFile");
        DynamicObject tenFile = BusinessDataServiceHelper.newDynamicObject((String)FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass()));
        tenFile.set("sectionid", bidsection.getPkValue());
        tenFile.set("status", (Object)"A");
        tenFile.set("supplierid", tempSupplier.getPkValue());
        tenFile.set("type", (Object)"tenFile");
        DynamicObject comFile = BusinessDataServiceHelper.newDynamicObject((String)FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass()));
        comFile.set("sectionid", bidsection.getPkValue());
        comFile.set("status", (Object)"A");
        comFile.set("supplierid", tempSupplier.getPkValue());
        comFile.set("type", (Object)"comFile");
        DynamicObject otherFile = BusinessDataServiceHelper.newDynamicObject((String)FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass()));
        otherFile.set("sectionid", bidsection.getPkValue());
        otherFile.set("status", (Object)"A");
        otherFile.set("supplierid", tempSupplier.getPkValue());
        otherFile.set("type", (Object)"otherFile");
        String formId = TenFormTypeConstants.getFormConstant((String)"bidding", ((Object)((Object)this)).getClass());
        List sourceFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)dataEntity.getPkValue(), (String)("attaother" + sectionId));
        String fileFormId = appId + "_supplier_file";
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{techFile, tenFile, comFile});
        if (!sourceFileList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{otherFile});
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                BidFileHelper.copyFileFromAToB((String)formId, (Object)dataEntity.getPkValue(), (String)("attatech" + sectionId), (String)fileFormId, (Object)techFile.getPkValue(), (String)"attachmentpanelap");
                BidFileHelper.copyFileFromAToB((String)formId, (Object)dataEntity.getPkValue(), (String)("attainvite" + sectionId), (String)fileFormId, (Object)tenFile.getPkValue(), (String)"attachmentpanelap");
                BidFileHelper.copyFileFromAToB((String)formId, (Object)dataEntity.getPkValue(), (String)("attacommerce" + sectionId), (String)fileFormId, (Object)comFile.getPkValue(), (String)"attachmentpanelap");
                if (!sourceFileList.isEmpty()) {
                    BidFileHelper.copyFileFromAToB((String)formId, (Object)dataEntity.getPkValue(), (String)("attaother" + sectionId), (String)fileFormId, (Object)otherFile.getPkValue(), (String)"attachmentpanelap");
                }
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public String getAppId(DynamicObject bidProject) {
        String appId = "bid";
        if (!bidProject.getDataEntityType().getProperties().containsKey((Object)"entitytypeid")) {
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        }
        String typeId = bidProject.getString("entitytypeid");
        int index = -1;
        if (typeId != null && (index = typeId.indexOf(95)) != -1) {
            appId = typeId.substring(0, index);
        }
        return appId;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            DynamicObject mytender = dataEntity.getDynamicObject("mytender");
            List<Map<String, String>> list = this.getIdAndName(mytender.getPkValue().toString());
            this.submitBiddingData(dataEntity, list);
            DynamicObject bidding = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)TenFormTypeConstants.getFormConstant((String)"bidding", ((Object)((Object)this)).getClass()), (String)"id,auditdate");
            bidding.set("auditdate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidding});
        }
    }

    public int parseInt(Object o) {
        if (o == null) {
            return 0;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public class Validator
    extends AbstractValidator {
        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            ExtendedDataEntity dataEntity = dataEntities[0];
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                DynamicObject mytender = (DynamicObject)dataEntities[0].getValue("mytender");
                DynamicObject bidProjectf7 = (DynamicObject)dataEntities[0].getValue("bidproject");
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectf7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"enablemultisection,isratebidding");
                Boolean enablemultisection = bidProject.getBoolean("enablemultisection");
                Boolean isRateBidding = bidProject.getBoolean("isratebidding");
                List<Map<String, String>> ids = TenBiddingOperationServicePlugin.this.getIdAndName(mytender.getPkValue().toString());
                for (int i = 0; i < ids.size(); ++i) {
                    Map<String, String> map = ids.get(i);
                    BigDecimal TenderPrice = (BigDecimal)dataEntity.getValue(TenBiddingOperationServicePlugin.TEXT_TENDERPRICE + map.get("id"));
                    BigDecimal pricevat = (BigDecimal)dataEntity.getValue(TenBiddingOperationServicePlugin.TEXT_PRICEVAT + map.get("id"));
                    Integer workDay = TenBiddingOperationServicePlugin.this.parseInt(dataEntity.getValue(TenBiddingOperationServicePlugin.TEXT_WORKDAY + map.get("id")));
                    BigDecimal rate = (BigDecimal)dataEntity.getValue(TenBiddingOperationServicePlugin.TEXT_RATE + map.get("id"));
                    if (!isRateBidding.booleanValue() && TenderPrice.compareTo(BigDecimal.ZERO) < 0) {
                        if (enablemultisection.booleanValue()) {
                            String str = String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u6295\u6807\u62a5\u4ef7\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenBiddingOperationServicePlugin_0", (String)"scm-ten-opplugin", (Object[])new Object[0]), map.get("name"));
                            this.addErrorMessage(dataEntity, str);
                        } else {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6295\u6807\u62a5\u4ef7\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenBiddingOperationServicePlugin_1", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                        }
                        return;
                    }
                    if (workDay >= 0) continue;
                    if (enablemultisection.booleanValue()) {
                        String str = String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5de5\u671f\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenBiddingOperationServicePlugin_2", (String)"scm-ten-opplugin", (Object[])new Object[0]), map.get("name"));
                        this.addErrorMessage(dataEntity, str);
                    } else {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5de5\u671f\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenBiddingOperationServicePlugin_3", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    }
                    return;
                }
            } else if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
                DynamicObject mytender = (DynamicObject)dataEntities[0].getValue("mytender");
                Object bidpublishid = dataEntity.getValue("bidpublishid");
                DynamicObject bidpublish = BusinessDataServiceHelper.loadSingle((Object)bidpublishid, (String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()));
                if (BillStatusEnum.INVALID.getVal().equals(bidpublish.get("billstatus")) || BillStatusEnum.ADJUSTING.getVal().equals(bidpublish.get("billstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u518d\u6b21\u53d1\u6807\u540e\uff0c\u4e0d\u80fd\u64a4\u6807\u3002", (String)"TenBiddingOperationServicePlugin_7", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection publishSectionColl = bidpublish.getDynamicObjectCollection("bidsection");
                boolean isRetender = false;
                Object tenderSuplierID = mytender.getDynamicObject("supplier").getPkValue();
                for (int i = 0; i < publishSectionColl.size(); ++i) {
                    DynamicObject publishSection = (DynamicObject)publishSectionColl.get(i);
                    DynamicObjectCollection supplierEntryColl = publishSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryColl) {
                        Long supplierID = supplierEntry.getDynamicObject("supplier").getLong("id");
                        String tenderstrategy = supplierEntry.getString("tenderstrategy");
                        if (!tenderSuplierID.equals(supplierID) || "UNNEEDBID".equals(tenderstrategy)) continue;
                        isRetender = true;
                    }
                }
                if (!isRetender) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u518d\u6b21\u53d1\u6807\u540e\uff0c\u4e0d\u80fd\u64a4\u6807\u3002", (String)"TenBiddingOperationServicePlugin_7", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }
}

