/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.edit;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IBidPayFileService;
import kd.scm.bid.business.bill.serviceImpl.BidPayFileServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.common.util.CommonUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class TenPayDetailEdit
extends AbstractFormPlugin
implements RowClickEventListener,
CellClickListener {
    private IBidPayFileService bidPayFileService = new BidPayFileServiceImpl();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidProjectID = formShowParameter.getCustomParam("bidProjectID");
        if (null == bidProjectID) {
            return;
        }
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectID, (String)"bid_project");
        Object orgPk = bidProject.getDynamicObject("org").getPkValue();
        this.getModel().setValue("currency", bidProject.get("currency"));
        List<Object> supplierIds = new ArrayList();
        supplierIds = "rebm_pay_list".equals(FormTypeConstants.getFormConstant((String)"pay_list", ((Object)((Object)this)).getClass())) ? SupplierUtil.getRESMSupplierByUserPkArray() : SupplierUtil.getSupplierPkArray();
        DynamicObject[] tempBidPayArray = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"pay_list", ((Object)((Object)this)).getClass()), (String)"id,status,sectionname,suresum,realsum,paytime,explain,reason,certificate,type", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectID), new QFilter("supplier.id", "in", supplierIds)});
        if (tempBidPayArray != null && tempBidPayArray.length > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            Date bidOpenDeadLine = CommonUtil.getOpenDeadLineDateFiled((DynamicObject)bidProject);
            for (int i = 0; i < tempBidPayArray.length; ++i) {
                DynamicObject temp = tempBidPayArray[i];
                String sectionName = temp.getString("sectionname");
                if (i != 0) {
                    model.createNewEntryRow("entryentity");
                }
                if ("0".equals(temp.getString("type"))) {
                    model.setValue("sectionname", (Object)ResManager.loadKDString((String)"\u6807\u4e66\u8d39", (String)"TenPayDetailEdit_0", (String)"scm-ten-formplugin", (Object[])new Object[0]), i);
                } else if (null != sectionName && !"".equals(sectionName)) {
                    String str = String.format(ResManager.loadKDString((String)"\u6295\u6807\u4fdd\u8bc1\u91d1<%s>", (String)"TenPayDetailEdit_1", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName);
                    model.setValue("sectionname", (Object)str, i);
                } else {
                    model.setValue("sectionname", (Object)ResManager.loadKDString((String)"\u6295\u6807\u4fdd\u8bc1\u91d1", (String)"TenPayDetailEdit_2", (String)"scm-ten-formplugin", (Object[])new Object[0]), i);
                }
                model.setValue("suresum", temp.get("suresum"), i);
                model.setValue("realsum", temp.get("realsum"), i);
                model.setValue("paytime", temp.get("paytime"), i);
                model.setValue("explain", temp.get("explain"), i);
                model.setValue("status", temp.get("status"), i);
                model.setValue("reason", temp.get("reason"), i);
                model.setValue("id", temp.get("id"), i);
                model.setValue("type", temp.get("type"), i);
                model.setValue("certificate", temp.get("certificate"), i);
                model.setValue("bidopendeadline", (Object)bidOpenDeadLine, i);
            }
            model.endInit();
        }
        this.getView().updateView("entryentity");
    }

    public void afterBindData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"suresum"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"realsum"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"paytime"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_reason", "btn_upload", "btn_upload1", "btn_upload2"});
    }

    public void click(EventObject var1) {
        DynamicObject entry;
        DynamicObject temp;
        int index;
        String btn_key = "";
        btn_key = var1.getSource() instanceof Label ? ((Label)var1.getSource()).getKey() : "btn_upload";
        if ("btn_reason".equals(btn_key)) {
            index = this.getModel().getEntryCurrentRowIndex("entryentity");
            temp = this.getModel().getDataEntity(true);
            entry = (DynamicObject)temp.getDynamicObjectCollection("entryentity").get(index);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", TenFormTypeConstants.getFormConstant((String)"pay_reason", ((Object)((Object)this)).getClass()));
            map.put("pkId", entry.get("id").toString());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            String status = entry.getString("status");
            DynamicObject bidPay = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"pay_list", ((Object)((Object)this)).getClass()), (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(entry.get("id").toString()))});
            String newStatus = bidPay.getString("status");
            if (!newStatus.equals(status)) {
                this.getView().invokeOperation("refresh");
            }
            if ("4".equals(newStatus)) {
                showParameter.setStatus(OperationStatus.EDIT);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "bid_pay_file");
                showParameter.setCloseCallBack(callBack);
                this.getView().showForm(showParameter);
            } else {
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(showParameter);
            }
        }
        if ("btn_upload".equals(btn_key) || "btn_upload1".equals(btn_key) || "btn_upload2".equals(btn_key)) {
            index = this.getModel().getEntryCurrentRowIndex("entryentity");
            temp = this.getModel().getDataEntity(true);
            entry = (DynamicObject)temp.getDynamicObjectCollection("entryentity").get(index);
            int certificate = entry.getInt("certificate");
            DynamicObject file = this.bidPayFileService.getOneFileRecordByPaylistid(Long.valueOf(entry.getLong("id")), "id");
            if (null != file && 0 != certificate) {
                HashMap<String, String> map = new HashMap<String, String>();
                String formId = FormTypeConstants.getFormConstant((String)"pay_file", ((Object)((Object)this)).getClass());
                map.put("formId", formId);
                String pkId = file.getString("id");
                map.put("pkId", pkId);
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                showParameter.setCustomParam("paylistid", (Object)entry.getLong("id"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(showParameter);
            } else if (null != file) {
                String pkId = file.getString("id");
                try (TXHandle h = TX.requiresNew();){
                    try {
                        BidFileHelper.removeAllFile((String)"bid_pay_file", (Object)pkId, (String)"attachmentpanelap");
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        throw ex;
                    }
                }
                MainEntityType t = EntityMetadataCache.getDataEntityType((String)"bid_pay_file");
                BusinessDataServiceHelper.delete((IDataEntityType)t, (Object[])new Object[]{pkId});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("bid_pay_file".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7f34\u8d39\u6210\u529f\u3002", (String)"TenPayDetailEdit_3", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("pay".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object bidProjectID = formShowParameter.getCustomParam("bidProjectID");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if ("rebm_pay_list".equals(FormTypeConstants.getFormConstant((String)"pay_list", ((Object)((Object)this)).getClass()))) {
                showParameter.setFormId("resp_pay");
            } else {
                showParameter.setFormId("ten_pay");
            }
            showParameter.setCustomParam("bidProjectID", bidProjectID);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "bid_pay_file");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        }
    }

    public void cellClick(CellClickEvent var1) {
    }

    public void cellDoubleClick(CellClickEvent var1) {
    }
}

