/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.edit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.formplugin.base.TenBaseFormPlugin;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class TenQuestionEditPlugin
extends TenBaseFormPlugin {
    private IBidAnswerQuestionService bidAnswerQuestionService = new BidAnswerQuestionServiceImpl();
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String BAR_CLOSE = "bar_close";
    private static final String MYTENDER = "mytender";
    private static final String BIDPROJECT = "bidproject";
    private static final String SUPPLIER = "supplier";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BAR_SAVE, BAR_SUBMIT, BAR_CLOSE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object myTenderId = formShowParameter.getCustomParam("mytenderId");
        DynamicObject myTender = BusinessDataServiceHelper.loadSingle((Object)myTenderId, (String)TenFormTypeConstants.getFormConstant((String)MYTENDER, ((Object)((Object)this)).getClass()), (String)"bidproject,bidproject.answerquestiontime,bidproject.currentstep");
        DynamicObject myTenderf7 = BusinessDataServiceHelper.loadSingle((Object)myTenderId, (String)TenFormTypeConstants.getFormConstant((String)"mytender_f7", ((Object)((Object)this)).getClass()));
        DynamicObject bidProject = myTender.getDynamicObject(BIDPROJECT);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            String questioncontent = this.getModel().getValue("questioncontent").toString();
            if (StringUtils.isEmpty((CharSequence)questioncontent)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u63d0\u95ee\u5185\u5bb9\u201d\u3002", (String)"TenQuestionEditPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue(MYTENDER, (Object)myTenderf7);
            this.getModel().setValue(BIDPROJECT, (Object)bidProject);
            if ("resp".equals(this.getAppId())) {
                this.getModel().setValue(SUPPLIER, (Object)SupplierUtil.getRESMSupplier());
            } else {
                bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
                Object orgpK = bidProject.getDynamicObject("org").getPkValue();
                DynamicObject tempSupplier = SupplierUtil.getSupplierByOrg(bidProject.getPkValue(), orgpK);
                this.getModel().setValue(SUPPLIER, (Object)tempSupplier);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            Date date = new Date();
            String pkValue = this.getModel().getDataEntity().getPkValue().toString();
            String questioncontent = this.getModel().getValue("questioncontent").toString();
            if (StringUtils.isEmpty((CharSequence)questioncontent)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u63d0\u95ee\u5185\u5bb9\u201d\u3002", (String)"TenQuestionEditPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object answerQuestionTime = bidProject.get("answerquestiontime");
            Object currentStep = bidProject.get("currentstep");
            if (currentStep != null && !currentStep.toString().contains("BidAnswerQuestion")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b54\u7591\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u63d0\u95ee\u3002", (String)"TenQuestionEditPlugin_1", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (answerQuestionTime != null) {
                try {
                    Date date1 = new Date();
                    int compareTo = date1.compareTo((Date)answerQuestionTime);
                    if (compareTo > 0) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String str = dateFormat.format(((Date)answerQuestionTime).getTime());
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u7b54\u7591\u65f6\u95f4%s\u201d\u5df2\u622a\u6b62\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u7b54\u7591\u3002", (String)"TenQuestionEditPlugin_2", (String)"scm-ten-formplugin", (Object[])new Object[0]), str));
                        args.setCancel(true);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String uid = RequestContext.get().getUserId();
            QFilter filter = new QFilter("user", "=", (Object)Long.parseLong(uid));
            String supplierId = "";
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
            Object orgpK = bidProject.getDynamicObject("org").getPkValue();
            DynamicObject partnerUser = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter[]{filter});
            DynamicObject partner = partnerUser.getDynamicObject("bizpartner");
            if (partner != null) {
                supplierId = "resp".equals(this.getAppId()) ? SupplierUtil.getRESMSupplier().getPkValue().toString() : SupplierUtil.getSupplierByOrg(bidProject.getPkValue(), orgpK).getPkValue().toString();
            }
            if (StringUtils.isNotBlank((CharSequence)supplierId)) {
                QFilter bidProjectQFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
                QFilter supplierQfilter = new QFilter("supplier.id", "=", (Object)Long.parseLong(supplierId));
                DynamicObject[] tenQuestionData = BusinessDataServiceHelper.load((String)TenFormTypeConstants.getFormConstant((String)"question", ((Object)((Object)this)).getClass()), (String)"id,questioncontent", (QFilter[])new QFilter[]{bidProjectQFilter.and(supplierQfilter)});
                if (null != tenQuestionData) {
                    for (DynamicObject question : tenQuestionData) {
                        if (StringUtils.equals((CharSequence)question.getPkValue().toString(), (CharSequence)pkValue) || !questioncontent.equals(question.getString("questioncontent"))) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f9b\u5e94\u5546\u5b58\u5728\u91cd\u590d\u7684\u63d0\u95ee\u5185\u5bb9\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TenQuestionEditPlugin_3", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
            }
            this.getModel().setValue("billno", (Object)("qustion_" + String.valueOf(date.getTime())));
            this.getModel().setValue(MYTENDER, (Object)myTenderf7);
            this.getModel().setValue(BIDPROJECT, (Object)bidProject);
            DynamicObject supplier = new DynamicObject();
            supplier = "resp".equals(this.getAppId()) ? SupplierUtil.getRESMSupplier() : SupplierUtil.getSupplierByOrg(bidProject.getPkValue(), orgpK);
            this.getModel().setValue(SUPPLIER, (Object)supplier);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperateKey().equals("submit") && args.getOperationResult().isSuccess()) {
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue(BIDPROJECT);
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
            ORM orm = ORM.create();
            DynamicObject[] records = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), (String)"id,bidanswerquestiontheme,bid_answerquestions_list,bid_answerquestions_list.questiondescribe,bid_answerquestions_list.proposedunit,bid_answerquestions_list.isfromten,bid_answerquestions_list.questionfile,bid_answerquestions_list.tenquestionid,bid_answerquestions_list.seq,bid_answerquestions_list.isillegalbid,bid_answerquestions_list.questiontime,bid_answerquestions_list.questionip,bid_answerquestions_list.questionuser,bid_answerquestions_list.questionfile_new", (QFilter[])new QFilter[]{new QFilter(BIDPROJECT, "=", (Object)bidProject.getLong("id")), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getVal())}, (String)"createtime desc");
            DynamicObject record = null;
            if (records != null && records.length > 0) {
                record = records[0];
            }
            MainEntityType answerFileType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"answer_file", ((Object)((Object)this)).getClass()));
            DynamicObject answerFile = new DynamicObject((DynamicObjectType)answerFileType);
            answerFile.set("id", (Object)ORM.create().genLongId((IDataEntityType)answerFile.getDynamicObjectType()));
            answerFile.set("status", (Object)BillStatusEnum.SAVE.getVal());
            answerFile.set("type", (Object)"questionfile");
            List attachments = AttachmentServiceHelper.getAttachments((String)TenFormTypeConstants.getFormConstant((String)"question", ((Object)((Object)this)).getClass()), (Object)this.getModel().getValue("id"), (String)"attachmentpanel");
            String ip = IsIllegalBidUtil.getLoginIp();
            if (record != null) {
                DynamicObjectCollection entry = (DynamicObjectCollection)record.get("bid_answerquestions_list");
                DynamicObject newRow = new DynamicObject(entry.getDynamicObjectType());
                newRow.set("id", (Object)ORM.create().genLongId((IDataEntityType)entry.getDynamicObjectType()));
                newRow.set("questiondescribe", this.getModel().getValue("questioncontent"));
                long supplierId = 0L;
                if ("resp".equals(this.getAppId())) {
                    DynamicObject resmSupplier = SupplierUtil.getRESMSupplier();
                    newRow.set("proposedunit", (Object)resmSupplier);
                    if (resmSupplier != null) {
                        supplierId = (Long)resmSupplier.getPkValue();
                    }
                } else {
                    newRow.set("proposedunit", this.getModel().getValue(SUPPLIER));
                    DynamicObject supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER);
                    if (supplier != null) {
                        supplierId = (Long)supplier.getPkValue();
                    }
                }
                if (attachments != null) {
                    List newAttachments = AttachmentUtil.copyToEntryAttachment((List)attachments);
                    DynamicObjectCollection questionfileNew = newRow.getDynamicObjectCollection("questionfile_new");
                    newAttachments.forEach(attachment -> questionfileNew.addNew().set("fbasedataid", attachment));
                    newRow.set("questionfile", (Object)attachments.size());
                }
                newRow.set("seq", (Object)(entry.size() + 1));
                newRow.set("isfromten", (Object)Boolean.TRUE);
                newRow.set("tenquestionid", this.getModel().getValue("id"));
                newRow.set("questiontime", (Object)new Date());
                newRow.set("isillegalbid", (Object)IsIllegalBidUtil.isIllegalBidInAnswerQuestionReco(supplierId, (Long)bidProject.getPkValue(), ip, FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), record.getString("bidanswerquestiontheme")));
                newRow.set("questionip", (Object)ip);
                newRow.set("questionuser", (Object)RequestContext.get().getCurrUserId());
                entry.add((Object)newRow);
                BusinessDataServiceHelper.save((IDataEntityType)record.getDynamicObjectType(), (Object[])new DynamicObject[]{record});
                answerFile.set("answerid", (Object)Long.parseLong(newRow.get("id").toString()));
                BusinessDataServiceHelper.save((IDataEntityType)answerFile.getDynamicObjectType(), (Object[])new DynamicObject[]{answerFile});
            } else {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()));
                record = new DynamicObject((DynamicObjectType)type);
                record.set(BIDPROJECT, (Object)bidProject);
                int numberoftimes = this.getMaxNumber(bidProject.get("id"));
                Lang lang = RequestContext.get().getLang();
                String bidanswerquestiontheme = String.format(ResManager.loadKDString((String)"\u5173\u4e8e%1$s\u7684\u7b2c%2$s\u6b21\u7b54\u7591", (String)"TenQuestionEditPlugin_4", (String)"scm-ten-formplugin", (Object[])new Object[0]), bidProject.getString("name"), String.valueOf(numberoftimes));
                if (!Lang.zh_CN.equals((Object)lang)) {
                    if (!Lang.zh_TW.equals((Object)lang)) {
                        bidanswerquestiontheme = String.format(ResManager.loadKDString((String)"\u5173\u4e8e%1$s\u7684\u7b2c%2$s\u6b21\u7b54\u7591", (String)"TenQuestionEditPlugin_4", (String)"scm-ten-formplugin", (Object[])new Object[0]), String.valueOf(numberoftimes), bidProject.getString("name"));
                    }
                }
                Date answerquestiontime = new Date();
                record.set("answerquestiontime", (Object)answerquestiontime);
                record.set("billno", bidProject.get("billno"));
                record.set("numberoftimes", (Object)numberoftimes);
                record.set("bidanswerquestiontheme", (Object)bidanswerquestiontheme);
                record.set("org", bidProject.get("org"));
                record.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                record.set("createtime", (Object)answerquestiontime);
                record.set("modifytime", (Object)answerquestiontime);
                DynamicObjectCollection entry = (DynamicObjectCollection)record.get("bid_answerquestions_list");
                DynamicObject newRow = new DynamicObject(entry.getDynamicObjectType());
                newRow.set("id", (Object)ORM.create().genLongId((IDataEntityType)entry.getDynamicObjectType()));
                newRow.set("questiondescribe", this.getModel().getValue("questioncontent"));
                long supplierId = 0L;
                if ("resp".equals(this.getAppId())) {
                    DynamicObject resmSupplier = SupplierUtil.getRESMSupplier();
                    newRow.set("proposedunit", (Object)resmSupplier);
                    if (resmSupplier != null) {
                        supplierId = (Long)resmSupplier.getPkValue();
                    }
                } else {
                    newRow.set("proposedunit", this.getModel().getValue(SUPPLIER));
                    DynamicObject supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER);
                    if (supplier != null) {
                        supplierId = (Long)supplier.getPkValue();
                    }
                }
                if (attachments != null) {
                    List newAttachments = AttachmentUtil.copyToEntryAttachment((List)attachments);
                    DynamicObjectCollection questionfileNew = newRow.getDynamicObjectCollection("questionfile_new");
                    newAttachments.forEach(attachment -> questionfileNew.addNew().set("fbasedataid", attachment));
                    newRow.set("questionfile", (Object)attachments.size());
                }
                newRow.set("seq", (Object)1);
                newRow.set("isfromten", (Object)Boolean.TRUE);
                newRow.set("tenquestionid", this.getModel().getValue("id"));
                newRow.set("isillegalbid", (Object)IsIllegalBidUtil.isIllegalBidInAnswerQuestionReco(supplierId, (Long)bidProject.getPkValue(), ip, FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), bidanswerquestiontheme));
                newRow.set("questiontime", (Object)new Date());
                newRow.set("questionip", (Object)ip);
                newRow.set("questionuser", (Object)RequestContext.get().getCurrUserId());
                entry.add((Object)newRow);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), (DynamicObject[])new DynamicObject[]{record}, (OperateOption)option);
                if (!operationResult.isSuccess()) {
                    try {
                        throw new Exception(operationResult.getMessage());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                answerFile.set("answerid", newRow.get("id"));
                BusinessDataServiceHelper.save((IDataEntityType)answerFile.getDynamicObjectType(), (Object[])new DynamicObject[]{answerFile});
            }
            this.bidAnswerQuestionService.updateAnswerCount(bidProject, null, true);
            try (TXHandle h = TX.requiresNew();){
                try {
                    BidFileHelper.copyFileFromAToB((String)TenFormTypeConstants.getFormConstant((String)"question", ((Object)((Object)this)).getClass()), (Object)this.getModel().getValue("id"), (String)"attachmentpanel", (String)FormTypeConstants.getFormConstant((String)"answer_file", ((Object)((Object)this)).getClass()), (Object)answerFile.get("id"), (String)"attachmentpanelap");
                }
                catch (Throwable ex) {
                    h.markRollback();
                    throw ex;
                }
            }
            this.sendMessage(bidProject, record);
        }
    }

    private int getMaxNumber(Object bidProjectId) {
        QFilter bidProjectIdFilter = new QFilter(BIDPROJECT, "=", bidProjectId);
        DynamicObject[] recoArr = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), (String)"id,numberoftimes", (QFilter[])new QFilter[]{bidProjectIdFilter});
        int maxNumber = 1;
        for (int i = 0; i < recoArr.length; ++i) {
            int numberoftimes = recoArr[i].getInt("numberoftimes");
            if (numberoftimes < maxNumber) continue;
            maxNumber = numberoftimes + 1;
        }
        return maxNumber;
    }

    private String getAppId() {
        return this.getModel().getDataEntityType().getAppId();
    }

    private void sendMessage(DynamicObject bidProject, DynamicObject record) {
        Object id = record.get("id");
        String projectName = bidProject.getString("name");
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject supplier = SupplierUtil.getSupplier();
        msgParam.put("pkId", id);
        msgParam.put("id", dataEntity.getPkValue());
        msgParam.put("title", null);
        msgParam.put("content", null);
        if ("ten".equals(this.getModel().getDataEntityType().getAppId())) {
            msgParam.put("appId", "bid");
            msgParam.put("formId", "bid_answerquestion_reco");
            msgParam.put("msgentity", "ten_question");
            msgParam.put("tplScene", "ten_question");
        } else {
            msgParam.put("appId", "rebm");
            msgParam.put("formId", "rebm_answerquestion_reco");
            msgParam.put("msgentity", "resp_question");
            msgParam.put("tplScene", "resp_question");
        }
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        msgParam.put("operation", "submit");
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        DynamicObject bidproject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        DynamicObjectCollection memberColl = bidproject.getDynamicObjectCollection("memberentity");
        for (DynamicObject member : memberColl) {
            String[] values = member.getString("respbusiness").split(",");
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    if (!"10".equals(values[i])) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!member.getBoolean("isdirector")) continue;
            memberSet.add(member.getDynamicObject("user"));
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        String notifyType = MessageChannelUtil.getNotifyType((String)"ten_question", (String)"ten_question");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
    }
}

