/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.edit;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.ten.common.util.TipsUtil;
import kd.scm.ten.formplugin.base.TenBaseFormPlugin;
import kd.scm.ten.formplugin.util.ResmSupplierBlackUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class TenRegistrationPreviewEditPlugin
extends TenBaseFormPlugin
implements ClickListener,
CountDownListener {
    private static final String KEY_MYFIELDCONTAINER = "checkpanel";
    private static final String ITEM_REGISTER = "register";
    private static final String ENROLLSUPPLIER = "enrollsupplier";
    private static final String ENROLLSUPPLIERCONTACT = "enrollsuppliercontact";
    private static final String ENROLLCONTACTPHONE = "enrollcontactphone";
    private static final String ENROLLADDRESS = "enrolladdress";
    private static final String ENROLLFAX = "enrollfax";
    private static final String ENROLLEMAIL = "enrollemail";
    private static final String BIDPROJECT = "bidproject";
    private static final String ANNOUNCEMENT = "announcement";
    private static final String BOS_BIZPARTNERUSER = "bos_bizpartneruser";
    private static final String BD_BIZPARTNER = "bd_bizpartner";
    private static final String ATTACHMENT_PANEL_AP = "attachmentpanelap";
    private static final String UPLOAD_FILE = "uploadfile";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CountDown cd = (CountDown)this.getControl("countdownap");
        cd.addCountDownListener((CountDownListener)this);
        if ("ten".equals(this.getAppId())) {
            CountDown uscd = (CountDown)this.getControl("countdownapus");
            uscd.addCountDownListener((CountDownListener)this);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Object bidproject = formShowParameter.getCustomParam(BIDPROJECT);
        DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)bidproject, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        Boolean enablemultisection = (Boolean)bid_project.get("enablemultisection");
        if (enablemultisection.booleanValue()) {
            DynamicObjectCollection colls = SupplierUtil.getSupplierInvitation(bidproject.toString());
            FlexPanelAp headAp = this.createDynamicPanel(colls);
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", KEY_MYFIELDCONTAINER);
            mapHead.put("items", (String)headAp.createControl().get("items"));
            e.getItems().add(mapHead);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("DynamicCreateCardEntry", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidproject = formShowParameter.getCustomParam(BIDPROJECT);
        DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)bidproject, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        Boolean enablemultisection = (Boolean)bid_project.get("enablemultisection");
        if (enablemultisection.booleanValue()) {
            DynamicObjectCollection colls = SupplierUtil.getSupplierInvitation(bidproject.toString());
            for (DynamicObject temp : colls) {
                dataEntity.set("section" + temp.getPkValue(), (Object)Boolean.FALSE);
                e.setDataEntity((Object)dataEntity);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidproject = formShowParameter.getCustomParam(BIDPROJECT);
        Object announcementId = formShowParameter.getCustomParam(ANNOUNCEMENT);
        DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)bidproject, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        Boolean enablemultisection = (Boolean)bid_project.get("enablemultisection");
        if (enablemultisection.booleanValue()) {
            DynamicObjectCollection colls = SupplierUtil.getSupplierInvitation(bidproject.toString());
            FlexPanelAp dynamicPanel = this.createDynamicPanel(colls);
            Container myFldPanel = (Container)this.getView().getControl(KEY_MYFIELDCONTAINER);
            myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(myFldPanel.getItems());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidinfopanel", "flexpanelap3"});
        }
        String uid = RequestContext.get().getUserId();
        String enrolldeadline = bid_project.getString("enrolldeadline");
        String tempDate = null;
        tempDate = enrolldeadline.indexOf(46) != -1 ? enrolldeadline.substring(0, enrolldeadline.indexOf(46)).replace('-', '/') : enrolldeadline.replace('-', '/');
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            Date date = sdf.parse(tempDate);
            Date nowDate = new Date();
            Long now = nowDate.getTime();
            Long target = date.getTime();
            Long timeDiff = (target - now) / 1000L;
            CountDown cd = (CountDown)this.getControl("countdownap");
            if (timeDiff >= 0L) {
                cd.setDuration(Integer.parseInt(timeDiff + ""));
            } else {
                cd.setDuration(0);
            }
            CountDown uscd = (CountDown)this.getControl("countdownapus");
            if (timeDiff >= 0L) {
                uscd.setDuration(Integer.parseInt(timeDiff + ""));
            } else {
                uscd.setDuration(0);
            }
            uscd.start();
            cd.start();
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"countdownap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"countdownapus"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"countdownap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"countdownapus"});
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user");
        DynamicObject obj = this.getPartner();
        if (obj == null) {
            return;
        }
        Object name = obj.get("name");
        Object address = obj.get("address");
        Object fax = obj.get("fax");
        Object username = user.get("name");
        Object phone = user.get("phone");
        Object email = user.get("email");
        this.getModel().setValue(ENROLLSUPPLIER, name);
        this.getModel().setValue(ENROLLSUPPLIERCONTACT, username);
        this.getModel().setValue(ENROLLCONTACTPHONE, phone);
        this.getModel().setValue(ENROLLADDRESS, address);
        this.getModel().setValue(ENROLLFAX, fax);
        this.getModel().setValue(ENROLLEMAIL, email);
        this.getModel().setValue(BIDPROJECT, bidproject);
        this.getModel().setValue(ANNOUNCEMENT, announcementId);
    }

    public DynamicObject getPartner() {
        return SupplierUtil.getPartner();
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().startsWith("section")) {
            FieldEdit textEdit = new FieldEdit();
            textEdit.setKey(e.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    private FlexPanelAp createDynamicPanel(DynamicObjectCollection colls) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("12px");
        style.setMargin(margin);
        for (DynamicObject temp : colls) {
            FieldAp checkboxAp = new FieldAp();
            checkboxAp.setId("section" + temp.getPkValue());
            checkboxAp.setKey("section" + temp.getPkValue());
            checkboxAp.setName(new LocaleString(temp.getString("entrysectionname")));
            checkboxAp.setBackColor("#FFFFFF");
            checkboxAp.setStyle(style);
            checkboxAp.setFireUpdEvt(true);
            checkboxAp.setWidth(new LocaleString("90px"));
            checkboxAp.setHeight(new LocaleString("20px"));
            CheckBoxField checkboxField = new CheckBoxField();
            checkboxField.setId("section" + temp.getPkValue());
            checkboxField.setKey("section" + temp.getPkValue());
            checkboxField.setDefValue(true);
            checkboxField.setShowStyle(1);
            checkboxAp.setField((Field)checkboxField);
            headPanelAp.getItems().add(checkboxAp);
        }
        return headPanelAp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidproject = formShowParameter.getCustomParam(BIDPROJECT);
        DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)bidproject, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        Boolean enablemultisection = (Boolean)bid_project.get("enablemultisection");
        if (enablemultisection.booleanValue()) {
            DynamicObjectCollection colls = SupplierUtil.getSupplierInvitation(bidproject.toString());
            for (DynamicObject temp : colls) {
                BooleanProp boolProp1 = new BooleanProp();
                boolProp1.setName("section" + temp.getPkValue());
                boolProp1.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u590d\u9009\u6846", (String)"TenRegistrationPreviewEditPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0])));
                boolProp1.setDbIgnore(true);
                boolProp1.setAlias("");
                boolProp1.setDefaultValue((Object)Boolean.TRUE);
                newMainType.registerSimpleProperty((DynamicSimpleProperty)boolProp1);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidProjectId = formShowParameter.getCustomParam(BIDPROJECT);
        String appId = formShowParameter.getFormId().split("_")[0];
        DynamicObject bidProject = null;
        if ("resp".equals(appId)) {
            appId = "resp";
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"enablemultisection,org,suppliergroup");
        } else {
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"enablemultisection,org");
        }
        if (operateKey.equals(ITEM_REGISTER)) {
            if (StringUtils.equals((CharSequence)"resp", (CharSequence)appId)) {
                DynamicObject resmOfficialSupplier;
                DynamicObject applyObject = BusinessDataServiceHelper.loadSingle((String)"resp_apply", (String)"org", (QFilter[])new QFilter[]{new QFilter("project.id", "=", bidProjectId)});
                DynamicObject orgObject = applyObject.getDynamicObject("org");
                Object bidOrgId = orgObject.getPkValue();
                DynamicObject supplier = SupplierUtil.getRESMSupplier();
                if (supplier != null && (resmOfficialSupplier = BusinessDataServiceHelper.loadSingle((Object)supplier.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"resm_official_supplier"))) != null) {
                    List<Object> unqualifiedGroupList;
                    Object belongOrg;
                    List<Object> backSupplierList = ResmSupplierBlackUtil.getOrgBlackSupplierIdList(bidOrgId);
                    if (!CollectionUtils.isEmpty(backSupplierList) && backSupplierList.contains(resmOfficialSupplier.getPkValue())) {
                        this.getView().showTipNotification(TipsUtil.getTipsTextByNumber((String)"resp", (String)"apply_tips_0"));
                        args.setCancel(true);
                        return;
                    }
                    DynamicObjectCollection requiredSupplierGroupCol = bidProject.getDynamicObjectCollection("suppliergroup");
                    ArrayList<Object> requiredSupplierGroupList = new ArrayList<Object>();
                    for (DynamicObject requiredSupplierGroup : requiredSupplierGroupCol) {
                        DynamicObject baseData = requiredSupplierGroup.getDynamicObject("fbasedataid");
                        if (baseData == null) continue;
                        requiredSupplierGroupList.add(baseData.getPkValue());
                    }
                    boolean serviceOrgFlag = false;
                    DynamicObjectCollection orgEntryCol = resmOfficialSupplier.getDynamicObjectCollection("entry_org");
                    ArrayList<Object> resmSupplierGroupList = new ArrayList<Object>();
                    for (DynamicObject orgEntry : orgEntryCol) {
                        belongOrg = orgEntry.getDynamicObject("belongorg");
                        if (!bidOrgId.equals(belongOrg.getPkValue())) continue;
                        serviceOrgFlag = true;
                        DynamicObjectCollection dynamicObjectCollection = orgEntry.getDynamicObjectCollection("entry_org_group");
                        for (DynamicObject dynamicObject : dynamicObjectCollection) {
                            DynamicObject supplierGroup5 = dynamicObject.getDynamicObject("suppliergroup");
                            resmSupplierGroupList.add(supplierGroup5.getPkValue());
                        }
                    }
                    if (!serviceOrgFlag) {
                        bidOrgId = resmOfficialSupplier.getDynamicObject("createorg").getPkValue();
                        for (DynamicObject orgEntry : orgEntryCol) {
                            belongOrg = orgEntry.getDynamicObject("belongorg");
                            if (!bidOrgId.equals(belongOrg.getPkValue())) continue;
                            DynamicObjectCollection dynamicObjectCollection = orgEntry.getDynamicObjectCollection("entry_org_group");
                            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                                Object supplierGroup = dynamicObject.getDynamicObject("suppliergroup");
                                resmSupplierGroupList.add(supplierGroup.getPkValue());
                            }
                        }
                    }
                    TreeSet unqualifiedFrozenGroupSet = new TreeSet();
                    List<Object> frozenGroupList = ResmSupplierBlackUtil.getFrozenGroups(supplier.getPkValue(), bidOrgId);
                    if (!CollectionUtils.isEmpty(frozenGroupList)) {
                        for (Object e : resmSupplierGroupList) {
                            if (!frozenGroupList.contains(e)) continue;
                            unqualifiedFrozenGroupSet.add(e);
                        }
                    }
                    if (!CollectionUtils.isEmpty(unqualifiedGroupList = ResmSupplierBlackUtil.getUnqualifiredGroups(supplier.getPkValue(), bidOrgId))) {
                        for (Object e : resmSupplierGroupList) {
                            if (!unqualifiedGroupList.contains(e)) continue;
                            unqualifiedFrozenGroupSet.add(e);
                        }
                    }
                    if (CollectionUtils.isEmpty(requiredSupplierGroupList)) {
                        if (!CollectionUtils.isEmpty(unqualifiedFrozenGroupSet)) {
                            boolean bl;
                            boolean bl2 = true;
                            for (Object e : resmSupplierGroupList) {
                                if (unqualifiedFrozenGroupSet.contains(e)) continue;
                                bl = false;
                            }
                            if (bl) {
                                this.getView().showTipNotification(TipsUtil.getTipsTextByNumber((String)"resp", (String)"apply_tips_1"));
                                args.setCancel(true);
                                return;
                            }
                        }
                    } else {
                        boolean bl;
                        if (CollectionUtils.isEmpty(resmSupplierGroupList)) {
                            this.getView().showTipNotification(TipsUtil.getTipsTextByNumber((String)"resp", (String)"apply_tips_2"));
                            args.setCancel(true);
                            return;
                        }
                        List list = requiredSupplierGroupList.stream().filter(item -> resmSupplierGroupList.contains(item)).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(list)) {
                            this.getView().showTipNotification(TipsUtil.getTipsTextByNumber((String)"resp", (String)"apply_tips_2"));
                            args.setCancel(true);
                            return;
                        }
                        boolean bl3 = false;
                        for (Object supplierGroup : list) {
                            if (!unqualifiedFrozenGroupSet.contains(supplierGroup)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            this.getView().showTipNotification(TipsUtil.getTipsTextByNumber((String)"resp", (String)"apply_tips_2"));
                            args.setCancel(true);
                            return;
                        }
                    }
                }
            }
        } else if (UPLOAD_FILE.equals(operateKey)) {
            DynamicObject supplier = null;
            supplier = "ten".equals(this.getAppId()) ? SupplierUtil.getSupplierByOrg(bidProject.getPkValue(), bidProject.getDynamicObject("org").getPkValue()) : SupplierUtil.getRESMSupplier();
            if (supplier == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u4f9b\u5e94\u5546\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TenRegistrationPreviewEditPlugin_7", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object announcementId = formShowParameter.getCustomParam(ANNOUNCEMENT);
            BillShowParameter billShowParameter = new BillShowParameter();
            String registerInviteFileFormId = this.getAppId() + "_register_invite_file";
            DynamicObject registerInviteFile = BusinessDataServiceHelper.loadSingle((String)registerInviteFileFormId, (String)"id,type,supplierid,bidprojectid, announcementid", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)ITEM_REGISTER), new QFilter("supplierId", "=", supplier.getPkValue()), new QFilter("bidprojectid", "=", bidProject.getPkValue()), new QFilter("announcementid", "=", (Object)Long.valueOf(announcementId.toString()))});
            if (registerInviteFile != null) {
                billShowParameter.setPkId(registerInviteFile.getPkValue());
            }
            billShowParameter.setCustomParam("type", (Object)ITEM_REGISTER);
            billShowParameter.setCustomParam("supplierId", supplier.getPkValue());
            billShowParameter.setCustomParam("bidProjectId", bidProject.getPkValue());
            billShowParameter.setCustomParam("announcementId", (Object)Long.valueOf(announcementId.toString()));
            billShowParameter.setCustomParam("appId", (Object)this.getAppId());
            billShowParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u540d\u9644\u4ef6\u4e0a\u4f20", (String)"TenRegistrationPreviewEditPlugin_6", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setFormId(this.getAppId() + "_register_invite_file");
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(ITEM_REGISTER) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    private String getAppId() {
        return ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
    }
}

