/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.list;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.ten.formplugin.base.TenBaseListPlugin;

public class QuestionAnswerListPlugin
extends TenBaseListPlugin {
    private Long bidProjectId = 0L;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object bidProjectIdObj = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
        if (bidProjectIdObj != null) {
            this.bidProjectId = Long.parseLong(bidProjectIdObj.toString());
        }
    }

    public void setFilter(SetFilterEvent setfilterevent) {
        if (this.bidProjectId != 0L) {
            QFilter qfilter = new QFilter("bidProject.id", "=", (Object)this.bidProjectId);
            setfilterevent.addCustomQFilter(qfilter);
            super.setFilter(setfilterevent);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObject[] records;
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ListSelectedRow selectedRow = selectedRows.get(0);
        Long id = (Long)selectedRow.getPrimaryKeyValue();
        if (key.equals("questionfile")) {
            List attachment = AttachmentServiceHelper.getAttachments((String)"ten_question", (Object)id, (String)"attachmentpanel");
            if (attachment.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u201c\u63d0\u95ee\u9644\u4ef6\u201d\u3002", (String)"QuestionAnswerListPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            }
            for (int j = 0; j < attachment.size(); ++j) {
                Map atta = (Map)attachment.get(j);
                String url = atta.get("url").toString();
                this.getView().download(url);
            }
        } else if (key.equals("answerfile") && (records = BusinessDataServiceHelper.load((String)"bid_answerquestion_reco", (String)"id,bid_answerquestions_list,bid_answerquestions_list.id,bid_answerquestions_list.tenquestionid", (QFilter[])new QFilter[]{new QFilter("bid_answerquestions_list.tenquestionid", "=", (Object)String.valueOf(id))})) != null && records.length > 0) {
            DynamicObject record = records[0];
            DynamicObjectCollection coll = record.getDynamicObjectCollection("bid_answerquestions_list");
            HashSet<Object> answers = new HashSet<Object>();
            if (!coll.isEmpty()) {
                for (int i = 0; i < coll.size(); ++i) {
                    DynamicObject entry = (DynamicObject)coll.get(i);
                    answers.add(entry.get("id"));
                }
            }
            QFilter qFilter = new QFilter("answerid", "in", answers);
            qFilter.and(new QFilter("type", "=", (Object)"answerfile"));
            DynamicObject[] files = BusinessDataServiceHelper.load((String)"bid_answer_file", (String)"id,type,answerid", (QFilter[])new QFilter[]{qFilter});
            HashSet<String> fileUrlSet = new HashSet<String>();
            if (files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    DynamicObject entry = files[i];
                    String questionEntryId = entry.getString("id");
                    List attachment = AttachmentServiceHelper.getAttachments((String)"bid_answer_file", (Object)questionEntryId, (String)"attachmentpanelap");
                    for (int j = 0; j < attachment.size(); ++j) {
                        Map atta = (Map)attachment.get(j);
                        String url = atta.get("url").toString();
                        this.getView().download(url);
                        fileUrlSet.add(url);
                    }
                }
            }
            if (fileUrlSet.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u201c\u7b54\u590d\u9644\u4ef6\u201d\u3002", (String)"QuestionAnswerListPlugin_1", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            }
        }
    }

    static class MyListDataProvider
    extends ListDataProvider {
        private static final String KEY_CREATOR_ID = "creator.id";
        private static final String KEY_MY_QUESTION = "myquestion";

        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            String userId = RequestContext.get().getUserId();
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            for (DynamicObject row : rows) {
                String creatorId = row.get(KEY_CREATOR_ID).toString();
                if (userId.equals(creatorId)) {
                    row.set(KEY_MY_QUESTION, (Object)Boolean.TRUE);
                    continue;
                }
                row.set(KEY_MY_QUESTION, (Object)Boolean.FALSE);
            }
            return rows;
        }
    }
}

