/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.ten.common.util.AppIdUtil;

public class BidMessageUtil {
    public static void sendRevokeBidMessage(String appId, DynamicObject onlineBid, DynamicObject bidProject, DynamicObject bidOpen, DynamicObject supplier) {
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        String projectName = bidProject.getString("name");
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("pkId", bidOpen.getPkValue());
        msgParam.put("id", onlineBid.getPkValue());
        if ("ten".equals(AppIdUtil.getTenAppId((String)appId))) {
            msgParam.put("appId", "bid");
            msgParam.put("formId", "bid_bidopen");
            msgParam.put("msgentity", "ten_online_bid");
            msgParam.put("tplScene", "ten_bidding_withdraw");
        } else {
            msgParam.put("appId", "rebm");
            msgParam.put("formId", "rebm_bidopen");
            msgParam.put("msgentity", "resp_online_bid");
            msgParam.put("tplScene", "resp_bidding_withdraw");
        }
        if ("bid".equals(appId)) {
            msgParam.put("notifyType", MessageChannelUtil.getNotifyType((String)"ten_bidding_withdraw", (String)"ten_online_bid"));
        } else {
            msgParam.put("notifyType", MessageChannelUtil.getNotifyType((String)"resp_bidding_withdraw", (String)"resp_online_bid"));
        }
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        msgParam.put("operation", "unsubmit");
        List<Long> receiveUserIds = BidMessageUtil.getMemberUserByBidProjectId(appId, bidProject.getPkValue());
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds);
    }

    public static void sendMsgByUntender(String appId, DynamicObject unTenderConfirm) {
        String orgname = unTenderConfirm.getString("orgname");
        DynamicObject bidProject = unTenderConfirm.getDynamicObject("bidproject");
        String projectName = bidProject.getString("name");
        QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        qFilter.and(new QFilter("billstatus", "in", (Object)new String[]{"D", "A"}));
        String bidOpenFormId = "ten".equals(appId) ? "bid_bidopen" : "rebm_bidopen";
        DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)bidOpenFormId, (String)"billstatus", (QFilter[])qFilter.toArray());
        if (bidOpenArray.length == 0) {
            BizLog.log((String)"sendMsgByUntender====bidpen is not find");
            return;
        }
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("pkId", bidOpenArray[0].getPkValue());
        msgParam.put("id", unTenderConfirm.getPkValue());
        msgParam.put("appId", "bid");
        msgParam.put("formId", "bid_bidopen");
        msgParam.put("msgentity", "ten_untender_confirm");
        msgParam.put("tplScene", "ten_untender_confirm");
        msgParam.put("notifyType", MessageChannelUtil.getNotifyType((String)"ten_untender_confirm", (String)"ten_untender_confirm"));
        if (Arrays.asList("resp", "rebm").contains(appId)) {
            msgParam.put("appId", "rebm");
            msgParam.put("formId", "rebm_bidopen");
            msgParam.put("msgentity", "ten_untender_confirm");
            msgParam.put("tplScene", "ten_untender_confirm");
        }
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        msgParam.put("operation", "confirm");
        List<Long> receiveUserIds = BidMessageUtil.getMemberUserByBidProjectId(appId, bidProject.getPkValue());
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds);
    }

    public static List<Long> getMemberUserByBidProjectId(String appId, Object bidProjectId) {
        ArrayList<Long> receiveList = new ArrayList<Long>();
        String formId = "bid_project";
        if (Arrays.asList("resp", "rebm").contains(appId)) {
            formId = "rebm_project";
        }
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("memberentity");
        joiner.add("respbusiness");
        joiner.add("user");
        joiner.add("isdirector");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)formId, (String)joiner.toString());
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        ArrayList<String> openBusList = new ArrayList<String>();
        openBusList.add("06");
        openBusList.add("11");
        openBusList.add("12");
        for (DynamicObject member : memberColl) {
            DynamicObject user;
            String[] respbusinessArr = member.getString("respbusiness").split(",");
            boolean isdirector = member.getBoolean("isdirector");
            boolean isHasOpen = Arrays.stream(respbusinessArr).anyMatch(bus -> openBusList.contains(bus));
            if (!isdirector && !isHasOpen || (user = member.getDynamicObject("user")) == null) continue;
            receiveList.add(user.getLong("id"));
        }
        return receiveList;
    }
}

