/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.ten.common.util.AppIdUtil;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.common.util.CommonUtil;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;
import kd.scm.ten.formplugin.util.TenderRecordUtil;

public class ConfirmBidUtil {
    private static final String TECH_SUFFIX = "_tech";
    private static final String BUS_SUFFIX = "_bus";
    private static final String OTHER_SUFFIX = "_other";

    public synchronized void confirmBid(DynamicObject onlineBidData) {
        BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u6570\u636e\u5f00\u59cb", (String)"ConfirmBidUtil_7", (String)"scm-ten-formplugin", (Object[])new Object[0]));
        DynamicObject bidProject = onlineBidData.getDynamicObject("bidproject");
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(appId + "_project"));
        ArrayList<String> currentSectionList = new ArrayList<String>();
        DynamicObjectCollection sectionEntryCol = onlineBidData.getDynamicObjectCollection("sectionentry");
        for (DynamicObject sectionEntry : sectionEntryCol) {
            String sectionStatus = sectionEntry.getString("sectionstatus");
            Boolean currentRoundFlag = sectionEntry.getBoolean("currentroundflag");
            if (!currentRoundFlag.booleanValue() || !MyTenderStatus.PRETENDERED.getValue().equals(sectionStatus)) continue;
            sectionEntry.set("sectionstatus", (Object)MyTenderStatus.TENDERED.getValue());
            currentSectionList.add(sectionEntry.getString("sectionname"));
        }
        BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u6807\u6bb5\u4fe1\u606f\uff1a", (String)"ConfirmBidUtil_8", (String)"scm-ten-formplugin", (Object[])new Object[0]) + JSON.toJSONString(currentSectionList)));
        if (!CollectionUtils.isEmpty(currentSectionList)) {
            DynamicObject supplier = null;
            if ("bid".equals(appId)) {
                supplier = SupplierUtil.getSupplier();
            } else if ("rebm".equals(appId)) {
                supplier = SupplierUtil.getRESMSupplier();
            }
            String tenAppId = AppIdUtil.getTenAppId((String)appId);
            String onlineBidDetailFormId = tenAppId + "_online_bid_detail";
            DynamicObject[] onlineBidDetailArray = BusinessDataServiceHelper.load((String)onlineBidDetailFormId, (String)CommonUtil.getAllSelectProperties((String)onlineBidDetailFormId), (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidData.getPkValue()), new QFilter("sectionname", "in", currentSectionList)});
            String bidOpenFormId = appId + "_bidopen";
            DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)bidOpenFormId, (String)CommonUtil.getAllSelectProperties((String)bidOpenFormId), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX", "J"})}, (String)"createtime asc");
            if (bidOpenArray == null || bidOpenArray.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f00\u6807\u6570\u636e\uff0c\u6570\u636e\u5f02\u5e38\u3002", (String)"ConfirmBidUtil_5", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            }
            this.saveBidOpenData(appId, onlineBidData, supplier, currentSectionList, onlineBidDetailArray, bidOpenArray);
            this.sendMessageToMember(appId, onlineBidData, bidOpenArray[0], bidProject);
            BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u53d1\u9001\u4fe1\u606f\u6210\u529f\uff1a", (String)"ConfirmBidUtil_9", (String)"scm-ten-formplugin", (Object[])new Object[0]) + onlineBidData.getPkValue()));
        }
    }

    public void saveBidOpenData(String appId, DynamicObject onlineBidData, DynamicObject supplier, List<String> currentSectionList, DynamicObject[] onlineBidDetailArray, DynamicObject[] bidOpenArray) {
        HashMap<Object, DynamicObject> supplierMap = new HashMap<Object, DynamicObject>(16);
        HashMap<String, DynamicObject> onlineBidDetailMap = new HashMap<String, DynamicObject>(16);
        ArrayList<Object> onlineBidDetailPkList = new ArrayList<Object>();
        ArrayList<Object> allBidOpenSectionIdList = new ArrayList<Object>();
        try {
            Map map;
            Map busFileMap;
            Map techFileMap;
            for (DynamicObject onlineBidDetail : onlineBidDetailArray) {
                String sectionName = onlineBidDetail.getString("sectionname");
                onlineBidDetailMap.put(sectionName, onlineBidDetail);
                onlineBidDetailPkList.add(onlineBidDetail.getPkValue());
                onlineBidDetail.set("onlinebidid", onlineBidData.getPkValue());
                onlineBidDetail.set("sectionstatus", (Object)MyTenderStatus.TENDERED.getValue());
                onlineBidDetail.set("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
            }
            String onlineBidDetailFormId = AppIdUtil.getTenAppId((String)appId) + "_online_bid_detail";
            HashMap<String, List<Map<String, Object>>> fileMap = new HashMap<String, List<Map<String, Object>>>(5);
            List inviteFileList = AttachmentServiceHelper.getAttachments((String)(AppIdUtil.getTenAppId((String)appId) + "_online_bid"), (Object)onlineBidData.getPkValue(), (String)"inviteattachment", (boolean)false);
            if (!CollectionUtils.isEmpty((Collection)inviteFileList)) {
                fileMap.put(onlineBidData.getPkValue().toString(), inviteFileList);
            }
            if (!CollectionUtils.isEmpty((Map)(techFileMap = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"techattachment", (boolean)false)))) {
                for (Map.Entry entry : techFileMap.entrySet()) {
                    List list = (List)entry.getValue();
                    if (CollectionUtils.isEmpty((Collection)list)) continue;
                    fileMap.put((String)entry.getKey() + TECH_SUFFIX, list);
                }
            }
            if (!CollectionUtils.isEmpty((Map)(busFileMap = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"busattachment", (boolean)false)))) {
                for (Map.Entry entry : busFileMap.entrySet()) {
                    List list = (List)entry.getValue();
                    if (CollectionUtils.isEmpty((Collection)list)) continue;
                    fileMap.put((String)entry.getKey() + BUS_SUFFIX, list);
                }
            }
            if (!CollectionUtils.isEmpty((Map)(map = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"otherattachment", (boolean)false)))) {
                for (Map.Entry entry : map.entrySet()) {
                    List fileList = (List)entry.getValue();
                    if (CollectionUtils.isEmpty((Collection)fileList)) continue;
                    fileMap.put((String)entry.getKey() + OTHER_SUFFIX, fileList);
                }
            }
            if ("bid".equals(appId)) {
                DynamicObject[] dynamicObjectArray;
                for (DynamicObject tempSupplier : dynamicObjectArray = SupplierUtil.getSupplierByUser()) {
                    supplierMap.put(tempSupplier.getPkValue(), tempSupplier);
                }
            } else if ("rebm".equals(appId)) {
                supplierMap.put(supplier.getPkValue(), supplier);
            }
            this.setBidOpenData(appId, onlineBidData, onlineBidDetailMap, fileMap, bidOpenArray, supplierMap, supplier, allBidOpenSectionIdList);
            SaveServiceHelper.save((DynamicObject[])bidOpenArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199--\u5f00\u6807\u5355\u6210\u529f\uff01", (String)"ConfirmBidUtil_10", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            SaveServiceHelper.save((DynamicObject[])onlineBidDetailArray);
            onlineBidData.set("tenderstatus", (Object)MyTenderStatus.TENDERED.getValue());
            onlineBidData.set("biddate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{onlineBidData});
            ConfirmBidUtil.updateMyTenderStatus(onlineBidData, currentSectionList, MyTenderStatus.TENDERED);
            TenderRecordUtil.createTenderRecordDataV2(onlineBidData, appId, true, currentSectionList, bidOpenArray);
        }
        catch (Exception e) {
            onlineBidData.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
            onlineBidData.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            onlineBidData.set("biddate", null);
            onlineBidData.getDynamicObjectCollection("sectionentry").clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{onlineBidData});
            for (DynamicObject onlineBidDetail : onlineBidDetailArray) {
                onlineBidDetail.set("onlinebidid", onlineBidData.getPkValue());
                onlineBidDetail.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
                onlineBidDetail.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            }
            SaveServiceHelper.save((DynamicObject[])onlineBidDetailArray);
            ConfirmBidUtil.updateMyTenderStatus(onlineBidData, currentSectionList, MyTenderStatus.PRETENDERED);
            ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u56de\u6eda\u6210\u529f\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u8bd5\u3002\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"ConfirmBidUtil_6", (String)"scm-ten-formplugin", (Object[])new Object[0]);
            throw new KDBizException(e.getMessage());
        }
    }

    public void setBidOpenData(String appId, DynamicObject onlineBid, HashMap<String, DynamicObject> onlineBidDetailMap, HashMap<String, List<Map<String, Object>>> fileMap, DynamicObject[] bidOpenArray, Map<Object, DynamicObject> supplierMap, DynamicObject supplier, List<Object> bidOpenSectionIdList) {
        String ip = IsIllegalBidUtil.getLoginIp();
        HashMap<String, DynamicObject> bidOpenDetailMap = new HashMap<String, DynamicObject>();
        for (DynamicObject bidOpen : bidOpenArray) {
            Object sectionName;
            BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\u5355id\uff1a", (String)"ConfirmBidUtil_11", (String)"scm-ten-formplugin", (Object[])new Object[0]) + bidOpen.getPkValue()));
            DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                sectionName = bidSection.getString("sectionname");
                DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierEntryColl.size(); ++j) {
                    DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                    DynamicObject bidOpenSupplier = supplierEntry.getDynamicObject("supplier");
                    boolean flag = supplierMap.containsKey(bidOpenSupplier.getPkValue());
                    DynamicObject onlineBidDetail = onlineBidDetailMap.get(sectionName);
                    if (!flag || onlineBidDetail == null) continue;
                    bidOpenSectionIdList.add(bidSection.getPkValue());
                    supplierEntry.set("supplier_istender", (Object)Boolean.TRUE);
                    supplierEntry.set("supplier_tenderdate", (Object)new Date());
                    supplierEntry.set("supplier_isfrombackbid", (Object)Boolean.TRUE);
                    supplierEntry.set("supplier_revokebidnumber", (Object)onlineBid.getInt("revokebidnumber"));
                    supplierEntry.set("supplier_manager", onlineBidDetail.get("projectmanage"));
                    supplierEntry.set("supplier_tenderprice", onlineBidDetail.get("tenderprice"));
                    supplierEntry.set("supplier_taxrate", (Object)onlineBidDetail.getBigDecimal("pricevat"));
                    supplierEntry.set("supplier_rate", (Object)onlineBidDetail.getBigDecimal("rate"));
                    supplierEntry.set("supplier_illustration", onlineBidDetail.get("illustration"));
                    supplierEntry.set("supplier_workday", onlineBidDetail.get("workday"));
                    supplierEntry.set("supplier_ip", (Object)ip);
                    this.copyToEntryAttach(fileMap.get(onlineBid.getPkValue().toString()), supplierEntry, "supplier_tenattach");
                    this.copyToEntryAttach(fileMap.get(onlineBidDetail.getPkValue() + OTHER_SUFFIX), supplierEntry, "supplier_otherattach");
                    this.copyToEntryAttach(fileMap.get(onlineBidDetail.getPkValue() + TECH_SUFFIX), supplierEntry, "supplier_techattach");
                    this.copyToEntryAttach(fileMap.get(onlineBidDetail.getPkValue() + BUS_SUFFIX), supplierEntry, "supplier_comattach");
                    DynamicObject bidProject = onlineBid.getDynamicObject("bidproject");
                    boolean isIllegalBid = IsIllegalBidUtil.isIllegalBidInOpen((Long)bidOpenSupplier.getPkValue(), (Long)bidProject.getPkValue(), (String)sectionName, ip, appId + "_tenderrecord");
                    supplierEntry.set("isillegalbid", (Object)isIllegalBid);
                    supplierEntry.set("tender", (Object)RequestContext.get().getCurrUserId());
                    supplierEntry.set("tenderrecord", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"ConfirmBidUtil_0", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    supplierEntry.set("supplier_pricevat", onlineBidDetail.get("tax"));
                    supplierEntry.set("supplier_exceptvat", onlineBidDetail.get("notaxtenderprice"));
                    BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199-- \u6807\u6bb5\u540d\u79f0\uff1a", (String)"ConfirmBidUtil_12", (String)"scm-ten-formplugin", (Object[])new Object[0]) + (String)sectionName + ResManager.loadKDString((String)" \u4f9b\u5e94\u5546\u540d\u79f0\uff1a", (String)"ConfirmBidUtil_13", (String)"scm-ten-formplugin", (Object[])new Object[0]) + bidOpenSupplier.getString("name") + ResManager.loadKDString((String)" \u6807\u6bb5id: ", (String)"ConfirmBidUtil_14", (String)"scm-ten-formplugin", (Object[])new Object[0]) + bidSection.getPkValue() + ResManager.loadKDString((String)" \u7a0e\u7387\uff1a", (String)"ConfirmBidUtil_15", (String)"scm-ten-formplugin", (Object[])new Object[0]) + onlineBidDetail.getBigDecimal("pricevat") + ResManager.loadKDString((String)" \u4ef7\u683c\uff1a", (String)"ConfirmBidUtil_16", (String)"scm-ten-formplugin", (Object[])new Object[0]) + onlineBidDetail.get("tenderprice")));
                }
            }
            for (DynamicObject bidOpenSectionEntry : bidOpen.getDynamicObjectCollection("bidsection")) {
                for (DynamicObject bidOpenDetailEntry : bidOpenSectionEntry.getDynamicObjectCollection("supplierdetail")) {
                    boolean flag;
                    DynamicObject bidOpenDetailSupplier = bidOpenDetailEntry.getDynamicObject("pursupplier");
                    if (bidOpenDetailSupplier == null || !(flag = supplierMap.containsKey(bidOpenDetailSupplier.getPkValue()))) continue;
                    DynamicObject bidOpenDetailMaterial = bidOpenDetailEntry.getDynamicObject("materialid");
                    String sectionName2 = bidOpenSectionEntry.getString("sectionname");
                    String key = ConfirmBidUtil.createKey(sectionName2, bidOpenDetailEntry, bidOpenDetailMaterial, appId);
                    bidOpenDetailMap.put(key, bidOpenDetailEntry);
                }
            }
            for (Map.Entry<String, DynamicObject> onlineBidDetailMapData : onlineBidDetailMap.entrySet()) {
                sectionName = onlineBidDetailMapData.getKey();
                DynamicObject onlineBidDetail = onlineBidDetailMapData.getValue();
                for (DynamicObject bidOpenSectionEntry : bidOpen.getDynamicObjectCollection("bidsection")) {
                    if (!((String)sectionName).equals(bidOpenSectionEntry.getString("sectionname"))) continue;
                    DynamicObjectCollection bidOpenDetailColl = bidOpenSectionEntry.getDynamicObjectCollection("supplierdetail");
                    for (DynamicObject onlineBidSupplierDetailEntry : onlineBidDetail.getDynamicObjectCollection("supplierdetail")) {
                        DynamicObject biddingDetailMaterial;
                        String key = ConfirmBidUtil.createKey((String)sectionName, onlineBidSupplierDetailEntry, biddingDetailMaterial = onlineBidSupplierDetailEntry.getDynamicObject("materialid"), appId);
                        if (bidOpenDetailMap.containsKey(key)) {
                            DynamicObject bidOpenDetail = (DynamicObject)bidOpenDetailMap.get(key);
                            bidOpenDetail.set("inclutaxprice", onlineBidSupplierDetailEntry.get("inclutaxprice"));
                            bidOpenDetail.set("inclutaxamount", onlineBidSupplierDetailEntry.get("inclutaxamount"));
                            bidOpenDetail.set("taxrate", onlineBidSupplierDetailEntry.get("taxrate"));
                            bidOpenDetail.set("taxamount", onlineBidSupplierDetailEntry.get("taxamount"));
                            bidOpenDetail.set("excepttaxamount", onlineBidSupplierDetailEntry.get("excepttaxamount"));
                            bidOpenDetail.set("costrate", onlineBidSupplierDetailEntry.get("costrate"));
                            bidOpenDetail.set("bd_taxrate", onlineBidSupplierDetailEntry.get("bd_taxrate"));
                            continue;
                        }
                        DynamicObject newSupplierDetail = bidOpenDetailColl.addNew();
                        newSupplierDetail.set("seq", (Object)bidOpenDetailColl.size());
                        newSupplierDetail.set("pursupplier", (Object)supplier);
                        newSupplierDetail.set("purentrycontent", onlineBidSupplierDetailEntry.get("purentrycontent"));
                        newSupplierDetail.set("purentryproject", onlineBidSupplierDetailEntry.get("purentryproject"));
                        newSupplierDetail.set("materialid", onlineBidSupplierDetailEntry.get("materialid"));
                        newSupplierDetail.set("materialdes", onlineBidSupplierDetailEntry.get("materialdes"));
                        newSupplierDetail.set("qty", onlineBidSupplierDetailEntry.get("qty"));
                        newSupplierDetail.set("inclutaxprice", onlineBidSupplierDetailEntry.get("inclutaxprice"));
                        newSupplierDetail.set("inclutaxamount", onlineBidSupplierDetailEntry.get("inclutaxamount"));
                        newSupplierDetail.set("bd_taxrate", onlineBidSupplierDetailEntry.get("bd_taxrate"));
                        newSupplierDetail.set("taxrate", onlineBidSupplierDetailEntry.get("taxrate"));
                        newSupplierDetail.set("taxamount", onlineBidSupplierDetailEntry.get("taxamount"));
                        newSupplierDetail.set("excepttaxamount", onlineBidSupplierDetailEntry.get("excepttaxamount"));
                        newSupplierDetail.set("costrate", onlineBidSupplierDetailEntry.get("costrate"));
                        if (!"rebm".equals(appId)) continue;
                        newSupplierDetail.set("listnumber", onlineBidSupplierDetailEntry.get("listnumber"));
                        newSupplierDetail.set("listname", onlineBidSupplierDetailEntry.get("listname"));
                        newSupplierDetail.set("resourceitem", onlineBidSupplierDetailEntry.get("resourceitem"));
                    }
                }
            }
        }
    }

    protected void copyToEntryAttach(List<Map<String, Object>> attachList, DynamicObject supplierEntry, String entryProperty) {
        List attachments = AttachmentUtil.copyToEntryAttachment(attachList);
        DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection(entryProperty);
        inviteAttachFiles.clear();
        attachments.stream().forEach(item -> {
            DynamicObject inviteAttach = inviteAttachFiles.addNew();
            inviteAttach.set("fbasedataid", item);
        });
        supplierEntry.set(entryProperty, (Object)inviteAttachFiles);
    }

    public static String createKey(String sectionName, DynamicObject detailEntry, DynamicObject detailMaterial, String appId) {
        StringJoiner stringJoiner = new StringJoiner("|");
        stringJoiner.add(sectionName);
        stringJoiner.add(StringUtils.isEmpty((CharSequence)detailEntry.getString("purentrycontent")) ? "" : detailEntry.getString("purentrycontent"));
        stringJoiner.add(detailMaterial == null ? "" : detailMaterial.getPkValue().toString());
        stringJoiner.add(detailEntry.getDynamicObject("purentryproject") == null ? "" : detailEntry.getDynamicObject("purentryproject").getString("id"));
        stringJoiner.add(detailEntry.getString("materialdes") == null ? "" : detailEntry.getString("materialdes"));
        if ("rebm".equals(appId)) {
            stringJoiner.add(detailEntry.getDynamicObject("resourceitem") == null ? "" : detailEntry.getDynamicObject("resourceitem").getString("id"));
        }
        return stringJoiner.toString();
    }

    public static void updateMyTenderStatus(DynamicObject onlineBidData, List<String> sectionNameList, MyTenderStatus tenderStatus) {
        DynamicObject myTender = onlineBidData.getDynamicObject("mytender");
        DynamicObject myTenderObject = BusinessDataServiceHelper.loadSingle((Object)myTender.getPkValue(), (String)"ten_mytender", (String)"bidproject,tenderstatus,biddingdate,entry,entry.projectsection,entry.sectionname,entry.sectionstatus");
        DynamicObjectCollection myTenderSectionEntryCol = myTenderObject.getDynamicObjectCollection("entry");
        for (DynamicObject myTenderEntry : myTenderSectionEntryCol) {
            String sectionName = myTenderEntry.getString("sectionname");
            if (!sectionNameList.contains(sectionName)) continue;
            myTenderEntry.set("sectionstatus", (Object)tenderStatus);
        }
        ArrayList<String> sectionStatusList = new ArrayList<String>();
        for (DynamicObject myTenderSectionEntry : myTenderSectionEntryCol) {
            String sectionStatus = myTenderSectionEntry.getString("sectionstatus");
            sectionStatusList.add(sectionStatus);
        }
        if (sectionStatusList.contains(MyTenderStatus.PRETENDERED.getValue())) {
            myTenderObject.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
        } else if (!sectionStatusList.contains(MyTenderStatus.PRETENDERED.getValue()) && sectionStatusList.contains(MyTenderStatus.TENDERED.getValue())) {
            myTenderObject.set("tenderstatus", (Object)MyTenderStatus.TENDERED);
        } else {
            myTenderObject.set("tenderstatus", (Object)MyTenderStatus.UNTENDERED);
        }
        if (MyTenderStatus.TENDERED.equals((Object)tenderStatus)) {
            myTenderObject.set("biddingdate", (Object)new Date());
        } else {
            myTenderObject.set("biddingdate", null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{myTenderObject});
    }

    public void sendMessageToMember(String bidAppId, DynamicObject dataEntity, DynamicObject bidOpen, DynamicObject bidProject) {
        if (bidOpen != null) {
            Object id = bidOpen.get("id");
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            msgParam.put("pkId", id);
            msgParam.put("id", dataEntity.getPkValue());
            msgParam.put("title", null);
            msgParam.put("content", null);
            String notifyType = null;
            if ("ten".equals(AppIdUtil.getTenAppId((String)bidAppId))) {
                msgParam.put("appId", "bid");
                msgParam.put("formId", "bid_bidopen");
                msgParam.put("msgentity", "ten_online_bid");
                msgParam.put("tplScene", "ten_bidding_tender_new");
                notifyType = MessageChannelUtil.getNotifyType((String)"ten_bidding_tender_new", (String)"ten_online_bid");
            } else {
                msgParam.put("appId", "rebm");
                msgParam.put("formId", "rebm_bidopen");
                msgParam.put("msgentity", "resp_online_bid");
                msgParam.put("tplScene", "resp_bidding_tender_new");
                notifyType = MessageChannelUtil.getNotifyType((String)"resp_bidding_tender_new", (String)"resp_online_bid");
            }
            msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
            msgParam.put("operation", "submit");
            ArrayList<Long> receiveUserIds = new ArrayList<Long>();
            HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
            DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
            for (DynamicObject member : memberColl) {
                String[] values = member.getString("respbusiness").split(",");
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        if (!"06".equals(values[i]) && !"11".equals(values[i]) && !"12".equals(values[i])) continue;
                        memberSet.add(member.getDynamicObject("user"));
                    }
                }
                if (!member.getBoolean("isdirector")) continue;
                memberSet.add(member.getDynamicObject("user"));
            }
            if (!memberSet.isEmpty()) {
                for (DynamicObject set : memberSet) {
                    receiveUserIds.add(set.getLong("id"));
                }
            }
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
        }
    }
}

