/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ResmSwitchSupplier {
    public static final String ORDER_BY = "id asc";

    public DynamicObject getSupplierByCurrentInfo() throws Exception {
        DynamicObject infoBySession = this.getCurrentInfoByRecord();
        if (infoBySession == null || infoBySession.getDynamicObject("currentsupplier") == null) {
            return this.getUserInfoByDB();
        }
        return infoBySession.getDynamicObject("currentsupplier");
    }

    public DynamicObject getCurrentInfoByRecord() {
        try {
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter userIdFilter = new QFilter("currentuser", "=", (Object)currUserId);
            DynamicObject[] supplierswitchData = BusinessDataServiceHelper.load((String)"resp_supplierswitch_data", (String)"id,currentuser,currentsupplier,currentpartner,account", (QFilter[])new QFilter[]{userIdFilter});
            if (supplierswitchData == null || supplierswitchData.length <= 0) {
                return null;
            }
            Optional<DynamicObject> any = Arrays.stream(supplierswitchData).filter(item -> {
                QFilter qFilter = new QFilter("enable", "=", (Object)true);
                qFilter.and("user.phone", "=", (Object)item.getString("account"));
                qFilter.and("bizpartner", "=", item.getDynamicObject("currentpartner").getPkValue());
                return QueryServiceHelper.exists((String)"bos_bizpartneruser", (QFilter[])qFilter.toArray());
            }).findAny();
            if (any.isPresent()) {
                return any.get();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public DynamicObject getUserInfoByDB() throws Exception {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter userIdFilter = new QFilter("user", "=", (Object)currUserId);
        userIdFilter.and("enable", "=", (Object)true);
        DynamicObject[] bizpartnerusers = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"bizpartner,org", (QFilter[])new QFilter[]{userIdFilter});
        if (bizpartnerusers == null || bizpartnerusers.length <= 0) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u67e5\u5230\u5546\u52a1\u4f19\u4f34\u7528\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResmSwitchSupplier_2", (String)"scm-ten-formplugin", (Object[])new Object[0]));
        }
        List partnerList = Arrays.stream(bizpartnerusers).filter(item -> item.getDynamicObject("bizpartner") != null).map(item -> item.getDynamicObject("bizpartner").getPkValue()).distinct().collect(Collectors.toList());
        QFilter partnersFilter = new QFilter("bizpartner", "in", partnerList);
        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"resm_official_supplier", (String)"id,bizpartner,name", (QFilter[])new QFilter[]{partnersFilter}, (String)ORDER_BY, (int)1);
        if (suppliers.length == 0) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u67e5\u5230\u4f9b\u5e94\u5546\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u4fee\u590d\u6570\u636e\u3002", (String)"ResmSwitchSupplier_3", (String)"scm-ten-formplugin", (Object[])new Object[0]));
        }
        return suppliers[0];
    }

    public DynamicObject[] getSupplierByPartner(DynamicObject supplier) {
        DynamicObject bizpartner = supplier.getDynamicObject("bizpartner");
        if (bizpartner == null) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)"resm_official_supplier", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", bizpartner.getPkValue())});
    }
}

