/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.common.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.FileNameUtils;

public class AttachmentUtil {
    public static void copyAttachFieldToAttachPanelByAttachId(Set<Object> oldAttachIdSet, String targetFormId, Object targetBillId, String attachKey) {
        ArrayList<DynamicObject> attachmentFileList = new ArrayList<DynamicObject>();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bd_attachment");
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        DynamicObject[] oldAttachments = BusinessDataServiceHelper.load((Object[])oldAttachIdSet.toArray(new Object[0]), (DynamicObjectType)mainType);
        if (oldAttachments == null || oldAttachments.length == 0) {
            return;
        }
        int i = 0;
        for (DynamicObject oldAttachment : oldAttachments) {
            String fileName = String.valueOf(oldAttachment.get("name"));
            Long fileSize = (Long)oldAttachment.get("size");
            String newUid = String.format("%s-%s-%s", "rc-upload", new Date().getTime(), i++);
            String fileRelativePath = oldAttachment.getString("url");
            InputStream in = fileService.getInputStream(fileRelativePath);
            RequestContext requestContext = RequestContext.get();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)oldAttachment.getPkValue(), (String)fileName);
            FileItem fileItem = new FileItem(fileName, pathParam, in);
            String filePath = fileService.upload(fileItem);
            if (StringUtils.isEmpty((CharSequence)filePath)) continue;
            DynamicObject newAttachment = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_attachment"));
            newAttachment.set("id", (Object)ID.genLongId());
            newAttachment.set("FNUMBER", (Object)newUid);
            newAttachment.set("FBillType", (Object)targetFormId);
            newAttachment.set("FInterID", targetBillId);
            newAttachment.set("FModifyTime", oldAttachment.get("modifytime"));
            newAttachment.set("FCREATEMEN", (Object)oldAttachment.getDynamicObject("creator"));
            newAttachment.set("fcreatetime", oldAttachment.get("createtime"));
            newAttachment.set("FaliasFileName", (Object)fileName);
            newAttachment.set("FAttachmentName", (Object)fileName);
            newAttachment.set("FExtName", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
            newAttachment.set("FATTACHMENTSIZE", (Object)fileSize);
            newAttachment.set("fattachmentpanel", (Object)attachKey);
            newAttachment.set("fdescription", oldAttachment.get("description"));
            newAttachment.set("FFileId", (Object)filePath);
            attachmentFileList.add(newAttachment);
        }
        SaveServiceHelper.save((DynamicObject[])attachmentFileList.toArray(new DynamicObject[0]));
    }

    public static List<DynamicObject> copyToEntryAttachment(List<Map<String, Object>> attachments) {
        ArrayList<DynamicObject> attachmentFileList = new ArrayList<DynamicObject>();
        if (CollectionUtils.isEmpty(attachments)) {
            return attachmentFileList;
        }
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            for (Map<String, Object> attachment : attachments) {
                String fileName = String.valueOf(attachment.get("name"));
                String type = fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
                DynamicObject oldAttachment = BusinessDataServiceHelper.loadSingle((Object)attachment.get("attPkId"), (String)"bos_attachment");
                String fileRelativePath = oldAttachment.getString("FFileId");
                InputStream in = fileService.getInputStream(fileRelativePath);
                RequestContext requestContext = RequestContext.get();
                String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)ID.genLongId(), (String)fileName);
                FileItem fileItem = new FileItem(fileName, pathParam, in);
                String filePath = fileService.upload(fileItem);
                if (StringUtils.isEmpty((CharSequence)filePath)) continue;
                DynamicObject newAttachment = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_attachment"));
                Long id = ID.genLongId();
                newAttachment.set("name", (Object)fileName);
                newAttachment.set("size", attachment.get("size"));
                newAttachment.set("url", (Object)filePath);
                newAttachment.set("type", (Object)type);
                newAttachment.set("description", (Object)"");
                newAttachment.set("tempfile", (Object)"1");
                newAttachment.set("pageid", (Object)"");
                newAttachment.set("number", (Object)id.toString());
                newAttachment.set("status", (Object)"B");
                Date now = new Date();
                newAttachment.set("createtime", (Object)now.getTime());
                newAttachment.set("modifytime", (Object)now.getTime());
                newAttachment.set("creator", (Object)RequestContext.get().getUserId());
                newAttachment.set("uid", (Object)String.format("%s-%s-%s", "rc-upload", new Date().getTime(), 1));
                newAttachment.set("id", (Object)id);
                attachmentFileList.add(newAttachment);
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])attachmentFileList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    h.markRollback();
                    BizLog.log((String)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
            return null;
        }
        return attachmentFileList;
    }
}

