/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.change;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class TndOpenChangePage
extends AbstractBillPlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String key;
        super.beforeDoOperation(evt);
        DynamicObject obj = this.getModel().getDataEntity();
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "bidchange": {
                Object bidChangeId;
                Object pkValue = obj.getPkValue();
                if (this.isTenderBill()) {
                    pkValue = obj.getDynamicObject("project").getPkValue();
                }
                if ((bidChangeId = this.getBidChangeObjId(pkValue)) == null) {
                    HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
                    paraMap.put("project", pkValue);
                    if (this.isTenderBill()) {
                        paraMap.put("tenderid", obj.getPkValue());
                        paraMap.put("supplierid", obj.getDynamicObject("supplier").getPkValue());
                        paraMap.put("entityname", obj.getDataEntityType().getName());
                    }
                    this.openBillPage(this.getView(), "tnd_bidchange", null, BillOperationStatus.EDIT, ShowType.MainNewTabPage, paraMap, null);
                    break;
                }
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u9879\u76ee\u5df2\u6709\u672a\u5904\u7406\u7684\u53d8\u66f4\u5355,\u8bf7\u5148\u5904\u7406\u3002", (String)"TndOpenChangePage_0", (String)"scm-tnd-common", (Object[])new Object[0]));
                return;
            }
            case "changequery": {
                HashMap<String, Object> paraMap = new HashMap<String, Object>(1);
                if (this.isTenderBill()) {
                    paraMap.put("projectid", obj.getDynamicObject("project").getPkValue());
                    paraMap.put("supplierid", obj.getDynamicObject("supplier").getPkValue());
                    paraMap.put("tenderid", obj.getPkValue());
                    paraMap.put("entityname", obj.getDataEntityType().getName());
                } else {
                    paraMap.put("projectid", obj.getPkValue());
                }
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_changequery", (ShowType)ShowType.Modal, paraMap, null);
                break;
            }
        }
    }

    private void openBillPage(IFormView currView, String pageKey, Object billId, BillOperationStatus openStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(openStatus);
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)bsp);
    }

    private Object getBidChangeObjId(Object projectId) {
        String selectFields = "id";
        QFilter projectFilter = new QFilter("project", "=", (Object)Long.parseLong(projectId.toString()));
        projectFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        List supIdsList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        projectFilter.and("supplier", "in", (Object)supIdsList);
        DynamicObject bidChange = QueryServiceHelper.queryOne((String)"tnd_bidchange", (String)selectFields, (QFilter[])new QFilter[]{projectFilter});
        if (null == bidChange) {
            return null;
        }
        return bidChange.get("id");
    }

    private boolean isTenderBill() {
        return "tnd_tenderbill".equals(this.getView().getEntityId()) || "tnd_quotebill".equals(this.getView().getEntityId());
    }
}

