/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.comptpl;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.comptpl.PdsCompTplServiceImpl;
import kd.scm.pds.common.enums.BidDocTypeEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import org.apache.commons.lang3.StringUtils;

public class TndProjectCompTplServiceImpl
extends PdsCompTplServiceImpl {
    private List<String> purListCompList = null;

    public Map<String, Object> getCompParams(String compKey) {
        if (StringUtils.equals((CharSequence)"tnd_project_task", (CharSequence)compKey)) {
            Map dataMap = super.getCompParams(compKey);
            dataMap.put("data", this.getPageCache().get("data"));
            dataMap.put("billno", this.getModel().getValue("billno"));
            return dataMap;
        }
        return super.getCompParams(compKey);
    }

    public boolean isShowComponent(String compKey) {
        if (this.isEmpty(compKey)) {
            return false;
        }
        return super.isShowComponent(compKey);
    }

    public boolean isEmpty(String compKey) {
        boolean isEmpty = false;
        if (!this.isPurListComp(compKey) && !"tnd_biddoc_query".equals(compKey)) {
            return isEmpty;
        }
        isEmpty = !this.existsCompData(compKey);
        return isEmpty;
    }

    public boolean existsCompData(String compKey) {
        DynamicObject projectObj = this.getModel().getDataEntity();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        QFilter qfilter = null;
        boolean exists = false;
        switch (compKey) {
            case "src_purlist_item": {
                qfilter = new QFilter("itementity.itemproject", "=", (Object)projectId);
                qfilter.and("itementity.itemsupplier", "in", (Object)SupplierUtil.getAllSupIdByBizPartnerAndSupType());
                exists = QueryServiceHelper.exists((String)compKey, (QFilter[])qfilter.toArray());
                break;
            }
            case "tnd_biddoc_query": {
                qfilter = new QFilter("project", "=", (Object)projectId);
                qfilter.and("packfiletype", "=", (Object)BidDocTypeEnums.SYN_DOC.getValue());
                exists = QueryServiceHelper.exists((String)"src_biddoctplf7", (QFilter[])qfilter.toArray());
                break;
            }
            default: {
                long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("srctypeid"));
                boolean isShowPurlistBeforePublish = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isShowPurlistBeforePublish", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)projectObj)));
                if (isShowPurlistBeforePublish) {
                    return true;
                }
                qfilter = new QFilter("project", "=", (Object)projectId);
                qfilter.and("supplier", "in", (Object)PdsCommonUtils.getSupplierByUserOfBizPartner());
                exists = QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])qfilter.toArray());
            }
        }
        return exists;
    }

    private boolean isPurListComp(String compKey) {
        if (null == this.purListCompList) {
            DynamicObject obj = this.getModel().getDataEntity();
            DynamicObject purListObj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"src_purlist");
            this.purListCompList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)purListObj);
        }
        return this.purListCompList.contains(compKey);
    }
}

