/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.comptpl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.pds.common.comptpl.PdsCompTplContext;
import kd.scm.pds.common.comptpl.PdsCompTplServiceImpl;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class TndTenderBillCompTplServiceImpl
extends PdsCompTplServiceImpl {
    private List<String> purListCompList = null;

    public void beforeDoOperation(PdsCompTplContext context) {
        String opKey;
        this.initParam(context);
        BeforeDoOperationEventArgs evt = context.getBeforeDoOperationEventArgs();
        Map checkResult = FeatureCheckUtil.checkTndFeature();
        if (!((Boolean)checkResult.get("hasLicense")).booleanValue()) {
            evt.setCancel(true);
            evt.setCancelMessage(String.valueOf(checkResult.get("licenseMsg")));
            return;
        }
        switch (opKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                long billId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
                String billNo = this.getModel().getDataEntity().getString("billno");
                QFilter qFilters = new QFilter("billno", "=", (Object)billNo).and("id", "!=", (Object)billId);
                if (QueryServiceHelper.exists((String)"tnd_tenderbill", (QFilter[])qFilters.toArray())) {
                    PdsCommonUtils.setBillNo((String)"tnd_tenderbill", (DynamicObject)this.getModel().getDataEntity());
                }
                super.beforeDoOperation(context);
                break;
            }
            case "audit": {
                OperationResult result = this.getView().invokeOperation("submit");
                if (!result.isSuccess()) {
                    evt.setCancel(true);
                    return;
                }
                result.setShowMessage(false);
                break;
            }
            default: {
                super.beforeDoOperation(context);
            }
        }
    }

    public List<String> getAttachCompKeyList() {
        List attachCompKeyList = super.getAttachCompKeyList();
        attachCompKeyList.clear();
        return attachCompKeyList;
    }

    public boolean isShowComponent(String compKey) {
        if (this.isEmpty(compKey)) {
            return false;
        }
        return super.isShowComponent(compKey);
    }

    public boolean isEmpty(String compKey) {
        DynamicObjectCollection cols;
        DynamicObject compDataObj;
        boolean isEmpty = false;
        if (!this.isPurListComp(compKey)) {
            return isEmpty;
        }
        DynamicObject obj = this.getModel().getDataEntity();
        String entry_entity = "entryentity";
        if ("src_purlist_item".equals(compKey)) {
            entry_entity = "itementity";
        }
        if (null != (compDataObj = TemplateUtil.getCompData((DynamicObject)obj, (String)compKey)) && (cols = compDataObj.getDynamicObjectCollection(entry_entity)).size() == 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private boolean isPurListComp(String compKey) {
        if (null == this.purListCompList) {
            this.purListCompList = super.getAttachCompKeyList();
        }
        return new HashSet<String>(this.purListCompList).contains(compKey);
    }

    public boolean isDoCompOperation(String operateKey, String entityKey, boolean isAttach) {
        if ("src_biddoc_src".equals(entityKey)) {
            return false;
        }
        return super.isDoCompOperation(operateKey, entityKey, isAttach);
    }
}

