/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.pds.common.util.TemplateUtil;

public class TndAptitudeSendMsg
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(TndAptitudeSendMsg.class);

    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        List billIdList = ((EntityEvent)evt).getBusinesskeys();
        ArrayList<Long> billIdObjList = new ArrayList<Long>(billIdList.size());
        for (String billId : billIdList) {
            billIdObjList.add(Long.valueOf(billId));
        }
        HashMap<String, List<Long>> billIdUserMap = new HashMap<String, List<Long>>(billIdList.size());
        QFilter filter = new QFilter("id", "in", billIdObjList);
        DynamicObject[] aptObjs = BusinessDataServiceHelper.load((String)"tnd_aptitude", (String)"id,project,supplier,org", (QFilter[])filter.toArray());
        if (aptObjs.length == 0) {
            return billIdUserMap;
        }
        String projectId = String.valueOf(aptObjs[0].getLong("project.id"));
        HashMap<Long, Set<Long>> supplierMap = new HashMap<Long, Set<Long>>(16);
        this.getInviteSupplier(projectId, supplierMap);
        this.getItemSupplier(projectId, supplierMap);
        StringBuilder logSb = new StringBuilder();
        for (DynamicObject aptObj : aptObjs) {
            Long supId;
            Set userids;
            if (CollectionUtils.isEmpty(supplierMap) || null == (userids = (Set)supplierMap.get(supId = Long.valueOf(aptObj.getLong("supplier.id"))))) continue;
            HashSet<Long> bizpartnerIds = new HashSet<Long>(8);
            HashSet specialSupUserIds = new HashSet(4);
            bizpartnerIds.add(BizPartnerUtil.getBizPartnerBySupplier((Object)supId));
            specialSupUserIds.addAll(userids);
            ArrayList<Long> userIds = new ArrayList<Long>(4);
            if (!specialSupUserIds.isEmpty()) {
                DynamicObjectCollection specialUserDyns = QueryServiceHelper.query((String)"pur_supuser", (String)"id,user", (QFilter[])new QFilter[]{new QFilter("id", "in", specialSupUserIds).and(new QFilter("enable", "=", (Object)"1"))});
                for (DynamicObject specialUserDyn : specialUserDyns) {
                    long user = specialUserDyn.getLong("user");
                    userIds.add(user);
                }
            }
            userIds.addAll(BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizpartnerIds));
            logSb.append("id:").append(aptObj.getPkValue());
            logSb.append("->alluser:").append(userIds).append("||");
            Iterator iterator = userIds.iterator();
            Long orgId = aptObj.getLong("org.id");
            while (iterator.hasNext()) {
                Long userId = (Long)iterator.next();
                HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, null, (String)"tnd_aptitude", (String)"47150e89000000ac");
                List permOrgs = hasPermOrgResult.getHasPermOrgs();
                if (permOrgs.contains(orgId)) continue;
                iterator.remove();
            }
            billIdUserMap.put(String.valueOf(aptObj.getPkValue()), userIds);
            logSb.append("->supplier user ids: ").append(userIds).append(';');
        }
        log.info(logSb.toString());
        return billIdUserMap;
    }

    private void getInviteSupplier(String billId, Map<Long, Set<Long>> supplierMap) {
        DynamicObject inviteSupplier = TemplateUtil.getComponentData((Object)billId, (String)"src_project", (String)"src_supplier_invite");
        if (Objects.isNull(inviteSupplier)) {
            return;
        }
        DynamicObjectCollection rows = inviteSupplier.getDynamicObjectCollection("entrysupplier");
        for (DynamicObject row : rows) {
            long supplierId = row.getLong("supplier.id");
            if (supplierId == 0L) continue;
            DynamicObjectCollection users = row.getDynamicObjectCollection("supplieruser");
            supplierMap.put(supplierId, users.stream().map(user -> user.getLong("fbasedataid.id")).collect(Collectors.toSet()));
        }
    }

    public void getItemSupplier(String billId, Map<Long, Set<Long>> supplierMap) {
        DynamicObject itemSupplier = TemplateUtil.getComponentData((Object)billId, (String)"src_project", (String)"src_itemsupplier");
        if (Objects.isNull(itemSupplier)) {
            return;
        }
        DynamicObjectCollection itemSupCols = itemSupplier.getDynamicObjectCollection("entryentity");
        for (DynamicObject itemSupCol : itemSupCols) {
            DynamicObjectCollection supCols = itemSupCol.getDynamicObjectCollection("supplier");
            supCols.forEach(supCol -> supplierMap.put(supCol.getLong("fbasedataid.id"), Collections.emptySet()));
        }
    }
}

