/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.logging.BizLog;
import kd.bos.url.UrlService;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.pds.common.util.PdsCommonUtils;

public class TndReEnrollSendMeg
implements IEventServicePlugin {
    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        HashMap<String, List<Long>> userIdMaps = new HashMap<String, List<Long>>(16);
        String billId = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        HashSet userIds = new HashSet(16);
        HashSet<Long> bizPartnerIds = new HashSet<Long>(16);
        List<String> supplierIdLists = new ArrayList<String>();
        if (evt.getVariables().contains(":")) {
            supplierIdLists = Arrays.asList(evt.getVariables().split(":")[1].split("\"")[1].replace("[", "").replace("]", "").replace(" ", "").split(","));
        } else {
            supplierIdLists.add(PdsCommonUtils.object2String((Object)evt.getVariables(), (String)"0"));
        }
        for (String supplierIdList : supplierIdLists) {
            bizPartnerIds.add(BizPartnerUtil.getBizPartnerBySupplier((Object)Long.parseLong(supplierIdList)));
        }
        userIds.addAll(BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizPartnerIds));
        userIdMaps.put(billId, new ArrayList(userIds));
        BizLog.log((String)("supplier user ids: " + userIds.size()));
        return userIdMaps;
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        HashMap<String, String> urlMaps = new HashMap<String, String>(8);
        String billId = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        urlMaps.put(billId, this.getUrl(billId));
        return urlMaps;
    }

    protected String getUrl(String billId) {
        StringBuilder url = new StringBuilder();
        String domainContextUrl = UrlService.getDomainContextUrl();
        url.append(domainContextUrl);
        url.append("?formId=");
        url.append("tnd_apply");
        url.append("&pkId=");
        url.append(Long.parseLong(billId));
        String accountId = RequestContext.get().getAccountId();
        url.append("&accountId=");
        url.append(accountId);
        return url.toString();
    }
}

