/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.extplugin.openapi;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.openapi.IQueryList;
import kd.scm.pds.common.extplugin.openapi.QueryContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.tnd.common.util.TndListFilterUtil;

public class TndTenderBillQueryListPlugin
implements IQueryList {
    public QFilter getFilter(QueryContext context) {
        List<Long> projectIds = TndListFilterUtil.getProjectByUnConfirm();
        QFilter qFilter = new QFilter("project", "not in", projectIds);
        Set supplierUserIds = SupplierUtil.getSupplierUserIdsByCurrUserId();
        QFilter userFilter = ExtFilterUtils.getMultiBaseDataFilter((String)"supplieruser", (Set)supplierUserIds);
        qFilter.and(userFilter);
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        qFilter.and(new QFilter(filterSupPro + "." + "id", "in", (Object)PdsCommonUtils.getSupplierByUserOfBizPartner()));
        if (context.isFilterByParams()) {
            QFilter paramfilter = this.buildQfilterByParams(context.getParamMap());
            if (Objects.nonNull(qFilter) && Objects.nonNull(paramfilter)) {
                qFilter.and(paramfilter);
            }
            BizLog.log((String)("###TndTenderQueryListPlugin getFilter:" + paramfilter));
        }
        return qFilter;
    }

    private QFilter buildQfilterByParams(Map<String, Object> paramMap) {
        QFilter qfilter = null;
        for (Map.Entry<String, Object> param : paramMap.entrySet()) {
            Object paramVal = param.getValue();
            String paramValStr = String.valueOf(paramVal);
            if ("*".equals(paramValStr)) continue;
            QFilter paramFilter = null;
            if ("start_date".equals(param.getKey())) {
                paramFilter = new QFilter("createtime", ">=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("end_date".equals(param.getKey())) {
                paramFilter = new QFilter("createtime", "<=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("search_text".equals(param.getKey())) {
                paramFilter = new QFilter("billno", "match", (Object)paramValStr);
                paramFilter.or("project.bidname", "match", (Object)paramValStr);
                paramFilter.or("project.billno", "match", (Object)paramValStr);
            } else if ("start_stopbiddate".equals(param.getKey())) {
                paramFilter = new QFilter("deadline", ">=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("end_stopbiddate".equals(param.getKey())) {
                paramFilter = new QFilter("deadline", "<=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("project_openstatus".equals(param.getKey())) {
                paramFilter = paramVal instanceof List ? new QFilter("project.openstatus", "in", paramVal) : new QFilter("project.openstatus", "=", paramVal);
            } else if ("billstatus".equals(param.getKey())) {
                paramFilter = paramVal instanceof List ? new QFilter("billstatus", "in", paramVal) : new QFilter("billstatus", "=", paramVal);
            }
            if (null == paramFilter) continue;
            if (null == qfilter) {
                qfilter = paramFilter;
                continue;
            }
            qfilter.and(paramFilter);
        }
        return qfilter;
    }

    public Set<String> getSelectSet(QueryContext context) {
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append("id,billno,billstatus,auditdate,modifytime,createtime,parentid,lastupdatetime,billdate,issplitdoc,bizstatus,");
        selectFieldsSb.append("isadd,deadline,isneedbiddoc,suppliertype,remark,turns,sumamount,sumtaxamount,supplierip,isnotice,ispuragent,isquote,istender,");
        selectFieldsSb.append("number,supplier.id,supplier.number,supplier.name,bizpartner.id,bizpartner.number,bizpartner.name,project.billno,project.openstatus,project.bidname,currency.id,org.id");
        String[] selectArray = selectFieldsSb.toString().split(",");
        HashSet<String> selectSet = new HashSet<String>(selectArray.length);
        for (String field : selectArray) {
            selectSet.add(field.trim());
        }
        return selectSet;
    }

    public String getOrderBys(QueryContext context) {
        return "createtime desc";
    }
}

