/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.nodestatus;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.EnrollStatusEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;
import kd.scm.tnd.common.util.TndApplyUtils;

public class TndNodeStatusHandlerApply
extends SrcNodeStatusHandler {
    private static final long serialVersionUID = 1L;

    public void getNodeStatusFilter(SrcNodeStatusContext context) {
        QFilter qFilter = new QFilter("id", "=", (Object)context.getProjectId());
        qFilter.and("tendertype", "=", (Object)"2");
        context.setFilters(new QFilter[]{qFilter});
    }

    public void getNodeStatusFields(SrcNodeStatusContext context) {
        String selectFields = "id,billno,bidname billname,billdate, replydate, stopbiddate enddate, billstatus bizstatus,'' remark,'' biztype";
        context.setSelectFields(selectFields);
        context.setOrderBy("billdate");
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        List supplierIds = context.getSupplierList();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(row.getLong("id"));
        Set<Long> enrollIds = TndApplyUtils.getEnrollIds(supplierIds, projectIds);
        Set<Long> inviteIds = TndApplyUtils.getInviteIds(supplierIds, projectIds);
        String bizStatus = TndApplyUtils.getEnrollStatus(row, enrollIds, inviteIds, row.getDate("replydate"), row.getDate("enddate"));
        if (EnrollStatusEnums.ENROLLED.getValue().equals(bizStatus) || EnrollStatusEnums.INVITED.getValue().equals(bizStatus) || EnrollStatusEnums.UNINVITED.getValue().equals(bizStatus)) {
            return ProcessStatusEnums.PROCESSED.getValue();
        }
        if (row.getDate("enddate") != null && row.getDate("enddate").before(TimeServiceHelper.now())) {
            return ProcessStatusEnums.CLOSED.getValue();
        }
        return ProcessStatusEnums.PROCESSING.getValue();
    }
}

