/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.nodestatus;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;
import kd.scm.pds.common.util.SupplierUtil;

public class TndNodeStatusHandlerEncrypt
extends SrcNodeStatusHandler {
    private static final long serialVersionUID = 1L;

    public void getNodeStatusFilter(SrcNodeStatusContext context) {
        QFilter qFilters = new QFilter("project", "=", (Object)context.getProjectId());
        QFilter openFilter = new QFilter("project.openstatus", "=", (Object)BidOpenStatusEnums.NOOPEN.getValue());
        openFilter.or("project.openstatus", "=", (Object)BidOpenStatusEnums.TECOPEN.getValue());
        openFilter.or("project.openstatus", "=", (Object)BidOpenStatusEnums.BIZOPEN.getValue());
        openFilter.or("project.openstatus", "=", (Object)BidOpenStatusEnums.OPEN.getValue());
        qFilters.and(openFilter);
        QFilter statusFilter = new QFilter("isencrypt", "=", (Object)"0").or("isdecrypt", "=", (Object)"0");
        qFilters.and(statusFilter);
        qFilters.and("supplier", "in", (Object)context.getSupplierList());
        QFilter userFilter = ExtFilterUtils.getMultiBaseDataFilter((String)"supplieruser", (Set)SupplierUtil.getSupplierUserIdsByCurrUserId());
        qFilters.and(userFilter);
        qFilters.and("isterminate", "=", (Object)"0");
        context.setFilters(new QFilter[]{qFilters});
    }

    public void getNodeStatusFields(SrcNodeStatusContext context) {
        String selectFields = "id,project.billno billno,project.bidname billname,project.billdate billdate, project.stopbiddate enddate,'A' bizstatus,'' remark,'' biztype,opentype,isencrypt,isdecrypt";
        context.setSelectFields(selectFields);
        context.setOrderBy("opentype,isencrypt,isdecrypt");
    }

    public void getNodeStatusRows(SrcNodeStatusContext context) {
        if (context.getFilters() == null) {
            context.setRows((DynamicObjectCollection)null);
        } else {
            String entityName = context.getNodeObj().getDynamicObject("biznode").getString("bizobject.number");
            DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)context.getSelectFields(), (QFilter[])context.getFilters(), (String)context.getOrderBy());
            DynamicObjectCollection firstRow = new DynamicObjectCollection();
            if (rows.size() > 0) {
                firstRow.add(rows.get(0));
            }
            context.setRows(firstRow);
        }
    }

    public String getNodeName(SrcNodeStatusContext context, DynamicObject row) {
        boolean isencrypt = row.getBoolean("isencrypt");
        boolean isdecrypt = row.getBoolean("isdecrypt");
        String nodeName = context.getNodeObj().getString("biznode.name");
        if (!isencrypt) {
            return ResManager.loadKDString((String)"\u5f00\u6807\u52a0\u5bc6", (String)"TndNodeStatusHandlerEncrypt_0", (String)"scm-tnd-common", (Object[])new Object[0]);
        }
        if (!isdecrypt) {
            return ResManager.loadKDString((String)"\u5f00\u6807\u89e3\u5bc6", (String)"TndNodeStatusHandlerEncrypt_1", (String)"scm-tnd-common", (Object[])new Object[0]);
        }
        return nodeName;
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        boolean isencrypt = row.getBoolean("isencrypt");
        boolean isdecrypt = row.getBoolean("isdecrypt");
        if (isencrypt && isdecrypt) {
            return ProcessStatusEnums.PROCESSED.getValue();
        }
        return ProcessStatusEnums.PROCESSING.getValue();
    }
}

