/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.nodestatus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;

public class TndNodeStatusHandlerNotice
extends SrcNodeStatusHandler {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(TndNodeStatusHandlerNotice.class);

    public void getNodeStatusFilter(SrcNodeStatusContext context) {
        String entityName = context.getNodeObj().getDynamicObject("biznode").getString("bizobject.number");
        if (this.isNeedFilter(context, entityName)) {
            QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
            if ("bd_supplier".equals(context.getSupplierType())) {
                qFilter.and("supplier", "in", (Object)context.getSupplierList());
            } else {
                qFilter.and("supplier.supplier", "in", (Object)context.getSupplierList());
            }
            qFilter.and("supletterstype", "in", this.getSupletterstype(entityName));
            qFilter.and("entrystatus", "=", (Object)"C");
            context.setFilters(new QFilter[]{qFilter});
            StringBuilder msg = new StringBuilder();
            msg.append("getNodeStatusFilter filter:");
            msg.append(qFilter);
            log.info(msg.toString());
        } else {
            context.setFilters(null);
        }
    }

    private boolean isNeedFilter(SrcNodeStatusContext context, String entityName) {
        boolean isFilter = false;
        if (context.isConfirm() || entityName.equals("tnd_inviteletter")) {
            isFilter = true;
        } else if (entityName.equals("tnd_winnotice")) {
            isFilter = true;
        }
        return isFilter;
    }

    public void getNodeStatusRows(SrcNodeStatusContext context) {
        if (context.getFilters() == null) {
            context.setRows(null);
        } else {
            String entityName = context.getNodeObj().getDynamicObject("biznode").getString("bizobject.number");
            log.info("getNodeStatusRows entityName:" + entityName);
            DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)context.getSelectFields(), (QFilter[])context.getFilters());
            log.info("getNodeStatusRows rowSize:" + rows.size());
            if (null == rows || rows.size() == 0) {
                return;
            }
            HashSet<String> keySet = new HashSet<String>();
            DynamicObjectCollection newRows = new DynamicObjectCollection();
            for (DynamicObject row : rows) {
                String key = row.getString("supletterstype") + "|" + row.getString("project.id") + "|" + row.getString("supplier.id");
                if (!keySet.add(key)) continue;
                newRows.add((Object)row);
            }
            context.setRows(newRows);
        }
    }

    public void getNodeStatusFields(SrcNodeStatusContext context) {
        String selectFields = null;
        String entityName = context.getNodeObj().getDynamicObject("biznode").getString("bizobject.number");
        selectFields = entityName.equals("tnd_inviteletter") ? "id,project.id,project.billno billno,project.bidname billname,project.bizstatus,senddate billdate, project.stopbiddate enddate,cfmstatus bizstatus,'' remark,supletterstype biztype,suppliertype,supplier,supletterstype,supplier.id" : "id,project.id,project.billno billno,project.bidname billname,project.bizstatus,senddate billdate, replydate enddate,cfmstatus bizstatus,'' remark,supletterstype biztype,supletterstype,supplier.id";
        context.setSelectFields(selectFields);
        log.info("TndNodeStatusHandlerNotice getNodeStatusFields selectfiles:" + selectFields);
        context.setOrderBy("senddate");
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        String pstatus = row.getString("project.bizstatus");
        if (ProcessStatusEnums.CLOSED.getValue().equals(pstatus) || ProcessStatusEnums.TERMINATED.getValue().equals(pstatus)) {
            return ProcessStatusEnums.CLOSED.getValue();
        }
        String status = row.getString("bizstatus");
        if (status.equals("B")) {
            return ProcessStatusEnums.PROCESSED.getValue();
        }
        if (status.equals("C")) {
            return ProcessStatusEnums.TERMINATED.getValue();
        }
        if (row.getDate("enddate") != null && row.getDate("enddate").before(TimeServiceHelper.now())) {
            if (row.getString("biztype").equals("4")) {
                return ProcessStatusEnums.CLOSED.getValue();
            }
            return ProcessStatusEnums.PROCESSING.getValue();
        }
        return ProcessStatusEnums.PROCESSING.getValue();
    }

    public String getNodeName(SrcNodeStatusContext context, DynamicObject row) {
        String bizType;
        switch (bizType = row.getString("biztype")) {
            case "1": {
                return ResManager.loadKDString((String)"\u4e2d\u6807\u901a\u77e5\u4e66\u786e\u8ba4", (String)"TndNodeStatusHandlerNotice_0", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u5019\u9009\u901a\u77e5\u4e66\u786e\u8ba4", (String)"TndNodeStatusHandlerNotice_1", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u611f\u8c22\u4fe1\u786e\u8ba4", (String)"TndNodeStatusHandlerNotice_2", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u786e\u8ba4", (String)"TndNodeStatusHandlerNotice_3", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u57f9\u517b\u901a\u77e5\u4e66\u786e\u8ba4", (String)"TndNodeStatusHandlerNotice_4", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u4e0d\u63a8\u8350\u901a\u77e5\u4e66\u786e\u8ba4", (String)"TndNodeStatusHandlerNotice_5", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "9": {
                return ResManager.loadKDString((String)"\u9884\u4e2d\u6807\u901a\u77e5\u4e66\u786e\u8ba4", (String)"TndNodeStatusHandlerNotice_6", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
        }
        return context.getNodeObj().getString("biznode.name");
    }

    public List<String> getSupletterstype(String bizObject) {
        switch (bizObject) {
            case "tnd_inviteletter": {
                return new ArrayList<String>(Collections.singletonList("4"));
            }
            case "tnd_winnotice": 
            case "tnd_candidate": 
            case "tnd_thankletter": {
                return new ArrayList<String>(Arrays.asList("1", "2", "3", "5", "6", "9"));
            }
        }
        return new ArrayList<String>(Arrays.asList("1", "2", "3", "5", "6", "9"));
    }
}

