/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.nodestatus;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsObjectCacheUtils;

public class TndNodeStatusHandlerPayment
extends SrcNodeStatusHandler {
    private static final long serialVersionUID = 1L;

    public void getNodeStatusFilter(SrcNodeStatusContext context) {
        if (context.isConfirm()) {
            QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
            if ("bd_supplier".equals(context.getSupplierType())) {
                qFilter.and("supplier", "in", (Object)context.getSupplierList());
            } else {
                qFilter.and("supplier.supplier", "in", (Object)context.getSupplierList());
            }
            context.setFilters(new QFilter[]{qFilter});
        } else {
            context.setFilters(null);
        }
    }

    public void getNodeStatusFields(SrcNodeStatusContext context) {
        String selectFields = "id,project.billno billno,project.bidname billname,project.billdate billdate, project.stopbiddate enddate,paystatus bizstatus,remark,packfeeitem.name biztype,package.packagename packagename,project.managetype managetype";
        context.setSelectFields(selectFields);
        context.setOrderBy("project.billdate");
    }

    public String getNodeName(SrcNodeStatusContext context, DynamicObject row) {
        String bizType = row.getString("biztype");
        String nodeName = context.getNodeObj().getString("biznode.name");
        if (bizType == null || bizType.trim().length() == 0) {
            return nodeName;
        }
        if ("2".equals(row.getString("managetype"))) {
            return nodeName + "(" + PdsCommonUtils.object2String((Object)row.get("packagename"), (String)"") + ' ' + bizType + ")";
        }
        return nodeName + "(" + bizType + ")";
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        String status = row.getString("bizstatus");
        if (PayStatusEnums.NOCONFIRM.getValue().equals(status) || PayStatusEnums.CONFIRMED.getValue().equals(status) || PayStatusEnums.RETURNED.getValue().equals(status) || PayStatusEnums.TRANSFERED.getValue().equals(status) || PayStatusEnums.EXEMPT.getValue().equals(status) || PayStatusEnums.CARRYOVER.getValue().equals(status)) {
            return ProcessStatusEnums.PROCESSED.getValue();
        }
        if (PayStatusEnums.DISCARDED.getValue().equals(status) || PayStatusEnums.TERMINATED.getValue().equals(status)) {
            return ProcessStatusEnums.CLOSED.getValue();
        }
        if (PdsObjectCacheUtils.isEndedOpenStatus((long)context.getProjectId())) {
            return ProcessStatusEnums.CLOSED.getValue();
        }
        return ProcessStatusEnums.PROCESSING.getValue();
    }

    public String getRemark(SrcNodeStatusContext context, DynamicObject row) {
        String status;
        switch (status = row.getString("bizstatus")) {
            case "B": {
                return ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e|\u5f85\u786e\u8ba4", (String)"TndNodeStatusHandlerPayment_0", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "C": {
                return ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e|\u5df2\u786e\u8ba4", (String)"TndNodeStatusHandlerPayment_1", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "D": {
                return ResManager.loadKDString((String)"\u5df2\u9000\u8fd8", (String)"TndNodeStatusHandlerPayment_2", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "E": {
                return ResManager.loadKDString((String)"\u5df2\u8f6c\u7ed3\u4f59", (String)"TndNodeStatusHandlerPayment_3", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "F": {
                return ResManager.loadKDString((String)"\u514d\u4ea4", (String)"TndNodeStatusHandlerPayment_4", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
            case "G": {
                return ResManager.loadKDString((String)"\u5df2\u8f6c\u5c65\u7ea6\u91d1", (String)"TndNodeStatusHandlerPayment_5", (String)"scm-tnd-common", (Object[])new Object[0]);
            }
        }
        if (row.getDate("enddate") != null && row.getDate("enddate").before(TimeServiceHelper.now())) {
            return ResManager.loadKDString((String)"\u5df2\u5173\u95ed", (String)"TndNodeStatusHandlerPayment_6", (String)"scm-tnd-common", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5f85\u7f34\u8d39", (String)"TndNodeStatusHandlerPayment_7", (String)"scm-tnd-common", (Object[])new Object[0]);
    }
}

