/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.EnrollStatusEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;

public class TndApplyUtils {
    public static Set<Long> getEnrollIds() {
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        QFilter enrollFilter = new QFilter("supplier", "in", (Object)supplierIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_enrollsupplier", (String)"billid", (QFilter[])enrollFilter.toArray());
        if (null == rows || rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(row -> row.getLong("billid")).collect(Collectors.toSet());
    }

    public static Set<Long> getEnrollIds(List<Long> supplierIds, List<Long> projectIds) {
        QFilter qFilter = new QFilter("billid", "in", projectIds).and("supplier", "in", supplierIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_enrollsupplier", (String)"billid", (QFilter[])new QFilter[]{qFilter});
        if (null == rows || rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(row -> row.getLong("billid")).collect(Collectors.toSet());
    }

    public static Set<Long> getInviteIds(List<Long> supplierIds, List<Long> projectIds) {
        QFilter qFilter = new QFilter("billid", "in", projectIds).and("supplier", "in", supplierIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"billid", (QFilter[])new QFilter[]{qFilter});
        if (null == rows || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(row -> row.getLong("billid")).collect(Collectors.toSet());
    }

    public static Set<Long> getUnEnrollIds(QFilter qfilters) {
        String selectFields = "id,bizstatus,enrollstatus,replydate,stopbiddate";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"tnd_apply", (String)selectFields, (QFilter[])qfilters.toArray());
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return Collections.emptySet();
        }
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        List<Long> projectIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        Set<Long> enrollIds = TndApplyUtils.getEnrollIds(supplierIds, projectIds);
        Set<Long> inviteIds = TndApplyUtils.getInviteIds(supplierIds, projectIds);
        for (DynamicObject row : rows) {
            row.set("enrollstatus", (Object)TndApplyUtils.getEnrollStatus(row, enrollIds, inviteIds, row.getDate("replydate"), row.getDate("stopbiddate")));
        }
        return rows.stream().filter(e -> e.getString("enrollstatus").equals(EnrollStatusEnums.UNENROLL.getValue())).map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    public static String getEnrollStatus(DynamicObject row, Set<Long> enrollIds, Set<Long> inviteIds, Date replyDate, Date stopbiddate) {
        long billId = PdsCommonUtils.object2Long((Object)row.get("id"));
        String bizStatus = row.getString("bizstatus");
        if (Objects.equals(ProcessStatusEnums.TERMINATED.getValue(), bizStatus) || Objects.equals(ProcessStatusEnums.CLOSED.getValue(), bizStatus)) {
            return EnrollStatusEnums.TERMINATED.getValue();
        }
        if (null != enrollIds && enrollIds.contains(billId) || inviteIds != null && inviteIds.contains(billId)) {
            if (inviteIds != null && inviteIds.contains(billId)) {
                return EnrollStatusEnums.INVITED.getValue();
            }
            if (stopbiddate != null && stopbiddate.before(TimeServiceHelper.now())) {
                return EnrollStatusEnums.UNINVITED.getValue();
            }
            return EnrollStatusEnums.ENROLLED.getValue();
        }
        if (replyDate != null && replyDate.before(TimeServiceHelper.now())) {
            return EnrollStatusEnums.INVALID.getValue();
        }
        return EnrollStatusEnums.UNENROLL.getValue();
    }

    public static final Date getDateByOffsetDay(Date now, int offsetDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(now);
        calendar.add(5, offsetDay);
        return calendar.getTime();
    }

    public static final String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return String.format(ResManager.loadKDString((String)"%1$s\u5929%2$s\u5c0f\u65f6 %3$s\u5206\u949f", (String)"TndApplyUtils_0", (String)"scm-tnd-common", (Object[])new Object[0]), day, hour, min);
    }

    public static QFilter getBidDocFilter(long projectId, String entityName) {
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        QFilter tenderBillFilter = new QFilter("project.id", "=", (Object)projectId).and("supplier.supplier", "in", (Object)supplierIds);
        DynamicObjectCollection tenderBillRows = QueryServiceHelper.query((String)"tnd_tenderbill", (String)"id", (QFilter[])new QFilter[]{tenderBillFilter});
        Set tenderBillSet = tenderBillRows.stream().map(row -> row.getLong("id")).collect(Collectors.toSet());
        QFilter bidDocFilter = new QFilter("parentid", "in", tenderBillSet).and("entitykey", "=", (Object)entityName);
        DynamicObjectCollection bidDocRows = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{bidDocFilter});
        Set bidDocSet = bidDocRows.stream().map(row -> row.getLong("id")).collect(Collectors.toSet());
        return new QFilter("billid", "in", bidDocSet);
    }

    public static List<DynamicObject> isSupplierAptitude(List<Long> supplierList) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        QFilter aptitudeFilter = new QFilter("supplier.id", "in", supplierList);
        String selectFields = "entry_aptitude.aptitudename,entry_aptitude.dateto";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"srm_supplier", (String)selectFields, (QFilter[])aptitudeFilter.toArray());
        for (DynamicObject row : rows) {
            Date dateTo;
            if (StringUtils.isBlank((Object)row.get("entry_aptitude.aptitudename")) || Objects.isNull(dateTo = row.getDate("entry_aptitude.dateto")) || !dateTo.before(TimeServiceHelper.now())) continue;
            result.add(row);
        }
        return result;
    }
}

