/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.scm.pds.common.vie.IPdsQuoteRefresh;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.tnd.common.vie.ITndQuoteRefreshFromDB;
import kd.scm.tnd.common.vie.TndVieFactory;

public class TndQuoteRefreshFromDB
implements ITndQuoteRefreshFromDB {
    public IPdsQuoteRefresh getData(PdsVieContext context) {
        TndVieFactory.getTndQuoteRankFromDB().getData(context);
        return this;
    }

    public IPdsQuoteRefresh handleData(PdsVieContext context) {
        TndVieFactory.getTndQuoteRankFromDB().rankData(context);
        return this;
    }

    public void refreshData(PdsVieContext context) {
        this.refreshQuoteRank(context);
    }

    protected void refreshQuoteRank(PdsVieContext context) {
        Map quoteRank = context.getQuoteRank();
        if (quoteRank == null || quoteRank.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        DynamicObjectCollection rows = model.getEntryEntity("entryentity");
        int rowIndex = 0;
        model.beginInit();
        for (DynamicObject row : rows) {
            StringBuilder key = new StringBuilder();
            key.append(row.getString("purlist.id"));
            key.append('|');
            key.append(row.getString("supplier.id"));
            Map rankMap = (Map)quoteRank.get(key.toString());
            if (rankMap != null && rankMap.size() > 0) {
                model.setValue("rank", rankMap.get("rank"), rowIndex);
                model.setValue("pkgrank", rankMap.get("pkgrank"), rowIndex);
                model.setValue("pkgamount", rankMap.get("pkgamount"), rowIndex);
                model.setValue("pkgtaxamount", rankMap.get("pkgtaxamount"), rowIndex);
                model.setValue("prorank", rankMap.get("prorank"), rowIndex);
                model.setValue("proamount", rankMap.get("proamount"), rowIndex);
                model.setValue("protaxamount", rankMap.get("protaxamount"), rowIndex);
                DynamicObject optimalQuote = (DynamicObject)rankMap.get("optimalquote");
                model.setValue("optimalprice", optimalQuote.get("locprice"), rowIndex);
                model.setValue("optimaltaxprice", optimalQuote.get("loctaxprice"), rowIndex);
                model.setValue("optimalamount", optimalQuote.get("locamount"), rowIndex);
                model.setValue("optimaltaxamount", optimalQuote.get("loctaxamount"), rowIndex);
                model.setValue("optimalsupplier", optimalQuote.get("supplier"), rowIndex);
            }
            ++rowIndex;
        }
        model.endInit();
        context.getView().updateView("entryentity");
    }
}

