/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.ITndQuoteVerify;

public class TndQuoteVerifyBidCountByPackage
implements ITndQuoteVerify {
    private static final long serialVersionUID = 1L;

    public void verifyData(PdsVieContext context) {
        if (!"package".equals(context.getBidCountType())) {
            return;
        }
        int bidCount = context.getVieBillObj().getInt("bidcount");
        if (bidCount == 0) {
            return;
        }
        Map<Long, String> packageMap = this.getPackageMap(context);
        if (packageMap.size() == 0) {
            return;
        }
        Map hasBidCountMap = PdsVieHelper.getHasBidCountMapByPackage((PdsVieContext)context);
        if (hasBidCountMap.size() == 0) {
            return;
        }
        StringBuilder sb = this.verifyBidCount(context, packageMap, hasBidCountMap);
        if (sb.length() > 0) {
            context.setMessage(ResManager.loadKDString((String)"\u8fd9\u4e9b\u6807\u6bb5\u7684\u62a5\u4ef7\u6b21\u6570\u5df2\u7528\u5b8c\uff0c\u65e0\u6cd5\u518d\u6b21\u62a5\u4ef7\uff1a", (String)"TndQuoteVerifyBidCountByPackage_0", (String)"scm-tnd-common", (Object[])new Object[0]));
            context.setMessage(sb.toString());
            context.setVerify(Boolean.FALSE.booleanValue());
        }
    }

    public Map<Long, String> getPackageMap(PdsVieContext context) {
        DynamicObjectCollection purlistObjs = context.getView().getModel().getEntryEntity("entryentity");
        if (purlistObjs == null || purlistObjs.size() == 0) {
            return null;
        }
        HashMap<Long, String> packageMap = new HashMap<Long, String>();
        for (DynamicObject purlistObj : purlistObjs) {
            if (purlistObj.getBoolean("isdiscarded") || !context.getSelectSrcentryIds().contains(purlistObj.getLong("srcentryid"))) continue;
            packageMap.put(purlistObj.getLong("purlist.package.id"), purlistObj.getString("purlist.package.packagename"));
        }
        return packageMap;
    }

    public StringBuilder verifyBidCount(PdsVieContext context, Map<Long, String> packageMap, Map<String, Integer> hasBidCountMap) {
        int bidCount = context.getVieBillObj().getInt("bidcount");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, String> entry : packageMap.entrySet()) {
            String key = PdsCommonUtils.object2String((Object)context.getSupplierId(), (String)"") + '_' + PdsCommonUtils.object2String((Object)entry.getKey(), (String)"");
            int hasBidCount = null == hasBidCountMap.get(key) ? 0 : hasBidCountMap.get(key);
            if (hasBidCount < bidCount) continue;
            sb.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u62a5\u4ef7\u6b21\u6570%2$s\u5927\u4e8e\u7b49\u4e8e\u53ef\u62a5\u4ef7\u6b21\u6570%3$s\u3002", (String)"TndQuoteVerifyBidCountByPackage_3", (String)"scm-tnd-common", (Object[])new Object[0]), entry.getValue(), hasBidCount, bidCount));
            sb.append("\n");
        }
        return sb;
    }
}

