/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.util.SrcExchangeRateUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.ITndQuoteVerify;

public class TndQuoteVerifyLimitPrice
implements ITndQuoteVerify {
    private static final long serialVersionUID = 1L;

    public void verifyData(PdsVieContext context) {
        String tendency = context.getVieBillObj().getString("tendency");
        if (null == tendency || "".equals(tendency) || "3".equals(tendency)) {
            return;
        }
        DynamicObjectCollection purlistObjs = context.getView().getModel().getEntryEntity("entryentity");
        if (purlistObjs == null || purlistObjs.size() == 0) {
            return;
        }
        StringBuilder currMsgSb = new StringBuilder();
        HashMap cacheMap = new HashMap(8);
        for (DynamicObject purlistObj : purlistObjs) {
            if (!context.getSelectSrcentryIds().contains(purlistObj.getLong("srcentryid"))) continue;
            SrcExchangeRateUtils.getExchangeRate((DynamicObject)purlistObj, (StringBuilder)currMsgSb, cacheMap);
        }
        if (currMsgSb.length() > 0) {
            context.setVerify(Boolean.FALSE.booleanValue());
            context.setMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u7ef4\u62a4\u6c47\u7387: %1$s", (String)"TndQuoteVerifyLimitPrice_2", (String)"scm-tnd-common", (Object[])new Object[0]), currMsgSb.toString()));
            return;
        }
        String taxtype = context.getVieBillObj().getString("taxtype");
        String decisiontype = context.getVieBillObj().getString("decisiontype");
        StringBuilder sb = new StringBuilder();
        int rowIndex = 0;
        for (DynamicObject purlistObj : purlistObjs) {
            BigDecimal maxprice;
            BigDecimal locprice;
            if (!context.getSelectSrcentryIds().contains(purlistObj.getLong("srcentryid"))) {
                ++rowIndex;
                continue;
            }
            if (purlistObj.getBoolean("isdiscarded") || purlistObj.getBoolean("ispresent")) {
                ++rowIndex;
                continue;
            }
            context.getView().getModel().setValue("locprice", (Object)SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"price", (String)"priceprecision"), rowIndex);
            context.getView().getModel().setValue("loctaxprice", (Object)SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"taxprice", (String)"priceprecision"), rowIndex);
            context.getView().getModel().setValue("locamount", (Object)SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"amount", (String)"priceprecision"), rowIndex);
            context.getView().getModel().setValue("loctaxamount", (Object)SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"taxamount", (String)"priceprecision"), rowIndex);
            if ("2".equals(taxtype)) {
                if ("2".equals(decisiontype)) {
                    locprice = SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"amount", (String)"priceprecision");
                    maxprice = purlistObj.getBigDecimal("maxamount");
                } else {
                    locprice = SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"price", (String)"priceprecision");
                    maxprice = purlistObj.getBigDecimal("maxprice");
                }
            } else if ("2".equals(decisiontype)) {
                locprice = SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"taxamount", (String)"priceprecision");
                maxprice = purlistObj.getBigDecimal("maxtaxamount");
            } else {
                locprice = SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"taxprice", (String)"priceprecision");
                maxprice = purlistObj.getBigDecimal("maxtaxprice");
            }
            DynamicObject locCurr = purlistObj.getDynamicObject("loccurr");
            int precision = null == locCurr ? 4 : locCurr.getInt("priceprecision");
            sb = PdsVieHelper.verifyLimitPrice((StringBuilder)sb, (String)taxtype, (String)tendency, (DynamicObject)purlistObj, (BigDecimal)locprice, (BigDecimal)maxprice, (int)precision);
            ++rowIndex;
        }
        if (sb.length() > 0) {
            context.setVerify(Boolean.FALSE.booleanValue());
            if ("1".equals(tendency)) {
                context.setMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u4ef7\u8d8b\u52bf\u4e3a\u53ea\u5141\u8bb8\u964d\u4ef7\uff0c\u62a5\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u6700\u9ad8\u9650\u4ef7\uff1a%1$s", (String)"TndQuoteVerifyLimitPrice_0", (String)"scm-tnd-common", (Object[])new Object[0]), sb.toString()));
            }
            if ("2".equals(tendency)) {
                context.setMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u4ef7\u8d8b\u52bf\u4e3a\u53ea\u5141\u8bb8\u52a0\u4ef7\uff0c\u62a5\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u6700\u4f4e\u9650\u4ef7\uff1a%1$s", (String)"TndQuoteVerifyLimitPrice_1", (String)"scm-tnd-common", (Object[])new Object[0]), sb.toString()));
            }
        }
    }
}

